/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterSelector;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.IWizardParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GSEAInitWizard;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;

public class DataPanel
extends JPanel
implements IWizardParameterPanel {
    private static final long serialVersionUID = 1L;
    private JPanel numberOfFactorPanel;
    private JLabel factorLabel;
    private JTextField factorTextField;
    private int num_factors = 0;
    private JTextField factorNameTextField;
    private JPanel factorLevelPanel;
    private JLabel factorLevelLabel;
    private JTextField factorLevelTextField;
    private ArrayList<String> factorNameList = new ArrayList();
    private ArrayList factorLevelList = new ArrayList();
    private AlgorithmData algData;
    private IData idata;
    private ClusterRepository clusterRepository;
    private JPanel gPanel;
    private JPanel pane;
    private JTabbedPane tabbedSelectors;
    private ClusterSelector[] clusterSelector;
    private static int ycoord = 0;
    private int maxFactors = 4;
    public GSEAInitWizard gseaInitWizard;
    GridBagLayout gridbag = new GridBagLayout();

    public DataPanel(IData iData, AlgorithmData algorithmData, JFrame jFrame, ClusterRepository clusterRepository, IFramework iFramework) {
        this(iData, algorithmData, jFrame, clusterRepository, iFramework, null);
    }

    public DataPanel(IData iData, AlgorithmData algorithmData, JFrame jFrame, ClusterRepository clusterRepository, IFramework iFramework, GSEAInitWizard gSEAInitWizard) {
        this.gseaInitWizard = gSEAInitWizard;
        this.idata = iData;
        this.algData = algorithmData;
        this.clusterRepository = clusterRepository;
        this.setMaxFactors(this.maxFactors);
        this.initComponents();
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(1000, 850));
        this.setLayout(this.gridbag);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.numberOfFactorPanel = new JPanel();
        this.numberOfFactorPanel.setBackground(Color.white);
        this.numberOfFactorPanel.setBorder(new EtchedBorder());
        this.factorLabel = new JLabel("Enter the number of factors in your samples:");
        this.factorTextField = new JTextField(5);
        this.factorTextField.setText("1");
        this.factorTextField.setMinimumSize(new Dimension(20, 30));
        this.factorTextField.addKeyListener(new Listener());
        this.factorLevelPanel = new JPanel();
        this.factorLevelPanel.setLayout(this.gridbag);
        this.factorLevelPanel.setBackground(Color.WHITE);
        this.factorLevelPanel.setBorder(new EtchedBorder());
        this.factorLevelPanel.setVisible(true);
        this.pane = new JPanel();
        this.pane.setBackground(Color.white);
        this.pane.setBorder(new EtchedBorder());
        this.pane.setVisible(true);
        gridBagConstraints = this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.gridbag.setConstraints(this.factorLabel, gridBagConstraints);
        this.numberOfFactorPanel.add(this.factorLabel);
        gridBagConstraints = this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 100, 100);
        gridBagConstraints.fill = 0;
        this.gridbag.setConstraints(this.factorTextField, gridBagConstraints);
        this.numberOfFactorPanel.add(this.factorTextField);
        gridBagConstraints = this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 0, 0);
        gridBagConstraints.fill = 1;
        this.gridbag.setConstraints(this.numberOfFactorPanel, gridBagConstraints);
        this.add(this.numberOfFactorPanel);
        gridBagConstraints = this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 30);
        gridBagConstraints.fill = 1;
        this.gridbag.setConstraints(this.factorLevelPanel, gridBagConstraints);
        this.add(this.factorLevelPanel);
        gridBagConstraints = this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 100, 100);
        gridBagConstraints.fill = 1;
        this.pane.setLayout(this.gridbag);
        this.gridbag.setConstraints(this.pane, gridBagConstraints);
        this.add(this.pane);
        this.addRemoveFactor(1);
        this.initialize();
        if (this.drawSampleGroupingsPanel()) {
            this.makeClusterSelector();
        }
        this.revalidate();
    }

    public void initialize() {
        this.factorNameList = new ArrayList(this.getNumberOfFactors());
        this.factorLevelList = new ArrayList(this.getNumberOfFactors());
        for (int i = 0; i < this.getNumberOfFactors(); ++i) {
            this.factorNameList.add(i, "Factor" + i);
            this.factorLevelList.add(i, 2);
        }
    }

    public void setNumberOfFactors(int n) {
        this.num_factors = n;
    }

    public int getNumberOfFactors() {
        return this.num_factors;
    }

    public void makeFactorLevel(String string) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Factor " + string + " name:");
        this.factorNameTextField = new JTextField(string, 5);
        this.factorNameTextField.setPreferredSize(new Dimension(20, 30));
        this.factorNameTextField.setEditable(true);
        this.factorNameTextField.setName(string);
        this.factorNameTextField.setText("Factor " + string);
        this.factorNameTextField.addKeyListener(new Listener(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (((JTextField)keyEvent.getSource()).getText() != "") {
                    DataPanel.this.setFactorName(Integer.parseInt(keyEvent.getComponent().getName()) - 1, ((JTextField)keyEvent.getSource()).getText());
                }
            }
        });
        this.factorLevelLabel = new JLabel("Number of levels of factor " + string + " :");
        this.factorLevelTextField = new JTextField(5);
        this.factorLevelTextField.setPreferredSize(new Dimension(20, 30));
        this.factorLevelTextField.setEditable(true);
        this.factorLevelTextField.setName(string);
        this.factorLevelTextField.setText("2");
        this.factorLevelTextField.addKeyListener(new Listener(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (((JTextField)keyEvent.getSource()).getText() != "" && ((JTextField)keyEvent.getSource()).getText().length() != 0) {
                    try {
                        DataPanel.this.setFactorLevel(Integer.parseInt(keyEvent.getComponent().getName()) - 1, Integer.parseInt(((JTextField)keyEvent.getSource()).getText()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(DataPanel.this, "You must enter a numeric value for factor level!", "Factor Level Error", 0);
                    }
                }
                if (DataPanel.this.drawSampleGroupingsPanel()) {
                    DataPanel.this.makeClusterSelector();
                }
            }
        });
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints = this.buildConstraints(gridBagConstraints, 0, Integer.parseInt(string) - 1, 1, 1, 100, 100);
        this.gridbag.setConstraints(jLabel, gridBagConstraints);
        this.factorLevelPanel.add(jLabel);
        gridBagConstraints = this.buildConstraints(gridBagConstraints, 1, Integer.parseInt(string) - 1, 1, 1, 100, 100);
        this.gridbag.setConstraints(this.factorNameTextField, gridBagConstraints);
        this.factorLevelPanel.add(this.factorNameTextField);
        gridBagConstraints = this.buildConstraints(gridBagConstraints, 2, Integer.parseInt(string) - 1, 1, 1, 100, 100);
        this.gridbag.setConstraints(this.factorLevelLabel, gridBagConstraints);
        this.factorLevelPanel.add(this.factorLevelLabel);
        gridBagConstraints = this.buildConstraints(gridBagConstraints, 3, Integer.parseInt(string) - 1, 1, 1, 100, 100);
        this.gridbag.setConstraints(this.factorLevelTextField, gridBagConstraints);
        this.factorLevelPanel.add(this.factorLevelTextField);
        this.revalidate();
        ++ycoord;
    }

    public boolean validateFactorNumber(int n) {
        if (n == 0) {
            JOptionPane.showMessageDialog(this, "You cannot have zero factors!", "Factor Number Error", 0);
            return false;
        }
        if (n >= this.getMaxFactors()) {
            JOptionPane.showMessageDialog(this, "You cannot have more than " + (this.getMaxFactors() - 1) + " factors!", "Factor Number Error", 0);
            return false;
        }
        return true;
    }

    public void resetPanel(JPanel jPanel) {
        jPanel.removeAll();
        this.validate();
    }

    public void resetCoordinates() {
        ycoord = 0;
    }

    public void addRemoveFactor(int n) {
        if (!this.factorLevelPanel.isVisible()) {
            this.factorLevelPanel.setVisible(true);
        }
        this.resetPanel(this.factorLevelPanel);
        this.resetCoordinates();
        for (int i = 0; i < n; ++i) {
            this.makeFactorLevel(String.valueOf(i + 1));
        }
        this.setNumberOfFactors(n);
    }

    public void makeClusterSelector() {
        int n;
        Serializable serializable;
        this.resetPanel(this.pane);
        this.pane.setVisible(true);
        this.setBackground(Color.white);
        this.clusterSelector = new ClusterSelector[this.getNumberOfFactors()];
        this.gPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.gPanel.setLayout(gridBagLayout);
        for (int i = 0; i < this.getNumberOfFactors(); ++i) {
            serializable = new MultiGroupExperimentsPanel("Factor " + (i + 1), (Integer)this.getAllFactorLevels().get(i));
            gridBagConstraints = i == 0 ? this.buildConstraints(gridBagConstraints, i, 0, 1, 1, 50, 90) : this.buildConstraints(gridBagConstraints, i, 0, 1, 1, 50, 0);
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints((Component)serializable, gridBagConstraints);
            this.gPanel.add((Component)serializable);
        }
        JPanel jPanel = new JPanel();
        serializable = new GridBagLayout();
        jPanel.setLayout((LayoutManager)((Object)serializable));
        jPanel.setBackground(Color.white);
        JButton jButton = new JButton("  Save settings  ");
        jButton.setFocusPainted(false);
        jButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
        JButton jButton2 = new JButton("  Load settings  ");
        jButton2.setFocusPainted(false);
        jButton2.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
        JButton jButton3 = new JButton("  Reset  ");
        jButton3.setFocusPainted(false);
        jButton3.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < DataPanel.this.getAllFactorNames().size(); ++i) {
                    ((MultiGroupExperimentsPanel)DataPanel.this.gPanel.getComponent(i)).reset();
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataPanel.this.saveAssignments();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataPanel.this.loadAssignments();
                DataPanel.this.gseaInitWizard.setParamSufficient(DataPanel.this.validateSampleSelection());
            }
        });
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints = this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 100);
        ((GridBagLayout)serializable).setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        gridBagConstraints = this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
        ((GridBagLayout)serializable).setConstraints(jButton2, gridBagConstraints);
        jPanel.add(jButton2);
        gridBagConstraints = this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 34, 0);
        ((GridBagLayout)serializable).setConstraints(jButton3, gridBagConstraints);
        jPanel.add(jButton3);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints = this.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 100, 5);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.gPanel.add(jPanel);
        for (n = 0; n < this.getNumberOfFactors(); ++n) {
            this.clusterSelector[n] = new ClusterSelector(this.clusterRepository, ((Integer)this.getAllFactorLevels().get(n)).intValue());
            this.clusterSelector[n].addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    DataPanel.this.gseaInitWizard.setParamSufficient(DataPanel.this.validateSampleSelection());
                }
            });
        }
        if (this.clusterRepository != null) {
            for (n = 0; n < this.num_factors; ++n) {
                this.clusterSelector[n].setClusterType(this.getAllFactorNames().get(n));
            }
        }
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.anchor = 20;
        for (int i = 0; i < this.getNumberOfFactors(); ++i) {
            jPanel2.add((Component)this.clusterSelector[i], gridBagConstraints2);
            ++gridBagConstraints2.gridy;
        }
        this.tabbedSelectors = new JTabbedPane();
        this.tabbedSelectors.insertTab("Cluster Selection", null, jPanel2, null, 0);
        this.tabbedSelectors.insertTab("Button Selection", null, this.gPanel, null, 1);
        if (this.clusterRepository == null || this.clusterRepository.isEmpty()) {
            this.tabbedSelectors.setSelectedIndex(1);
        }
        gridBagConstraints = this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 80);
        gridBagConstraints.fill = 1;
        ((GridBagLayout)this.pane.getLayout()).setConstraints(this.tabbedSelectors, gridBagConstraints);
        this.pane.add(this.tabbedSelectors);
        this.revalidate();
    }

    public ArrayList<String> getAllFactorNames() {
        return this.factorNameList;
    }

    public ArrayList getAllFactorLevels() {
        return this.factorLevelList;
    }

    public int getMaximumFactorLevel() {
        int n = -1;
        for (int i = 0; i < this.factorLevelList.size(); ++i) {
            if ((Integer)this.factorLevelList.get(i) <= n) continue;
            n = (Integer)this.factorLevelList.get(i);
        }
        return n;
    }

    public void setFactorLevel(int n, int n2) {
        this.factorLevelList.set(n, n2);
    }

    public void setFactorName(int n, String string) {
        this.factorNameList.set(n, string);
    }

    public ArrayList getSampleNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Experiment experiment = this.idata.getExperiment();
        int n = experiment.getNumberOfSamples();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.idata.getSampleName(i));
        }
        return arrayList;
    }

    public boolean drawSampleGroupingsPanel() {
        boolean bl = false;
        for (int i = 0; i < this.getNumberOfFactors(); ++i) {
            bl = (Integer)this.getAllFactorLevels().get(i) != 0;
        }
        return bl;
    }

    @Override
    public void clearValuesFromAlgorithmData() {
    }

    @Override
    public void onDisplayed() {
    }

    @Override
    public void populateAlgorithmData() {
        int n;
        if (this.getAllFactorNames().size() != 0) {
            this.algData.addStringArray("factor-names", this.getAllFactorNames().toArray(new String[this.getNumberOfFactors()]));
        }
        int[] nArray = new int[this.getNumberOfFactors()];
        int[][] nArrayArray = new int[this.getNumberOfFactors()][];
        for (n = 0; n < this.getNumberOfFactors(); ++n) {
            nArray[n] = (Integer)this.getAllFactorLevels().get(n);
        }
        if (nArray.length != 0) {
            this.algData.addIntArray("factor-levels", nArray);
        }
        for (n = 0; n < this.getNumberOfFactors(); ++n) {
            nArrayArray[n] = ((MultiGroupExperimentsPanel)this.gPanel.getComponent(n)).getFactorAssignments(n);
        }
        if (this.checkGroupAssignment(nArrayArray)) {
            this.algData.addIntMatrix("factor-assignments", (int[][])nArrayArray);
        } else {
            this.algData.addIntMatrix("factor-assignments", (int[][])null);
        }
    }

    public boolean checkGroupAssignment(int[][] nArray) {
        boolean bl = false;
        for (int i = 0; i < 1; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                if (nArray[i][j] == 1) continue;
                bl = true;
            }
        }
        return bl;
    }

    public boolean validateSampleSelection() {
        for (int i = 0; i < this.num_factors; ++i) {
            int n;
            int[] nArray = !((MultiGroupExperimentsPanel)this.gPanel.getComponent(i)).isButtonSelectionMethod() ? this.getFactorClusterAssignments(i) : ((MultiGroupExperimentsPanel)this.gPanel.getComponent(i)).getGroupAssignments();
            boolean[] blArray = new boolean[((MultiGroupExperimentsPanel)this.gPanel.getComponent((int)i)).numGroups];
            for (n = 0; n < blArray.length; ++n) {
                blArray[n] = false;
            }
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] == 0) continue;
                blArray[nArray[n] - 1] = true;
            }
            for (n = 0; n < blArray.length; ++n) {
                if (blArray[n]) continue;
                return false;
            }
        }
        return true;
    }

    public int[] getFactorClusterAssignments(int n) {
        int n2;
        int n3;
        int[] nArray = new int[this.getSampleNames().size()];
        ArrayList[] arrayListArray = new ArrayList[this.getMaximumFactorLevel()];
        for (n3 = 0; n3 < this.getMaximumFactorLevel(); ++n3) {
            n2 = n3 + 1;
            arrayListArray[n3] = this.clusterSelector[n].getGroupSamples("Group " + n2);
        }
        for (n3 = 0; n3 < this.getSampleNames().size(); ++n3) {
            boolean bl = false;
            nArray[n3] = 0;
            for (n2 = 0; n2 < this.getMaximumFactorLevel(); ++n2) {
                if (!arrayListArray[n2].contains(n3)) continue;
                if (bl) {
                    Object[] objectArray = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen " + this.getAllFactorNames().get(0) + " have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, objectArray, objectArray[0]);
                    return null;
                }
                nArray[n3] = n2 + 1;
                bl = true;
            }
        }
        return nArray;
    }

    private void saveAssignments() {
        JFileChooser jFileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
        if (jFileChooser.showSaveDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                int n;
                PrintWriter printWriter = new PrintWriter(new FileWriter(file));
                Date date = new Date(System.currentTimeMillis());
                String string = date.toString();
                String string2 = System.getProperty("user.name");
                printWriter.println("# Assignment File");
                printWriter.println("# User: " + string2 + " Save Date: " + string);
                printWriter.println("#");
                printWriter.print("Module:\t");
                printWriter.println("GSEA");
                int n2 = 0;
                for (n = 0; n < this.getAllFactorLevels().size(); ++n) {
                    if ((Integer)this.getAllFactorLevels().get(n) <= n2) continue;
                    n2 = (Integer)this.getAllFactorLevels().get(n);
                }
                for (n = 0; n < n2; ++n) {
                    printWriter.print("Group " + (n + 1) + " Label:\t");
                    printWriter.println("Group " + (n + 1));
                }
                printWriter.println("#");
                printWriter.println("Sample Index\tSample Name\tGroup Assignment");
                int[] nArray = ((MultiGroupExperimentsPanel)this.gPanel.getComponent(0)).getFactorAssignments(0);
                int[] nArray2 = null;
                int[] nArray3 = null;
                if (this.getAllFactorNames().size() == 3 || this.getAllFactorNames().size() == 2) {
                    nArray2 = ((MultiGroupExperimentsPanel)this.gPanel.getComponent(1)).getFactorAssignments(1);
                }
                if (this.getAllFactorNames().size() == 3) {
                    nArray3 = ((MultiGroupExperimentsPanel)this.gPanel.getComponent(2)).getFactorAssignments(2);
                }
                for (int i = 0; i < this.getSampleNames().size(); ++i) {
                    printWriter.print(String.valueOf(i + 1) + "\t");
                    printWriter.print(this.getSampleNames().get(i) + "\t");
                    if (nArray[i] != 0) {
                        printWriter.print("Group " + nArray[i]);
                    } else {
                        printWriter.print("Exclude");
                    }
                    if (this.getAllFactorNames().size() == 3 || this.getAllFactorNames().size() == 2) {
                        if (nArray2[i] != 0) {
                            printWriter.print("\tGroup " + nArray2[i]);
                        } else {
                            printWriter.print("\tExclude");
                        }
                    }
                    if (this.getAllFactorNames().size() == 3) {
                        if (nArray3[i] != 0) {
                            printWriter.print("\tGroup " + nArray3[i]);
                        } else {
                            printWriter.print("\tExclude");
                        }
                    }
                    printWriter.println();
                }
                printWriter.flush();
                printWriter.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void loadAssignments() {
        JFileChooser jFileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                int n;
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                Vector<String> vector = new Vector<String>();
                while ((string = bufferedReader.readLine()) != null) {
                    vector.add(string.trim());
                }
                bufferedReader.close();
                Vector<String> vector2 = new Vector<String>();
                Vector<Integer> vector3 = new Vector<Integer>();
                Vector<String> vector4 = new Vector<String>();
                Vector<String> vector5 = new Vector<String>();
                Vector<String> vector6 = new Vector<String>();
                Vector<String> vector7 = new Vector<String>();
                boolean bl = true;
                boolean bl2 = true;
                for (int i = 0; i < vector.size(); ++i) {
                    string = (String)vector.get(i);
                    if (string.startsWith("#") || string.startsWith("SampleIndex")) continue;
                    String[] stringArray = string.split("\t");
                    if (stringArray[0].startsWith("Module:")) {
                        if (stringArray[1].equals("GSEA")) continue;
                        Object[] objectArray = new Object[]{"Continue", "Cancel"};
                        if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + stringArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, objectArray, objectArray[0]) == 0) continue;
                        return;
                    }
                    if (stringArray[0].startsWith("Group ") && stringArray[0].endsWith("Label:")) {
                        vector2.add(stringArray[1]);
                        continue;
                    }
                    try {
                        Integer.parseInt(stringArray[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    vector3.add(new Integer(stringArray[0]));
                    vector4.add(stringArray[1]);
                    vector5.add(stringArray[2]);
                    try {
                        vector6.add(stringArray[3]);
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    try {
                        vector7.add(stringArray[4]);
                        continue;
                    }
                    catch (Exception exception) {
                        bl2 = false;
                    }
                }
                if (!bl) {
                    JOptionPane.showMessageDialog(null, "The loaded file contained only 1 Factor.  Only " + this.getAllFactorNames().get(0) + " will be loaded.", "Error", 0);
                } else if (!bl2 && this.getAllFactorNames().size() == 3) {
                    JOptionPane.showMessageDialog(null, "The loaded file contained only 2 Factors.  Only " + this.getAllFactorNames().get(0) + " and " + this.getAllFactorNames().get(1) + " will be loaded.", "Error", 0);
                }
                if (this.getSampleNames().size() != vector4.size()) {
                    System.out.println(this.getSampleNames().size() + "  " + vector4.size());
                    System.out.println(this.getSampleNames().size() + " s length " + vector4.size());
                    JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(vector4.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + this.getSampleNames().size() + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                    return;
                }
                Vector<String> vector8 = new Vector<String>();
                for (n = 0; n < this.getSampleNames().size(); ++n) {
                    vector8.add((String)this.getSampleNames().get(n));
                }
                n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                for (int i = 0; i < this.getSampleNames().size(); ++i) {
                    boolean bl3 = false;
                    for (int j = 0; j < this.getSampleNames().size(); ++j) {
                        if (j == i || !this.getSampleNames().get(j).equals(this.getSampleNames().get(i))) continue;
                        bl3 = true;
                    }
                    n = vector4.indexOf(this.getSampleNames().get(i));
                    if (n == -1) {
                        bl3 = true;
                    }
                    if (bl && (n3 = vector4.indexOf(this.getSampleNames().get(i))) == -1) {
                        bl3 = true;
                        break;
                    }
                    if (bl2 && this.getAllFactorNames().size() == 3 && (n5 = vector4.indexOf(this.getSampleNames().get(i))) == -1) {
                        bl3 = true;
                        break;
                    }
                    if (bl3) {
                        this.setStateBasedOnIndex(vector5, vector6, vector7, vector2, bl, bl2);
                        break;
                    }
                    String string2 = (String)vector5.get(n);
                    n2 = vector2.indexOf(string2);
                    try {
                        ((MultiGroupExperimentsPanel)this.gPanel.getComponent((int)0)).exptGroupRadioButtons[n2][i].setSelected(true);
                    }
                    catch (Exception exception) {
                        ((MultiGroupExperimentsPanel)this.gPanel.getComponent((int)0)).notInGroupRadioButtons[i].setSelected(true);
                    }
                    if (bl) {
                        String string3 = vector6.get(n3);
                        n4 = vector2.indexOf(string3);
                        try {
                            ((MultiGroupExperimentsPanel)this.gPanel.getComponent((int)1)).exptGroupRadioButtons[n4][i].setSelected(true);
                        }
                        catch (Exception exception) {
                            ((MultiGroupExperimentsPanel)this.gPanel.getComponent((int)1)).notInGroupRadioButtons[i].setSelected(true);
                        }
                    }
                    if (!bl2 || this.getAllFactorNames().size() != 3) continue;
                    String string4 = vector7.get(n5);
                    n6 = vector2.indexOf(string4);
                    try {
                        ((MultiGroupExperimentsPanel)this.gPanel.getComponent((int)2)).exptGroupRadioButtons[n6][i].setSelected(true);
                        continue;
                    }
                    catch (Exception exception) {
                        ((MultiGroupExperimentsPanel)this.gPanel.getComponent((int)2)).notInGroupRadioButtons[i].setSelected(true);
                    }
                }
                this.gseaInitWizard.setParamSufficient(this.validateSampleSelection());
                this.repaint();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
            }
        }
    }

    private void setStateBasedOnIndex(Vector<String> vector, Vector<String> vector2, Vector<String> vector3, Vector<String> vector4, boolean bl, boolean bl2) {
        int n;
        Object[] objectArray = new Object[]{"Continue", "Cancel"};
        if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, objectArray, objectArray[0]) == 1) {
            return;
        }
        for (n = 0; n < this.getSampleNames().size(); ++n) {
            try {
                ((MultiGroupExperimentsPanel)this.gPanel.getComponent((int)0)).exptGroupRadioButtons[vector4.indexOf(vector.get(n))][n].setSelected(true);
                continue;
            }
            catch (Exception exception) {
                ((MultiGroupExperimentsPanel)this.gPanel.getComponent((int)0)).notInGroupRadioButtons[n].setSelected(true);
            }
        }
        if (bl) {
            for (n = 0; n < this.getSampleNames().size(); ++n) {
                try {
                    ((MultiGroupExperimentsPanel)this.gPanel.getComponent((int)1)).exptGroupRadioButtons[vector4.indexOf(vector2.get(n))][n].setSelected(true);
                    continue;
                }
                catch (Exception exception) {
                    ((MultiGroupExperimentsPanel)this.gPanel.getComponent((int)1)).notInGroupRadioButtons[n].setSelected(true);
                }
            }
        }
        if (bl2 && this.getAllFactorNames().size() == 3) {
            for (n = 0; n < this.getSampleNames().size(); ++n) {
                try {
                    ((MultiGroupExperimentsPanel)this.gPanel.getComponent((int)2)).exptGroupRadioButtons[vector4.indexOf(vector3.get(n))][n].setSelected(true);
                    continue;
                }
                catch (Exception exception) {
                    ((MultiGroupExperimentsPanel)this.gPanel.getComponent((int)2)).notInGroupRadioButtons[n].setSelected(true);
                }
            }
        }
    }

    public GridBagConstraints buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
        return gridBagConstraints;
    }

    public int getMaxFactors() {
        return this.maxFactors;
    }

    public void setMaxFactors(int n) {
        this.maxFactors = n;
    }

    public static void main(String[] stringArray) {
    }

    private class MultiGroupExperimentsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JLabel[] expLabels;
        JRadioButton[][] exptGroupRadioButtons;
        JRadioButton[] notInGroupRadioButtons;
        int numGroups;

        MultiGroupExperimentsPanel(String string, int n) {
            int n2;
            this.setBorder(new TitledBorder(new EtchedBorder(), string + " assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.numGroups = n;
            this.setBackground(Color.white);
            JPanel jPanel = new JPanel();
            this.expLabels = new JLabel[DataPanel.this.getSampleNames().size()];
            this.exptGroupRadioButtons = new JRadioButton[n][DataPanel.this.getSampleNames().size()];
            this.notInGroupRadioButtons = new JRadioButton[DataPanel.this.getSampleNames().size()];
            ButtonGroup[] buttonGroupArray = new ButtonGroup[DataPanel.this.getSampleNames().size()];
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout2);
            jPanel.setLayout(gridBagLayout);
            for (n2 = 0; n2 < DataPanel.this.getSampleNames().size(); ++n2) {
                int n3;
                String string2 = (String)DataPanel.this.getSampleNames().get(n2);
                this.expLabels[n2] = new JLabel(string2);
                buttonGroupArray[n2] = new ButtonGroup();
                for (n3 = 0; n3 < n; ++n3) {
                    this.exptGroupRadioButtons[n3][n2] = new JRadioButton("Group " + (n3 + 1) + "     ", n3 == 0);
                    buttonGroupArray[n2].add(this.exptGroupRadioButtons[n3][n2]);
                    this.exptGroupRadioButtons[n3][n2].addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            DataPanel.this.gseaInitWizard.setParamSufficient(DataPanel.this.validateSampleSelection());
                        }
                    });
                }
                this.notInGroupRadioButtons[n2] = new JRadioButton("Not in groups", false);
                buttonGroupArray[n2].add(this.notInGroupRadioButtons[n2]);
                for (n3 = 0; n3 < n; ++n3) {
                    gridBagConstraints = DataPanel.this.buildConstraints(gridBagConstraints, n3, n2, 1, 1, 100, 100);
                    gridBagLayout.setConstraints(this.exptGroupRadioButtons[n3][n2], gridBagConstraints);
                    jPanel.add(this.exptGroupRadioButtons[n3][n2]);
                }
                gridBagConstraints = DataPanel.this.buildConstraints(gridBagConstraints, n + 1, n2, 1, 1, 100, 100);
                gridBagLayout.setConstraints(this.notInGroupRadioButtons[n2], gridBagConstraints);
                jPanel.add(this.notInGroupRadioButtons[n2]);
            }
            n2 = 0;
            for (int i = 0; i < this.expLabels.length; ++i) {
                if (!(this.expLabels[i].getPreferredSize().getWidth() > (double)n2)) continue;
                n2 = (int)Math.ceil(this.expLabels[i].getPreferredSize().getWidth());
            }
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
            JPanel jPanel2 = new JPanel();
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            jPanel2.setSize(50, jPanel.getPreferredSize().height);
            jPanel2.setPreferredSize(new Dimension(n2 + 10, jPanel.getPreferredSize().height));
            jPanel2.setLayout(gridBagLayout3);
            for (int i = 0; i < this.expLabels.length; ++i) {
                gridBagConstraints = DataPanel.this.buildConstraints(gridBagConstraints, 0, i, 1, 1, 100, 100);
                gridBagConstraints.fill = 1;
                gridBagLayout3.setConstraints(this.expLabels[i], gridBagConstraints);
                jPanel2.add(this.expLabels[i]);
            }
            jScrollPane.setRowHeaderView(jPanel2);
            gridBagConstraints = DataPanel.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 90);
            gridBagConstraints.fill = 1;
            gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            this.revalidate();
        }

        public void reset() {
            for (int i = 0; i < DataPanel.this.getSampleNames().size(); ++i) {
                this.exptGroupRadioButtons[0][i].setSelected(true);
            }
        }

        public boolean isButtonSelectionMethod() {
            return DataPanel.this.tabbedSelectors.getSelectedIndex() == 1;
        }

        private int[] getGroupAssignments() {
            int n;
            int[] nArray = new int[DataPanel.this.getSampleNames().size()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = 0;
            }
            block1: for (n = 0; n < nArray.length; ++n) {
                for (int i = 0; i < this.numGroups; ++i) {
                    if (!this.exptGroupRadioButtons[i][n].isSelected()) continue;
                    nArray[n] = i + 1;
                    continue block1;
                }
            }
            return nArray;
        }

        public int[] getFactorAssignments(int n) {
            if (!this.isButtonSelectionMethod()) {
                return DataPanel.this.getFactorClusterAssignments(n);
            }
            return ((MultiGroupExperimentsPanel)DataPanel.this.gPanel.getComponent(n)).getGroupAssignments();
        }
    }

    private class Listener
    implements KeyListener {
        private Listener() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            Object object = keyEvent.getSource();
            if (object == DataPanel.this.factorTextField && DataPanel.this.factorTextField.getText() != "") {
                if (DataPanel.this.validateFactorNumber(Integer.parseInt(DataPanel.this.factorTextField.getText()))) {
                    DataPanel.this.addRemoveFactor(Integer.parseInt(DataPanel.this.factorTextField.getText()));
                    DataPanel.this.initialize();
                }
                if (DataPanel.this.getAllFactorLevels().size() != 0 && DataPanel.this.drawSampleGroupingsPanel()) {
                    DataPanel.this.makeClusterSelector();
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }
    }
}

