/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.goseq.gotree;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.impl.ease.EaseAlgorithmData;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ktree.ITreeNode;
import org.tigr.microarray.mev.cluster.gui.helpers.ktree.Ktree;
import org.tigr.microarray.mev.cluster.gui.impl.goseq.gotree.EaseThresholdDialog;
import org.tigr.microarray.mev.cluster.gui.impl.goseq.gotree.GONode;
import org.tigr.microarray.mev.cluster.gui.impl.goseq.gotree.GOTreeHeader;

public class GOTreeViewer
extends JPanel
implements IViewer {
    private String category;
    private Ktree tree;
    private Vector nodes;
    private DefaultMutableTreeNode viewerNode;
    private int selectionPolarity = 0;
    private JPopupMenu popup;
    private boolean verbose = false;
    private GOTreeHeader header;
    private JMenu newTreeMenu;
    private JMenu launchMenu;
    private IFramework framework;
    private double upper = 0.05;
    private double lower = 0.01;
    private GONode[][] storedNodes;
    private String[] headerFields;
    private int exptID = 0;
    private MouseOverListener mouseOverListener;
    private boolean showToolTip = true;
    String impliesFile;
    EaseAlgorithmData data;

    public GOTreeViewer() {
    }

    public GOTreeViewer(GONode root) {
        super(new GridBagLayout());
        this.tree = new Ktree((ITreeNode)root);
        this.add((Component)this.tree, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mouseOverListener = new MouseOverListener();
        this.setVerboseNodeStyle(false);
    }

    public GOTreeViewer(GONode[][] data, DefaultMutableTreeNode viewerNode, String baseFileSystem) {
        super(new GridBagLayout());
        this.storedNodes = data;
        this.impliesFile = baseFileSystem;
        this.tree = new Ktree((ITreeNode[][])data);
        this.header = new GOTreeHeader(data[0][0], this, this.upper, this.lower);
        this.viewerNode = viewerNode;
        this.add((Component)this.tree, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.nodes = new Vector();
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                this.nodes.addElement(data[i][j]);
            }
        }
        Listener listener = new Listener();
        this.tree.addMouseListener((MouseListener)listener);
        this.addMouseListener(listener);
        this.createPopupMenu(listener);
        this.mouseOverListener = new MouseOverListener();
        this.setVerboseNodeStyle(false);
    }

    public GOTreeViewer(String goCategory, String[] headerFields, EaseAlgorithmData data, DefaultMutableTreeNode viewerNode) {
        super(new GridBagLayout());
        this.data = data;
        this.viewerNode = viewerNode;
        this.category = goCategory;
        this.impliesFile = new File(data.getImpliesFileLocation(), this.category + ".txt").getAbsolutePath();
        this.storedNodes = this.constructTree(goCategory, headerFields, data.getResultMatrix());
        this.headerFields = headerFields;
        this.tree = new Ktree((ITreeNode[][])this.storedNodes);
        this.header = new GOTreeHeader(this.storedNodes[0][0], this, this.upper, this.lower);
        this.add((Component)this.tree, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        Listener listener = new Listener();
        this.tree.addMouseListener((MouseListener)listener);
        this.addMouseListener(listener);
        this.createPopupMenu(listener);
        this.setVerboseNodeStyle(false);
        this.mouseOverListener = new MouseOverListener();
        this.setVerboseNodeStyle(false);
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.category, this.headerFields, this.data, this.viewerNode});
    }

    public GOTreeViewer(GONode[][] storedNodes, String baseFileSystem, String category, String[] headerFields, Integer selectionPolarity, Boolean verbose, Double upper, Double lower) {
        super(new GridBagLayout());
        this.storedNodes = storedNodes;
        this.headerFields = headerFields;
        this.category = category;
        this.tree = new Ktree((ITreeNode[][])this.storedNodes);
        this.selectionPolarity = selectionPolarity;
        this.verbose = verbose;
        this.upper = upper;
        this.lower = lower;
        this.header = new GOTreeHeader(this.storedNodes[0][0], this, this.upper, this.lower);
        this.nodes = new Vector();
        for (int i = 0; i < storedNodes.length; ++i) {
            for (int j = 0; j < storedNodes[i].length; ++j) {
                this.nodes.addElement(storedNodes[i][j]);
            }
        }
        this.setVerboseNodeStyle(this.verbose);
        Listener listener = new Listener();
        this.tree.addMouseListener((MouseListener)listener);
        this.addMouseListener(listener);
        this.createPopupMenu(listener);
        this.mouseOverListener = new MouseOverListener();
        this.setVerboseNodeStyle(false);
    }

    private GONode[][] constructTree(String goCategory, String[] header, String[][] data) {
        GONode currNode;
        Hashtable termHash = new Hashtable(data.length);
        int goAccIndex = 0;
        int termIndex = 0;
        int listHitIndex = 0;
        int popHitIndex = 0;
        int statIndex = 0;
        int catIndex = 0;
        String[] keys = new String[]{"Acc.", "Term", "List Hits", "Pop. Hits", "File"};
        boolean haveAcc = false;
        int index = 0;
        for (int i = 0; i < keys.length; ++i) {
            for (int j = 0; j < header.length; ++j) {
                if (!header[j].equals(keys[i])) continue;
                index = j;
            }
            if (i == 0) {
                goAccIndex = index;
                continue;
            }
            if (i == 1) {
                termIndex = index;
                continue;
            }
            if (i == 2) {
                listHitIndex = index;
                continue;
            }
            if (i == 3) {
                popHitIndex = index;
                continue;
            }
            catIndex = index;
        }
        if (goAccIndex < 4) {
            haveAcc = true;
            statIndex = 8;
        } else {
            statIndex = 7;
        }
        try {
            if (data[0][statIndex] == null) {
                statIndex = 7;
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            statIndex = 7;
        }
        this.nodes = new Vector(data.length);
        for (int i = 0; i < data.length; ++i) {
            if (data[i][catIndex].indexOf(this.category) == -1) continue;
            GONode node = new GONode(data[i][goAccIndex], data[i][termIndex], this.category, Double.parseDouble(data[i][statIndex]), Integer.parseInt(data[i][listHitIndex]), Integer.parseInt(data[i][listHitIndex + 1]), Integer.parseInt(data[i][popHitIndex]), Integer.parseInt(data[i][popHitIndex + 1]), i);
            node.setRenderingHint(1);
            node.setLowerThr(0.01);
            node.setUpperThr(0.05);
            this.nodes.addElement(node);
        }
        this.makeAssociations(this.nodes);
        GONode myRoot = new GONode("GO:00000001", this.category, this.category, 1.0, 100, 100, 100, 100, -1);
        myRoot.setRenderingHint(1);
        for (int i = 0; i < this.nodes.size(); ++i) {
            currNode = (GONode)((Object)this.nodes.elementAt(i));
            if (currNode.hasParents()) continue;
            currNode.addParent(myRoot);
            myRoot.addChild(currNode);
        }
        this.nodes.addElement(myRoot);
        this.setLevelIndex(this.nodes);
        int maxDepth = 0;
        for (int i = 0; i < this.nodes.size(); ++i) {
            currNode = (GONode)((Object)this.nodes.elementAt(i));
            maxDepth = Math.max(maxDepth, currNode.getLevel());
        }
        GONode[][] nodeData = new GONode[maxDepth + 1][];
        for (int i = 0; i < nodeData.length; ++i) {
            nodeData[i] = this.getLevelNodes(this.nodes, i);
        }
        ITreeNode[] children = myRoot.getChildren();
        if (children.length > 0) {
            myRoot.setListSize(((GONode)children[0]).getListSize());
            myRoot.setListHits(((GONode)children[0]).getListSize());
            myRoot.setPopSize(((GONode)children[0]).getPopSize());
            myRoot.setPopHits(((GONode)children[0]).getPopSize());
        }
        return nodeData;
    }

    private GONode[] getLevelNodes(Vector nodes, int level) {
        Vector<GONode> levelNodes = new Vector<GONode>();
        for (int i = 0; i < nodes.size(); ++i) {
            GONode node = (GONode)((Object)nodes.elementAt(i));
            if (node.getLevel() != level) continue;
            levelNodes.addElement(node);
        }
        GONode[] n = new GONode[levelNodes.size()];
        for (int i = 0; i < n.length; ++i) {
            n[i] = (GONode)((Object)levelNodes.elementAt(i));
        }
        return n;
    }

    private boolean makeAssociations(Vector nodes) {
        Hashtable<String, Vector<String>> impliesTable = null;
        try {
            impliesTable = this.getAllAssociations();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("fnfe");
            fnfe.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            System.out.println("ioe");
            ioe.printStackTrace();
            return false;
        }
        if (impliesTable == null || impliesTable.size() == 0) {
            return false;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            this.makeAssociations(impliesTable, nodes, (GONode)((Object)nodes.elementAt(i)));
        }
        return true;
    }

    private void makeAssociations(Hashtable impTable, Vector nodes, GONode baseNode) {
        String term = baseNode.getTerm();
        if (!impTable.containsKey(term)) {
            return;
        }
        Vector termVector = (Vector)impTable.get(term);
        if (termVector == null) {
            return;
        }
        for (int i = 0; i < termVector.size(); ++i) {
            GONode parentNode = this.getNode(nodes, (String)termVector.elementAt(i));
            if (parentNode == null) continue;
            baseNode.addParent(parentNode);
            parentNode.addChild(baseNode);
            this.makeAssociations(impTable, nodes, parentNode);
        }
    }

    public int getViewerWidth() {
        return this.tree.getTreePixelWidth();
    }

    private void setLevelIndex(Vector nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            GONode currNode = (GONode)((Object)nodes.elementAt(i));
            currNode.setLevel(currNode.getMaxPathLengthToRoot() - 1);
        }
    }

    private Hashtable<String, Vector<String>> getAllAssociations() throws FileNotFoundException, IOException {
        String line;
        Hashtable<String, Vector<String>> implied_associations = new Hashtable<String, Vector<String>>(10000);
        File file = new File(this.impliesFile);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((line = in.readLine()) != null) {
            int idx = line.indexOf(9);
            if (idx >= line.length() || idx < 1) continue;
            if (!implied_associations.containsKey(line.substring(0, idx).trim())) {
                implied_associations.put(line.substring(0, idx).trim(), new Vector());
                implied_associations.get(line.substring(0, idx).trim()).addElement(line.substring(idx, line.length()).trim());
                continue;
            }
            implied_associations.get(line.substring(0, idx).trim()).addElement(line.substring(idx, line.length()).trim());
        }
        return implied_associations;
    }

    private GONode getNode(Vector nodes, String key) {
        Iterator iter = nodes.iterator();
        GONode foundNode = null;
        boolean found = false;
        while (!found && iter.hasNext()) {
            GONode currNode = (GONode)((Object)iter.next());
            if (!key.equals(currNode.getTerm())) continue;
            foundNode = currNode;
            found = true;
        }
        return foundNode;
    }

    public int[][] getClusters() {
        return null;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData data) {
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu menu) {
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.header.update();
        if (this.viewerNode == null) {
            this.viewerNode = (DefaultMutableTreeNode)framework.getCurrentNode().getParent();
        }
    }

    private void setStraightConnectorStyle(boolean isStraight) {
        this.tree.setStraightConnectorStyle(isStraight);
        this.tree.repaint();
    }

    private void setVerboseNodeStyle(boolean isVerbose) {
        int rendering;
        if (isVerbose) {
            rendering = 0;
            this.tree.setInterNodeHeight(60);
            this.tree.setInterNodeWidth(30);
            if (this.showToolTip) {
                this.tree.removeMouseMotionListener((MouseMotionListener)this.mouseOverListener);
                this.tree.nodeUnderMouse = null;
            }
        } else {
            rendering = 1;
            this.tree.setInterNodeHeight(40);
            this.tree.setInterNodeWidth(15);
            if (this.showToolTip) {
                this.tree.addMouseMotionListener((MouseMotionListener)this.mouseOverListener);
            } else {
                this.tree.removeMouseMotionListener((MouseMotionListener)this.mouseOverListener);
            }
        }
        this.verbose = isVerbose;
        for (int i = 0; i < this.nodes.size(); ++i) {
            ((GONode)((Object)this.nodes.elementAt(i))).setRenderingHint(rendering);
        }
        int verticalBuffer = 0;
        int horizontalBuffer = 0;
        if (!this.verbose) {
            verticalBuffer = ((GONode)((Object)this.nodes.elementAt(0))).getToolTipHeight();
            horizontalBuffer = ((GONode)((Object)this.nodes.elementAt(0))).getToolTipWidth();
        }
        this.tree.updateSize(horizontalBuffer, verticalBuffer);
        this.tree.validate();
        this.header.update();
        this.validate();
        if (this.framework != null) {
            this.framework.refreshCurrentViewer();
            this.framework.getFrame().validate();
        }
        this.tree.repaint();
    }

    private void setThresholds() {
        EaseThresholdDialog dialog = new EaseThresholdDialog((JFrame)this.framework.getFrame(), this.lower, this.upper);
        if (dialog.showModal() == 0) {
            this.setThresholds(dialog.getUpperThreshold(), dialog.getLowerThreshold());
            this.tree.repaint();
            this.header.repaint();
        }
    }

    public void setThresholds(double upper, double lower) {
        this.lower = lower;
        this.upper = upper;
        for (int i = 0; i < this.nodes.size(); ++i) {
            GONode currNode = (GONode)((Object)this.nodes.elementAt(i));
            currNode.setLowerThr(lower);
            currNode.setUpperThr(upper);
        }
        this.header.setThresholds(upper, lower);
    }

    private void setSelected(int x, int y) {
        if (this.tree.checkSelection(x, y, this.selectionPolarity)) {
            this.newTreeMenu.setEnabled(true);
            this.launchMenu.setEnabled(true);
        } else {
            this.newTreeMenu.setEnabled(false);
            this.launchMenu.setEnabled(false);
        }
        this.tree.repaint();
    }

    private void launchNewGOTreeViewer() {
        int i;
        GONode node;
        Vector selectedNodes = this.tree.getSelectedPathNodes();
        if (selectedNodes.isEmpty()) {
            return;
        }
        Vector<GONode> nodes = new Vector<GONode>();
        int minLevel = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < selectedNodes.size(); ++i2) {
            node = (GONode)((Object)selectedNodes.elementAt(i2));
            minLevel = Math.min(minLevel, node.getLevel());
            nodes.add(new GONode(node));
        }
        int newDepth = 0;
        for (int i3 = 0; i3 < nodes.size(); ++i3) {
            node = (GONode)((Object)nodes.elementAt(i3));
            node.setLevel(node.getLevel() - minLevel);
            newDepth = Math.max(newDepth, node.getLevel());
            node.setRenderingHint(0);
        }
        this.pruneExtraNodes(nodes, selectedNodes, newDepth);
        Vector<GONode[]> levelArrayVector = new Vector<GONode[]>();
        for (int i4 = 0; i4 < newDepth + 1; ++i4) {
            levelArrayVector.addElement(this.getLevelNodes(nodes, i4));
        }
        Vector<GONode[]> toRemove = new Vector<GONode[]>();
        for (i = 0; i < levelArrayVector.size(); ++i) {
            GONode[] array = (GONode[])levelArrayVector.elementAt(i);
            if (array.length >= 1) continue;
            toRemove.add(array);
        }
        for (i = 0; i < toRemove.size(); ++i) {
            levelArrayVector.remove(toRemove.elementAt(i));
        }
        GONode[][] data = new GONode[levelArrayVector.size()][];
        for (int i5 = 0; i5 < data.length; ++i5) {
            data[i5] = (GONode[])levelArrayVector.elementAt(i5);
            for (int j = 0; j < data[i5].length; ++j) {
                data[i5][j].setLevel(i5);
            }
        }
        GOTreeViewer viewer = new GOTreeViewer(data, this.viewerNode, "");
        viewer.setThresholds(this.upper, this.lower);
        JFrame frame = new JFrame();
        JScrollPane pane = new JScrollPane(viewer.getContentComponent());
        pane.setColumnHeaderView(viewer.getHeaderComponent());
        frame.getContentPane().add(pane);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setSize(screenDim.width / 3, screenDim.height / 2);
        frame.setVisible(true);
        viewer.onSelected(this.framework);
    }

    private void pruneExtraNodes(Vector nodes, Vector selectedNodes, int depth) {
        for (int i = 0; i < nodes.size(); ++i) {
            GONode nodeToAdd;
            int j;
            GONode currNode = (GONode)((Object)nodes.elementAt(i));
            if (currNode.getLevel() == 0) {
                currNode.clearParents();
            } else {
                ITreeNode[] parents = currNode.getParents();
                Vector<GONode> parentsToKeep = new Vector<GONode>();
                for (j = 0; j < parents.length; ++j) {
                    nodeToAdd = null;
                    if (!selectedNodes.contains(parents[j]) || (nodeToAdd = this.findNode(nodes, ((GONode)parents[j]).getGOID())) == null) continue;
                    parentsToKeep.addElement(nodeToAdd);
                }
                currNode.setParents(parentsToKeep);
            }
            if (currNode.getLevel() == depth) {
                currNode.clearChildren();
                continue;
            }
            ITreeNode[] children = currNode.getChildren();
            Vector<GONode> childrenToKeep = new Vector<GONode>();
            for (j = 0; j < children.length; ++j) {
                nodeToAdd = null;
                if (!selectedNodes.contains(children[j]) || (nodeToAdd = this.findNode(nodes, ((GONode)children[j]).getGOID())) == null) continue;
                childrenToKeep.addElement(nodeToAdd);
            }
            currNode.setChildren(childrenToKeep);
        }
    }

    private void onOpenViewer(String viewerType) {
        GONode selNode = (GONode)this.tree.getSelectedNode();
        if (selNode == null) {
            return;
        }
        int index = selNode.getClusterIndex();
        if (index == -1 || this.viewerNode == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.viewerNode.getChildAt(1);
        if (node.getChildCount() < index) {
            return;
        }
        node = (DefaultMutableTreeNode)node.getChildAt(index);
        if (viewerType.equals("expression image")) {
            node = (DefaultMutableTreeNode)node.getChildAt(0);
        } else if (viewerType.equals("centroid graph")) {
            node = (DefaultMutableTreeNode)node.getChildAt(1);
        } else if (viewerType.equals("expression graph")) {
            node = (DefaultMutableTreeNode)node.getChildAt(2);
        }
        if (this.framework != null) {
            this.framework.setTreeNode(node);
        }
    }

    private void createDockedGOTreeViewer() {
        int i;
        GONode node;
        Vector selectedNodes = this.tree.getSelectedPathNodes();
        if (selectedNodes.isEmpty()) {
            return;
        }
        Vector<GONode> nodes = new Vector<GONode>();
        int minLevel = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < selectedNodes.size(); ++i2) {
            node = (GONode)((Object)selectedNodes.elementAt(i2));
            minLevel = Math.min(minLevel, node.getLevel());
            nodes.add(new GONode(node));
        }
        int newDepth = 0;
        for (int i3 = 0; i3 < nodes.size(); ++i3) {
            node = (GONode)((Object)nodes.elementAt(i3));
            node.setLevel(node.getLevel() - minLevel);
            newDepth = Math.max(newDepth, node.getLevel());
            node.setRenderingHint(0);
        }
        this.pruneExtraNodes(nodes, selectedNodes, newDepth);
        Vector<GONode[]> levelArrayVector = new Vector<GONode[]>();
        for (int i4 = 0; i4 < newDepth + 1; ++i4) {
            levelArrayVector.addElement(this.getLevelNodes(nodes, i4));
        }
        Vector<GONode[]> toRemove = new Vector<GONode[]>();
        for (i = 0; i < levelArrayVector.size(); ++i) {
            GONode[] array = (GONode[])levelArrayVector.elementAt(i);
            if (array.length >= 1) continue;
            toRemove.add(array);
        }
        for (i = 0; i < toRemove.size(); ++i) {
            levelArrayVector.remove(toRemove.elementAt(i));
        }
        GONode[][] data = new GONode[levelArrayVector.size()][];
        for (int i5 = 0; i5 < data.length; ++i5) {
            data[i5] = (GONode[])levelArrayVector.elementAt(i5);
            for (int j = 0; j < data[i5].length; ++j) {
                data[i5][j].setLevel(i5);
            }
        }
        GOTreeViewer viewer = new GOTreeViewer(data, this.viewerNode, "");
        viewer.setThresholds(this.upper, this.lower);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new LeafInfo("GO Subtree", (IViewer)viewer));
        this.framework.addNode(this.viewerNode, newNode);
        this.framework.setTreeNode(newNode);
    }

    private GONode findNode(Vector nodes, String goID) {
        for (int i = 0; i < nodes.size(); ++i) {
            if (!((GONode)((Object)nodes.elementAt(i))).getGOID().equals(goID)) continue;
            return (GONode)((Object)nodes.elementAt(i));
        }
        return null;
    }

    private void createPopupMenu(ActionListener listener) {
        this.popup = new JPopupMenu();
        JMenu menu = new JMenu("Node Style");
        ButtonGroup bg = new ButtonGroup();
        JCheckBoxMenuItem checkBoxItem = new JCheckBoxMenuItem("Minimal", true);
        checkBoxItem.setActionCommand("simple-node-command");
        checkBoxItem.addActionListener(listener);
        bg.add(checkBoxItem);
        menu.add(checkBoxItem);
        checkBoxItem = new JCheckBoxMenuItem("Verbose");
        checkBoxItem.setActionCommand("verbose-node-command");
        checkBoxItem.addActionListener(listener);
        bg.add(checkBoxItem);
        menu.add(checkBoxItem);
        this.popup.add(menu);
        this.popup.addSeparator();
        menu = new JMenu("Connector Style");
        bg = new ButtonGroup();
        checkBoxItem = new JCheckBoxMenuItem("Curved", true);
        checkBoxItem.setActionCommand("curved-connector-command");
        checkBoxItem.addActionListener(listener);
        bg.add(checkBoxItem);
        menu.add(checkBoxItem);
        checkBoxItem = new JCheckBoxMenuItem("Straight");
        checkBoxItem.setActionCommand("straight-connector-command");
        checkBoxItem.addActionListener(listener);
        bg.add(checkBoxItem);
        menu.add(checkBoxItem);
        this.popup.add(menu);
        this.popup.addSeparator();
        JMenuItem item = new JMenuItem("Set Thresholds");
        item.setActionCommand("set-thresholds-command");
        item.addActionListener(listener);
        this.popup.add(item);
        this.popup.addSeparator();
        menu = new JMenu("Selection Polarity");
        bg = new ButtonGroup();
        JCheckBoxMenuItem box = new JCheckBoxMenuItem("Select Ancestors");
        box.setActionCommand("ancestor-selection-command");
        box.addActionListener(listener);
        bg.add(box);
        menu.add(box);
        box = new JCheckBoxMenuItem("Select Successors");
        box.setActionCommand("successor-selection-command");
        box.addActionListener(listener);
        bg.add(box);
        menu.add(box);
        box = new JCheckBoxMenuItem("Bipolar Selection", true);
        box.setActionCommand("bipolar-selection-command");
        box.addActionListener(listener);
        bg.add(box);
        menu.add(box);
        this.popup.add(menu);
        this.popup.addSeparator();
        this.newTreeMenu = new JMenu("Create Subset Viewer");
        this.newTreeMenu.setEnabled(false);
        item = new JMenuItem("In New Window...");
        item.setActionCommand("new-subtree-command");
        item.addActionListener(listener);
        this.newTreeMenu.add(item);
        item = new JMenuItem("Docked in Result Tree...");
        item.setActionCommand("new-docked-subtree-command");
        item.addActionListener(listener);
        this.newTreeMenu.add(item);
        this.popup.add(this.newTreeMenu);
        this.popup.addSeparator();
        this.launchMenu = new JMenu("Open Viewer");
        this.launchMenu.setEnabled(false);
        item = new JMenuItem("Expression Image");
        item.setActionCommand("launch-expression-image-command");
        item.addActionListener(listener);
        this.launchMenu.add(item);
        item = new JMenuItem("Centroid Graph");
        item.setActionCommand("launch-centroid-graph-command");
        item.addActionListener(listener);
        this.launchMenu.add(item);
        item = new JMenuItem("Expression Graph");
        item.setActionCommand("launch-expression-graph-command");
        item.addActionListener(listener);
        this.launchMenu.add(item);
        this.popup.add(this.launchMenu);
    }

    public int getViewerType() {
        return -1;
    }

    public void setExperiment(Experiment e) {
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public void setExperimentID(int id) {
        this.exptID = id;
    }

    private class MouseOverListener
    implements MouseMotionListener {
        private MouseOverListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ((GOTreeViewer)GOTreeViewer.this).tree.nodeUnderMouse = GOTreeViewer.this.tree.getNodeUnder(e.getX(), e.getY());
            GOTreeViewer.this.repaint();
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("verbose-node-command")) {
                GOTreeViewer.this.setVerboseNodeStyle(true);
            } else if (command.equals("simple-node-command")) {
                GOTreeViewer.this.setVerboseNodeStyle(false);
            } else if (command.equals("straight-connector-command")) {
                GOTreeViewer.this.setStraightConnectorStyle(true);
            } else if (command.equals("curved-connector-command")) {
                GOTreeViewer.this.setStraightConnectorStyle(false);
            } else if (command.equals("set-thresholds-command")) {
                GOTreeViewer.this.setThresholds();
            } else if (command.equals("bipolar-selection-command")) {
                GOTreeViewer.this.selectionPolarity = 0;
            } else if (command.equals("ancestor-selection-command")) {
                GOTreeViewer.this.selectionPolarity = 1;
            } else if (command.equals("successor-selection-command")) {
                GOTreeViewer.this.selectionPolarity = 2;
            } else if (command.equals("new-subtree-command")) {
                GOTreeViewer.this.launchNewGOTreeViewer();
            } else if (command.equals("new-docked-subtree-command")) {
                GOTreeViewer.this.createDockedGOTreeViewer();
            } else if (command.equals("launch-expression-image-command")) {
                GOTreeViewer.this.onOpenViewer("expression image");
            } else if (command.equals("launch-centroid-graph-command")) {
                GOTreeViewer.this.onOpenViewer("centroid graph");
            } else if (command.equals("launch-expression-graph-command")) {
                GOTreeViewer.this.onOpenViewer("expression graph");
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                GOTreeViewer.this.popup.show((Component)GOTreeViewer.this.tree, evt.getX(), evt.getY());
            } else if (evt.getModifiers() == 16) {
                GOTreeViewer.this.setSelected(evt.getX(), evt.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                GOTreeViewer.this.popup.show((Component)GOTreeViewer.this.tree, evt.getX(), evt.getY());
            } else if (evt.getModifiers() == 16) {
                GOTreeViewer.this.setSelected(evt.getX(), evt.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                GOTreeViewer.this.popup.show((Component)GOTreeViewer.this.tree, evt.getX(), evt.getY());
            } else if (evt.getModifiers() == 16) {
                GOTreeViewer.this.setSelected(evt.getX(), evt.getY());
            }
        }
    }
}

