/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.goseq.gotree;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.gui.helpers.ktree.ITreeNode;
import org.tigr.microarray.mev.cluster.gui.helpers.ktree.ITreeNodeRenderer;
import org.tigr.microarray.mev.cluster.gui.helpers.ktree.KNodeImpl;

public class GONode
extends KNodeImpl
implements ITreeNodeRenderer {
    private String goID;
    private String goTerm;
    private String goCategory;
    private double pValue;
    private int listHits;
    private int listSize;
    private int popHits;
    private int popSize;
    private double lowerThr;
    private double upperThr;
    private int clusterIndex = -1;
    private int renderingHint;
    private int VERBOSE_HEIGHT = 130;
    private int VERBOSE_WIDTH = 125;
    private int NON_VERBOSE_HEIGHT = 15;
    private int NON_VERBOSE_WIDTH = 15;
    private int GO_ID_HEIGHT = 20;
    private int GO_TERM_HEIGHT = 70;
    private int GO_STAT_HEIGHT = 20;
    private int GO_POP_HEIGHT = 20;

    public void setParents(ITreeNode[] p) {
        Vector<ITreeNode> v = new Vector<ITreeNode>(p.length);
        for (int i = 0; i < p.length; ++i) {
            v.add(p[i]);
        }
        this.setParents(v);
    }

    public void setChildren(ITreeNode[] c) {
        Vector<ITreeNode> v = new Vector<ITreeNode>(c.length);
        for (int i = 0; i < c.length; ++i) {
            v.add(c[i]);
        }
        this.setChildren(v);
    }

    public GONode() {
    }

    public GONode(String goID, String goTerm, String goCategory, double pValue, int clusterHits, int clusterSize, int popHits, int popSize, int clusterIndex) {
        this.goID = goID;
        this.goTerm = goTerm;
        this.goCategory = goCategory;
        this.pValue = pValue;
        this.listHits = clusterHits;
        this.listSize = clusterSize;
        this.popHits = popHits;
        this.popSize = popSize;
        this.clusterIndex = clusterIndex;
    }

    public GONode(GONode origNode) {
        this.goID = origNode.getGOID();
        this.goTerm = origNode.getTerm();
        this.goCategory = origNode.getCategory();
        this.pValue = origNode.getPValue();
        this.listHits = origNode.getListHits();
        this.listSize = origNode.getListSize();
        this.popHits = origNode.getPopHits();
        this.popSize = origNode.getPopSize();
        this.upperThr = origNode.getUpperThr();
        this.lowerThr = origNode.getLowerThr();
        this.children = origNode.getChildren();
        this.parents = origNode.getParents();
        this.level = origNode.getLevel();
        this.verboseRendering = origNode.isVerboseRendering();
        this.clusterIndex = origNode.getClusterIndex();
    }

    public String getTerm() {
        return this.goTerm;
    }

    public String getGOID() {
        return this.goID;
    }

    public double getPValue() {
        return this.pValue;
    }

    public String getCategory() {
        return this.goCategory;
    }

    public int getListHits() {
        return this.listHits;
    }

    public int getListSize() {
        return this.listSize;
    }

    public int getPopHits() {
        return this.popHits;
    }

    public int getPopSize() {
        return this.popSize;
    }

    public void setTerm(String term) {
        this.goTerm = term;
    }

    public void setListHits(int hits) {
        this.listHits = hits;
    }

    public void setListSize(int size) {
        this.listSize = size;
    }

    public void setPopHits(int hits) {
        this.popHits = hits;
    }

    public void setPopSize(int size) {
        this.popSize = size;
    }

    public void setLowerThr(double lower) {
        this.lowerThr = lower;
    }

    public void setUpperThr(double upper) {
        this.upperThr = upper;
    }

    public double getLowerThr() {
        return this.lowerThr;
    }

    public double getUpperThr() {
        return this.upperThr;
    }

    public int getClusterIndex() {
        return this.clusterIndex;
    }

    public void addChild(GONode node) {
        super.addChild((ITreeNode)node);
    }

    public void addParent(GONode node) {
        super.addParent((ITreeNode)node);
    }

    public int getToolTipHeight() {
        return this.VERBOSE_HEIGHT;
    }

    public int getToolTipWidth() {
        return this.VERBOSE_WIDTH;
    }

    public void setRenderingHint(int hint) {
        this.renderingHint = hint;
        this.setDimensions();
    }

    public void renderNode(Graphics2D g2, int x, int y, int modifier) {
        Color origColor = g2.getColor();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Composite composite = g2.getComposite();
        if (modifier == 3) {
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, 0.3f);
            g2.setComposite(alphaComp);
        }
        int yOffset = 0;
        this.x = x;
        this.y = y;
        if (this.verboseRendering) {
            String pStr;
            this.x = x;
            this.y = y;
            g2.drawRect(x, y, this.w, this.h);
            g2.drawRect(x + 1, y + ++yOffset, this.w - 2, this.h - 2);
            if (this.pValue > this.upperThr) {
                g2.setColor(Color.green);
            } else if (this.pValue <= this.upperThr && this.pValue > this.lowerThr) {
                g2.setColor(Color.orange);
            } else {
                g2.setColor(Color.red);
            }
            g2.fillRect(x + 2, y + ++yOffset, this.w - 3, this.GO_ID_HEIGHT);
            g2.setColor(origColor);
            TextLayout layout = new TextLayout(this.goID, g2.getFont(), g2.getFontRenderContext());
            layout.draw(g2, (float)x + ((float)this.w - layout.getAdvance()) / 2.0f, (float)y + layout.getAscent() + ((float)this.GO_ID_HEIGHT - layout.getAscent()) / 2.0f);
            g2.drawLine(x, y + (yOffset += this.GO_ID_HEIGHT), x + this.w, y + yOffset);
            int yLoc = y + yOffset + 2;
            int marginLoc = x + 6;
            this.renderGoTermText(g2, marginLoc, yLoc, x, y);
            g2.drawLine(x, y + this.GO_TERM_HEIGHT + yOffset, x + this.w, y + this.GO_TERM_HEIGHT + yOffset);
            yOffset += this.GO_TERM_HEIGHT;
            if (this.pValue < 1.0E-4) {
                DecimalFormat format = new DecimalFormat("0.#####E00");
                pStr = format.format(this.pValue);
            } else {
                DecimalFormat format = new DecimalFormat("0.#####");
                pStr = format.format(this.pValue);
            }
            layout = new TextLayout("p = " + pStr, g2.getFont(), g2.getFontRenderContext());
            layout.draw(g2, (float)x + ((float)this.w - layout.getAdvance()) / 2.0f, (float)(y + yOffset) + layout.getAscent() + ((float)this.GO_STAT_HEIGHT - layout.getAscent()) / 2.0f);
            g2.drawLine(x, y + this.GO_STAT_HEIGHT + yOffset, x + this.w, y + this.GO_STAT_HEIGHT + yOffset);
            layout = new TextLayout("(" + String.valueOf(this.listHits) + ")   (" + String.valueOf(this.popHits) + ")", g2.getFont(), g2.getFontRenderContext());
            layout.draw(g2, (float)x + ((float)this.w - layout.getAdvance()) / 2.0f, (float)(y + (yOffset += this.GO_STAT_HEIGHT)) + layout.getAscent() + ((float)this.GO_POP_HEIGHT - layout.getAscent()) / 2.0f - 2.0f);
            if (modifier == 1) {
                g2.setColor(Color.red);
                g2.drawRect(x - 3, y - 3, this.w + 6, this.h + 6);
                g2.drawRect(x - 2, y - 2, this.w + 4, this.h + 4);
                g2.setColor(origColor);
            } else if (modifier == 2) {
                g2.setColor(Color.blue);
                g2.drawRect(x - 3, y - 3, this.w + 6, this.h + 6);
                g2.drawRect(x - 2, y - 2, this.w + 4, this.h + 4);
                g2.setColor(origColor);
            }
        } else {
            if (this.pValue > this.upperThr) {
                g2.setColor(Color.green);
            } else if (this.pValue <= this.upperThr && this.pValue > this.lowerThr) {
                g2.setColor(Color.orange);
            } else {
                g2.setColor(Color.red);
            }
            g2.fillOval(x, y, this.w, this.h);
            g2.setColor(Color.black);
            g2.drawOval(x, y, this.w, this.h);
            g2.setColor(origColor);
            if (modifier == 1) {
                g2.setColor(Color.red);
                g2.drawOval(x - 3, y - 3, this.w + 6, this.h + 6);
                g2.drawOval(x - 2, y - 2, this.w + 4, this.h + 4);
                g2.setColor(origColor);
            } else if (modifier == 2) {
                g2.setColor(Color.blue);
                g2.drawOval(x - 3, y - 3, this.w + 6, this.h + 6);
                g2.drawOval(x - 2, y - 2, this.w + 4, this.h + 4);
                g2.setColor(origColor);
            }
        }
        g2.setComposite(composite);
    }

    public void renderVerboseTip(Graphics2D g2) {
        String pStr;
        int x = this.x + this.NON_VERBOSE_WIDTH / 2;
        int y = this.y + this.NON_VERBOSE_HEIGHT / 2;
        this.renderingHint = 0;
        this.setDimensions();
        Color origColor = g2.getColor();
        Composite origComposite = g2.getComposite();
        AlphaComposite alphaComp = AlphaComposite.getInstance(3, 0.8f);
        g2.setComposite(alphaComp);
        g2.setColor(Color.white);
        g2.fillRect(x + 2, y + 2, this.w - 4, this.h - 4);
        g2.setColor(origColor);
        int yOffset = 0;
        if (this.pValue > this.upperThr) {
            g2.setColor(Color.green);
        } else if (this.pValue <= this.upperThr && this.pValue > this.lowerThr) {
            g2.setColor(Color.orange);
        } else {
            g2.setColor(Color.red);
        }
        g2.fillRect(x + 2, y + (yOffset += 2), this.w - 3, this.GO_ID_HEIGHT);
        g2.setComposite(origComposite);
        g2.setColor(origColor);
        yOffset = 0;
        g2.drawRect(x, y, this.w, this.h);
        g2.drawRect(x + 1, y + ++yOffset, this.w - 2, this.h - 2);
        ++yOffset;
        TextLayout layout = new TextLayout(this.goID, g2.getFont(), g2.getFontRenderContext());
        layout.draw(g2, (float)x + ((float)this.w - layout.getAdvance()) / 2.0f, (float)y + layout.getAscent() + ((float)this.GO_ID_HEIGHT - layout.getAscent()) / 2.0f);
        g2.drawLine(x, y + (yOffset += this.GO_ID_HEIGHT), x + this.w, y + yOffset);
        int yLoc = y + yOffset + 2;
        int marginLoc = x + 6;
        this.renderGoTermText(g2, marginLoc, yLoc, x, y);
        g2.drawLine(x, y + this.GO_TERM_HEIGHT + yOffset, x + this.w, y + this.GO_TERM_HEIGHT + yOffset);
        yOffset += this.GO_TERM_HEIGHT;
        if (this.pValue < 1.0E-4) {
            DecimalFormat format = new DecimalFormat("0.#####E00");
            pStr = format.format(this.pValue);
        } else {
            DecimalFormat format = new DecimalFormat("0.#####");
            pStr = format.format(this.pValue);
        }
        layout = new TextLayout("p = " + pStr, g2.getFont(), g2.getFontRenderContext());
        layout.draw(g2, (float)x + ((float)this.w - layout.getAdvance()) / 2.0f, (float)(y + yOffset) + layout.getAscent() + ((float)this.GO_STAT_HEIGHT - layout.getAscent()) / 2.0f);
        g2.drawLine(x, y + this.GO_STAT_HEIGHT + yOffset, x + this.w, y + this.GO_STAT_HEIGHT + yOffset);
        layout = new TextLayout("(" + String.valueOf(this.listHits) + ")   (" + String.valueOf(this.popHits) + ")", g2.getFont(), g2.getFontRenderContext());
        layout.draw(g2, (float)x + ((float)this.w - layout.getAdvance()) / 2.0f, (float)(y + (yOffset += this.GO_STAT_HEIGHT)) + layout.getAscent() + ((float)this.GO_POP_HEIGHT - layout.getAscent()) / 2.0f - 2.0f);
        this.renderingHint = 1;
        this.setDimensions();
    }

    private void renderPVaue(Graphics2D g2, int yOffset) {
        DecimalFormat format = new DecimalFormat();
        format.setMaximumFractionDigits(5);
        format.setMaximumIntegerDigits(1);
        format.setMinimumIntegerDigits(1);
        format.setMinimumFractionDigits(4);
        String pStr = format.format(this.pValue);
        TextLayout layout = new TextLayout("p = " + pStr, g2.getFont(), g2.getFontRenderContext());
        layout.draw(g2, (float)this.x + ((float)this.w - layout.getAdvance()) / 2.0f, (float)(this.y + yOffset) + layout.getAscent() + ((float)this.GO_STAT_HEIGHT - layout.getAscent()) / 2.0f);
    }

    private void renderGoTermText(Graphics2D g2, int marginLoc, int yLoc, int x, int y) {
        Point2D.Float penPoint;
        TextLayout layout;
        Rectangle newClip;
        Rectangle origClip = g2.getClipBounds();
        if (!origClip.intersects(newClip = new Rectangle(x, yLoc, x + this.w < origClip.x + origClip.width ? this.w : origClip.x + origClip.width - x, yLoc + this.GO_TERM_HEIGHT < origClip.y + origClip.height ? this.GO_TERM_HEIGHT : origClip.y + origClip.height - yLoc))) {
            return;
        }
        if (newClip.y < origClip.y) {
            newClip.y = origClip.y;
        }
        g2.setClip(newClip);
        AttributedString goTermAttStr = new AttributedString(this.goTerm);
        goTermAttStr.addAttribute(TextAttribute.JUSTIFICATION, TextAttribute.JUSTIFICATION_NONE);
        goTermAttStr.addAttribute(TextAttribute.FONT, new Font("Arial", 0, 12));
        int width = g2.getFontMetrics().stringWidth(this.goTerm);
        if (width > 4 * this.w) {
            goTermAttStr.addAttribute(TextAttribute.FONT, new Font("Arial", 0, 11));
        }
        AttributedCharacterIterator iter = goTermAttStr.getIterator();
        FontRenderContext frc = new FontRenderContext(null, true, true);
        LineBreakMeasurer lbm = new LineBreakMeasurer(iter, frc);
        Vector<TextLayout> layouts = new Vector<TextLayout>();
        Vector<Point2D.Float> penPos = new Vector<Point2D.Float>();
        while (lbm.getPosition() < iter.getEndIndex()) {
            layout = lbm.nextLayout(this.w - 10);
            yLoc = (int)((float)yLoc + layout.getAscent());
            penPoint = new Point2D.Float(marginLoc, yLoc);
            if (layouts.size() > 0) {
                TextLayout prevLine = (TextLayout)layouts.elementAt(layouts.size() - 1);
                prevLine = prevLine.getJustifiedLayout(this.w - 10);
                layouts.setElementAt(prevLine, layouts.size() - 1);
            }
            penPos.addElement(penPoint);
            layouts.addElement(layout);
            yLoc = (int)((float)yLoc + (layout.getDescent() + layout.getLeading()));
        }
        for (int i = 0; i < layouts.size(); ++i) {
            layout = (TextLayout)layouts.elementAt(i);
            penPoint = (Point2D.Float)penPos.elementAt(i);
            layout.draw(g2, penPoint.x, penPoint.y);
        }
        g2.setClip(origClip);
    }

    private void setDimensions() {
        if (this.renderingHint == 0) {
            this.w = this.VERBOSE_WIDTH;
            this.h = this.VERBOSE_HEIGHT;
            this.verboseRendering = true;
        } else {
            this.w = this.NON_VERBOSE_WIDTH;
            this.h = this.NON_VERBOSE_HEIGHT;
            this.verboseRendering = false;
        }
    }

    public String getGoCategory() {
        return this.goCategory;
    }

    public void setGoCategory(String goCategory) {
        this.goCategory = goCategory;
    }

    public String getGoID() {
        return this.goID;
    }

    public void setGoID(String goID) {
        this.goID = goID;
    }

    public String getGoTerm() {
        return this.goTerm;
    }

    public void setGoTerm(String goTerm) {
        this.goTerm = goTerm;
    }

    public void setClusterIndex(int clusterIndex) {
        this.clusterIndex = clusterIndex;
    }

    public void setPValue(double value) {
        this.pValue = value;
    }
}

