/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.goseq;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.Expression;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.FloatMatrix;

public class GOSEQPlotViewer
extends ViewerAdapter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private JComponent content;
    IFramework framework;
    FloatMatrix data;
    String[] labels;
    String biasString = "Transcript Length";
    int[] samplesOrder;
    private float minValue;
    private double maxValue;
    int ticks = 21;
    static boolean orderedSamples = false;
    protected static final String ORDERED_SAMPLES = "order-samples";

    public GOSEQPlotViewer(float[][] data, String biasString) {
        this(new FloatMatrix(data), biasString);
    }

    public GOSEQPlotViewer(FloatMatrix data, String biasString) {
        this.data = data;
        this.biasString = biasString;
        this.initLabels();
        this.content = this.createContent(data.A, this.labels, this.minValue, this.maxValue);
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.data, this.biasString});
    }

    @Override
    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.content.updateUI();
        this.content.repaint();
    }

    private void initLabels() {
        float minValue = 0.0f;
        float maxValue = Float.NEGATIVE_INFINITY;
        for (int i = 1; i < this.data.A.length; ++i) {
            for (int j = 0; j < this.data.A[i].length; ++j) {
                if (this.data.A[i][j] < minValue) {
                    minValue = this.data.A[i][j];
                }
                if (!(this.data.A[i][j] > maxValue)) continue;
                maxValue = this.data.A[i][j];
            }
        }
        this.minValue = minValue;
        this.maxValue = maxValue * 1.1f;
        float min = 0.0f;
        String[] ccLabels = new String[this.ticks];
        float max = this.data.A[0][this.data.A[0].length - 1];
        for (int i = 0; i < this.ticks; ++i) {
            ccLabels[i] = Integer.toString((int)((float)i * (max - min) / (float)(this.ticks - 1)));
        }
        this.labels = ccLabels;
        this.samplesOrder = new int[this.labels.length];
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    private JComponent createContent(float[][] data, String[] labels, double minValue, double maxValue) {
        return new Plot(data, labels, minValue, maxValue);
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    public static void main(String[] args) {
        int i;
        float[][] fm = new float[20][20];
        for (i = 0; i < fm.length; ++i) {
            for (int j = 0; j < fm[i].length; ++j) {
                fm[i][j] = 0.0f;
            }
        }
        fm[0][0] = 2000.0f;
        fm[1][1] = 2000.0f;
        fm[0][1] = 4000.0f;
        fm[1][0] = 4000.0f;
        for (i = 0; i < fm.length; ++i) {
            fm[i][i] = i;
        }
        fm[0][0] = 20.0f;
        float[][] fa = new float[][]{{0.09f, 0.28f, 0.32f, 0.6f, 0.8f, 1.2f, 2.09f, 3.28f, 4.32f, 5.6f, 6.8f, 11.2f}, {0.99f, 0.88f, 0.72f, 0.1f, 0.3f, -0.2f, 0.09f, 0.28f, 0.32f, 0.6f, 0.8f, 1.2f}, {0.99f, 1.1f, 1.72f, 2.1f, 0.4f, 0.0f, 0.28f, 0.76f, 0.32f, 0.6f, 0.8f, 1.2f}};
        GOSEQPlotViewer pv = new GOSEQPlotViewer(fa, "tran");
        JDialog jd = new JDialog();
        pv.onSelected(null);
        jd.add(pv.getContentComponent());
        jd.setSize(1200, 800);
        jd.setBackground(Color.yellow);
        jd.setForeground(Color.blue);
        jd.setModal(true);
        jd.setVisible(true);
        System.exit(0);
    }

    private class Plot
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected JPopupMenu popup;
        double maxValue = 1.0;
        double minValue = 0.7;
        Color[] colors;
        private static final int left = 80;
        private static final int top = 40;
        private float[][] data;
        private String[] labels;
        private Font font = new Font("monospaced", 1, 10);

        public Plot(float[][] data, String[] labels, double minValue, double maxValue) {
            this.setBackground(Color.white);
            this.setFont(this.font);
            this.data = data;
            this.labels = labels;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.colors = new Color[data.length];
            this.fillColors();
            this.init();
        }

        private void fillColors() {
            Color[] colorOrder = new Color[]{Color.red, Color.green, Color.blue, Color.yellow, Color.ORANGE, Color.black};
            for (int i = 0; i < this.colors.length; ++i) {
                if (i < colorOrder.length) {
                    this.colors[i] = colorOrder[i];
                    continue;
                }
                int red = (int)(Math.random() * 256.0);
                int green = (int)(Math.random() * 256.0);
                int blue = (int)(Math.random() * 256.0);
                this.colors[i] = new Color(red, green, blue);
            }
        }

        @Override
        public void paint(Graphics g) {
            int width;
            String str;
            super.paint(g);
            int plotWidth = this.getWidth() - 160;
            int plotHeight = this.getHeight() - 200;
            if (plotWidth < 5 || plotHeight < 5) {
                return;
            }
            g.setColor(Color.black);
            g.drawRect(80, 40, plotWidth, plotHeight);
            int steps = 10;
            double stepValue = (this.maxValue - this.minValue) / (double)steps;
            if (Double.isNaN(this.maxValue)) {
                return;
            }
            float scale = (float)(this.maxValue - this.minValue);
            double stepY = (double)plotHeight / (double)steps;
            for (int i = 1; i < steps; ++i) {
                g.drawLine(80, 40 + (int)Math.round((double)i * stepY), 85, 40 + (int)Math.round((double)i * stepY));
            }
            double stepX = (double)plotWidth / ((double)GOSEQPlotViewer.this.ticks - 1.0);
            for (int i = 1; i < GOSEQPlotViewer.this.ticks; ++i) {
                g.drawLine(80 + (int)Math.round((double)i * stepX), 40 + plotHeight - 5, 80 + (int)Math.round((double)i * stepX), 40 + plotHeight);
            }
            FontMetrics metrics = g.getFontMetrics();
            for (int i = 0; i <= steps; ++i) {
                str = String.valueOf((double)Math.round(100.0 * (this.maxValue - stepValue * (double)i)) / 100.0);
                width = metrics.stringWidth(str);
                g.drawString(str, 70 - width, 40 + (int)Math.round((double)i * stepY) + 5);
            }
            ((Graphics2D)g).rotate(-1.5707963267948966);
            g.setColor(Color.blue);
            int labelFreq = this.labels.length / 100 + 1;
            stepX = (double)plotWidth / ((double)GOSEQPlotViewer.this.ticks - 1.0);
            for (int i = 0; i < this.labels.length / labelFreq; ++i) {
                str = String.valueOf(this.labels[orderedSamples ? GOSEQPlotViewer.this.samplesOrder[i * labelFreq] : i * labelFreq]);
                width = metrics.stringWidth(str);
                g.drawString(str, -40 - plotHeight - 10 - width, 85 + (int)Math.round((double)(i * labelFreq) * stepX));
            }
            ((Graphics2D)g).rotate(1.5707963267948966);
            g.setFont(new Font("monospaced", 1, 20));
            g.drawString(GOSEQPlotViewer.this.biasString, plotWidth / 2, 40 + plotHeight + 100);
            ((Graphics2D)g).rotate(-1.5707963267948966);
            g.drawString("Probability of Differential Expression", -40 - plotHeight / 2 - 200, 20);
            ((Graphics2D)g).rotate(1.5707963267948966);
            for (int j = 1; j < this.data.length; ++j) {
                int curValue;
                int i;
                g.setColor(this.colors[j]);
                double factor = plotHeight;
                int prevValue = -((int)Math.round(((double)this.data[j][orderedSamples ? GOSEQPlotViewer.this.samplesOrder[0] : 0] - this.minValue) * factor / (double)scale));
                float maxXAxis = this.data[0][this.data[0].length - 1] / (float)plotWidth;
                int zeroValue = 40 + plotHeight;
                g.setColor(Color.blue);
                if (j == 1) {
                    for (i = 0; i < this.data[j].length; ++i) {
                        curValue = -((int)Math.round(((double)this.data[j][orderedSamples ? GOSEQPlotViewer.this.samplesOrder[i] : i] - this.minValue) * factor / (double)scale));
                        g.fillOval(80 + (int)(this.data[0][i] / maxXAxis) - 3, zeroValue + curValue - 3, 6, 6);
                    }
                }
                g.setColor(Color.red);
                if (j != 2) continue;
                for (i = 1; i < this.data[j].length; ++i) {
                    curValue = -((int)Math.round(((double)this.data[j][orderedSamples ? GOSEQPlotViewer.this.samplesOrder[i] : i] - this.minValue) * factor / (double)scale));
                    g.drawLine(80 + (int)(this.data[0][i - 1] / maxXAxis), zeroValue + prevValue, 80 + (int)(this.data[0][i] / maxXAxis), zeroValue + curValue);
                    prevValue = curValue;
                }
            }
        }

        private void setOrdered() {
            orderedSamples = !orderedSamples;
            Listener listener = new Listener();
            this.popup = this.createJPopupMenu(listener);
        }

        private void init() {
            Listener listener = new Listener();
            this.popup = this.createJPopupMenu(listener);
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
            this.repaint();
        }

        protected JPopupMenu createJPopupMenu(ActionListener listener) {
            JPopupMenu popup = new JPopupMenu();
            this.addMenuItems(popup, listener);
            return popup;
        }

        protected void addMenuItems(JPopupMenu menu, ActionListener listener) {
            JMenuItem menuItem = new JMenuItem("Arrange/reset Samples order", GUIFactory.getIcon("new16.gif"));
            menuItem.setActionCommand(GOSEQPlotViewer.ORDERED_SAMPLES);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
        }

        private class Listener
        extends MouseAdapter
        implements MouseMotionListener,
        ActionListener {
            private Listener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command.equals(GOSEQPlotViewer.ORDERED_SAMPLES)) {
                    Plot.this.setOrdered();
                    Plot.this.repaint();
                }
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event)) {
                    return;
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                this.maybeShowPopup(event);
                if (event.isPopupTrigger()) {
                    return;
                }
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Plot.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    Plot.this.repaint();
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        }
    }
}

