/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.goseq;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.tigr.microarray.mev.annotation.AnnotationFieldConstants;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterBrowser;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.BroadGeneSet;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.BroadGeneSetList;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GeneSigDbGeneSets;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.resources.FileResourceManager;
import org.tigr.microarray.mev.resources.ISupportFileDefinition;
import org.tigr.microarray.mev.resources.RepositoryInitializationError;
import org.tigr.microarray.mev.resources.SelectMultiFilesDialog;
import org.tigr.microarray.mev.resources.SupportFileAccessError;

public class GOSEQInitBox
extends AlgorithmDialog {
    private static final long serialVersionUID = 1L;
    boolean okPressed = false;
    boolean okReady = false;
    Vector<String> exptNames;
    ClusterBrowserPanel mPanel;
    GeneSetFilePanel clusterAnalysisPanel;
    JTabbedPane selectionPanel;
    ClusterRepository repository;
    private String[] annotFields;
    private JTabbedPane analysisTypeTab;
    private GOAnalysisPanel goPanel;
    private GeneSetFilePanel runDEAnalysisPanel;
    private FileResourceManager frm;
    private boolean geneSigValid = false;
    private String errorString = "ERROR:";
    boolean msigOK = false;

    public GOSEQInitBox(JFrame parentFrame, boolean modality, Vector<String> exptNames, String[] annotFields, ClusterRepository repository) {
        super(parentFrame, "GOSEQ Initialization", modality);
        this.annotFields = annotFields;
        this.exptNames = exptNames;
        this.repository = repository;
        this.setBounds(0, 0, 1000, 850);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        this.analysisTypeTab = new JTabbedPane();
        this.clusterAnalysisPanel = new GeneSetFilePanel(false);
        this.goPanel = new GOAnalysisPanel();
        this.runDEAnalysisPanel = new GeneSetFilePanel(true);
        this.analysisTypeTab.add((Component)this.goPanel, "GO Analysis");
        this.analysisTypeTab.add((Component)this.clusterAnalysisPanel, "Cluster Analysis");
        this.analysisTypeTab.add((Component)this.runDEAnalysisPanel, "Differential Expression Analysis");
        this.analysisTypeTab.setSelectedIndex(1);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 80);
        gridbag.setConstraints(this.analysisTypeTab, constraints);
        pane.add(this.analysisTypeTab);
        this.mPanel = new ClusterBrowserPanel();
        this.buildConstraints(constraints, 0, 1, 1, 1, 100, 80);
        gridbag.setConstraints(this.mPanel, constraints);
        pane.add(this.mPanel);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy, int anc, int fill) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.anchor = anc;
        gbc.fill = fill;
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public void enableOK() {
        this.okButton.setEnabled(true);
    }

    private boolean isParamSufficient() {
        if (this.isRunDEAnalysis() && this.runDEAnalysisPanel.genesetFilePath[0].equals("")) {
            JOptionPane.showMessageDialog(null, "Please choose a gene set file.", "Error", 0);
            return false;
        }
        if (this.isClusterAnalysis()) {
            if (this.clusterAnalysisPanel.genesetFilePath[0].equals("")) {
                JOptionPane.showMessageDialog(null, "Please choose a gene set file.", "Error", 0);
                return false;
            }
            if (this.repository == null || this.repository.isEmpty()) {
                JOptionPane.showMessageDialog(null, "Cluster Repository is empty.\nPlease create a cluster or choose an alternative analysis.", "Error", 0);
                return false;
            }
        }
        if (this.isGOAnalysis() && (this.repository == null || this.repository.isEmpty())) {
            JOptionPane.showMessageDialog(null, "Cluster Repository is empty.\nPlease create a cluster or choose an alternative analysis.", "Error", 0);
            return false;
        }
        return true;
    }

    public String[] getClusterGeneSetFilePath() {
        return this.clusterAnalysisPanel.genesetFilePath;
    }

    public String[] getDEGeneSetFilePath() {
        return this.runDEAnalysisPanel.genesetFilePath;
    }

    public boolean isGOAnalysis() {
        return this.analysisTypeTab.getSelectedIndex() == 0;
    }

    private boolean isClusterAnalysis() {
        return this.analysisTypeTab.getSelectedIndex() == 1;
    }

    public boolean isRunDEAnalysis() {
        return this.analysisTypeTab.getSelectedIndex() == 2;
    }

    public int getClusterGeneSetOrigin() {
        return this.clusterAnalysisPanel.geneSetSelectionBox.getSelectedIndex();
    }

    public int getDEGeneSetOrigin() {
        return this.runDEAnalysisPanel.geneSetSelectionBox.getSelectedIndex();
    }

    public float getAlpha() {
        return Float.parseFloat(this.mPanel.alphaField.getText());
    }

    public int getNumPerms() {
        return Integer.parseInt(this.mPanel.permField.getText());
    }

    public int getNumBins() {
        return Integer.parseInt(this.mPanel.genesPerBinField.getText());
    }

    public int[] getDiffGeneSet() {
        if (this.isGOAnalysis()) {
            return this.goPanel.clusterBrowser.getSelectedCluster().getIndices();
        }
        if (this.isClusterAnalysis()) {
            return this.clusterAnalysisPanel.clusterBrowser.getSelectedCluster().getIndices();
        }
        return null;
    }

    public static void main(String[] args) {
        JFrame dummyFrame = new JFrame();
        Vector<String> dummyVect = new Vector<String>();
        for (int i = 0; i < 24; ++i) {
            dummyVect.add("Expt " + i);
        }
        String[] anfi = new String[]{"asdasd", "qweqweqwe", "zxczczxc"};
        GOSEQInitBox oBox = new GOSEQInitBox(dummyFrame, true, dummyVect, anfi, null);
        oBox.setVisible(true);
        System.exit(0);
    }

    public String getSelectedAnnotation() {
        if (this.isGOAnalysis()) {
            return "Probe_ID";
        }
        if (this.isClusterAnalysis()) {
            return (String)this.clusterAnalysisPanel.geneIdentifierBox.getSelectedItem();
        }
        if (this.isRunDEAnalysis()) {
            return (String)this.runDEAnalysisPanel.geneIdentifierBox.getSelectedItem();
        }
        return null;
    }

    public String getBias() {
        return (String)this.mPanel.biasBox.getSelectedItem();
    }

    public int[] getClusterExpIndices() {
        if (this.isGOAnalysis()) {
            return this.goPanel.clusterBrowser.getSelectedCluster().getExperimentIndices();
        }
        if (this.isClusterAnalysis()) {
            return this.clusterAnalysisPanel.clusterBrowser.getSelectedCluster().getExperimentIndices();
        }
        return null;
    }

    public String getDEAnalysis() {
        return (String)this.runDEAnalysisPanel.analysisBox.getSelectedItem();
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                if (!GOSEQInitBox.this.isParamSufficient()) {
                    return;
                }
                GOSEQInitBox.this.okPressed = true;
                GOSEQInitBox.this.dispose();
            } else if (command.equals("reset-command")) {
                GOSEQInitBox.this.mPanel.reset();
            } else if (command.equals("cancel-command")) {
                GOSEQInitBox.this.okPressed = false;
                GOSEQInitBox.this.dispose();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(GOSEQInitBox.this, "GO Analysis for RNA-seq- Initialization Dialog");
                GOSEQInitBox.this.okPressed = false;
            }
        }
    }

    public class RadioButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
        }
    }

    class GeneSetFilePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JLabel chooseFileLabel = new JLabel("Choose File: ");
        JLabel chooseAnnoLabel = new JLabel("Choose Annotation Type: ");
        private String[] genesetFilePath = new String[]{""};
        JDialog jd;
        private JButton browseDownloadButton;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        public JTextField filePath = new JTextField();
        JTextField jtf;
        private JComboBox geneIdentifierBox;
        String broademail = "";
        private JComboBox analysisBox;
        private JComboBox geneSetSelectionBox;
        ClusterBrowser clusterBrowser;

        public GeneSetFilePanel(boolean isRun) {
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Gene Set File", 0, 0, null, Color.black));
            this.setLayout(this.gridbag);
            String buttonName = "Browse";
            String actionCommand = "genesigdb_download";
            String[] selectionMethods = new String[]{"Load local geneset file/files", "Download from MSigDB", "Download from GeneSigDB"};
            this.geneSetSelectionBox = new JComboBox<String>(selectionMethods);
            this.geneSetSelectionBox.addActionListener(new Listener());
            this.jd = new JDialog();
            this.jd.setLayout(this.gridbag);
            this.jd.setTitle("Please enter a valid MSigDB email address");
            this.jtf = new JTextField(25);
            this.jd.add(this.jtf);
            JButton jb = new JButton("OK");
            jb.addActionListener(new Listener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GeneSetFilePanel.this.broademail = GeneSetFilePanel.this.jtf.getText();
                    GeneSetFilePanel.this.jd.dispose();
                }
            });
            GOSEQInitBox.this.buildConstraints(this.constraints, 0, 0, 2, 2, 0, 0);
            this.constraints.fill = 2;
            this.gridbag.setConstraints(this.jtf, this.constraints);
            this.jd.add(this.jtf);
            GOSEQInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 0);
            this.gridbag.setConstraints(jb, this.constraints);
            this.jd.add(jb);
            this.jd.setPreferredSize(new Dimension(400, 130));
            this.jd.setMinimumSize(new Dimension(400, 130));
            this.jd.setSize(new Dimension(400, 130));
            this.jd.setLocationRelativeTo(this);
            this.jd.pack();
            this.jd.setModal(true);
            this.constraints.fill = 0;
            this.filePath.setEditable(false);
            this.browseDownloadButton = new JButton(buttonName);
            this.browseDownloadButton.setName(buttonName);
            this.browseDownloadButton.setActionCommand(actionCommand);
            this.browseDownloadButton.setSize(new Dimension(100, 30));
            this.browseDownloadButton.setPreferredSize(new Dimension(100, 30));
            this.browseDownloadButton.addActionListener(new Listener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GeneSetFilePanel.this.geneSetSelectionBox.getSelectedIndex() == 0) {
                        if (!GeneSetFilePanel.this.onBrowse()) {
                            return;
                        }
                        GeneSetFilePanel.this.filePath.setText(GeneSetFilePanel.this.genesetFilePath[0]);
                        GeneSetFilePanel.this.browseDownloadButton.setEnabled(false);
                        GeneSetFilePanel.this.geneSetSelectionBox.setEnabled(false);
                        GeneSetFilePanel.this.chooseFileLabel.setForeground(Color.red);
                        GeneSetFilePanel.this.chooseFileLabel.setText("File Loaded");
                    } else if (GeneSetFilePanel.this.geneSetSelectionBox.getSelectedIndex() == 1) {
                        GeneSetFilePanel.this.jd.setVisible(true);
                        if (GeneSetFilePanel.this.broademail.length() == 0) {
                            return;
                        }
                        GeneSetFilePanel.this.BROADDownloads(GeneSetFilePanel.this.broademail);
                        if (GOSEQInitBox.this.msigOK) {
                            GeneSetFilePanel.this.geneIdentifierBox.setSelectedItem("GENE_SYMBOL");
                            GeneSetFilePanel.this.geneIdentifierBox.setEnabled(false);
                            GeneSetFilePanel.this.browseDownloadButton.setEnabled(false);
                            GeneSetFilePanel.this.geneSetSelectionBox.setEnabled(false);
                            GeneSetFilePanel.this.chooseFileLabel.setForeground(Color.red);
                            GeneSetFilePanel.this.chooseFileLabel.setText("File Loaded");
                            String allfiles = "";
                            for (int i = 0; i < GeneSetFilePanel.this.genesetFilePath.length; ++i) {
                                allfiles = allfiles + GeneSetFilePanel.this.genesetFilePath[i];
                                if (i >= GeneSetFilePanel.this.genesetFilePath.length - 1) continue;
                                allfiles = allfiles + "; ";
                            }
                            GeneSetFilePanel.this.filePath.setText(allfiles);
                        } else {
                            JOptionPane.showMessageDialog(null, "Invalid MSigDB email address.", "Error", 0);
                        }
                    } else if (e.getActionCommand().equalsIgnoreCase("genesigdb_download")) {
                        GeneSetFilePanel.this.GeneSigDBDownloads();
                        GeneSetFilePanel.this.geneIdentifierBox.setSelectedItem("GENE_SYMBOL");
                        GeneSetFilePanel.this.geneIdentifierBox.setEnabled(false);
                        GeneSetFilePanel.this.browseDownloadButton.setEnabled(!GOSEQInitBox.this.geneSigValid);
                        GeneSetFilePanel.this.geneSetSelectionBox.setEnabled(!GOSEQInitBox.this.geneSigValid);
                        GeneSetFilePanel.this.chooseFileLabel.setForeground(GOSEQInitBox.this.geneSigValid ? Color.red : Color.black);
                        GeneSetFilePanel.this.chooseFileLabel.setText(GOSEQInitBox.this.geneSigValid ? "File Loaded" : "Choose File:");
                        GeneSetFilePanel.this.filePath.setText(GeneSetFilePanel.this.genesetFilePath[0]);
                    }
                }
            });
            Field[] fields = AnnotationFieldConstants.class.getFields();
            String[] annotation = new String[fields.length + 1];
            annotation[0] = "";
            try {
                for (int index = 0; index < fields.length; ++index) {
                    annotation[index + 1] = (String)fields[index].get(new AnnotationFieldConstants());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.geneIdentifierBox = new JComboBox<String>(GOSEQInitBox.this.annotFields);
            this.geneIdentifierBox.setSelectedItem("GENE_SYMBOL");
            String[] analysisTypes = new String[]{"EDGER", "DEGSEQ", "DESEQ"};
            this.analysisBox = new JComboBox<String>(analysisTypes);
            this.analysisBox.setSelectedItem("GENE_SYMBOL");
            this.constraints.anchor = 13;
            int xind = 0;
            int yind = 0;
            if (isRun) {
                GOSEQInitBox.this.buildConstraints(this.constraints, xind++, yind, 1, 1, 5, 10);
                this.add((Component)new JLabel("Select Differential Expression Analysis"), this.constraints);
                GOSEQInitBox.this.buildConstraints(this.constraints, xind++, yind, 1, 1, 5, 10);
                this.gridbag.setConstraints(this.analysisBox, this.constraints);
                this.add(this.analysisBox);
            }
            xind = 0;
            GOSEQInitBox.this.buildConstraints(this.constraints, xind++, ++yind, 1, 1, 5, 10);
            this.add((Component)this.chooseFileLabel, this.constraints);
            GOSEQInitBox.this.buildConstraints(this.constraints, xind++, yind, 1, 1, 5, 10);
            this.gridbag.setConstraints(this.geneSetSelectionBox, this.constraints);
            this.add(this.geneSetSelectionBox);
            GOSEQInitBox.this.buildConstraints(this.constraints, xind++, yind, 1, 1, 5, 10);
            this.gridbag.setConstraints(this.browseDownloadButton, this.constraints);
            this.add(this.browseDownloadButton);
            xind = 0;
            GOSEQInitBox.this.buildConstraints(this.constraints, 0, ++yind, 1, 1, 5, 10);
            this.gridbag.setConstraints(this.chooseAnnoLabel, this.constraints);
            this.add(this.chooseAnnoLabel);
            GOSEQInitBox.this.buildConstraints(this.constraints, ++xind, yind, 1, 1, 5, 10);
            this.gridbag.setConstraints(this.geneIdentifierBox, this.constraints);
            this.add(this.geneIdentifierBox);
            xind = 0;
            GOSEQInitBox.this.buildConstraints(this.constraints, 0, ++yind, 1, 1, 5, 10);
            this.constraints.anchor = 13;
            this.add((Component)new JLabel("File Location: "), this.constraints);
            GOSEQInitBox.this.buildConstraints(this.constraints, ++xind, yind, 2, 1, 5, 10);
            this.constraints.fill = 2;
            this.gridbag.setConstraints(this.filePath, this.constraints);
            this.add(this.filePath);
            if (!isRun) {
                JLabel infoLabel = new JLabel("Please select a cluster of differentially expressed genes");
                infoLabel.setMaximumSize(new Dimension(50, 50));
                Font font = infoLabel.getFont();
                infoLabel.setFont(font.deriveFont(10.0f));
                xind = 0;
                GOSEQInitBox.this.buildConstraints(this.constraints, 0, ++yind, 3, 1, 0, 5, 10, 0);
                this.gridbag.setConstraints(infoLabel, this.constraints);
                this.add((Component)infoLabel, this.constraints);
                this.clusterBrowser = new ClusterBrowser(GOSEQInitBox.this.repository);
                xind = 0;
                GOSEQInitBox.this.buildConstraints(this.constraints, 0, ++yind, 3, 1, 0, 5, 10, 0);
                this.constraints.fill = 1;
                this.gridbag.setConstraints((Component)this.clusterBrowser, this.constraints);
                this.add((Component)this.clusterBrowser, this.constraints);
            }
        }

        private void BROADDownloads(String broademail) {
            try {
                GOSEQInitBox.this.frm = new FileResourceManager(new File(new File(System.getProperty("user.home"), ".mev"), "repository"));
                File geneSetList = GOSEQInitBox.this.frm.getSupportFile((ISupportFileDefinition)new BroadGeneSetList(), true);
                try {
                    ArrayList<String> genesetFilenames = BroadGeneSetList.getFileNames(geneSetList);
                    String email = broademail;
                    String[] genesetFileNameArray = new String[genesetFilenames.size()];
                    int index = 0;
                    ArrayList<BroadGeneSet> defs = new ArrayList<BroadGeneSet>();
                    Iterator<String> it = genesetFilenames.iterator();
                    while (it.hasNext()) {
                        genesetFileNameArray[index] = it.next();
                        ++index;
                    }
                    SelectMultiFilesDialog dialog = new SelectMultiFilesDialog(new JFrame(), "Select files to download", new BroadGeneSetList().getURL().getHost(), genesetFileNameArray);
                    dialog.setVisible(true);
                    int[] indices = dialog.getSelectedFilesIndices();
                    String[] selectedFiles = new String[indices.length];
                    for (int i = 0; i < indices.length; ++i) {
                        selectedFiles[i] = genesetFilenames.get(indices[i]);
                        defs.add(new BroadGeneSet(selectedFiles[i], email));
                    }
                    Hashtable results = GOSEQInitBox.this.frm.getSupportFiles(defs, true);
                    Enumeration e = results.keys();
                    ArrayList<String> arl = new ArrayList<String>();
                    while (e.hasMoreElements()) {
                        ISupportFileDefinition thisDef = (ISupportFileDefinition)e.nextElement();
                        File temp = (File)results.get(thisDef);
                        if (!this.isValidAddress(temp)) {
                            GOSEQInitBox.this.msigOK = false;
                            temp.deleteOnExit();
                            return;
                        }
                        if (thisDef.isValid(temp)) {
                            arl.add(temp.getAbsolutePath());
                            GOSEQInitBox.this.msigOK = true;
                            continue;
                        }
                        System.out.println("support file not downloaded " + temp.getAbsolutePath());
                    }
                    this.genesetFilePath = new String[arl.size()];
                    for (int i = 0; i < this.genesetFilePath.length; ++i) {
                        this.genesetFilePath[i] = (String)arl.get(i);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            catch (SupportFileAccessError sfae) {
                sfae.printStackTrace();
            }
            catch (RepositoryInitializationError rie) {
                rie.printStackTrace();
            }
        }

        private void GeneSigDBDownloads() {
            try {
                File file = new File(new File(System.getProperty("user.home"), ".mev"), "repository/org.tigr.microarray.mev.cluster.gui.impl.gsea.GeneSigDbGeneSets/genesigdb_genesets.txt");
                if (!file.exists()) {
                    GOSEQInitBox.this.frm = new FileResourceManager(new File(new File(System.getProperty("user.home"), ".mev"), "repository"));
                    GeneSigDbGeneSets temp = new GeneSigDbGeneSets();
                    File geneSigs = GOSEQInitBox.this.frm.getSupportFile((ISupportFileDefinition)temp, true);
                    if (temp.isValid(geneSigs)) {
                        this.genesetFilePath = new String[1];
                        this.genesetFilePath[0] = geneSigs.getAbsolutePath();
                        GOSEQInitBox.this.geneSigValid = true;
                    }
                } else {
                    this.genesetFilePath = new String[1];
                    this.genesetFilePath[0] = file.getAbsolutePath();
                    GOSEQInitBox.this.geneSigValid = true;
                    System.out.println(file.getAbsolutePath());
                }
            }
            catch (SupportFileAccessError sfae) {
                System.out.println("Could not download GeneSigDbGeneSets file.");
            }
            catch (RepositoryInitializationError e) {
                e.printStackTrace();
            }
        }

        public boolean onBrowse() {
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                this.genesetFilePath = new String[1];
                this.genesetFilePath[0] = selectedFile.getAbsolutePath();
                return true;
            }
            return false;
        }

        private boolean isValidAddress(File f) {
            try {
                FileReader fr = null;
                BufferedReader buff = null;
                fr = new FileReader(f);
                buff = new BufferedReader(fr);
                String line = buff.readLine();
                return !line.startsWith(GOSEQInitBox.this.errorString);
            }
            catch (IOException ioe) {
                return false;
            }
        }

        private class Listener
        implements ActionListener {
            private Listener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((String)GeneSetFilePanel.this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Download from MSigDB")) {
                    GeneSetFilePanel.this.browseDownloadButton.setText("Download");
                } else if (((String)GeneSetFilePanel.this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Load local geneset file/files")) {
                    GeneSetFilePanel.this.browseDownloadButton.setText("Browse");
                } else if (((String)GeneSetFilePanel.this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Download from GeneSigDB")) {
                    GeneSetFilePanel.this.browseDownloadButton.setText("Download");
                }
            }
        }
    }

    class RunAnalysisPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
    }

    class GOAnalysisPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        ClusterBrowser clusterBrowser;

        public GOAnalysisPanel() {
            this.setLayout(this.gridbag);
            this.clusterBrowser = new ClusterBrowser(GOSEQInitBox.this.repository);
            GOSEQInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 1, 5, 10, 1);
            this.gridbag.setConstraints((Component)this.clusterBrowser, this.constraints);
            this.add((Component)this.clusterBrowser, this.constraints);
        }
    }

    class ClusterBrowserPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        JPanel dummyPanel;
        JTabbedPane tabbedmulg;
        JLabel infoLabel;
        JLabel infoLabel2;
        int numGroups = -1;
        private JTextField alphaField;
        private JTextField permField;
        private JTextField genesPerBinField;
        private JComboBox biasBox;

        public ClusterBrowserPanel() {
            this.setBackground(Color.white);
            this.setLayout(this.gridbag);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "GOSEQ Parameters", 0, 0, null, Color.black));
            JPanel topPanel = new JPanel();
            topPanel.setBackground(Color.white);
            topPanel.setLayout(this.gridbag);
            JLabel alphaLabel = new JLabel("Significance Level: Alpha = ");
            GOSEQInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 30, 100);
            this.constraints.anchor = 13;
            this.gridbag.setConstraints(alphaLabel, this.constraints);
            this.add(alphaLabel);
            this.alphaField = new JTextField(".05", 7);
            this.alphaField.setMinimumSize(new Dimension(50, 20));
            this.constraints.anchor = 17;
            GOSEQInitBox.this.buildConstraints(this.constraints, 1, 0, 1, 1, 30, 0);
            this.gridbag.setConstraints(this.alphaField, this.constraints);
            this.add(this.alphaField);
            JLabel permLabel = new JLabel("Number of Permutations: ");
            GOSEQInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 30, 100);
            this.constraints.anchor = 13;
            this.gridbag.setConstraints(permLabel, this.constraints);
            this.add(permLabel);
            this.permField = new JTextField("1000", 7);
            this.permField.setMinimumSize(new Dimension(50, 20));
            this.constraints.anchor = 17;
            GOSEQInitBox.this.buildConstraints(this.constraints, 1, 1, 1, 1, 30, 0);
            this.gridbag.setConstraints(this.permField, this.constraints);
            this.add(this.permField);
            JLabel binCountLabel = new JLabel("Number of Genes per Transcript Length Bin: ");
            GOSEQInitBox.this.buildConstraints(this.constraints, 0, 2, 1, 1, 30, 100);
            this.constraints.anchor = 13;
            this.gridbag.setConstraints(binCountLabel, this.constraints);
            this.add(binCountLabel);
            this.genesPerBinField = new JTextField("50", 7);
            this.genesPerBinField.setMinimumSize(new Dimension(50, 20));
            this.constraints.anchor = 17;
            GOSEQInitBox.this.buildConstraints(this.constraints, 1, 2, 1, 1, 30, 0);
            this.gridbag.setConstraints(this.genesPerBinField, this.constraints);
            this.add(this.genesPerBinField);
            JLabel biasLabel = new JLabel("Account for differential expression bias in: ");
            GOSEQInitBox.this.buildConstraints(this.constraints, 0, 3, 1, 1, 30, 100);
            this.constraints.anchor = 13;
            this.gridbag.setConstraints(biasLabel, this.constraints);
            this.add(biasLabel);
            String[] selectedBiases = new String[2 + GOSEQInitBox.this.annotFields.length];
            selectedBiases[0] = "RNASeq Transcript Length";
            selectedBiases[1] = "Total Expression";
            for (int i = 0; i < GOSEQInitBox.this.annotFields.length; ++i) {
                selectedBiases[i + 2] = GOSEQInitBox.this.annotFields[i];
            }
            this.biasBox = new JComboBox<String>(selectedBiases);
            this.biasBox.setMinimumSize(new Dimension(50, 20));
            this.constraints.anchor = 17;
            GOSEQInitBox.this.buildConstraints(this.constraints, 1, 3, 1, 1, 30, 0);
            this.gridbag.setConstraints(this.biasBox, this.constraints);
            this.add(this.biasBox);
        }

        protected void reset() {
        }
    }
}

