/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.goseq;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.IRNASeqSlide;
import org.tigr.microarray.mev.RNASeqElement;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.impl.ease.EaseAlgorithmData;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.degseq.DEGseqGUI;
import org.tigr.microarray.mev.cluster.gui.impl.deseq.DESEQGUI;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEGUI;
import org.tigr.microarray.mev.cluster.gui.impl.edger.EDGERGUI;
import org.tigr.microarray.mev.cluster.gui.impl.goseq.GOSEQExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.goseq.GOSEQInitBox;
import org.tigr.microarray.mev.cluster.gui.impl.goseq.GOSEQPlotViewer;
import org.tigr.microarray.mev.cluster.gui.impl.goseq.GOSEQResultTable;
import org.tigr.microarray.mev.cluster.gui.impl.goseq.gotree.GOTreeViewer;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class GOSEQGUI
implements IClusterGUI,
IScriptGUI {
    protected Algorithm algorithm;
    protected Progress progress;
    protected Experiment experiment;
    protected int[][] clusters;
    protected int[][] errorGenesArray = new int[1][];
    protected FloatMatrix means;
    protected FloatMatrix variances;
    protected int[][] sigGenesArrays;
    protected String[] auxTitles;
    protected Object[][] auxData;
    protected float[][] geneGroupMeans;
    protected float[][] geneGroupSDs;
    Vector<String> exptNamesVector;
    protected IData data;
    protected float alpha;
    protected int iterations;
    protected ArrayList<String> geneLabels;
    protected ArrayList<String> sampleLabels;
    private FloatMatrix resultMatrix;
    private String[] geneListNames;
    private String[] geneSetFilePath;
    private int geneSetOrigin;
    private int[] diffGeneCluster;
    private int numPerms;
    private String annotChosen;
    private float[][] pwfBinData;
    private int numGenesPerBin;
    private float[][] geneSetSigs;
    private String[] categoryNames;
    EaseAlgorithmData result;
    private boolean isGO;
    private String biasString;
    private boolean isRunDE;
    private String deAnalysis;
    private int[][] geneLists;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        int i;
        if (this.sysMsg("R 2.11.x", "GOSeq") != 0) {
            return null;
        }
        this.experiment = framework.getData().getExperiment();
        this.data = framework.getData();
        this.exptNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int[] columnIndices = this.experiment.getColumnIndicesCopy();
        GOSEQInitBox GOSEQDialog = new GOSEQInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getData().getAllFilledAnnotationFields(), framework.getClusterRepository(0));
        GOSEQDialog.setVisible(true);
        this.sampleLabels = new ArrayList();
        for (i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(columnIndices[i]));
            this.sampleLabels.add(framework.getData().getFullSampleName(columnIndices[i]));
        }
        this.annotChosen = GOSEQDialog.getSelectedAnnotation();
        this.geneLabels = new ArrayList();
        for (i = 0; i < this.experiment.getNumberOfGenes(); ++i) {
            this.geneLabels.add(framework.getData().getElementAnnotation(i, this.annotChosen)[0]);
        }
        if (!GOSEQDialog.isOkPressed()) {
            return null;
        }
        this.isGO = GOSEQDialog.isGOAnalysis();
        this.isRunDE = GOSEQDialog.isRunDEAnalysis();
        this.deAnalysis = GOSEQDialog.getDEAnalysis();
        this.result = new EaseAlgorithmData();
        if (this.isGO) {
            try {
                EASEGUI gui = new EASEGUI();
                gui.execute(framework);
                this.result = gui.getAlgData();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Error running EASE.", "Error", 0);
                return null;
            }
        } else if (this.isRunDE) {
            try {
                Object gui;
                if (this.deAnalysis.equalsIgnoreCase("EDGER")) {
                    gui = new EDGERGUI();
                    ((EDGERGUI)gui).execute(framework);
                    this.diffGeneCluster = ((EDGERGUI)gui).getResultCluster();
                } else if (this.deAnalysis.equalsIgnoreCase("DEGSEQ")) {
                    gui = new DEGseqGUI();
                    ((DEGseqGUI)gui).execute(framework);
                    this.diffGeneCluster = ((DEGseqGUI)gui).getResultCluster();
                } else if (this.deAnalysis.equalsIgnoreCase("DESEQ")) {
                    gui = new DESEQGUI();
                    ((DESEQGUI)gui).execute(framework);
                    this.diffGeneCluster = ((DESEQGUI)gui).getResultCluster();
                } else {
                    JOptionPane.showMessageDialog(null, "Could not find " + this.deAnalysis + ".", "Error", 0);
                    return null;
                }
                this.geneSetFilePath = GOSEQDialog.getDEGeneSetFilePath();
                this.geneSetOrigin = GOSEQDialog.getDEGeneSetOrigin();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Error running " + this.deAnalysis + ".", "Error", 0);
                return null;
            }
        } else {
            this.geneSetFilePath = GOSEQDialog.getClusterGeneSetFilePath();
            this.geneSetOrigin = GOSEQDialog.getClusterGeneSetOrigin();
        }
        this.alpha = GOSEQDialog.getAlpha();
        this.numPerms = GOSEQDialog.getNumPerms();
        this.numGenesPerBin = GOSEQDialog.getNumBins();
        if (!this.isRunDE) {
            this.diffGeneCluster = GOSEQDialog.getDiffGeneSet();
        }
        int[] nonDiffGeneCluster = new int[this.experiment.getNumberOfGenes() - this.diffGeneCluster.length];
        ArrayList<Integer> diffAL = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.diffGeneCluster.length; ++i2) {
            diffAL.add(this.diffGeneCluster[i2]);
        }
        int ind = 0;
        for (int i3 = 0; i3 < this.experiment.getNumberOfGenes(); ++i3) {
            if (diffAL.contains(i3)) continue;
            nonDiffGeneCluster[ind] = i3;
            ++ind;
        }
        this.clusters = new int[2][];
        this.clusters[0] = this.diffGeneCluster;
        this.clusters[1] = nonDiffGeneCluster;
        Listener listener = new Listener();
        try {
            int i4;
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("GOSEQ");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Running GOSEQ Analysis", listener);
            this.progress.setIndeterminate(true);
            this.progress.setIndeterminantString("");
            this.progress.show();
            int[] transInt = new int[this.experiment.getNumberOfGenes()];
            this.biasString = GOSEQDialog.getBias();
            try {
                if (this.biasString.equals("RNASeq Transcript Length")) {
                    ArrayList temp = this.data.getFeaturesList();
                    for (int i5 = 0; i5 < this.experiment.getNumberOfGenes(); ++i5) {
                        transInt[i5] = ((RNASeqElement)((IRNASeqSlide)temp.get(0)).getSlideDataElement(i5)).getTranscriptLength();
                    }
                } else if (this.biasString.equals("Total Expression")) {
                    for (int i6 = 0; i6 < this.experiment.getNumberOfGenes(); ++i6) {
                        float sum = 0.0f;
                        for (int j = 0; j < this.experiment.getNumberOfSamples(); ++j) {
                            sum += this.experiment.get(i6, j);
                        }
                        transInt[i6] = (int)sum;
                    }
                } else {
                    String[] trans = framework.getData().getAnnotationList(GOSEQDialog.getBias());
                    for (int i7 = 0; i7 < trans.length; ++i7) {
                        transInt[i7] = Integer.parseInt(trans[i7]);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Error reading values in " + GOSEQDialog.getBias() + ".", "Error", 0);
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                if (this.algorithm != null) {
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                }
                if (this.progress != null) {
                    this.progress.dispose();
                }
                return defaultMutableTreeNode;
            }
            this.result.addMatrix("experiment", this.experiment.getMatrix());
            this.result.addParam("isGO", String.valueOf(this.isGO));
            this.result.addParam("geneSetOrigin", String.valueOf(this.geneSetOrigin));
            this.result.addStringArray("geneSetFilePaths", this.geneSetFilePath);
            this.result.addIntArray("diffGeneCluster", this.diffGeneCluster);
            this.result.addIntArray("transcriptLengths", transInt);
            this.result.addParam("alpha", String.valueOf(this.alpha));
            this.result.addParam("numPerms", String.valueOf(this.numPerms));
            this.result.addParam("numGenesPerBin", String.valueOf(this.numGenesPerBin));
            this.result.addStringArray("geneLabels", this.geneLabels.toArray(new String[this.geneLabels.size()]));
            this.result.addStringArray("sampleLabels", this.sampleLabels.toArray(new String[this.sampleLabels.size()]));
            long start = System.currentTimeMillis();
            this.algorithm.execute((AlgorithmData)this.result);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = this.result.getCluster("cluster");
            this.geneListNames = this.result.getStringArray("gene-list-names");
            this.geneLists = this.result.getIntMatrix("gene-lists");
            this.resultMatrix = this.result.getMatrix("resultsMatrix");
            this.means = this.result.getMatrix("clusters_means");
            this.variances = this.result.getMatrix("clusters_variances");
            this.pwfBinData = this.result.getMatrix((String)"pwfM2").A;
            this.geneSetSigs = this.result.getMatrix((String)"geneSetSigs").A;
            this.categoryNames = this.result.getStringArray("category-names");
            FloatMatrix geneGroupMeansMatrix = this.result.getMatrix("geneGroupMeansMatrix");
            FloatMatrix geneGroupSDsMatrix = this.result.getMatrix("geneGroupSDsMatrix");
            this.iterations = this.result.getParams().getInt("iterations");
            this.geneGroupMeans = new float[geneGroupMeansMatrix.getRowDimension()][geneGroupMeansMatrix.getColumnDimension()];
            this.geneGroupSDs = new float[geneGroupSDsMatrix.getRowDimension()][geneGroupSDsMatrix.getColumnDimension()];
            for (i4 = 0; i4 < this.geneGroupMeans.length; ++i4) {
                for (int j = 0; j < this.geneGroupMeans[i4].length; ++j) {
                    this.geneGroupMeans[i4][j] = geneGroupMeansMatrix.A[i4][j];
                    this.geneGroupSDs[i4][j] = geneGroupSDsMatrix.A[i4][j];
                }
            }
            this.auxTitles = new String[1];
            this.auxTitles[0] = "PWF";
            this.auxData = new Object[this.experiment.getNumberOfGenes()][this.auxTitles.length];
            for (i4 = 0; i4 < this.auxData.length; ++i4) {
                this.auxData[i4][0] = "NA";
            }
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.alpha = this.alpha;
            if (this.isGO) {
                this.replaceResultClusterResults();
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private void replaceResultClusterResults() {
        for (int i = 0; i < this.result.getResultMatrix().length; ++i) {
            this.result.getResultMatrix()[i][8] = String.valueOf(this.resultMatrix.A[i][1]);
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        this.experiment = framework.getData().getExperiment();
        this.exptNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(this.experiment.getSampleIndex(i)));
        }
        GOSEQInitBox GOSEQDialog = new GOSEQInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getData().getAllFilledAnnotationFields(), framework.getClusterRepository(1));
        GOSEQDialog.setVisible(true);
        if (!GOSEQDialog.isOkPressed()) {
            return null;
        }
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 4;
        }
        AlgorithmData data = new AlgorithmData();
        data.addParam("alpha-value", String.valueOf(this.alpha));
        data.addParam("name", "GOSEQ");
        data.addParam("alg-type", "cluster-genes");
        data.addParam("output-class", "partition-output");
        String[] outputNodes = new String[]{"Significant Genes", "Non-significant Genes"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        return null;
    }

    protected DefaultMutableTreeNode createResultTree(Cluster result_cluster, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("GOSEQ");
        this.addResultNodes(root, result_cluster, info);
        return root;
    }

    protected void addResultNodes(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        this.addInputViewers(root);
        this.addExpressionImages(root);
        this.addTableViews(root);
        this.addGeneSetInfo(root);
        this.addPWFGraphs(root);
        if (this.isGO) {
            this.addGOTree(root, this.result, this.result.getHeaderNames());
        }
        this.addGeneralInfo(root, info);
    }

    private void addInputViewers(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode inNode = new DefaultMutableTreeNode("Input Viewers");
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        GOSEQExperimentViewer expViewer = new GOSEQExperimentViewer(this.experiment, this.clusters, (float[][])null, (float[][])null, null, null, null, null, null, null, null);
        node.add(new DefaultMutableTreeNode(new LeafInfo("Differentially Expressed Cluster", (IViewer)expViewer, (Object)new Integer(0))));
        node.add(new DefaultMutableTreeNode(new LeafInfo("Non-Differentially Expressed Cluster", (IViewer)expViewer, (Object)new Integer(1))));
        inNode.add(node);
        DefaultMutableTreeNode nodeT = new DefaultMutableTreeNode("Table Views");
        ClusterTableViewer tabViewer = new ClusterTableViewer(this.experiment, this.clusters, this.data, this.auxTitles, this.auxData);
        nodeT.add(new DefaultMutableTreeNode(new LeafInfo("Differentially Expressed Cluster", (IViewer)tabViewer, (Object)new Integer(0))));
        nodeT.add(new DefaultMutableTreeNode(new LeafInfo("Non-Differentially Expressed Cluster", (IViewer)tabViewer, (Object)new Integer(1))));
        inNode.add(nodeT);
        root.add(inNode);
    }

    protected void addGOTree(DefaultMutableTreeNode root, EaseAlgorithmData data, String[] headerNames) {
        GOTreeViewer viewer;
        String category;
        String categories = new String("");
        for (int i = 0; i < this.categoryNames.length; ++i) {
            categories = categories + this.categoryNames[i];
        }
        if (categories.indexOf("GO Biological Process") != -1) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode();
            category = "GO Biological Process";
            viewer = new GOTreeViewer(category, headerNames, data, root);
            node.setUserObject(new LeafInfo("GO Hierarchy -- Biological Process", (IViewer)viewer));
            root.add(node);
        }
        if (categories.indexOf("GO Cellular Component") != -1) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode();
            category = "GO Cellular Component";
            viewer = new GOTreeViewer(category, headerNames, data, root);
            node.setUserObject(new LeafInfo("GO Hierarchy -- Cellular Component", (IViewer)viewer));
            root.add(node);
        }
        if (categories.indexOf("GO Molecular Function") != -1) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode();
            category = "GO Molecular Function";
            viewer = new GOTreeViewer(category, headerNames, data, root);
            node.setUserObject(new LeafInfo("GO Hierarchy -- Molecular Function", (IViewer)viewer));
            root.add(node);
        }
    }

    private void addPWFGraphs(DefaultMutableTreeNode root) {
        root.add(new DefaultMutableTreeNode(new LeafInfo("Probability Weighting Function", (IViewer)new GOSEQPlotViewer(this.pwfBinData, this.biasString))));
    }

    private void addGeneSetInfo(DefaultMutableTreeNode root) {
        Object[][] results = new Object[this.resultMatrix.A.length][this.resultMatrix.A[0].length + 1 + this.geneSetSigs.length];
        for (int i = 0; i < results.length; ++i) {
            results[i][0] = this.geneListNames[i];
            results[i][1] = Float.valueOf(this.resultMatrix.A[i][0]);
            results[i][2] = Float.valueOf(this.geneSetSigs[1][i]);
            results[i][3] = Float.valueOf(this.geneSetSigs[0][i]);
            results[i][4] = Float.valueOf(this.resultMatrix.A[i][1]);
        }
        String[] columns = new String[]{"Gene List", "Gene Count", "Significant Genes", "Expected Sig. Genes", "p-value (permutation)"};
        GOSEQResultTable tabViewer = new GOSEQResultTable(results, columns);
        root.add(new DefaultMutableTreeNode(new LeafInfo("Results Table", (IViewer)tabViewer, (Object)new Integer(0))));
    }

    protected void addTableViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table Views");
        DefaultMutableTreeNode sigNode = new DefaultMutableTreeNode("Significant Gene Sets");
        DefaultMutableTreeNode nonSigNode = new DefaultMutableTreeNode("Non-significant Gene Sets");
        ClusterTableViewer expViewer = new ClusterTableViewer(this.experiment, this.geneLists, this.data, this.auxTitles, this.auxData);
        for (int i = 0; i < this.geneLists.length; ++i) {
            if (this.resultMatrix.A[i][1] < this.alpha) {
                sigNode.add(new DefaultMutableTreeNode(new LeafInfo(this.geneListNames[i], (IViewer)expViewer, (Object)new Integer(i))));
                continue;
            }
            nonSigNode.add(new DefaultMutableTreeNode(new LeafInfo(this.geneListNames[i], (IViewer)expViewer, (Object)new Integer(i))));
        }
        if (sigNode.getLeafCount() != 1) {
            node.add(sigNode);
        }
        if (nonSigNode.getLeafCount() != 1) {
            node.add(nonSigNode);
        }
        root.add(node);
    }

    protected void addExpressionImages(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode sigNode = new DefaultMutableTreeNode("Significant Gene Sets");
        DefaultMutableTreeNode nonSigNode = new DefaultMutableTreeNode("Non-significant Gene Sets");
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        GOSEQExperimentViewer expViewer = new GOSEQExperimentViewer(this.experiment, this.geneLists, (float[][])null, (float[][])null, null, null, null, null, null, null, null);
        for (int i = 0; i < this.geneLists.length; ++i) {
            if (this.resultMatrix.A[i][1] < this.alpha) {
                sigNode.add(new DefaultMutableTreeNode(new LeafInfo(this.geneListNames[i], (IViewer)expViewer, (Object)new Integer(i))));
                continue;
            }
            nonSigNode.add(new DefaultMutableTreeNode(new LeafInfo(this.geneListNames[i], (IViewer)expViewer, (Object)new Integer(i))));
        }
        if (sigNode.getLeafCount() != 1) {
            node.add(sigNode);
        }
        if (nonSigNode.getLeafCount() != 1) {
            node.add(nonSigNode);
        }
        root.add(node);
    }

    protected void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode(this.isGO ? "GO Analysis" : (this.isRunDE ? this.deAnalysis : "Cluster Analysis")));
        node.add(new DefaultMutableTreeNode("Iterations: " + this.iterations));
        node.add(new DefaultMutableTreeNode("Bias: " + this.biasString));
        node.add(new DefaultMutableTreeNode("Alpha: " + this.alpha));
        if (!this.isGO) {
            String gsfp = "";
            for (int i = 0; i < this.geneSetFilePath.length; ++i) {
                gsfp = gsfp + this.geneSetFilePath;
                if (i >= this.geneSetFilePath.length - 1) continue;
                gsfp = gsfp + ", ";
            }
            node.add(new DefaultMutableTreeNode("Gene Set: " + gsfp.toString()));
        }
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time - 1L) + " ms"));
        root.add(node);
    }

    private int sysMsg(String rVer, String module) {
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        String ver = System.getProperty("os.version");
        String message = "System Config:\n";
        message = message + "OS: " + os + " | Architecture: " + arch + " | Version: " + ver + "\n";
        message = message + "Please note:\n";
        if (arch.toLowerCase().contains("64") && os.toLowerCase().contains("mac")) {
            message = message + "You need to have 32Bit JVM as default for " + module + "\n";
            message = message + "Please contact MeV Support if you need help.\n";
            message = message + "You also need to have" + rVer + " installed for " + module + "\n";
            message = message + "Cancel if either is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        if (arch.toLowerCase().contains("64")) {
            message = message + "You need to have 32Bit JVM as default for " + module + "\n";
            message = message + "Please contact MeV Support if you need help.\n";
            message = message + "Cancel if 32 Bit JVM is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        if (os.toLowerCase().contains("mac")) {
            message = message + "You need to have" + rVer + " installed for " + module + "\n";
            message = message + "Cancel if R is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        return 0;
    }

    protected class GeneralInfo {
        public int clusters;
        public String correctionMethod;
        public float alpha;
        public long time;
        public String function;
        protected boolean hcl;
        protected boolean usePerms;
        protected int hcl_method;
        protected int numPerms;
        protected boolean hcl_genes;
        protected boolean hcl_samples;

        protected GeneralInfo() {
        }
    }

    protected class Listener
    extends DialogListener
    implements AlgorithmListener {
        protected Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    GOSEQGUI.this.progress.setUnits(event.getIntValue());
                    GOSEQGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    GOSEQGUI.this.progress.setValue(event.getIntValue());
                    GOSEQGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    int value = event.getIntValue();
                    if (value != -1) break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                GOSEQGUI.this.algorithm.abort();
                GOSEQGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            GOSEQGUI.this.algorithm.abort();
            GOSEQGUI.this.progress.dispose();
        }
    }
}

