/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.globanc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.annotation.AnnotationFieldConstants;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterSelector;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.BroadGeneSet;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.BroadGeneSetList;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GeneSigDbGeneSets;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.resources.FileResourceManager;
import org.tigr.microarray.mev.resources.ISupportFileDefinition;
import org.tigr.microarray.mev.resources.RepositoryInitializationError;
import org.tigr.microarray.mev.resources.SelectMultiFilesDialog;
import org.tigr.microarray.mev.resources.SupportFileAccessError;

public class GLOBANCInitBox
extends AlgorithmDialog {
    private static final long serialVersionUID = 1L;
    public static final int JUST_ALPHA = 1;
    public static final int STD_BONFERRONI = 2;
    public static final int ADJ_BONFERRONI = 3;
    public static final int MAX_T = 9;
    public static final int FALSE_NUM = 12;
    public static final int FALSE_PROP = 13;
    public static final int BUTTON_SELECTION = 14;
    public static final int CLUSTER_SELECTION = 15;
    boolean okPressed = false;
    boolean okReady = false;
    boolean step2 = false;
    Vector<String> exptNames;
    MultiClassPanel mPanel;
    GeneSetFilePanel gsfPanel;
    JTabbedPane selectionPanel;
    ClusterRepository repository;
    JButton step2Button = new JButton("Continue...");
    String[] annotFields;
    private JComboBox geneSetSelectionBox;
    private FileResourceManager frm;
    private String[] genesetFilePath = new String[]{""};
    private boolean geneSigValid = false;
    private String errorString = "ERROR:";
    boolean msigOK = false;

    public GLOBANCInitBox(JFrame parentFrame, boolean modality, Vector<String> exptNames, String[] annotFields, ClusterRepository repository) {
        super(parentFrame, "Global Ancova Initialization", modality);
        this.annotFields = annotFields;
        this.exptNames = exptNames;
        this.repository = repository;
        this.setBounds(0, 0, 1000, 850);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        this.okButton.setEnabled(false);
        this.mPanel = new MultiClassPanel();
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 80);
        gridbag.setConstraints(this.mPanel, constraints);
        pane.add(this.mPanel);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy, int anc) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.anchor = anc;
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy, int anc, int fill) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.anchor = anc;
        gbc.fill = fill;
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public void enableOK() {
        this.okButton.setEnabled(true);
    }

    private void BROADDownloads(String broademail) {
        try {
            this.frm = new FileResourceManager(new File(new File(System.getProperty("user.home"), ".mev"), "repository"));
            File geneSetList = this.frm.getSupportFile((ISupportFileDefinition)new BroadGeneSetList(), true);
            try {
                ArrayList<String> genesetFilenames = BroadGeneSetList.getFileNames(geneSetList);
                String email = broademail;
                String[] genesetFileNameArray = new String[genesetFilenames.size()];
                int index = 0;
                ArrayList<BroadGeneSet> defs = new ArrayList<BroadGeneSet>();
                Iterator<String> it = genesetFilenames.iterator();
                while (it.hasNext()) {
                    genesetFileNameArray[index] = it.next();
                    ++index;
                }
                SelectMultiFilesDialog dialog = new SelectMultiFilesDialog(new JFrame(), "Select files to download", new BroadGeneSetList().getURL().getHost(), genesetFileNameArray);
                dialog.setVisible(true);
                int[] indices = dialog.getSelectedFilesIndices();
                String[] selectedFiles = new String[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    selectedFiles[i] = genesetFilenames.get(indices[i]);
                    defs.add(new BroadGeneSet(selectedFiles[i], email));
                }
                Hashtable results = this.frm.getSupportFiles(defs, true);
                Enumeration e = results.keys();
                ArrayList<String> arl = new ArrayList<String>();
                while (e.hasMoreElements()) {
                    ISupportFileDefinition thisDef = (ISupportFileDefinition)e.nextElement();
                    File temp = (File)results.get(thisDef);
                    if (!this.isValidAddress(temp)) {
                        this.msigOK = false;
                        temp.deleteOnExit();
                        return;
                    }
                    if (thisDef.isValid(temp)) {
                        arl.add(temp.getAbsolutePath());
                        this.msigOK = true;
                        continue;
                    }
                    System.out.println("support file not downloaded " + temp.getAbsolutePath());
                }
                this.genesetFilePath = new String[arl.size()];
                for (int i = 0; i < this.genesetFilePath.length; ++i) {
                    this.genesetFilePath[i] = (String)arl.get(i);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (SupportFileAccessError sfae) {
            sfae.printStackTrace();
        }
        catch (RepositoryInitializationError rie) {
            rie.printStackTrace();
        }
    }

    private void GeneSigDBDownloads() {
        try {
            File file = new File(new File(System.getProperty("user.home"), ".mev"), "repository/org.tigr.microarray.mev.cluster.gui.impl.gsea.GeneSigDbGeneSets/genesigdb_genesets.txt");
            if (!file.exists()) {
                this.frm = new FileResourceManager(new File(new File(System.getProperty("user.home"), ".mev"), "repository"));
                GeneSigDbGeneSets temp = new GeneSigDbGeneSets();
                File geneSigs = this.frm.getSupportFile((ISupportFileDefinition)temp, true);
                if (temp.isValid(geneSigs)) {
                    this.genesetFilePath = new String[1];
                    this.genesetFilePath[0] = geneSigs.getAbsolutePath();
                    this.geneSigValid = true;
                }
            } else {
                this.genesetFilePath = new String[1];
                this.genesetFilePath[0] = file.getAbsolutePath();
                this.geneSigValid = true;
                System.out.println(file.getAbsolutePath());
            }
        }
        catch (SupportFileAccessError sfae) {
            System.out.println("Could not download GeneSigDbGeneSets file.");
        }
        catch (RepositoryInitializationError e) {
            e.printStackTrace();
        }
    }

    private boolean isValidAddress(File f) {
        try {
            FileReader fr = null;
            BufferedReader buff = null;
            fr = new FileReader(f);
            buff = new BufferedReader(fr);
            String line = buff.readLine();
            return !line.startsWith(this.errorString);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public boolean onBrowse() {
        JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
        int retVal = fileChooser.showOpenDialog(this);
        if (retVal == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.genesetFilePath = new String[1];
            this.genesetFilePath[0] = selectedFile.getAbsolutePath();
            return true;
        }
        return false;
    }

    private boolean isParamSufficient() {
        int i;
        boolean[] full = new boolean[this.mPanel.numFullGroups];
        boolean[] reduced = new boolean[this.mPanel.numRedGroups];
        for (i = 0; i < this.exptNames.size(); ++i) {
            int j;
            if (this.mPanel.fullModelESP.notInTimeGroupRadioButtons[i].isSelected() || this.mPanel.reducedModelESP.notInTimeGroupRadioButtons[i].isSelected()) continue;
            for (j = 0; j < this.mPanel.fullModelESP.assignmentRBs.length; ++j) {
                if (!this.mPanel.fullModelESP.assignmentRBs[j][i].isSelected()) continue;
                full[j] = true;
            }
            for (j = 0; j < this.mPanel.reducedModelESP.assignmentRBs.length; ++j) {
                if (!this.mPanel.reducedModelESP.assignmentRBs[j][i].isSelected()) continue;
                reduced[j] = true;
            }
        }
        for (i = 0; i < full.length; ++i) {
            if (full[i]) continue;
            return false;
        }
        for (i = 0; i < reduced.length; ++i) {
            if (reduced[i]) continue;
            return false;
        }
        return true;
    }

    public int[] getGroupAssignments() {
        if (this.getSelectionDesign() == 15) {
            return this.getClusterSelectorFactorAssignments();
        }
        int[] factorGroupAssignments = new int[this.exptNames.size()];
        for (int i = 0; i < this.exptNames.size(); ++i) {
            int j;
            if (this.mPanel.fullModelESP.notInTimeGroupRadioButtons[i].isSelected() || this.mPanel.reducedModelESP.notInTimeGroupRadioButtons[i].isSelected()) {
                factorGroupAssignments[i] = 0;
                continue;
            }
            int a = 0;
            int b = 0;
            for (j = 0; j < this.mPanel.fullModelESP.assignmentRBs.length; ++j) {
                if (!this.mPanel.fullModelESP.assignmentRBs[j][i].isSelected()) continue;
                a = j;
                break;
            }
            for (j = 0; j < this.mPanel.reducedModelESP.assignmentRBs.length; ++j) {
                if (!this.mPanel.reducedModelESP.assignmentRBs[j][i].isSelected()) continue;
                b = j;
                break;
            }
            factorGroupAssignments[i] = a * this.getNumRedGroups() + b + 1;
        }
        return factorGroupAssignments;
    }

    private int[] getClusterSelectorFactorAssignments() {
        boolean doubleAssigned;
        int j;
        int i;
        int[][] groupAssignments = new int[2][this.exptNames.size()];
        ArrayList[] arraylistArray = new ArrayList[this.getNumRedGroups()];
        for (i = 0; i < this.getNumRedGroups(); ++i) {
            j = i + 1;
            arraylistArray[i] = this.mPanel.factorACS.getGroupSamples("Full Model " + j);
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            doubleAssigned = false;
            groupAssignments[0][i] = 0;
            for (j = 0; j < this.getNumRedGroups(); ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[0][i] = j + 1;
                doubleAssigned = true;
            }
        }
        arraylistArray = new ArrayList[2];
        for (i = 0; i < 2; ++i) {
            j = i + 1;
            arraylistArray[i] = this.mPanel.factorBCS.getGroupSamples("Reduced Model " + j);
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            doubleAssigned = false;
            groupAssignments[1][i] = 0;
            for (j = 0; j < 2; ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[1][i] = j + 1;
                doubleAssigned = true;
            }
        }
        int[] groupAssignments2 = new int[this.exptNames.size()];
        for (int i2 = 0; i2 < groupAssignments2.length; ++i2) {
            groupAssignments2[i2] = groupAssignments[0][i2] == 0 || groupAssignments[1][i2] == 0 ? 0 : (groupAssignments[0][i2] - 1) * this.getNumRedGroups() + (groupAssignments[1][i2] - 1) + 1;
        }
        return groupAssignments2;
    }

    public int[][] getGroupMatrix() {
        int[] timeAssignments = this.getGroupAssignments();
        int[] numEachTime = new int[this.getNumGroups()];
        for (int i = 0; i < timeAssignments.length; ++i) {
            if (timeAssignments[i] == 0) continue;
            int n = timeAssignments[i] - 1;
            numEachTime[n] = numEachTime[n] + 1;
        }
        int[][] timeMatrix = new int[this.getNumGroups()][];
        for (int i = 0; i < this.getNumGroups(); ++i) {
            timeMatrix[i] = new int[numEachTime[i]];
        }
        int[] nextEntry = new int[this.getNumGroups()];
        for (int i = 0; i < timeAssignments.length; ++i) {
            if (timeAssignments[i] == 0) continue;
            timeMatrix[timeAssignments[i] - 1][nextEntry[timeAssignments[i] - 1]] = i;
            int n = timeAssignments[i] - 1;
            nextEntry[n] = nextEntry[n] + 1;
        }
        return timeMatrix;
    }

    public int getExperimentalDesign() {
        int design = 4;
        return design;
    }

    public int getSelectionDesign() {
        int design = -1;
        design = this.mPanel.tabbedmulg.getSelectedIndex() == 0 ? 14 : 15;
        return design;
    }

    public int getNumGroups() {
        if (this.getExperimentalDesign() == 4) {
            return this.getNumFullGroups() * this.getNumRedGroups();
        }
        return this.mPanel.numFullGroups;
    }

    public int getNumFullGroups() {
        return this.mPanel.numFullGroups;
    }

    public int getNumRedGroups() {
        return this.mPanel.numRedGroups;
    }

    public String getFactorAName() {
        return this.mPanel.factorAName;
    }

    public String getFactorBName() {
        return this.mPanel.factorBName;
    }

    public float getAlpha() {
        return 0.0f;
    }

    public static void main(String[] args) {
        JFrame dummyFrame = new JFrame();
        Vector<String> dummyVect = new Vector<String>();
        for (int i = 0; i < 24; ++i) {
            dummyVect.add("Expt " + i);
        }
        String[] anf = new String[]{"asd", "dfgdfg", "GENE_SYMBOL", "PROBE_ID"};
        GLOBANCInitBox oBox = new GLOBANCInitBox(dummyFrame, true, dummyVect, anf, null);
        oBox.setVisible(true);
        System.exit(0);
    }

    public String[] getGeneSetFilePath() {
        return this.genesetFilePath;
    }

    public int getGeneSetOrigin() {
        return this.geneSetSelectionBox.getSelectedIndex();
    }

    public String getSelectedAnnotation() {
        return (String)this.gsfPanel.geneIdentifierBox.getSelectedItem();
    }

    public int getNumPerms() {
        return this.mPanel.numPerms;
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                if (!GLOBANCInitBox.this.okReady) {
                    return;
                }
                if (GLOBANCInitBox.this.getSelectionDesign() == 15 && GLOBANCInitBox.this.repository.isEmpty()) {
                    JOptionPane.showMessageDialog(null, "Cluster Repository is Empty.", "Error", 2);
                    return;
                }
                if (!GLOBANCInitBox.this.isParamSufficient()) {
                    JOptionPane.showMessageDialog(null, "Please select at least 1 sample for each group.", "Error", 2);
                    return;
                }
                GLOBANCInitBox.this.okPressed = true;
                GLOBANCInitBox.this.dispose();
            } else if (command.equals("reset-command")) {
                GLOBANCInitBox.this.mPanel.reset();
            } else if (command.equals("cancel-command")) {
                GLOBANCInitBox.this.okPressed = false;
                GLOBANCInitBox.this.dispose();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(GLOBANCInitBox.this, "Global Ancova- Initialization Dialog");
            }
        }
    }

    public class RadioButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            GLOBANCInitBox.this.mPanel.ngPanel.numFullGroupsField.setVisible(false);
            GLOBANCInitBox.this.mPanel.ngPanel.numGroupsLabel.setVisible(false);
            GLOBANCInitBox.this.mPanel.ngPanel.factorPanel.setVisible(true);
        }
    }

    class MultiClassPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        DesignPanel ngPanel;
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        JPanel dummyPanel;
        ExperimentsSelectionPanel sampleSelectionPanel;
        ExperimentsSelectionPanel fullModelESP;
        ExperimentsSelectionPanel reducedModelESP;
        ExperimentsSelectionPanel ConditionESP;
        ExperimentsSelectionPanel TimePointESP;
        JTabbedPane tabbedmulg;
        ClusterSelector groupsCS;
        ClusterSelector factorACS;
        ClusterSelector factorBCS;
        ClusterSelector conditionCS;
        ClusterSelector timepointCS;
        JLabel infoLabel;
        JLabel infoLabel2;
        int numFullGroups = -1;
        int numRedGroups = -1;
        int numPerms = 100;
        String factorAName = "Full Model";
        String factorBName = "Reduced Model";

        public MultiClassPanel() {
            this.setBackground(Color.white);
            this.setLayout(this.gridbag);
            this.ngPanel = new DesignPanel();
            GLOBANCInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 10);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.ngPanel, this.constraints);
            GLOBANCInitBox.this.step2Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (GLOBANCInitBox.this.step2) {
                        MultiClassPanel.this.goBack();
                        return;
                    }
                    MultiClassPanel.this.initiatePanels();
                }
            });
            GLOBANCInitBox.this.step2Button.setEnabled(false);
            GLOBANCInitBox.this.gsfPanel = new GeneSetFilePanel();
            GLOBANCInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 10);
            this.gridbag.setConstraints(GLOBANCInitBox.this.gsfPanel, this.constraints);
            this.add(GLOBANCInitBox.this.gsfPanel);
            JPanel topPanel = new JPanel();
            topPanel.setBackground(Color.white);
            topPanel.setLayout(this.gridbag);
            GLOBANCInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 2, 75, 100);
            this.gridbag.setConstraints(this.ngPanel, this.constraints);
            topPanel.add(this.ngPanel);
            GLOBANCInitBox.this.buildConstraints(this.constraints, 1, 1, 1, 1, 0, 10);
            this.constraints.anchor = 17;
            this.constraints.fill = 0;
            this.gridbag.setConstraints(GLOBANCInitBox.this.step2Button, this.constraints);
            topPanel.add(GLOBANCInitBox.this.step2Button);
            this.constraints.fill = 1;
            topPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Global Ancova Parameters", 0, 0, null, Color.black));
            GLOBANCInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 100, 10);
            this.gridbag.setConstraints(topPanel, this.constraints);
            this.add(topPanel);
            this.infoLabel = new JLabel("Sample Group Assignment");
            this.infoLabel.setMaximumSize(new Dimension(50, 50));
            Font font = this.infoLabel.getFont();
            this.infoLabel.setFont(font.deriveFont(20.0f));
            GLOBANCInitBox.this.buildConstraints(this.constraints, 0, 2, 1, 1, 0, 5, 10, 0);
            this.gridbag.setConstraints(this.infoLabel, this.constraints);
            this.add((Component)this.infoLabel, this.constraints);
            this.infoLabel2 = new JLabel("Please select the Global Ancova parameters on which to run the analysis, then click 'Continue'.");
            GLOBANCInitBox.this.buildConstraints(this.constraints, 0, 3, 1, 1, 100, 5, 10);
            this.gridbag.setConstraints(this.infoLabel2, this.constraints);
            this.add((Component)this.infoLabel2, this.constraints);
            GLOBANCInitBox.this.buildConstraints(this.constraints, 0, 4, 1, 1, 100, 90);
            this.dummyPanel = new JPanel();
            this.dummyPanel.setBackground(Color.white);
            this.gridbag.setConstraints(this.dummyPanel, this.constraints);
            this.add(this.dummyPanel);
        }

        private void goBack() {
            this.infoLabel.setVisible(true);
            this.infoLabel2.setVisible(true);
            this.ngPanel.numFullGroupsField.setEnabled(true);
            this.ngPanel.numReducedGroupsField.setEnabled(true);
            this.ngPanel.numPermsField.setEnabled(true);
            GLOBANCInitBox.this.step2Button.setText("Continue...");
            GLOBANCInitBox.this.step2 = false;
            this.tabbedmulg.setVisible(false);
            GLOBANCInitBox.this.buildConstraints(this.constraints, 0, 1, 2, 1, 0, 90);
            this.constraints.fill = 1;
            GLOBANCInitBox.this.buildConstraints(this.constraints, 0, 3, 1, 1, 100, 90);
            this.gridbag.setConstraints(this.dummyPanel, this.constraints);
            this.add(this.dummyPanel);
            GLOBANCInitBox.this.step2Button.setSelected(false);
        }

        private void initiatePanels() {
            this.ngPanel.okPressed = true;
            GLOBANCInitBox.this.okReady = true;
            try {
                this.numFullGroups = Integer.parseInt(this.ngPanel.numFullGroupsField.getText());
                this.numRedGroups = Integer.parseInt(this.ngPanel.numReducedGroupsField.getText());
                this.numPerms = Integer.parseInt(this.ngPanel.numPermsField.getText());
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(null, "Error reading parameter input.", "Error", 0);
                return;
            }
            if (this.numFullGroups < 2 || this.numRedGroups < 2) {
                JOptionPane.showMessageDialog(null, "The number of groups in each factor must be greater than 1.", "Error", 0);
                return;
            }
            JPanel selectionPanel = new JPanel();
            GridBagLayout gbg = new GridBagLayout();
            selectionPanel.setLayout(gbg);
            GridBagConstraints cnstr = new GridBagConstraints();
            GLOBANCInitBox.this.buildConstraints(cnstr, 0, 0, 1, 1, 1, 1);
            cnstr.fill = 1;
            JPanel clusterSelectorPanel = new JPanel();
            this.remove(this.dummyPanel);
            this.tabbedmulg = new JTabbedPane();
            this.fullModelESP = new ExperimentsSelectionPanel(GLOBANCInitBox.this.exptNames, this.numFullGroups, "Full Model", false);
            this.reducedModelESP = new ExperimentsSelectionPanel(GLOBANCInitBox.this.exptNames, this.numRedGroups, "Reduced Model", false);
            selectionPanel.add((Component)this.fullModelESP, cnstr);
            cnstr.gridx = 1;
            selectionPanel.add((Component)this.reducedModelESP, cnstr);
            ++cnstr.gridy;
            --cnstr.gridx;
            cnstr.gridwidth = 2;
            cnstr.weighty = 0.0;
            selectionPanel.add((Component)this.createSaveLoadPanel(), cnstr);
            this.factorACS = new ClusterSelector(GLOBANCInitBox.this.repository, this.numFullGroups, "Full Model");
            this.factorBCS = new ClusterSelector(GLOBANCInitBox.this.repository, this.numRedGroups, "Reduced Model");
            if (GLOBANCInitBox.this.repository != null) {
                this.factorACS.setClusterType(this.factorAName);
                this.factorBCS.setClusterType(this.factorBName);
            }
            GLOBANCInitBox.this.buildConstraints(cnstr, 0, 1, 1, 1, 1, 1);
            cnstr.fill = 1;
            clusterSelectorPanel.add((Component)this.factorACS, cnstr);
            cnstr.gridx = 1;
            clusterSelectorPanel.add((Component)this.factorBCS, cnstr);
            this.tabbedmulg.add("Button Selection", selectionPanel);
            this.tabbedmulg.add("Cluster Selection", clusterSelectorPanel);
            this.tabbedmulg.setSelectedIndex(1);
            if (GLOBANCInitBox.this.repository == null || GLOBANCInitBox.this.repository.isEmpty()) {
                this.tabbedmulg.setSelectedIndex(0);
            }
            GLOBANCInitBox.this.buildConstraints(this.constraints, 0, 2, 2, 1, 0, 90);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.tabbedmulg, this.constraints);
            this.add(this.tabbedmulg);
            this.validate();
            GLOBANCInitBox.this.enableOK();
            this.ngPanel.numFullGroupsField.setEnabled(false);
            this.ngPanel.numReducedGroupsField.setEnabled(false);
            this.ngPanel.numPermsField.setEnabled(false);
            GLOBANCInitBox.this.step2Button.setText("<<< Go Back");
            this.infoLabel.setVisible(false);
            this.infoLabel2.setVisible(false);
            GLOBANCInitBox.this.step2 = true;
        }

        private void saveAssignments() {
            JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
            if (fileChooser.showSaveDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    PrintWriter pw = new PrintWriter(new FileWriter(file));
                    Date currDate = new Date(System.currentTimeMillis());
                    String dateString = currDate.toString();
                    String userName = System.getProperty("user.name");
                    pw.println("# Assignment File");
                    pw.println("# User: " + userName + " Save Date: " + dateString);
                    pw.println("#");
                    pw.print("Module:\t");
                    pw.println("Global Ancova");
                    pw.print("Design:\t");
                    pw.println(GLOBANCInitBox.this.getExperimentalDesign());
                    int groupMax = GLOBANCInitBox.this.getExperimentalDesign() != 4 ? this.numFullGroups : Math.max(this.numFullGroups, this.numRedGroups);
                    for (int i = 0; i < groupMax; ++i) {
                        pw.print("Group " + (i + 1) + " Label:\t");
                        pw.println("Group " + (i + 1));
                    }
                    pw.println("#");
                    pw.println("Sample Index\tSample Name\tGroup Assignment");
                    if (GLOBANCInitBox.this.getExperimentalDesign() < 4) {
                        int[] groupAssgn = GLOBANCInitBox.this.getGroupAssignments();
                        for (int sample = 0; sample < GLOBANCInitBox.this.exptNames.size(); ++sample) {
                            pw.print(String.valueOf(sample + 1) + "\t");
                            pw.print(GLOBANCInitBox.this.exptNames.get(sample) + "\t");
                            if (groupAssgn[sample] != 0) {
                                pw.println("Group " + groupAssgn[sample]);
                                continue;
                            }
                            pw.println("Exclude");
                        }
                    } else {
                        for (int sample = 0; sample < GLOBANCInitBox.this.exptNames.size(); ++sample) {
                            int j;
                            pw.print(String.valueOf(sample + 1) + "\t");
                            pw.print(GLOBANCInitBox.this.exptNames.get(sample) + "\t");
                            int a = 0;
                            int b = 0;
                            if (GLOBANCInitBox.this.getExperimentalDesign() == 4) {
                                for (j = 0; j < GLOBANCInitBox.this.mPanel.fullModelESP.assignmentRBs.length; ++j) {
                                    if (!GLOBANCInitBox.this.mPanel.fullModelESP.assignmentRBs[j][sample].isSelected()) continue;
                                    a = j + 1;
                                    break;
                                }
                                for (j = 0; j < GLOBANCInitBox.this.mPanel.reducedModelESP.assignmentRBs.length; ++j) {
                                    if (!GLOBANCInitBox.this.mPanel.reducedModelESP.assignmentRBs[j][sample].isSelected()) continue;
                                    b = j + 1;
                                    break;
                                }
                            } else {
                                for (j = 0; j < GLOBANCInitBox.this.mPanel.ConditionESP.assignmentRBs.length; ++j) {
                                    if (!GLOBANCInitBox.this.mPanel.ConditionESP.assignmentRBs[j][sample].isSelected()) continue;
                                    b = j + 1;
                                    break;
                                }
                                for (j = 0; j < GLOBANCInitBox.this.mPanel.TimePointESP.assignmentRBs.length; ++j) {
                                    if (!GLOBANCInitBox.this.mPanel.TimePointESP.assignmentRBs[j][sample].isSelected()) continue;
                                    a = j + 1;
                                    break;
                                }
                            }
                            pw.println((a == 0 ? "Exclude" : "Group " + a) + "\t" + (b == 0 ? "Exclude" : "Group " + b));
                        }
                    }
                    pw.flush();
                    pw.close();
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        private void loadAssignments() {
            JFileChooser fileChooser = new JFileChooser("./data");
            if (fileChooser.showOpenDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    Vector<String> data = new Vector<String>();
                    while ((line = br.readLine()) != null) {
                        data.add(line.trim());
                    }
                    br.close();
                    Vector<String> groupNames = new Vector<String>();
                    Vector<Integer> sampleIndices = new Vector<Integer>();
                    Vector<String> sampleNames = new Vector<String>();
                    Vector<String> groupAssignments = new Vector<String>();
                    Vector<String> group2Assignments = new Vector<String>();
                    int design = 0;
                    for (int row = 0; row < data.size(); ++row) {
                        line = (String)data.get(row);
                        if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                        String[] lineArray = line.split("\t");
                        if (lineArray[0].startsWith("Module:")) {
                            if (lineArray[1].equals("Global Ancova")) continue;
                            Object[] optionst = new Object[]{"Continue", "Cancel"};
                            if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                            return;
                        }
                        if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                            groupNames.add(lineArray[1]);
                            continue;
                        }
                        if (lineArray[0].startsWith("Design")) {
                            try {
                                design = Integer.parseInt(lineArray[1]);
                            }
                            catch (NumberFormatException nfe) {}
                            continue;
                        }
                        try {
                            Integer.parseInt(lineArray[0]);
                        }
                        catch (NumberFormatException nfe) {
                            continue;
                        }
                        sampleIndices.add(new Integer(lineArray[0]));
                        sampleNames.add(lineArray[1]);
                        groupAssignments.add(lineArray[2]);
                        if (design != 4 && design != 5) continue;
                        group2Assignments.add(lineArray[3]);
                    }
                    if (GLOBANCInitBox.this.exptNames.size() != sampleNames.size()) {
                        System.out.println(GLOBANCInitBox.this.exptNames.size() + "  " + sampleNames.size());
                        System.out.println(GLOBANCInitBox.this.exptNames.size() + " s length " + sampleNames.size());
                        JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + GLOBANCInitBox.this.exptNames.size() + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                        return;
                    }
                    Vector<String> currSampleVector = new Vector<String>();
                    for (int i = 0; i < GLOBANCInitBox.this.exptNames.size(); ++i) {
                        currSampleVector.add(GLOBANCInitBox.this.exptNames.get(i));
                    }
                    int fileSampleIndex = 0;
                    int groupIndex = 0;
                    int condIndex = 0;
                    for (int sample = 0; sample < GLOBANCInitBox.this.exptNames.size(); ++sample) {
                        boolean doIndex = false;
                        for (int i = 0; i < GLOBANCInitBox.this.exptNames.size(); ++i) {
                            if (i == sample || !GLOBANCInitBox.this.exptNames.get(i).equals(GLOBANCInitBox.this.exptNames.get(sample))) continue;
                            doIndex = true;
                        }
                        fileSampleIndex = sampleNames.indexOf(GLOBANCInitBox.this.exptNames.get(sample));
                        if (fileSampleIndex == -1) {
                            doIndex = true;
                        }
                        if (doIndex) {
                            this.setStateBasedOnIndex(groupAssignments, groupNames, design, group2Assignments);
                            break;
                        }
                        String groupName = (String)groupAssignments.get(fileSampleIndex);
                        groupIndex = groupNames.indexOf(groupName);
                        if (design == 4 || design == 5) {
                            String condName = group2Assignments.get(fileSampleIndex);
                            condIndex = groupNames.indexOf(condName);
                        }
                        try {
                            GLOBANCInitBox.this.mPanel.reducedModelESP.assignmentRBs[condIndex][sample].setSelected(true);
                            GLOBANCInitBox.this.mPanel.fullModelESP.assignmentRBs[groupIndex][sample].setSelected(true);
                            continue;
                        }
                        catch (Exception e) {
                            GLOBANCInitBox.this.mPanel.fullModelESP.notInTimeGroupRadioButtons[sample].setSelected(true);
                            GLOBANCInitBox.this.mPanel.reducedModelESP.notInTimeGroupRadioButtons[sample].setSelected(true);
                        }
                    }
                    this.repaint();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
                }
            }
        }

        private void setStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames, int cond, Vector<String> condAssignments) {
            Object[] optionst = new Object[]{"Continue", "Cancel"};
            if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
                return;
            }
            int condIndex = 0;
            for (int sample = 0; sample < GLOBANCInitBox.this.exptNames.size(); ++sample) {
                if (cond == 2) {
                    String condName = condAssignments.get(sample);
                    condIndex = groupNames.indexOf(condName);
                }
                try {
                    GLOBANCInitBox.this.mPanel.fullModelESP.assignmentRBs[groupNames.indexOf(groupAssignments.get(sample))][sample].setSelected(true);
                    GLOBANCInitBox.this.mPanel.reducedModelESP.assignmentRBs[condIndex][sample].setSelected(true);
                    continue;
                }
                catch (Exception e) {
                    GLOBANCInitBox.this.mPanel.fullModelESP.notInTimeGroupRadioButtons[sample].setSelected(true);
                    GLOBANCInitBox.this.mPanel.reducedModelESP.notInTimeGroupRadioButtons[sample].setSelected(true);
                }
            }
        }

        private JPanel createSaveLoadPanel() {
            JPanel panel2 = new JPanel();
            GridBagLayout gridbag3 = new GridBagLayout();
            panel2.setLayout(gridbag3);
            panel2.setBackground(Color.white);
            JButton saveButton = new JButton("  Save settings  ");
            saveButton.setFocusPainted(false);
            saveButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            JButton loadButton = new JButton("  Load settings  ");
            loadButton.setFocusPainted(false);
            loadButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            JButton resetButton = new JButton("  Reset  ");
            resetButton.setFocusPainted(false);
            resetButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            final int finNum = GLOBANCInitBox.this.exptNames.size();
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    for (int i = 0; i < finNum; ++i) {
                        GLOBANCInitBox.this.mPanel.fullModelESP.notInTimeGroupRadioButtons[i].setSelected(true);
                        GLOBANCInitBox.this.mPanel.reducedModelESP.notInTimeGroupRadioButtons[i].setSelected(true);
                    }
                }
            });
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File("Data"));
            saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MultiClassPanel.this.saveAssignments();
                }
            });
            loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MultiClassPanel.this.loadAssignments();
                }
            });
            this.constraints.anchor = 10;
            this.constraints.fill = 0;
            this.constraints.insets = new Insets(5, 5, 5, 5);
            GLOBANCInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 33, 100);
            gridbag3.setConstraints(saveButton, this.constraints);
            panel2.add(saveButton);
            GLOBANCInitBox.this.buildConstraints(this.constraints, 1, 0, 1, 1, 33, 0);
            gridbag3.setConstraints(loadButton, this.constraints);
            panel2.add(loadButton);
            GLOBANCInitBox.this.buildConstraints(this.constraints, 2, 0, 1, 1, 34, 0);
            gridbag3.setConstraints(resetButton, this.constraints);
            panel2.add(resetButton);
            this.constraints.insets = new Insets(0, 0, 0, 0);
            GLOBANCInitBox.this.buildConstraints(this.constraints, 0, 2, 1, 1, 0, 5);
            this.constraints.anchor = 10;
            return panel2;
        }

        protected void reset() {
            if (this.ngPanel.okPressed) {
                this.sampleSelectionPanel.reset();
            }
        }

        class ExperimentsSelectionPanel
        extends JPanel {
            private static final long serialVersionUID = 1L;
            int numPanels = 0;
            JLabel[] expLabels;
            JRadioButton[][] assignmentRBs;
            JRadioButton[] notInTimeGroupRadioButtons;

            ExperimentsSelectionPanel(Vector<String> exptNames, int numGroups, String title, boolean firstPanel) {
                int i;
                int i2;
                this.setBorder(new TitledBorder(new EtchedBorder(), title + " Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
                this.setBackground(Color.white);
                this.expLabels = new JLabel[exptNames.size()];
                this.assignmentRBs = new JRadioButton[numGroups][exptNames.size()];
                this.numPanels = exptNames.size() / 512 + 1;
                this.notInTimeGroupRadioButtons = new JRadioButton[exptNames.size()];
                ButtonGroup[] chooseTime = new ButtonGroup[exptNames.size()];
                ButtonGroup[] chooseCondition = new ButtonGroup[exptNames.size()];
                GridBagLayout gridbag = new GridBagLayout();
                GridBagLayout gridbag2 = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                this.setLayout(gridbag2);
                JPanel[] panels = new JPanel[this.numPanels];
                int currPanel = 0;
                for (i2 = 0; i2 < panels.length; ++i2) {
                    panels[i2] = new JPanel(gridbag);
                }
                for (i2 = 0; i2 < exptNames.size(); ++i2) {
                    String s1 = exptNames.get(i2);
                    this.expLabels[i2] = new JLabel(s1);
                    chooseTime[i2] = new ButtonGroup();
                    chooseCondition[i2] = new ButtonGroup();
                    for (int j = 0; j < numGroups; ++j) {
                        this.assignmentRBs[j][i2] = new JRadioButton("Group " + (j + 1) + "     ", true);
                        chooseTime[i2].add(this.assignmentRBs[j][i2]);
                    }
                    currPanel = i2 / 512;
                    this.notInTimeGroupRadioButtons[i2] = new JRadioButton("Unassigned", false);
                    chooseTime[i2].add(this.notInTimeGroupRadioButtons[i2]);
                    int twoCondRoom = 0;
                    for (int j = 0; j < numGroups; ++j) {
                        GLOBANCInitBox.this.buildConstraints(constraints, j + twoCondRoom, i2 % 512, 1, 1, 100, 100);
                        gridbag.setConstraints(this.assignmentRBs[j][i2], constraints);
                        panels[currPanel].add(this.assignmentRBs[j][i2]);
                    }
                    GLOBANCInitBox.this.buildConstraints(constraints, numGroups + 1 + twoCondRoom, i2 % 512, 1, 1, 100, 100);
                    gridbag.setConstraints(this.notInTimeGroupRadioButtons[i2], constraints);
                    panels[currPanel].add(this.notInTimeGroupRadioButtons[i2]);
                }
                int maxLabelWidth = 0;
                for (int i3 = 0; i3 < this.expLabels.length; ++i3) {
                    if (!(this.expLabels[i3].getPreferredSize().getWidth() > (double)maxLabelWidth)) continue;
                    maxLabelWidth = (int)Math.ceil(this.expLabels[i3].getPreferredSize().getWidth());
                }
                JPanel bigPanel = new JPanel(new GridBagLayout());
                for (int i4 = 0; i4 < this.numPanels; ++i4) {
                    bigPanel.add((Component)panels[i4], new GridBagConstraints(0, i4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                JScrollPane scroll = new JScrollPane(bigPanel);
                scroll.setHorizontalScrollBarPolicy(32);
                scroll.setVerticalScrollBarPolicy(22);
                JPanel[] exptNameHeaderPanels = new JPanel[this.numPanels];
                GridBagLayout exptHeaderGridbag = new GridBagLayout();
                for (i = 0; i < exptNameHeaderPanels.length; ++i) {
                    exptNameHeaderPanels[i] = new JPanel();
                    exptNameHeaderPanels[i].setSize(50, panels[i].getPreferredSize().height);
                    exptNameHeaderPanels[i].setPreferredSize(new Dimension(maxLabelWidth + 10, panels[i].getPreferredSize().height));
                    exptNameHeaderPanels[i].setLayout(exptHeaderGridbag);
                }
                for (i = 0; i < this.expLabels.length; ++i) {
                    currPanel = i / 512;
                    GLOBANCInitBox.this.buildConstraints(constraints, 0, i % 512, 1, 1, 100, 100);
                    constraints.fill = 1;
                    exptHeaderGridbag.setConstraints(this.expLabels[i], constraints);
                    exptNameHeaderPanels[currPanel].add(this.expLabels[i]);
                }
                JPanel headerPanel = new JPanel(new GridBagLayout());
                for (int i5 = 0; i5 < exptNameHeaderPanels.length; ++i5) {
                    headerPanel.add((Component)exptNameHeaderPanels[i5], new GridBagConstraints(0, i5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                scroll.setRowHeaderView(headerPanel);
                GLOBANCInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90, 10, 1);
                gridbag2.setConstraints(scroll, constraints);
                this.add(scroll);
            }

            protected void reset() {
                for (int i = 0; i < GLOBANCInitBox.this.exptNames.size(); ++i) {
                    this.notInTimeGroupRadioButtons[i].setSelected(true);
                }
            }
        }

        class DesignPanel
        extends JPanel {
            private static final long serialVersionUID = 1L;
            JTextField factorAName;
            JTextField factorBName;
            JTextField factorALevel;
            JTextField factorBLevel;
            JTextField numFullGroupsField;
            JTextField numReducedGroupsField;
            JTextField numPermsField;
            JLabel numGroupsLabel;
            JLabel numPermsLabel;
            JPanel factorPanel;
            boolean okPressed = false;

            public DesignPanel() {
                this.setBackground(Color.white);
                GridBagLayout gridbag = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                this.setLayout(gridbag);
                this.setMinimumSize(new Dimension(300, 100));
                this.numGroupsLabel = new JLabel("Number of full model groups: ");
                this.numGroupsLabel.setVisible(true);
                GLOBANCInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 30, 100);
                constraints.anchor = 13;
                gridbag.setConstraints(this.numGroupsLabel, constraints);
                this.add(this.numGroupsLabel);
                this.numFullGroupsField = new JTextField("2", 7);
                this.numFullGroupsField.setVisible(true);
                this.numFullGroupsField.setMinimumSize(new Dimension(50, 20));
                constraints.anchor = 17;
                GLOBANCInitBox.this.buildConstraints(constraints, 1, 1, 1, 1, 30, 0);
                gridbag.setConstraints(this.numFullGroupsField, constraints);
                this.add(this.numFullGroupsField);
                this.numGroupsLabel = new JLabel("Number of reduced model groups: ");
                this.numGroupsLabel.setVisible(true);
                GLOBANCInitBox.this.buildConstraints(constraints, 0, 2, 1, 1, 30, 100);
                constraints.anchor = 13;
                gridbag.setConstraints(this.numGroupsLabel, constraints);
                this.add(this.numGroupsLabel);
                this.numReducedGroupsField = new JTextField("2", 7);
                this.numReducedGroupsField.setVisible(true);
                this.numReducedGroupsField.setMinimumSize(new Dimension(50, 20));
                constraints.anchor = 17;
                GLOBANCInitBox.this.buildConstraints(constraints, 1, 2, 1, 1, 30, 0);
                gridbag.setConstraints(this.numReducedGroupsField, constraints);
                this.add(this.numReducedGroupsField);
                this.numPermsLabel = new JLabel("Number of permutations: ");
                this.numPermsLabel.setVisible(true);
                GLOBANCInitBox.this.buildConstraints(constraints, 0, 3, 1, 1, 30, 100);
                constraints.anchor = 13;
                gridbag.setConstraints(this.numPermsLabel, constraints);
                this.add(this.numPermsLabel);
                this.numPermsField = new JTextField("100", 7);
                this.numPermsField.setVisible(true);
                this.numPermsField.setMinimumSize(new Dimension(50, 20));
                constraints.anchor = 17;
                GLOBANCInitBox.this.buildConstraints(constraints, 1, 3, 1, 1, 30, 0);
                gridbag.setConstraints(this.numPermsField, constraints);
                this.add(this.numPermsField);
            }

            @Override
            public void setVisible(boolean visible) {
                this.setLocation((MultiClassPanel.this.getWidth() - this.getSize().width) / 2, (MultiClassPanel.this.getHeight() - this.getSize().height) / 2);
                super.setVisible(visible);
            }

            public boolean isOkPressed() {
                return this.okPressed;
            }
        }
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((String)GLOBANCInitBox.this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Download from MSigDB")) {
                GLOBANCInitBox.this.gsfPanel.browseDownloadButton.setText("Download");
            } else if (((String)GLOBANCInitBox.this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Load local geneset file/files")) {
                GLOBANCInitBox.this.gsfPanel.browseDownloadButton.setText("Browse");
            } else if (((String)GLOBANCInitBox.this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Download from GeneSigDB")) {
                GLOBANCInitBox.this.gsfPanel.browseDownloadButton.setText("Download");
            }
        }
    }

    class GeneSetFilePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JLabel chooseFileLabel = new JLabel("Choose File: ");
        JLabel chooseAnnoLabel = new JLabel("Choose Annotation Type: ");
        JDialog jd;
        private JButton browseDownloadButton;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        public JTextField filePath = new JTextField();
        JTextField jtf;
        private JComboBox geneIdentifierBox;
        String broademail = "";

        public GeneSetFilePanel() {
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Gene Set File", 0, 0, null, Color.black));
            this.setLayout(this.gridbag);
            String buttonName = "Browse";
            String actionCommand = "genesigdb_download";
            String[] selectionMethods = new String[]{"Load local geneset file/files", "Download from MSigDB", "Download from GeneSigDB"};
            GLOBANCInitBox.this.geneSetSelectionBox = new JComboBox<String>(selectionMethods);
            GLOBANCInitBox.this.geneSetSelectionBox.addActionListener(new Listener());
            this.jd = new JDialog();
            this.jd.setLayout(this.gridbag);
            this.jd.setTitle("Please enter a valid MSigDB email address");
            this.jtf = new JTextField(25);
            this.jd.add(this.jtf);
            JButton jb = new JButton("OK");
            jb.addActionListener(new Listener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GeneSetFilePanel.this.broademail = GeneSetFilePanel.this.jtf.getText();
                    GeneSetFilePanel.this.jd.dispose();
                }
            });
            GLOBANCInitBox.this.buildConstraints(this.constraints, 0, 0, 2, 2, 0, 0);
            this.constraints.fill = 2;
            this.gridbag.setConstraints(this.jtf, this.constraints);
            this.jd.add(this.jtf);
            GLOBANCInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 0);
            this.gridbag.setConstraints(jb, this.constraints);
            this.jd.add(jb);
            this.jd.setPreferredSize(new Dimension(400, 130));
            this.jd.setMinimumSize(new Dimension(400, 130));
            this.jd.setSize(new Dimension(400, 130));
            this.jd.setLocationRelativeTo(this);
            this.jd.pack();
            this.jd.setModal(true);
            this.constraints.fill = 0;
            this.filePath.setEditable(false);
            this.browseDownloadButton = new JButton(buttonName);
            this.browseDownloadButton.setName(buttonName);
            this.browseDownloadButton.setActionCommand(actionCommand);
            this.browseDownloadButton.setSize(new Dimension(100, 30));
            this.browseDownloadButton.setPreferredSize(new Dimension(100, 30));
            this.browseDownloadButton.addActionListener(new Listener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GLOBANCInitBox.this.geneSetSelectionBox.getSelectedIndex() == 0) {
                        if (!GLOBANCInitBox.this.onBrowse()) {
                            return;
                        }
                        GeneSetFilePanel.this.filePath.setText(GLOBANCInitBox.this.genesetFilePath[0]);
                        GeneSetFilePanel.this.browseDownloadButton.setEnabled(false);
                        GLOBANCInitBox.this.geneSetSelectionBox.setEnabled(false);
                        GeneSetFilePanel.this.chooseFileLabel.setForeground(Color.red);
                        GeneSetFilePanel.this.chooseFileLabel.setText("File Loaded");
                        GLOBANCInitBox.this.step2Button.setEnabled(true);
                    } else if (GLOBANCInitBox.this.geneSetSelectionBox.getSelectedIndex() == 1) {
                        GeneSetFilePanel.this.jd.setVisible(true);
                        if (GeneSetFilePanel.this.broademail.length() == 0) {
                            return;
                        }
                        GLOBANCInitBox.this.BROADDownloads(GeneSetFilePanel.this.broademail);
                        if (GLOBANCInitBox.this.msigOK) {
                            GeneSetFilePanel.this.geneIdentifierBox.setSelectedItem("GENE_SYMBOL");
                            GeneSetFilePanel.this.browseDownloadButton.setEnabled(false);
                            GLOBANCInitBox.this.geneSetSelectionBox.setEnabled(false);
                            GeneSetFilePanel.this.chooseFileLabel.setForeground(Color.red);
                            GeneSetFilePanel.this.chooseFileLabel.setText("File Loaded");
                            String allfiles = "";
                            for (int i = 0; i < GLOBANCInitBox.this.genesetFilePath.length; ++i) {
                                allfiles = allfiles + GLOBANCInitBox.this.genesetFilePath[i];
                                if (i >= GLOBANCInitBox.this.genesetFilePath.length - 1) continue;
                                allfiles = allfiles + "; ";
                            }
                            GeneSetFilePanel.this.filePath.setText(allfiles);
                            GLOBANCInitBox.this.step2Button.setEnabled(true);
                        } else {
                            JOptionPane.showMessageDialog(null, "Invalid MSigDB email address.", "Error", 0);
                        }
                    } else if (e.getActionCommand().equalsIgnoreCase("genesigdb_download")) {
                        GLOBANCInitBox.this.GeneSigDBDownloads();
                        GeneSetFilePanel.this.browseDownloadButton.setEnabled(!GLOBANCInitBox.this.geneSigValid);
                        GLOBANCInitBox.this.geneSetSelectionBox.setEnabled(!GLOBANCInitBox.this.geneSigValid);
                        GeneSetFilePanel.this.chooseFileLabel.setForeground(GLOBANCInitBox.this.geneSigValid ? Color.red : Color.black);
                        GeneSetFilePanel.this.chooseFileLabel.setText(GLOBANCInitBox.this.geneSigValid ? "File Loaded" : "Choose File:");
                        GeneSetFilePanel.this.filePath.setText(GLOBANCInitBox.this.genesetFilePath[0]);
                        GLOBANCInitBox.this.step2Button.setEnabled(true);
                    }
                }
            });
            Field[] fields = AnnotationFieldConstants.class.getFields();
            String[] annotation = new String[fields.length + 1];
            annotation[0] = "";
            try {
                for (int index = 0; index < fields.length; ++index) {
                    annotation[index + 1] = (String)fields[index].get(new AnnotationFieldConstants());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.geneIdentifierBox = new JComboBox<String>(GLOBANCInitBox.this.annotFields);
            this.geneIdentifierBox.setSelectedItem("GENE_SYMBOL");
            this.constraints.anchor = 13;
            int xind = 0;
            GLOBANCInitBox.this.buildConstraints(this.constraints, xind++, 0, 1, 1, 5, 10);
            this.add((Component)this.chooseFileLabel, this.constraints);
            GLOBANCInitBox.this.buildConstraints(this.constraints, xind++, 0, 1, 1, 5, 10);
            this.gridbag.setConstraints(GLOBANCInitBox.this.geneSetSelectionBox, this.constraints);
            this.add(GLOBANCInitBox.this.geneSetSelectionBox);
            GLOBANCInitBox.this.buildConstraints(this.constraints, xind++, 0, 1, 1, 5, 10);
            this.gridbag.setConstraints(this.browseDownloadButton, this.constraints);
            this.add(this.browseDownloadButton);
            xind = 0;
            GLOBANCInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 5, 10);
            this.gridbag.setConstraints(this.chooseAnnoLabel, this.constraints);
            this.add(this.chooseAnnoLabel);
            GLOBANCInitBox.this.buildConstraints(this.constraints, ++xind, 1, 1, 1, 5, 10);
            this.gridbag.setConstraints(this.geneIdentifierBox, this.constraints);
            this.add(this.geneIdentifierBox);
            xind = 0;
            GLOBANCInitBox.this.buildConstraints(this.constraints, 0, 2, 1, 1, 5, 10);
            this.constraints.anchor = 13;
            this.add((Component)new JLabel("File Location: "), this.constraints);
            GLOBANCInitBox.this.buildConstraints(this.constraints, ++xind, 2, 2, 1, 5, 10);
            this.constraints.fill = 2;
            this.gridbag.setConstraints(this.filePath, this.constraints);
            this.add(this.filePath);
        }
    }
}

