/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.globanc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.FloatMatrix;

public class GLOBANCInfoViewer
extends ViewerAdapter {
    private JComponent header;
    private JComponent rowheader;
    private JTextArea content;
    private JTable table;
    private String[] geneListNames;
    private FloatMatrix resultsMatrix;

    public GLOBANCInfoViewer(int[][] clusters, String[] geneListNames, FloatMatrix resultsMatrix, int genes, int dd, int numGroups) {
        this.resultsMatrix = resultsMatrix;
        this.geneListNames = geneListNames;
        this.createHeader();
        this.rowheader = this.createRowHeader();
        this.content = this.createContent(clusters, genes);
        this.setMaxWidth(this.content, this.header);
        this.getRowHeaderComponent();
    }

    public GLOBANCInfoViewer(JTextArea content, JComponent header) {
        this.header = header;
        this.content = content;
        this.setMaxWidth(content, header);
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JScrollPane createRowHeader() {
        JTextArea area = new JTextArea(this.resultsMatrix.A.length * 3, 20);
        area.setEditable(false);
        area.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer sb = new StringBuffer(this.resultsMatrix.A.length * 3 * 10);
        for (int counter = 0; counter < this.resultsMatrix.A.length; ++counter) {
            sb.append(this.geneListNames[counter]);
            sb.append("\n\n");
        }
        area.setText(sb.toString());
        area.setCaretPosition(0);
        JScrollPane jsp = new JScrollPane(area);
        jsp.setHorizontalScrollBarPolicy(30);
        return jsp;
    }

    private JComponent createHeader() {
        this.header = new JPanel(new GridBagLayout());
        this.header.setBackground(Color.gray);
        GridBagLayout gridbag = new GridBagLayout();
        this.header.setLayout(gridbag);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 0, 10, 0);
        this.header.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Gene List Information</b></font></body></html>"), gbc);
        JTextArea headerLabels = new JTextArea();
        headerLabels.setEditable(false);
        StringBuffer sb = new StringBuffer();
        sb.append("Genes");
        sb.append("\t");
        sb.append("F-Value");
        sb.append("\t");
        sb.append("p.perm");
        sb.append("\t");
        sb.append("p.approx");
        headerLabels.setText(sb.toString());
        headerLabels.setCaretPosition(0);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.header.add((Component)headerLabels, gbc);
        return this.header;
    }

    private JTextArea createContent(int[][] clusters, int genes) {
        JTextArea area = new JTextArea(clusters.length * 3, 20);
        area.setEditable(false);
        area.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer sb = new StringBuffer(clusters.length * 3 * 10);
        for (int counter = 0; counter < clusters.length; ++counter) {
            sb.append((int)this.resultsMatrix.A[counter][0]);
            sb.append("\t");
            sb.append(this.resultsMatrix.A[counter][1]);
            sb.append("\t");
            sb.append(this.resultsMatrix.A[counter][2]);
            sb.append("\t");
            sb.append(this.resultsMatrix.A[counter][3]);
            sb.append("\n\n");
        }
        area.setText(sb.toString());
        area.setCaretPosition(0);
        return area;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return this.rowheader;
    }
}

