/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.globanc;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.globanc.GLOBALANCResultTable;
import org.tigr.microarray.mev.cluster.gui.impl.globanc.GLOBANCCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.globanc.GLOBANCCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.globanc.GLOBANCExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.globanc.GLOBANCInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.globanc.GLOBANCInitBox;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class GLOBANCGUI
implements IClusterGUI,
IScriptGUI {
    protected Algorithm algorithm;
    protected Progress progress;
    protected Experiment experiment;
    protected int[][] geneLists;
    protected int[][] errorGenesArray = new int[1][];
    protected FloatMatrix means;
    protected FloatMatrix variances;
    protected int[][] sigGenesArrays;
    protected String[] auxTitles;
    protected Object[][] auxData;
    protected float[][] geneGroupMeans;
    protected float[][] geneGroupSDs;
    Vector<String> exptNamesVector;
    protected int[] groupAssignments;
    protected double falseProp;
    protected IData data;
    protected int numGroups;
    protected int dataDesign;
    protected int numFullGroups;
    protected int numRedGroups;
    protected int geneSetOrigin;
    protected int numPerms;
    protected float alpha;
    protected String factorAName;
    protected String factorBName;
    protected boolean errorGenes;
    protected int iterations;
    protected ArrayList<String> geneLabels;
    protected ArrayList<String> sampleLabels;
    private String[] geneListNames;
    private FloatMatrix resultMatrix;
    private String[] geneSetFilePath;
    private String annotChosen;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        if (this.sysMsg("R 2.11.x", "GlobalAncova") != 0) {
            return null;
        }
        this.experiment = framework.getData().getExperiment();
        this.data = framework.getData();
        this.exptNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int[] columnIndices = this.experiment.getColumnIndicesCopy();
        this.sampleLabels = new ArrayList();
        this.geneLabels = new ArrayList();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(columnIndices[i]));
            this.sampleLabels.add(framework.getData().getFullSampleName(columnIndices[i]));
        }
        GLOBANCInitBox GLOBALANCDialog = new GLOBANCInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getData().getAllFilledAnnotationFields(), framework.getClusterRepository(1));
        GLOBALANCDialog.setVisible(true);
        this.annotChosen = GLOBALANCDialog.getSelectedAnnotation();
        for (int i = 0; i < this.experiment.getNumberOfGenes(); ++i) {
            this.geneLabels.add(framework.getData().getElementAnnotation(i, this.annotChosen)[0]);
        }
        if (!GLOBALANCDialog.isOkPressed()) {
            return null;
        }
        this.alpha = GLOBALANCDialog.getAlpha();
        this.dataDesign = 4;
        this.numGroups = GLOBALANCDialog.getNumGroups();
        this.numPerms = GLOBALANCDialog.getNumPerms();
        this.numFullGroups = GLOBALANCDialog.getNumFullGroups();
        this.numRedGroups = GLOBALANCDialog.getNumRedGroups();
        this.factorAName = GLOBALANCDialog.getFactorAName();
        this.factorBName = GLOBALANCDialog.getFactorBName();
        this.groupAssignments = GLOBALANCDialog.getGroupAssignments();
        this.geneSetFilePath = GLOBALANCDialog.getGeneSetFilePath();
        this.geneSetOrigin = GLOBALANCDialog.getGeneSetOrigin();
        if (this.groupAssignments == null) {
            return null;
        }
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 4;
        }
        Listener listener = new Listener();
        try {
            int i;
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("GLOBANC");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Running Global ANCOVA Analysis", listener);
            this.progress.setIndeterminate(true);
            this.progress.setIndeterminantString("Running Analysis...");
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            data.addMatrix("experiment", this.experiment.getMatrix());
            data.addIntArray("group_assignments", this.groupAssignments);
            data.addParam("dataDesign", String.valueOf(this.dataDesign));
            data.addParam("numGroups", String.valueOf(this.numGroups));
            data.addParam("alpha", String.valueOf(this.alpha));
            data.addParam("numAGroups", String.valueOf(this.numFullGroups));
            data.addParam("numPerms", String.valueOf(this.numPerms));
            data.addParam("numBGroups", String.valueOf(this.numRedGroups));
            data.addParam("nameA", String.valueOf(this.factorAName));
            data.addParam("nameB", String.valueOf(this.factorBName));
            data.addParam("geneSetOrigin", String.valueOf(this.geneSetOrigin));
            data.addStringArray("geneSetFilePaths", this.geneSetFilePath);
            if (this.dataDesign == 5) {
                data.addParam("numAGroups", String.valueOf(2));
                data.addParam("numBGroups", String.valueOf(this.numGroups));
                data.addParam("nameA", String.valueOf("Condition"));
                data.addParam("nameB", String.valueOf("Time"));
            }
            data.addStringArray("geneLabels", this.geneLabels.toArray(new String[this.geneLabels.size()]));
            data.addStringArray("sampleLabels", this.sampleLabels.toArray(new String[this.sampleLabels.size()]));
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            this.geneLists = result.getIntMatrix("geneListsMatrix");
            this.geneListNames = result.getStringArray("gene-list-names");
            this.resultMatrix = result.getMatrix("result-matrix");
            FloatMatrix geneGroupMeansMatrix = result.getMatrix("geneGroupMeansMatrix");
            FloatMatrix geneGroupSDsMatrix = result.getMatrix("geneGroupSDsMatrix");
            this.iterations = result.getParams().getInt("iterations");
            this.geneGroupMeans = new float[geneGroupMeansMatrix.getRowDimension()][geneGroupMeansMatrix.getColumnDimension()];
            this.geneGroupSDs = new float[geneGroupSDsMatrix.getRowDimension()][geneGroupSDsMatrix.getColumnDimension()];
            for (int i2 = 0; i2 < this.geneGroupMeans.length; ++i2) {
                for (int j = 0; j < this.geneGroupMeans[i2].length; ++j) {
                    this.geneGroupMeans[i2][j] = geneGroupMeansMatrix.A[i2][j];
                    this.geneGroupSDs[i2][j] = geneGroupSDsMatrix.A[i2][j];
                }
            }
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.alpha = this.alpha;
            info.function = menu.getFunctionName(function);
            Vector<String> titlesVector = new Vector<String>();
            for (int i3 = 0; i3 < this.geneGroupMeans[0].length; ++i3) {
                titlesVector.add("Group " + (i3 + 1) + " mean");
                titlesVector.add("Group " + (i3 + 1) + " std.dev");
            }
            titlesVector.add("F-values");
            int x = 1;
            int y = 2;
            for (i = 0; i < this.getTotalInteractions(this.numGroups); ++i) {
                titlesVector.add("significance-values, " + x + "vs." + y);
                titlesVector.add("adj-p-values, " + x + "vs." + y);
                titlesVector.add("log fold change, " + x + "vs." + y);
                titlesVector.add("t-statistic, " + x + "vs." + y);
                titlesVector.add("log-odds, " + x + "vs." + y);
                if (++y <= this.numGroups) continue;
                y = ++x + 1;
            }
            this.auxTitles = new String[titlesVector.size()];
            for (i = 0; i < this.auxTitles.length; ++i) {
                this.auxTitles[i] = (String)titlesVector.get(i);
            }
            this.auxData = new Object[this.experiment.getNumberOfGenes()][this.auxTitles.length];
            for (i = 0; i < this.auxData.length; ++i) {
                int counter = 0;
                for (int j = 0; j < this.geneGroupMeans[i].length; ++j) {
                    this.auxData[i][counter++] = new Float(this.geneGroupMeans[i][j]);
                    this.auxData[i][counter++] = new Float(this.geneGroupSDs[i][j]);
                }
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        this.experiment = framework.getData().getExperiment();
        this.exptNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(this.experiment.getSampleIndex(i)));
        }
        GLOBANCInitBox GLOBANCDialog = new GLOBANCInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getData().getAllFilledAnnotationFields(), framework.getClusterRepository(1));
        GLOBANCDialog.setVisible(true);
        if (!GLOBANCDialog.isOkPressed()) {
            return null;
        }
        this.dataDesign = GLOBANCDialog.getExperimentalDesign();
        this.numGroups = GLOBANCDialog.getNumGroups();
        this.groupAssignments = GLOBANCDialog.getGroupAssignments();
        if (this.groupAssignments == null) {
            return null;
        }
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 4;
        }
        AlgorithmData data = new AlgorithmData();
        data.addParam("distance-factor", String.valueOf(1.0f));
        data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
        data.addParam("distance-function", String.valueOf(function));
        data.addIntArray("group_assignments", this.groupAssignments);
        data.addParam("numGroups", String.valueOf(this.numGroups));
        data.addParam("name", "GLOBANC");
        data.addParam("alg-type", "cluster-genes");
        data.addParam("output-class", "partition-output");
        String[] outputNodes = new String[]{"Significant Genes", "Non-significant Genes"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        Listener listener = new Listener();
        this.experiment = experiment;
        this.data = framework.getData();
        this.groupAssignments = algData.getIntArray("group_assignments");
        this.exptNamesVector = new Vector();
        int number_of_samples = experiment.getNumberOfSamples();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(this.data.getFullSampleName(i));
        }
        try {
            int i;
            algData.addMatrix("experiment", experiment.getMatrix());
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("GLOBANC");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Running GLOBANC Analysis", listener);
            this.progress.setIndeterminate(true);
            this.progress.setIndeterminantString("Running Analysis");
            this.progress.show();
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            int k = 2;
            this.geneLists = new int[k][];
            for (int i2 = 0; i2 < k; ++i2) {
                this.geneLists[i2] = nodeList.getNode(i2).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            AlgorithmParameters params = algData.getParams();
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.alpha = params.getFloat("alpha");
            this.numGroups = params.getInt("numGroups");
            info.usePerms = params.getBoolean("usePerms");
            info.numPerms = params.getInt("numPerms");
            info.function = framework.getDistanceMenu().getFunctionName(params.getInt("distance-function"));
            info.hcl = params.getBoolean("hierarchical-tree");
            info.hcl_genes = params.getBoolean("calculate-genes");
            info.hcl_samples = params.getBoolean("calculate-experiments");
            if (info.hcl) {
                info.hcl_method = params.getInt("method-linkage");
            }
            Vector<String> titlesVector = new Vector<String>();
            for (i = 0; i < this.geneGroupMeans[0].length; ++i) {
                titlesVector.add("Group" + (i + 1) + " mean");
                titlesVector.add("Group" + (i + 1) + " std.dev");
            }
            this.auxTitles = new String[titlesVector.size()];
            for (i = 0; i < this.auxTitles.length; ++i) {
                this.auxTitles[i] = (String)titlesVector.get(i);
            }
            this.auxData = new Object[experiment.getNumberOfGenes()][this.auxTitles.length];
            for (i = 0; i < this.auxData.length; ++i) {
                int counter = 0;
                for (int j = 0; j < this.geneGroupMeans[i].length; ++j) {
                    this.auxData[i][counter++] = new Float(this.geneGroupMeans[i][j]);
                    this.auxData[i][counter++] = new Float(this.geneGroupSDs[i][j]);
                }
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private int getTotalInteractions(int groups) {
        if (this.dataDesign == 4 || this.dataDesign == 5) {
            return 3;
        }
        if (groups <= 1) {
            return 0;
        }
        return groups - 1 + this.getTotalInteractions(groups - 1);
    }

    public static void main(String[] args) {
    }

    protected String getNodeTitle(int ind, int x, int y) {
        return this.geneListNames[ind];
    }

    protected DefaultMutableTreeNode createResultTree(Cluster result_cluster, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("GLOBANC");
        this.addResultNodes(root, result_cluster, info);
        return root;
    }

    protected void addResultNodes(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        this.addExpressionImages(root);
        this.addTableViews(root);
        this.addGeneSetInfo(root);
        this.addGeneralInfo(root, info);
    }

    private void addGeneSetInfo(DefaultMutableTreeNode root) {
        int i;
        Object[][] results = new Object[this.resultMatrix.A.length][this.resultMatrix.A[0].length + 1];
        for (i = 0; i < results.length; ++i) {
            for (int j = 1; j < results[0].length; ++j) {
                results[i][j] = Float.valueOf(this.resultMatrix.A[i][j - 1]);
            }
        }
        for (i = 0; i < results.length; ++i) {
            results[i][0] = this.geneListNames[i];
        }
        String[] columns = new String[]{"Gene List", "Gene Count", "F-value", "p-value (permutation)", "p-value (approximate)"};
        GLOBALANCResultTable tabViewer = new GLOBALANCResultTable(results, columns);
        root.add(new DefaultMutableTreeNode(new LeafInfo("Results Table", (IViewer)tabViewer, (Object)new Integer(0))));
    }

    protected void addTableViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table Views");
        ClusterTableViewer tabViewer = new ClusterTableViewer(this.experiment, this.geneLists, this.data, this.auxTitles, this.auxData);
        int x = 1;
        int y = 2;
        for (int i = 0; i < this.geneLists.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo(this.getNodeTitle(i, x, y), (IViewer)tabViewer, (Object)new Integer(i))));
            if (i % 2 == 1) {
                ++y;
            }
            if (y <= this.numGroups) continue;
            y = ++x + 1;
        }
        root.add(node);
    }

    protected void addExpressionImages(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        GLOBANCExperimentViewer expViewer = new GLOBANCExperimentViewer(this.experiment, this.geneLists, (float[][])null, (float[][])null, null, null, null, null, null, null, null);
        int x = 1;
        int y = 2;
        for (int i = 0; i < this.geneLists.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo(this.getNodeTitle(i, x, y), (IViewer)expViewer, (Object)new Integer(i))));
            if (i % 2 == 1) {
                ++y;
            }
            if (y <= this.numGroups) continue;
            y = ++x + 1;
        }
        root.add(node);
    }

    protected void addClusterInfo(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        node.add(new DefaultMutableTreeNode(new LeafInfo("Results (#,%)", (IViewer)new GLOBANCInfoViewer(this.geneLists, this.geneListNames, this.resultMatrix, this.experiment.getNumberOfGenes(), this.dataDesign, this.numGroups))));
        root.add(node);
    }

    protected void addCentroidViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        GLOBANCCentroidViewer centroidViewer = new GLOBANCCentroidViewer(this.experiment, this.geneLists, null, null, null, null, null, null, null, null, null);
        centroidViewer.setMeans(this.means.A);
        centroidViewer.setVariances(this.variances.A);
        for (int i = 0; i < this.geneLists.length; ++i) {
            if (i == 0) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                continue;
            }
            if (i != 1) continue;
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
        }
        GLOBANCCentroidsViewer centroidsViewer = new GLOBANCCentroidsViewer(this.experiment, this.geneLists, this.geneGroupMeans, this.geneGroupSDs, null, null, null, null, null, null, null);
        centroidsViewer.setMeans(this.means.A);
        centroidsViewer.setVariances(this.variances.A);
        centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(0))));
        expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(1))));
        root.add(centroidNode);
        root.add(expressionNode);
    }

    protected void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(this.getGroupAssignmentInfo());
        node.add(new DefaultMutableTreeNode("Full Model Groups: " + this.numFullGroups));
        node.add(new DefaultMutableTreeNode("Reduced Model Groups: " + this.numRedGroups));
        node.add(new DefaultMutableTreeNode("Number of Permutations: " + this.numPerms));
        node.add(new DefaultMutableTreeNode("Gene set: " + (this.geneSetOrigin == 0 ? "local file" : (this.geneSetOrigin == 1 ? "MSigDB" : "GeneSigDB"))));
        node.add(new DefaultMutableTreeNode("Annotation Type: " + this.annotChosen));
        for (int i = 0; i < this.geneSetFilePath.length; ++i) {
            node.add(new DefaultMutableTreeNode("File location: " + this.geneSetFilePath[i]));
        }
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time - 1L) + " ms"));
        root.add(node);
    }

    protected DefaultMutableTreeNode getGroupAssignmentInfo() {
        int i;
        DefaultMutableTreeNode groupAssignmentInfo = new DefaultMutableTreeNode("Group assignments ");
        DefaultMutableTreeNode notInGroups = new DefaultMutableTreeNode("Not in groups");
        DefaultMutableTreeNode[] groups = new DefaultMutableTreeNode[this.numGroups];
        for (i = 0; i < this.numGroups; ++i) {
            groups[i] = new DefaultMutableTreeNode("Group " + (i + 1));
        }
        for (i = 0; i < this.groupAssignments.length; ++i) {
            int currentGroup = this.groupAssignments[i];
            if (currentGroup == 0) {
                notInGroups.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
                continue;
            }
            groups[currentGroup - 1].add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
        }
        for (i = 0; i < groups.length; ++i) {
            groupAssignmentInfo.add(groups[i]);
        }
        if (notInGroups.getChildCount() > 0) {
            groupAssignmentInfo.add(notInGroups);
        }
        return groupAssignmentInfo;
    }

    private int sysMsg(String rVer, String module) {
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        String ver = System.getProperty("os.version");
        String message = "System Config:\n";
        message = message + "OS: " + os + " | Architecture: " + arch + " | Version: " + ver + "\n";
        message = message + "Please note:\n";
        if (arch.toLowerCase().contains("64") && os.toLowerCase().contains("mac")) {
            message = message + "You need to have 32Bit JVM as default for " + module + "\n";
            message = message + "Please contact MeV Support if you need help.\n";
            message = message + "You also need to have" + rVer + " installed for " + module + "\n";
            message = message + "Cancel if either is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        if (arch.toLowerCase().contains("64")) {
            message = message + "You need to have 32Bit JVM as default for " + module + "\n";
            message = message + "Please contact MeV Support if you need help.\n";
            message = message + "Cancel if 32 Bit JVM is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        if (os.toLowerCase().contains("mac")) {
            message = message + "You need to have" + rVer + " installed for " + module + "\n";
            message = message + "Cancel if R is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        return 0;
    }

    protected class GeneralInfo {
        public int clusters;
        public String correctionMethod;
        public float alpha;
        public long time;
        public String function;
        protected boolean hcl;
        protected boolean usePerms;
        protected int hcl_method;
        protected int numPerms;
        protected boolean hcl_genes;
        protected boolean hcl_samples;

        protected GeneralInfo() {
        }
    }

    protected class Listener
    extends DialogListener
    implements AlgorithmListener {
        protected Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    GLOBANCGUI.this.progress.setUnits(event.getIntValue());
                    GLOBANCGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    GLOBANCGUI.this.progress.setValue(event.getIntValue());
                    GLOBANCGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    int value = event.getIntValue();
                    if (value != -1) break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                GLOBANCGUI.this.algorithm.abort();
                GLOBANCGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            GLOBANCGUI.this.algorithm.abort();
            GLOBANCGUI.this.progress.dispose();
        }
    }
}

