/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.globanc;

import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;

public class GLOBANCCentroidViewer
extends CentroidViewer {
    private Vector rawPValues;
    private Vector adjPValues;
    private Vector fValues;
    private Vector dfNumValues;
    private Vector dfDenomValues;
    private Vector ssGroups;
    private Vector ssError;
    private float[][] geneGroupMeans;
    private float[][] geneGroupSDs;

    public GLOBANCCentroidViewer(Experiment experiment, int[][] clusters, float[][] geneGroupMeans, float[][] geneGroupSDs, Vector rawPValues, Vector adjPValues, Vector fValues, Vector ssGroups, Vector ssError, Vector dfNumValues, Vector dfDenomValues) {
        super(experiment, clusters);
    }

    public GLOBANCCentroidViewer(Experiment e, int[][] clusters, float[][] variances, float[][] means, float[][] codes, float[][] geneGroupMeans, float[][] geneGroupSDs, Vector rawPValues, Vector adjPValues, Vector fValues, Vector ssGroups, Vector ssError, Vector dfNumValues, Vector dfDenomValues) {
        super(e, clusters, variances, means, codes);
    }

    public GLOBANCCentroidViewer(Experiment e, ClusterWrapper clusters) {
        super(e, clusters.getClusters());
    }

    protected void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getClusters());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    protected void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getCluster());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData data, int[] rows) throws Exception {
        File file = GLOBANCCentroidViewer.getFile(frame);
        if (file != null) {
            this.saveCluster(file, experiment, data, rows);
        }
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData data, int[][] clusters) throws Exception {
        File file = GLOBANCCentroidViewer.getFile(frame);
        if (file != null) {
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i] == null || clusters[i].length == 0) continue;
                File aFile = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                this.saveCluster(aFile, experiment, data, clusters[i]);
            }
        }
    }

    private void saveCluster(File file, Experiment experiment, IData data, int[] rows) throws Exception {
        int i;
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getFieldNames();
        out.print("Original row");
        out.print("\t");
        for (i = 0; i < fieldNames.length; ++i) {
            out.print(fieldNames[i]);
            out.print("\t");
        }
        for (i = 0; i < this.geneGroupMeans[0].length; ++i) {
            out.print("Group" + (i + 1) + " mean\t");
            out.print("Group" + (i + 1) + " std.dev.\t");
        }
        out.print("F ratio");
        out.print("\t");
        out.print("SS(Groups)\t");
        out.print("SS(Error)\t");
        out.print("df (Groups)\t");
        out.print("df (Error)\t");
        out.print(" raw p value\t");
        out.print("adj p.value");
        for (i = 0; i < experiment.getNumberOfSamples(); ++i) {
            out.print("\t");
            out.print(data.getFullSampleName(experiment.getSampleIndex(i)));
        }
        out.print("\n");
        for (i = 0; i < rows.length; ++i) {
            int j;
            out.print(Integer.toString(experiment.getGeneIndexMappedToData(rows[i]) + 1));
            out.print("\t");
            for (int k = 0; k < fieldNames.length; ++k) {
                out.print(data.getElementAttribute(experiment.getGeneIndexMappedToData(rows[i]), k));
                out.print("\t");
            }
            for (j = 0; j < this.geneGroupMeans[i].length; ++j) {
                out.print(this.geneGroupMeans[rows[i]][j] + "\t");
                out.print(this.geneGroupSDs[rows[i]][j] + "\t");
            }
            out.print("" + ((Float)this.fValues.get(rows[i])).floatValue());
            out.print("\t");
            out.print("" + ((Float)this.ssGroups.get(rows[i])).floatValue());
            out.print("\t");
            out.print("" + ((Float)this.ssError.get(rows[i])).floatValue());
            out.print("\t");
            out.print("" + ((Float)this.dfNumValues.get(rows[i])).floatValue());
            out.print("\t");
            out.print("" + ((Float)this.dfDenomValues.get(rows[i])).floatValue());
            out.print("\t");
            out.print("" + ((Float)this.rawPValues.get(rows[i])).floatValue());
            out.print("\t");
            out.print("" + ((Float)this.adjPValues.get(rows[i])).floatValue());
            for (j = 0; j < experiment.getNumberOfSamples(); ++j) {
                out.print("\t");
                out.print(Float.toString(experiment.get(rows[i], j)));
            }
            out.print("\n");
        }
        out.flush();
        out.close();
    }

    private static File getFile(Frame frame) {
        File file = null;
        JFileChooser fc = new JFileChooser(TMEV.getDataPath());
        fc.addChoosableFileFilter((FileFilter)new ExpressionFileFilter());
        fc.setFileView((FileView)new ExpressionFileView());
        int ret = fc.showSaveDialog(frame);
        if (ret == 0) {
            file = fc.getSelectedFile();
        }
        return file;
    }
}

