/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.QSort;

public class GDMResultSelectionDialog
extends AlgorithmDialog {
    private int result;
    private JList resultList;

    public GDMResultSelectionDialog(JFrame frame, Enumeration nameEnum) {
        super(frame, "GDM Result Selection Dialog", true);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        ParameterPanel parameters = new ParameterPanel();
        parameters.setLayout(new GridBagLayout());
        Vector v = this.sortAndLoadResultVector(nameEnum);
        this.resultList = new JList(v);
        this.resultList.setVisibleRowCount(3);
        this.resultList.setSelectedIndex(0);
        JScrollPane pane = new JScrollPane(this.resultList);
        JLabel label = new JLabel("Select Cluster Result: ");
        label.setVerticalAlignment(1);
        parameters.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 30, 10), 0, 0));
        parameters.add((Component)pane, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 30, 50), 0, 0));
        this.addContent(parameters);
        this.setActionListeners(listener);
        this.pack();
    }

    public void resetControls() {
        this.resultList.setSelectedIndex(0);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public String getSelectedResult() {
        return (String)this.resultList.getSelectedValue();
    }

    public static void main(String[] args) {
        Vector<String> nameVector = new Vector<String>();
        nameVector.add("KMC - genes (6)");
        nameVector.add("TTEST");
        nameVector.add("SOTA Test");
        nameVector.add("SOTA - genes (1)");
        nameVector.add("QTC - genes (2)");
        GDMResultSelectionDialog dialog = new GDMResultSelectionDialog(new JFrame(), nameVector.elements());
        dialog.setDefaultCloseOperation(2);
        dialog.showModal();
        System.out.println("Selected result: " + dialog.getSelectedResult());
    }

    private Vector sortAndLoadResultVector(Enumeration _enum) {
        Vector results = new Vector();
        while (_enum.hasMoreElements()) {
            results.add(_enum.nextElement());
        }
        String[] names = new String[results.size()];
        float[] order = new float[results.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)results.elementAt(i);
            int index = names[i].indexOf("(");
            if (index != -1) {
                try {
                    order[i] = Integer.parseInt(names[i].substring(index + 1, names[i].indexOf(")")));
                }
                catch (NumberFormatException nfe) {
                    order[i] = 1000 + i;
                }
                continue;
            }
            order[i] = 1000 + i;
        }
        QSort sorter = new QSort(order);
        int[] origOrder = sorter.getOrigIndx();
        results = new Vector();
        for (int i = 0; i < origOrder.length; ++i) {
            results.add(names[origOrder[i]]);
        }
        return results;
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                GDMResultSelectionDialog.this.result = 0;
                GDMResultSelectionDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                GDMResultSelectionDialog.this.result = 2;
                GDMResultSelectionDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                GDMResultSelectionDialog.this.resetControls();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(GDMResultSelectionDialog.this, "GDM Result Selection Dialog");
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            GDMResultSelectionDialog.this.result = -1;
            GDMResultSelectionDialog.this.dispose();
        }
    }
}

