/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class GDMMemberSelectionDialog
extends AlgorithmDialog {
    JTextField kField;
    JCheckBox allBox;
    JPanel selectPanel;
    JLabel label1;
    JLabel label2;
    JLabel label3;
    int k;
    int result = 2;

    public GDMMemberSelectionDialog(JFrame parent, int num_elements) {
        super(parent, "Select number of neighbors", true);
        this.k = num_elements;
        Listener listener = new Listener();
        this.allBox = new JCheckBox("Save all neighbors", true);
        this.allBox.setBackground(Color.white);
        this.allBox.setFocusPainted(false);
        this.allBox.setActionCommand("save-all-command");
        this.allBox.setHorizontalAlignment(0);
        this.allBox.addActionListener(listener);
        this.kField = new JTextField("20", 6);
        this.kField.setEnabled(false);
        this.label1 = new JLabel("Save the nearest ");
        this.label1.setEnabled(false);
        this.label2 = new JLabel(" neighbors");
        this.label2.setEnabled(false);
        this.label3 = new JLabel("( There are " + num_elements + " elements in the matrix. )");
        this.label3.setEnabled(false);
        this.selectPanel = new JPanel(new GridBagLayout());
        this.selectPanel.setBackground(Color.white);
        this.selectPanel.add((Component)this.label1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.selectPanel.add((Component)this.kField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.selectPanel.add((Component)this.label2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.selectPanel.add((Component)this.label3, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        JPanel parameters = new JPanel(new GridBagLayout());
        parameters.setBackground(Color.white);
        parameters.setBorder(BorderFactory.createLineBorder(Color.black));
        parameters.add((Component)this.allBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 15, 0), 0, 0));
        parameters.add((Component)this.selectPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.addContent(parameters);
        this.setActionListeners(listener);
        this.pack();
    }

    private void resetControls() {
        this.label1.setEnabled(false);
        this.label2.setEnabled(false);
        this.label3.setEnabled(false);
        this.kField.setText("20");
        this.allBox.setSelected(true);
    }

    private void setControls(boolean setting) {
        this.label1.setEnabled(setting);
        this.label2.setEnabled(setting);
        this.label3.setEnabled(setting);
        this.kField.setEnabled(setting);
    }

    public int getK() {
        if (this.allBox.isSelected()) {
            return this.k;
        }
        return Integer.parseInt(this.kField.getText());
    }

    private boolean validateInput() {
        try {
            int n = Integer.parseInt(this.kField.getText());
            if (n < 0) {
                JOptionPane.showMessageDialog(this, "Input must be > 0", "Input Warning", 2);
                return false;
            }
            if (n > this.k) {
                JOptionPane.showMessageDialog(this, "Input must be <= the number of matrix elements (" + this.k + ")", "Input Warning", 2);
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, "Invalid number format.", "Input Warning", 2);
            return false;
        }
        return true;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public static void main(String[] args) {
        GDMMemberSelectionDialog d = new GDMMemberSelectionDialog(new JFrame(), 1080);
        d.showModal();
        System.out.println("save " + d.getK() + " neighbors");
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            String command = evt.getActionCommand();
            if (command.equals("ok-command")) {
                if (!GDMMemberSelectionDialog.this.allBox.isSelected()) {
                    if (!GDMMemberSelectionDialog.this.validateInput()) return;
                    GDMMemberSelectionDialog.this.result = 0;
                } else {
                    GDMMemberSelectionDialog.this.result = 0;
                }
            } else if (command.equals("cancel-command")) {
                GDMMemberSelectionDialog.this.result = 2;
                GDMMemberSelectionDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    GDMMemberSelectionDialog.this.resetControls();
                    GDMMemberSelectionDialog.this.result = 2;
                    return;
                }
                if (!command.equals("info-command") && command.equals("save-all-command")) {
                    GDMMemberSelectionDialog.this.setControls(!GDMMemberSelectionDialog.this.allBox.isSelected());
                    return;
                }
            }
            GDMMemberSelectionDialog.this.dispose();
        }
    }
}

