/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class GDMInitDialog
extends AlgorithmDialog {
    private int result;
    private JRadioButton genRadio;
    private JRadioButton expRadio;
    private JTextField textField;
    private JLabel displayLabel;

    public GDMInitDialog(Frame parent, boolean useGenes) {
        super(parent, "Gene Distance Matrix Initialization", true);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        ParameterPanel parameters = new ParameterPanel();
        parameters.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.genRadio = new JRadioButton("Genes");
        this.genRadio.setBackground(Color.white);
        this.genRadio.setFocusPainted(false);
        gbc.gridx = 0;
        gbc.gridy = 4;
        parameters.add((Component)this.genRadio, gbc);
        this.expRadio = new JRadioButton("Samples");
        this.expRadio.setBackground(Color.white);
        this.expRadio.setFocusPainted(false);
        gbc.gridx = 1;
        gbc.gridy = 4;
        parameters.add((Component)this.expRadio, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.genRadio);
        bg.add(this.expRadio);
        this.genRadio.setActionCommand("gene-radio-command");
        this.genRadio.addActionListener(listener);
        this.expRadio.setActionCommand("gene-radio-command");
        this.expRadio.addActionListener(listener);
        this.genRadio.setEnabled(useGenes);
        this.genRadio.setSelected(useGenes);
        this.expRadio.setEnabled(!useGenes);
        this.expRadio.setSelected(!useGenes);
        gbc.gridx = 0;
        gbc.gridy = 10;
        this.displayLabel = new JLabel("  Display Interval  ");
        parameters.add((Component)this.displayLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 10;
        this.textField = new JTextField(String.valueOf(1), 7);
        parameters.add((Component)this.textField, gbc);
        this.addContent(parameters);
        this.setActionListeners(listener);
        this.pack();
    }

    public GDMInitDialog(Frame parent) {
        super(parent, "Gene Distance Matrix Initialization", true);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        ParameterPanel parameters = new ParameterPanel();
        parameters.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.genRadio = new JRadioButton("Genes");
        this.genRadio.setBackground(Color.white);
        this.genRadio.setFocusPainted(false);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.insets = new Insets(0, 0, 25, 20);
        parameters.add((Component)this.genRadio, gbc);
        this.expRadio = new JRadioButton("Samples");
        this.expRadio.setBackground(Color.white);
        this.expRadio.setFocusPainted(false);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.insets = new Insets(0, 20, 25, 0);
        parameters.add((Component)this.expRadio, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.genRadio);
        bg.add(this.expRadio);
        this.genRadio.setSelected(true);
        this.genRadio.setActionCommand("gene-radio-command");
        this.genRadio.addActionListener(listener);
        this.expRadio.setActionCommand("gene-radio-command");
        this.expRadio.addActionListener(listener);
        gbc.gridx = 0;
        gbc.gridy = 10;
        this.displayLabel = new JLabel("  Display Interval  ");
        parameters.add((Component)this.displayLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 10;
        this.textField = new JTextField(String.valueOf(1), 7);
        parameters.add((Component)this.textField, gbc);
        this.addContent(parameters);
        this.setActionListeners(listener);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public boolean isUseGenes() {
        return this.genRadio.isSelected();
    }

    public void setGeneSelected(boolean selected) {
        this.genRadio.setSelected(selected);
    }

    public void setExpSelected(boolean selected) {
        this.expRadio.setSelected(selected);
    }

    public int getDisplayInterval() {
        return Integer.parseInt(this.textField.getText());
    }

    public static void main(String[] args) {
        GDMInitDialog dialog = new GDMInitDialog(new Frame());
        dialog.setDefaultCloseOperation(2);
        dialog.showModal();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("gene-radio-command")) {
                GDMInitDialog.this.displayLabel.setEnabled(GDMInitDialog.this.genRadio.isSelected());
                GDMInitDialog.this.textField.setEnabled(GDMInitDialog.this.genRadio.isSelected());
            } else if (command.equals("ok-command")) {
                try {
                    Integer.parseInt(GDMInitDialog.this.textField.getText());
                    GDMInitDialog.this.result = 0;
                }
                catch (Exception exception) {
                    GDMInitDialog.this.result = 2;
                }
                GDMInitDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                GDMInitDialog.this.result = 2;
                GDMInitDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                if (GDMInitDialog.this.genRadio.isEnabled() && GDMInitDialog.this.expRadio.isEnabled()) {
                    GDMInitDialog.this.genRadio.setSelected(true);
                }
                GDMInitDialog.this.textField.setText("1");
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(GDMInitDialog.this, "GDM Initialization Dialog");
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            GDMInitDialog.this.result = -1;
            GDMInitDialog.this.dispose();
        }
    }
}

