/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMAnnotationSizeDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMBorderColorDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMColorScaleDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMColorSelectionDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMElementSizeDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMGeneHeader;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMGeneSpotInfoDisplay;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMMemberSelectionDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMResultSelectionDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMScaleListener;
import org.tigr.microarray.util.SlideDataSorter;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class GDMGeneViewer
extends JPanel
implements IViewer {
    private JPanel content;
    private GDMGeneHeader geneColumnHeaderSP;
    private GDMGeneHeader geneRowHeaderSP;
    private JScrollBar upperRightCornerSB;
    private JScrollBar lowerLeftCornerSB;
    private FloatMatrix geneDistMatrix;
    private FloatMatrix rawMatrix;
    private IData expData;
    private String[] fieldNames;
    private IFramework framework;
    private JFrame mainframe;
    private static final int TRACE_SPACE = 50;
    private static final int MAX_MATRIX_WIDTH = 400;
    private static final int MAX_COL_WIDTH = 400;
    private static final int MAX_COL_HEIGHT = 500;
    private static final int MAX_ROW_WIDTH = 500;
    private static final int MAX_ROW_HEIGHT = 400;
    private static final int NOT_UPDATE_ANNOTATION_SIZE = -1;
    private int num_genes;
    private int maxGeneNameLength;
    private int probes;
    private int featuresCount;
    private int[] indices;
    private int label;
    private int[] clusterlength;
    private Insets insets;
    private int elementWidth;
    private int paletteStyle;
    private int labelIndex = -1;
    private int maxLabelWidth = 0;
    private boolean isGRScale;
    private boolean isDrawBorders;
    private boolean isDrawClusterBorders = true;
    private boolean isAntiAliasing = true;
    private boolean isTracing = false;
    private int tracespace;
    private int xWidth;
    private int xHeight;
    private Dimension elementSize = new Dimension(10, 10);
    private boolean sortByGeneProximity = true;
    private boolean imposeClusterOrder = false;
    public static Color zeroColor = Color.black;
    public static Color NaNColor = Color.gray;
    public static Color diagColor = Color.white;
    private float maxValue;
    private float minValue;
    private float origMaxValue;
    private float origMinValue;
    private int colorScheme = 5;
    private BufferedImage negGreenColorImage = this.createGradientImage(Color.green, Color.black);
    private BufferedImage posRedColorImage = this.createGradientImage(Color.black, Color.red);
    private BufferedImage negBlueColorImage = this.createGradientImage(Color.blue, Color.black);
    private BufferedImage posYellowColorImage = this.createGradientImage(Color.black, Color.yellow);
    private BufferedImage negCustomColorImage;
    private BufferedImage posCustomColorImage;
    private BufferedImage posColorImage = this.posRedColorImage;
    private BufferedImage negColorImage = this.negGreenColorImage;
    private Color borderColor;
    private Color clusterBorderColor;
    private String distanceMetric;
    private JPopupMenu popup;
    private JCheckBoxMenuItem drawClusterBorderItem;
    private JMenu sortMenu;
    private int displayEvery = 1;
    private Experiment experiment;
    private int[][] clusters;
    private int numOfClusters;
    private Listener listener;
    private HashMap actions = new HashMap();
    private static final String PARAMETER = "command-parameter";
    private static final String BORDER_COLOR_CMD = "select-border-color-cmd";
    private static final String COLOR_SCALE_CMD = "set-color-scale-cmd";
    private static final String GREEN_RED_COLOR_SCHEME_CMD = "display-green-red-scheme-cmd";
    private static final String BLUE_YELLOW_COLOR_SCHEME_CMD = "display-blue-yellow-scheme-cmd";
    private static final String NO_LABEL = "No Label";
    private static final String LABEL_BY = "Label by ";
    private static final String DISPLAY_LABEL_ACTION = "display--label-action";
    private static final String DISPLAY_LABEL_CMD = "display-label-cmd";
    private static final String CUSTOM_COLOR_SCHEME_CMD = "display-custom-color-scheme-cmd";
    private static final String DISPLAY_DRAW_BORDERS_CMD = "display-draw-borders-cmd";
    private static final String DISPLAY_2X2_CMD = "display-2x2-cmd";
    private static final String DISPLAY_5X5_CMD = "display-5x5-cmd";
    private static final String DISPLAY_10X10_CMD = "display-10x10-cmd";
    private static final String DISPLAY_15X15_CMD = "display-15x15-cmd";
    private static final String DISPLAY_OTHER_CMD = "display-other-cmd";
    private static final String SET_CLUSTER_BORDER_CMD = "set-cluster-border-cmd";
    private static final String SORT_BY = "Sort by ";
    private static final String SORT_BY_CLUSTER_ORDER_CMD = "sort-by-cluster-order-cmd";
    private static final String SORT_BY_LOCATION_CMD = "sort-by-location-cmd";
    private static final String SORT_BY_RATIO_CMD = "sort-by-ratio-cmd";
    private static final String SORT_LABEL_ACTION = "sort-label-action";
    private static final String SORT_LABEL_CMD = "sort-label-cmd";
    public static final String SORT_BY_GENE_PROXIMITY_CMD = "sort-by-gene-proximity-cmd";
    private static final String ANNOTATION_WIDTH_ACTION = "annotation-width-action";
    private static final String ANNOTATION_WIDTH_CMD = "annotation-width-cmd";
    private static final String CHANGE_ANNOTATION_WIDTH = "Change Annotation Width";
    private static final String TOGGLE_PROXIMITY_SORT_CMD = "Toggle-proximity-cmd";
    private static final String SAVE_NEIGHBORS_CMD = "Save-neighbors-cmd";
    private static final String SAVE_MATRIX_CMD = "save-matrix";

    public GDMGeneViewer(IFramework fmwk, AlgorithmData aData, String distMetric, int displayEvery, int[][] clusters, int numOfClusters) {
        this.setBackground(Color.white);
        this.framework = fmwk;
        this.distanceMetric = distMetric;
        IDisplayMenu menu = this.framework.getDisplayMenu();
        this.setElementWidth(this.elementSize.width);
        this.expData = fmwk.getData();
        this.fieldNames = this.expData.getFieldNames();
        this.experiment = this.expData.getExperiment();
        this.probes = this.expData.getFeaturesSize();
        this.featuresCount = this.expData.getFeaturesCount();
        this.geneDistMatrix = aData.getMatrix("gdMatrix");
        this.rawMatrix = aData.getMatrix("rawMatrix");
        AlgorithmParameters params = aData.getParams();
        this.minValue = params.getFloat("minDist");
        this.origMaxValue = this.maxValue;
        this.origMinValue = this.minValue;
        this.displayEvery = displayEvery;
        this.clusters = clusters;
        this.numOfClusters = numOfClusters;
        this.maxValue = params.getFloat("maxDist");
        this.maxGeneNameLength = params.getInt("maxGeneNameLength");
        this.num_genes = this.geneDistMatrix.getRowDimension() / displayEvery;
        this.borderColor = Color.black;
        this.clusterBorderColor = Color.white;
        this.insets = new Insets(1, 1, 1, 1);
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        if (this.displayEvery == 1) {
            this.setIndices(this.createIndices());
        } else if (this.displayEvery > 1) {
            this.setIndices(this.createIndices(this.displayEvery));
        }
        this.listener = new Listener();
        this.addMouseMotionListener(this.listener);
        this.addKeyListener(this.listener);
        this.initLabelActions(this.expData.getFieldNames());
        this.initSortActions(this.expData.getFieldNames());
        this.initAnnotationWidthActions();
        this.geneColumnHeaderSP = this.createHeader(50, true, this.xWidth, 500, this.elementSize, this.experiment);
        this.geneColumnHeaderSP.setBorder(BorderFactory.createLineBorder(Color.white));
        this.geneRowHeaderSP = this.createHeader(50, false, 500, this.xHeight, this.elementSize, this.experiment);
        this.content = this.createContent(400, 400, this.listener);
        this.geneColumnHeaderSP.setMatrixListener(this.listener);
        this.geneRowHeaderSP.setMatrixListener(this.listener);
        this.upperRightCornerSB = this.createScrollBar(1);
        this.lowerLeftCornerSB = this.createScrollBar(0);
        this.setMaxWidth(this.content, this.geneColumnHeaderSP);
        this.setMaxHeight(this.content, this.geneRowHeaderSP);
        this.geneColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.geneRowHeaderSP.setPosColorImages(this.posColorImage);
        this.geneColumnHeaderSP.setIndices(this.indices);
        this.geneRowHeaderSP.setIndices(this.indices);
        this.add(this.content);
        this.popup = this.createJPopupMenu(this.listener);
        this.getContentComponent().addMouseListener(this.listener);
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    public GDMGeneViewer() {
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, this.geneDistMatrix, this.rawMatrix, new Integer(this.probes), new Integer(this.featuresCount), new Float(this.minValue), this.distanceMetric, new Float(this.origMaxValue), new Float(this.origMinValue), new Float(this.maxValue), new Integer(this.maxGeneNameLength), this.fieldNames, new Integer(this.displayEvery), this.clusters, new Integer(this.numOfClusters)});
    }

    public GDMGeneViewer(Experiment e, FloatMatrix geneDistMatrix, FloatMatrix rawMatrix, Integer probes, Integer featuresCount, Float minValue, String distMetric, Float origMaxValue, Float origMinValue, Float maxValue, Integer maxGeneNameLength, String[] fieldNames, Integer displayEvery, int[][] clusters, Integer numOfClusters) {
        this.setBackground(Color.white);
        this.distanceMetric = distMetric;
        this.setElementWidth(this.elementSize.width);
        this.fieldNames = fieldNames;
        this.probes = probes;
        this.featuresCount = featuresCount;
        this.geneDistMatrix = geneDistMatrix;
        this.rawMatrix = rawMatrix;
        this.minValue = minValue.floatValue();
        this.origMaxValue = origMaxValue.floatValue();
        this.origMinValue = origMinValue.floatValue();
        this.displayEvery = displayEvery;
        this.clusters = clusters;
        this.numOfClusters = numOfClusters;
        this.maxValue = maxValue.floatValue();
        this.maxGeneNameLength = maxGeneNameLength;
        this.num_genes = geneDistMatrix.getRowDimension() / displayEvery;
        this.borderColor = Color.black;
        this.clusterBorderColor = Color.white;
        this.insets = new Insets(1, 1, 1, 1);
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        if (this.displayEvery == 1) {
            this.setIndices(this.createIndices());
        } else if (this.displayEvery > 1) {
            this.setIndices(this.createIndices(this.displayEvery));
        }
        this.experiment = e;
        this.listener = new Listener();
        this.addMouseMotionListener(this.listener);
        this.addKeyListener(this.listener);
        this.geneColumnHeaderSP = this.createHeader(50, true, this.xWidth, 500, this.elementSize, this.experiment);
        this.geneColumnHeaderSP.setBorder(BorderFactory.createLineBorder(Color.white));
        this.geneRowHeaderSP = this.createHeader(50, false, 500, this.xHeight, this.elementSize, this.experiment);
        this.content = this.createContent(400, 400, this.listener);
        this.geneColumnHeaderSP.setMatrixListener(this.listener);
        this.geneRowHeaderSP.setMatrixListener(this.listener);
        this.upperRightCornerSB = this.createScrollBar(1);
        this.lowerLeftCornerSB = this.createScrollBar(0);
        this.setMaxWidth(this.content, this.geneColumnHeaderSP);
        this.setMaxHeight(this.content, this.geneRowHeaderSP);
        this.geneColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.geneRowHeaderSP.setPosColorImages(this.posColorImage);
        this.geneColumnHeaderSP.setIndices(this.indices);
        this.geneRowHeaderSP.setIndices(this.indices);
        this.add(this.content);
        this.popup = this.createJPopupMenu(this.listener);
        this.getContentComponent().addMouseListener(this.listener);
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    public void setExperiment(Experiment e) {
        this.experiment = e;
    }

    private void initLabelActions(String[] labels) {
        DefaultAction action = new DefaultAction(NO_LABEL, DISPLAY_LABEL_CMD);
        action.putValue(PARAMETER, String.valueOf(-1));
        this.actions.put(DISPLAY_LABEL_ACTION + String.valueOf(-1), action);
        for (int i = 0; i < labels.length; ++i) {
            action = new DefaultAction(LABEL_BY + labels[i], DISPLAY_LABEL_CMD);
            action.putValue(PARAMETER, String.valueOf(i));
            this.actions.put(DISPLAY_LABEL_ACTION + String.valueOf(i), action);
        }
    }

    private void initSortActions(String[] labels) {
        for (int i = 0; i < labels.length; ++i) {
            DefaultAction action = new DefaultAction(SORT_BY + labels[i], SORT_LABEL_CMD);
            action.putValue(PARAMETER, String.valueOf(i));
            this.actions.put(SORT_LABEL_ACTION + String.valueOf(i), action);
        }
    }

    private void initAnnotationWidthActions() {
        DefaultAction action = new DefaultAction(CHANGE_ANNOTATION_WIDTH, ANNOTATION_WIDTH_CMD);
        action.putValue(PARAMETER, String.valueOf(-1));
        this.actions.put(ANNOTATION_WIDTH_ACTION + String.valueOf(-1), action);
    }

    public Action getAction(String name) {
        return (Action)this.actions.get(name);
    }

    public void setMainFrame(JFrame mframe) {
        this.mainframe = mframe;
    }

    private void setIndices(int[] indexes) {
        this.indices = indexes;
    }

    private int[] getIndices() {
        return this.indices;
    }

    private int[] createIndices(int displayEvery) {
        int indicesSize = this.num_genes;
        int[] indices = new int[indicesSize];
        int i = 0;
        int total = 0;
        int index = 0;
        for (index = 0; index < this.probes; ++index) {
            if (total % this.displayEvery == 0 && i < indicesSize) {
                indices[i] = index;
                ++i;
            }
            ++total;
        }
        total = 0;
        if (this.numOfClusters > 0) {
            this.clusterlength = new int[this.numOfClusters];
            i = 0;
            for (int j = 0; j < this.numOfClusters; ++j) {
                for (int k = 0; k < this.clusters[j].length; ++k) {
                    if (total % this.displayEvery == 0 && i < indicesSize) {
                        indices[i] = this.clusters[j][k];
                        ++i;
                        int n = j;
                        this.clusterlength[n] = this.clusterlength[n] + 1;
                    }
                    ++total;
                }
            }
        }
        return indices;
    }

    private int[] createIndices() {
        int i;
        int[] indices = new int[this.num_genes];
        for (i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        if (this.numOfClusters > 0) {
            this.clusterlength = new int[this.num_genes];
            i = 0;
            for (int j = 0; j < this.numOfClusters; ++j) {
                for (int k = 0; k < this.clusters[j].length; ++k) {
                    indices[i] = this.clusters[j][k];
                    int n = j;
                    this.clusterlength[n] = this.clusterlength[n] + 1;
                    ++i;
                }
            }
        }
        return indices;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    private void setMaxHeight(JComponent content, JComponent header) {
        int c_height = content.getPreferredSize().height;
        int h_height = header.getPreferredSize().height;
        if (c_height > h_height) {
            header.setPreferredSize(new Dimension(header.getPreferredSize().width, c_height));
        } else {
            content.setPreferredSize(new Dimension(content.getPreferredSize().width, h_height));
        }
    }

    public BufferedImage getPosColorImage() {
        return this.posColorImage;
    }

    public BufferedImage getNegColorImage() {
        return this.negColorImage;
    }

    public void setPosColorImage(BufferedImage image) {
        this.posColorImage = image;
    }

    public void setNegColorImage(BufferedImage image) {
        this.negColorImage = image;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    private GDMGeneHeader createHeader(int tracespace, boolean colHdr, int width, int height, Dimension eSize, Experiment experiment) {
        GDMGeneHeader hdr = new GDMGeneHeader(this.insets, tracespace, colHdr, experiment, width, height, eSize, this.maxGeneNameLength, this.num_genes, this.getIndices());
        return hdr;
    }

    private JPanel createContent(int width, int height, Listener listener) {
        JPanel cPanel = new JPanel(new BorderLayout());
        cPanel.setBackground(Color.white);
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        cPanel.setSize(this.xWidth + 5, this.xHeight + 5);
        cPanel.setPreferredSize(new Dimension(this.xWidth + 5, this.xHeight + 5));
        cPanel.setOpaque(true);
        cPanel.setVisible(true);
        return cPanel;
    }

    private JScrollBar createScrollBar(int orientation) {
        JScrollBar jsb = new JScrollBar(orientation);
        if (orientation == 1) {
            jsb.setModel(this.geneColumnHeaderSP.getVerticalScrollBar().getModel());
        } else {
            jsb.setModel(this.geneRowHeaderSP.getHorizontalScrollBar().getModel());
        }
        return jsb;
    }

    private int getTopIndex(int top) {
        if (top < 0) {
            return 0;
        }
        return (top - this.insets.top) / this.elementSize.height;
    }

    private int getLeftIndex(int left) {
        if (left < 0) {
            return 0;
        }
        return (left - this.insets.left) / (this.elementSize.width + this.getSpacing());
    }

    private int getRightIndex(int right, int limit) {
        if (right < 0) {
            return 0;
        }
        int result = (right - this.insets.left) / (this.elementSize.width + this.getSpacing()) + 1;
        return result > limit ? limit : result;
    }

    private int getBottomIndex(int bottom, int limit) {
        if (bottom < 0) {
            return 0;
        }
        int result = (bottom - this.insets.top) / this.elementSize.height + 1;
        return result > limit ? limit : result;
    }

    @Override
    public void paint(Graphics g1D) {
        super.paint(g1D);
        if (this.num_genes == 0 || this.framework == null) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g1D;
        if (this.isAntiAliasing) {
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.drawColumns(g2D);
        if (this.isDrawClusterBorders && this.numOfClusters > 0) {
            this.drawClusterBorder(g2D);
        }
        this.drawPerimeter(g2D);
    }

    private void drawClusterBorder(Graphics2D g2d) {
        int xPosition = this.insets.left;
        int yPosition = this.insets.top;
        int width = 0;
        int height = 0;
        Graphics2D g = g2d;
        g.setColor(this.clusterBorderColor);
        for (int i = 0; i < this.numOfClusters; ++i) {
            height = this.clusterlength[i] * (this.elementSize.height + this.getSpacing());
            xPosition = this.insets.left;
            for (int j = 0; j < this.numOfClusters; ++j) {
                width = this.clusterlength[j] * (this.elementSize.width + this.getSpacing());
                g.drawRect(xPosition, yPosition, width, height);
                xPosition += width;
            }
            yPosition += height;
        }
    }

    private void drawColumns(Graphics2D g) {
        Rectangle bounds = g.getClipBounds();
        int top = this.getTopIndex(bounds.y);
        int left = this.getLeftIndex(bounds.x);
        int bottom = 0;
        int right = 0;
        bottom = this.getBottomIndex(bounds.y + bounds.height, this.num_genes);
        right = this.getRightIndex(bounds.x + bounds.width, this.num_genes);
        for (int column = left; column < right; ++column) {
            this.drawColumn(g, column, top, bottom);
        }
    }

    private void drawPerimeter(Graphics2D g) {
        Color color = g.getColor();
        g.setColor(Color.black);
        if (this.isDrawClusterBorders && this.numOfClusters > 0) {
            g.drawRect(0, 0, this.getXSize() - this.insets.right + 1, this.getYSize() - this.insets.bottom + 1);
        } else {
            g.drawRect(0, 0, this.getXSize() - this.insets.right, this.getYSize() - this.insets.bottom);
        }
        g.setColor(color);
    }

    private void drawColumn(Graphics2D g, int column, int top, int bottom) {
        for (int row = top; row < bottom; ++row) {
            this.drawSlideDataElement(g, row, column);
        }
    }

    private void drawSlideDataElement(Graphics g, int row, int column) {
        float distance = this.geneDistMatrix.get(this.indices[row], this.indices[column]);
        Color holdColor = Float.isNaN(distance) ? NaNColor : (distance == 0.0f && row == column ? diagColor : (distance == 0.0f && row != column ? zeroColor : this.getColor(distance)));
        g.setColor(holdColor);
        g.fillRect(this.getXPos(column), this.getYPos(row), this.elementSize.width, this.elementSize.height);
        if (this.isDrawBorders && this.elementSize.width > 2) {
            g.setColor(this.borderColor);
            g.drawRect(this.getXPos(column), this.getYPos(row), this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    private BufferedImage createGradientImage(Color color1, Color color2) {
        BufferedImage image = new BufferedImage(256, 1, 5);
        Graphics2D graphics = image.createGraphics();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, 255.0f, 0.0f, color2);
        graphics.setPaint(gp);
        graphics.drawRect(0, 0, 255, 1);
        return image;
    }

    private Color getColor(float value) {
        if (Float.isNaN(value) || this.posColorImage == null || this.negColorImage == null) {
            return NaNColor;
        }
        int colorIndex = (int)(255.0f * (value - this.minValue) / this.maxValue);
        if (colorIndex > 255) {
            colorIndex = 255;
        }
        if (colorIndex < 0) {
            colorIndex = 0;
        }
        int rgb = value < 0.0f ? this.negColorImage.getRGB(255 - colorIndex, 0) : this.posColorImage.getRGB(colorIndex, 0);
        return new Color(rgb);
    }

    private void setFontSize(int width) {
        if (width > 12) {
            width = 12;
        }
        this.setFont(new Font("monspaced", 0, width));
    }

    public void setElementWidth(int width) {
        this.elementWidth = width;
        this.setFontSize(width);
    }

    public int getElementWidth() {
        return this.elementWidth;
    }

    void setTracing(boolean isTracing) {
        this.isTracing = isTracing;
    }

    private int getSpacing() {
        if (this.isTracing) {
            return this.tracespace;
        }
        return 0;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return this.geneColumnHeaderSP;
    }

    public JComponent getColumnHeaderComponent() {
        return this.geneColumnHeaderSP;
    }

    public JComponent getRowHeaderComponent() {
        return this.geneRowHeaderSP;
    }

    public JComponent getUpperRightCornerSB() {
        return this.upperRightCornerSB;
    }

    public JComponent getLowerLeftCornerSB() {
        return this.lowerLeftCornerSB;
    }

    private int getXSize() {
        int size = 0;
        size = this.num_genes * this.elementSize.width + (this.num_genes - 1) * this.getSpacing() + this.insets.left + this.insets.right;
        return size;
    }

    private int getYSize() {
        int size = 0;
        size = this.num_genes * this.elementSize.height + ((this.num_genes - 1) * this.getSpacing() + this.insets.top + this.insets.bottom);
        return size;
    }

    private int getMaxGeneNameLength() {
        return this.maxGeneNameLength;
    }

    private void updateSize(int annotationSize) {
        int width = this.getXSize();
        int height = this.getYSize();
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
        this.geneColumnHeaderSP.setNumGenes(this.num_genes);
        this.geneColumnHeaderSP.updateSize(annotationSize);
        this.geneRowHeaderSP.setNumGenes(this.num_genes);
        this.geneRowHeaderSP.updateSize(annotationSize);
        this.setMaxWidth(this.content, this.geneColumnHeaderSP);
        this.setMaxHeight(this.content, this.geneRowHeaderSP);
        this.geneColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.geneRowHeaderSP.setPosColorImages(this.posColorImage);
        this.repaint();
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.expData = framework.getData();
        this.onDataChanged(this.expData);
        this.probes = this.expData.getFeaturesSize();
        this.featuresCount = this.expData.getFeaturesCount();
        this.num_genes = this.geneDistMatrix.getRowDimension() / this.displayEvery;
        IDisplayMenu menu = framework.getDisplayMenu();
        this.setFontSize(this.elementSize.width);
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        this.geneColumnHeaderSP.setData(this.expData);
        this.geneColumnHeaderSP.setContentWidth(this.xWidth + 10);
        this.geneColumnHeaderSP.setElementWidth(this.elementSize.width);
        this.geneRowHeaderSP.setData(this.expData);
        this.geneRowHeaderSP.setContentHeight(this.xHeight + 10);
        this.geneRowHeaderSP.setElementHeight(this.elementSize.height);
        this.geneColumnHeaderSP.repaint();
        this.geneRowHeaderSP.repaint();
        this.onMenuChanged(menu);
        this.onDataChanged(this.expData);
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.probes = this.expData.getFeaturesSize();
        this.featuresCount = this.expData.getFeaturesCount();
        this.num_genes = this.geneDistMatrix.getRowDimension() / this.displayEvery;
        this.paletteStyle = menu.getPaletteStyle();
        this.isGRScale = menu.isGRScale();
        if (menu.isTracing() == this.isTracing && this.labelIndex == menu.getLabelIndex() && this.isAntiAliasing == menu.isAntiAliasing()) {
            return;
        }
        this.isAntiAliasing = menu.isAntiAliasing();
        this.geneColumnHeaderSP.setAntiAliasing(this.isAntiAliasing);
        this.geneRowHeaderSP.setAntiAliasing(this.isAntiAliasing);
        this.labelIndex = menu.getLabelIndex();
        this.isTracing = menu.isTracing();
        this.setFont(new Font("monospaced", 1, this.elementSize.height));
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        this.geneColumnHeaderSP.setContentWidth(this.xWidth);
        this.geneColumnHeaderSP.setElementWidth(this.elementSize.width);
        this.geneColumnHeaderSP.setTracing(this.isTracing);
        this.geneRowHeaderSP.setContentHeight(this.xHeight);
        this.geneRowHeaderSP.setElementHeight(this.elementSize.height);
        this.geneRowHeaderSP.setTracing(this.isTracing);
        this.geneColumnHeaderSP.repaint();
        this.geneRowHeaderSP.repaint();
        this.updateSize(-1);
    }

    public void onDataChanged(IData data) {
        this.expData = data;
        this.probes = this.expData.getFeaturesSize();
        this.featuresCount = this.expData.getFeaturesCount();
        this.num_genes = this.geneDistMatrix.getRowDimension() / this.displayEvery;
        this.geneColumnHeaderSP.setData(data);
        this.geneRowHeaderSP.setData(data);
        this.updateSize(-1);
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public BufferedImage getImage() {
        return null;
    }

    private boolean isLegalPosition(int row, int column) {
        return this.isLegalRow(row) && this.isLegalColumn(column);
    }

    private boolean isLegalColumn(int column) {
        return column >= 0 && column <= this.num_genes - 1;
    }

    private boolean isLegalRow(int row) {
        return row >= 0 && row <= this.num_genes - 1;
    }

    private int findColumn(int targetx) {
        int columnSize = this.elementSize.width + this.getSpacing();
        if (targetx > this.num_genes * columnSize - this.getSpacing() + this.insets.left || targetx < this.insets.left) {
            return -1;
        }
        return targetx / columnSize;
    }

    private int findRow(int targety) {
        int rowSize = this.num_genes * this.elementSize.height;
        if (targety > rowSize + this.insets.top || targety < this.insets.top) {
            return -1;
        }
        return targety / this.elementSize.height;
    }

    private int getXPos(int column) {
        return column * (this.elementSize.width + this.getSpacing()) + this.insets.left;
    }

    private int getYPos(int row) {
        return row * this.elementSize.height + this.insets.top;
    }

    private void drawColoredBoxAt(Graphics g, int row, int column, Color color) {
        g.setColor(color);
        g.drawRect(this.insets.left + column * (this.elementSize.width + this.getSpacing()), this.insets.top + row * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height - 1);
    }

    public void displayGDMSpotInfo(int colIndex, int rowIndex, int column, int row) {
        new GDMGeneSpotInfoDisplay(this.mainframe, this.experiment, this.expData, this.geneDistMatrix, this.rawMatrix, this.distanceMetric, colIndex, rowIndex, column, row);
    }

    private JCheckBoxMenuItem createJCheckBoxMenuItem(String name, String command, Listener listener, boolean isSelected) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(name);
        item.setActionCommand(command);
        item.addActionListener(listener);
        item.setSelected(isSelected);
        return item;
    }

    private JCheckBoxMenuItem createJCheckBoxMenuItem(String name, String command, Listener listener) {
        return this.createJCheckBoxMenuItem(name, command, listener, false);
    }

    private JRadioButtonMenuItem createJRadioButtonMenuItem(String name, String command, Listener listener, ButtonGroup buttonGroup, boolean isSelected) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(name);
        item.setActionCommand(command);
        item.addActionListener(listener);
        item.setSelected(isSelected);
        if (buttonGroup != null) {
            buttonGroup.add(item);
        }
        return item;
    }

    private JRadioButtonMenuItem createJRadioButtonMenuItem(String name, String command, Listener listener, ButtonGroup buttonGroup) {
        return this.createJRadioButtonMenuItem(name, command, listener, buttonGroup, false);
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    private void addMenuItems(JPopupMenu menu, Listener listener) {
        JMenu colorSchemeMenu = new JMenu("Color Scheme");
        ButtonGroup buttonGroup = new ButtonGroup();
        colorSchemeMenu.add(this.createJRadioButtonMenuItem("Black/Red Scheme", GREEN_RED_COLOR_SCHEME_CMD, listener, buttonGroup, true));
        colorSchemeMenu.add(this.createJRadioButtonMenuItem("Black/Yellow Scheme", BLUE_YELLOW_COLOR_SCHEME_CMD, listener, buttonGroup));
        colorSchemeMenu.add(this.createJRadioButtonMenuItem("Custom Color Scheme", CUSTOM_COLOR_SCHEME_CMD, listener, buttonGroup));
        menu.add(colorSchemeMenu);
        menu.addSeparator();
        JMenu sizeMenu = new JMenu("Element Size");
        buttonGroup = new ButtonGroup();
        sizeMenu.add(this.createJRadioButtonMenuItem("2 x 2", DISPLAY_2X2_CMD, listener, buttonGroup));
        sizeMenu.add(this.createJRadioButtonMenuItem("5 x 5", DISPLAY_5X5_CMD, listener, buttonGroup));
        sizeMenu.add(this.createJRadioButtonMenuItem("10 x 10", DISPLAY_10X10_CMD, listener, buttonGroup, true));
        sizeMenu.add(this.createJRadioButtonMenuItem("15 x 15", DISPLAY_15X15_CMD, listener, buttonGroup));
        sizeMenu.add(this.createJRadioButtonMenuItem("Other", DISPLAY_OTHER_CMD, listener, buttonGroup));
        menu.add(sizeMenu);
        menu.addSeparator();
        menu.add(this.createJCheckBoxMenuItem("Draw Borders", DISPLAY_DRAW_BORDERS_CMD, listener));
        if (this.numOfClusters > 0) {
            this.drawClusterBorderItem = this.createJCheckBoxMenuItem("Draw Cluster Borders", SET_CLUSTER_BORDER_CMD, listener, true);
            menu.add(this.drawClusterBorderItem);
        }
        menu.addSeparator();
        JMenuItem item = new JMenuItem("Select Border Color");
        item.setActionCommand(BORDER_COLOR_CMD);
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Set Color Scale");
        item.setActionCommand(COLOR_SCALE_CMD);
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Toggle Sort on Proximity");
        item.setActionCommand(TOGGLE_PROXIMITY_SORT_CMD);
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Save k Neighbors");
        item.setActionCommand(SAVE_NEIGHBORS_CMD);
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Save Distance Matrix");
        item.setActionCommand(SAVE_MATRIX_CMD);
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        this.sortMenu = new JMenu("Sort");
        buttonGroup = new ButtonGroup();
        if (this.numOfClusters > 0) {
            this.sortMenu.add(this.createJRadioButtonMenuItem("Sort by Location", SORT_BY_LOCATION_CMD, listener, buttonGroup, false));
        } else {
            this.sortMenu.add(this.createJRadioButtonMenuItem("Sort by Location", SORT_BY_LOCATION_CMD, listener, buttonGroup, false));
        }
        this.addSortMenuItems(this.sortMenu, buttonGroup);
        if (this.numOfClusters > 0) {
            this.addSortClusterMenuItems(this.sortMenu, buttonGroup, listener);
        }
        menu.add(this.sortMenu);
        menu.addSeparator();
        item = new JMenuItem("Impose Cluster Result");
        item.setActionCommand("impose-cluster-order");
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        JMenu annotationMenu = new JMenu("Change Annotation");
        buttonGroup = new ButtonGroup();
        this.addLabelMenuItems(annotationMenu, buttonGroup);
        menu.add(annotationMenu);
        menu.addSeparator();
        item = new JMenuItem("Change annotation Width");
        item.setActionCommand(ANNOTATION_WIDTH_CMD);
        item.addActionListener(listener);
        menu.add(item);
    }

    private void addLabelMenuItems(JMenu menu, ButtonGroup buttonGroup) {
        Action action;
        int index = -1;
        while ((action = this.getAction(DISPLAY_LABEL_ACTION + String.valueOf(index))) != null) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            buttonGroup.add(item);
            if (index < 1) {
                item.setSelected(true);
                String indexStr = (String)action.getValue(PARAMETER);
                this.label = Integer.parseInt(indexStr);
            }
            menu.add(item);
            ++index;
        }
    }

    private void addSortMenuItems(JMenu menu, ButtonGroup buttonGroup) {
        Action action;
        int index = 0;
        while ((action = this.getAction(SORT_LABEL_ACTION + String.valueOf(index))) != null) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            buttonGroup.add(item);
            menu.add(item);
            ++index;
        }
    }

    private void addSortClusterMenuItems(JMenu menu, ButtonGroup buttonGroup, Listener listener) {
        menu.add(this.createJRadioButtonMenuItem("Sort by Cluster Number", SORT_BY_CLUSTER_ORDER_CMD, listener, buttonGroup, true));
    }

    private void onElementSizeChanged(int width, int height) {
        this.elementSize = new Dimension(width, height);
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        this.geneColumnHeaderSP.setContentWidth(this.xWidth);
        this.geneColumnHeaderSP.setElementWidth(this.elementSize.width);
        this.geneColumnHeaderSP.setElementHeight(this.elementSize.height);
        this.geneRowHeaderSP.setContentHeight(this.xHeight);
        this.geneRowHeaderSP.setElementWidth(this.elementSize.width);
        this.geneRowHeaderSP.setElementHeight(this.elementSize.height);
        this.geneColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.geneRowHeaderSP.setPosColorImages(this.posColorImage);
        this.updateSize(-1);
        this.validate();
    }

    private void onElementSizeChanged() {
        GDMElementSizeDialog dialog = new GDMElementSizeDialog(this.mainframe, this.elementSize);
        if (dialog.showModal() == 0) {
            Dimension size = dialog.getElementSize();
            this.onElementSizeChanged(size.width, size.height);
        }
    }

    private void onDrawBordersChanged(boolean state) {
        this.isDrawBorders = state;
        this.geneColumnHeaderSP.repaint();
        this.repaint();
    }

    private void onDrawClusterBorderChange(boolean state) {
        if (this.numOfClusters > 0) {
            this.isDrawClusterBorders = state;
            this.geneColumnHeaderSP.repaint();
            this.repaint();
        }
    }

    private void onColorSchemeChange(int scheme) {
        if (this.colorScheme == scheme && scheme != 7) {
            return;
        }
        if (scheme == 5) {
            this.setPosColorImage(this.posRedColorImage);
            this.colorScheme = scheme;
        } else if (scheme == 6) {
            this.setPosColorImage(this.posYellowColorImage);
            this.colorScheme = scheme;
        } else {
            GDMColorSelectionDialog dialog = new GDMColorSelectionDialog((Frame)this.mainframe, true, this.getPosColorImage());
            if (dialog.showModal() != 0) {
                return;
            }
            this.setPosColorImage(dialog.getPositiveGradient());
            this.colorScheme = scheme;
        }
        this.geneColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.geneRowHeaderSP.setPosColorImages(this.posColorImage);
        this.geneColumnHeaderSP.repaint();
        this.geneRowHeaderSP.repaint();
        this.repaint();
    }

    private void onBorderColorChanged() {
        GDMBorderColorDialog dialog = new GDMBorderColorDialog((Frame)this.mainframe, true, this.borderColor);
        if (dialog.showModal() != 0) {
            return;
        }
        this.setBorderColor(dialog.getBorderColor());
        this.geneColumnHeaderSP.repaint();
        this.geneRowHeaderSP.repaint();
        this.repaint();
    }

    private void onColorScaleChanged() {
        BufferedImage grad = this.getPosColorImage();
        Color lowerColor = new Color(grad.getRGB(0, 0));
        Color upperColor = new Color(grad.getRGB(grad.getWidth() - 1, 0));
        GDMColorScaleDialog dialog = new GDMColorScaleDialog(this.mainframe, this.minValue, this.maxValue, this.geneDistMatrix, this.num_genes, lowerColor, upperColor);
        dialog.setGDMScaleListener(new ScaleListener());
        int res = dialog.showModal();
        this.minValue = dialog.getLowerLimit();
        this.maxValue = dialog.getUpperLimit();
        this.geneColumnHeaderSP.setValues(this.minValue, this.maxValue);
        this.geneRowHeaderSP.setValues(this.minValue, this.maxValue);
        this.geneColumnHeaderSP.updateSize(-1);
        this.geneRowHeaderSP.updateSize(-1);
        this.revalidate();
    }

    private void onSortByClusterChange() {
        if (this.numOfClusters > 0) {
            this.isDrawClusterBorders = true;
            if (this.displayEvery == 1) {
                this.setIndices(this.createIndices());
            } else if (this.displayEvery > 1) {
                this.setIndices(this.createIndices(this.displayEvery));
            }
            this.geneColumnHeaderSP.setIndices(this.indices);
            this.geneRowHeaderSP.setIndices(this.indices);
            this.onDataChanged(this.expData);
        }
    }

    private void toggleSortByGeneProximity() {
        this.sortByGeneProximity = !this.sortByGeneProximity;
        this.geneColumnHeaderSP.setSortByGeneProximity(this.sortByGeneProximity);
        this.geneRowHeaderSP.setSortByGeneProximity(this.sortByGeneProximity);
    }

    private void onSortByGeneProximity(int baseIndex) {
        this.isDrawClusterBorders = false;
        QSort qsort = new QSort(this.geneDistMatrix.A[baseIndex]);
        int[] sortedIndices = qsort.getOrigIndx();
        if (sortedIndices[0] != baseIndex) {
            boolean notFound = true;
            for (int i = 0; i < sortedIndices.length && notFound; ++i) {
                if (sortedIndices[i] != baseIndex) continue;
                sortedIndices[i] = sortedIndices[0];
                sortedIndices[0] = baseIndex;
                notFound = false;
            }
        }
        this.setIndices(sortedIndices);
        this.geneColumnHeaderSP.setIndices(sortedIndices);
        this.geneRowHeaderSP.setIndices(sortedIndices);
        this.onDataChanged(this.expData);
        this.validate();
        this.geneColumnHeaderSP.repaint();
        this.geneRowHeaderSP.repaint();
    }

    private void clearSortSelection() {
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < this.sortMenu.getMenuComponentCount(); ++i) {
            ((JRadioButtonMenuItem)this.sortMenu.getMenuComponent(i)).setSelected(false);
            group.add((JRadioButtonMenuItem)this.sortMenu.getMenuComponent(i));
        }
    }

    private void onSort(Action action) {
        String index = (String)action.getValue(PARAMETER);
        this.isDrawClusterBorders = false;
        this.onSort(Integer.parseInt(index));
    }

    private void onSort(int style) {
        this.setIndices(this.createIndices(this.displayEvery));
        this.isDrawClusterBorders = false;
        if (this.drawClusterBorderItem != null) {
            this.drawClusterBorderItem.setState(false);
        }
        this.sortIndices(style);
        this.onDataChanged(this.expData);
    }

    private void sortIndices(int style) {
        SlideDataSorter sorter = new SlideDataSorter();
        sorter.setSlideData(this.expData.getFeature(0));
        int[] indexes = this.getIndices();
        sorter.sort(indexes, style);
        this.setIndices(indexes);
        this.geneColumnHeaderSP.setIndices(indexes);
        this.geneRowHeaderSP.setIndices(indexes);
        this.geneColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.geneRowHeaderSP.setPosColorImages(this.posColorImage);
    }

    private void onLabelChanged(Action action) {
        String index = (String)action.getValue(PARAMETER);
        this.setLabelIndex(Integer.parseInt(index));
        this.geneColumnHeaderSP.setLabelIndex(this.label);
        this.geneRowHeaderSP.setLabelIndex(this.label);
        this.onDataChanged(this.expData);
        this.geneColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.geneRowHeaderSP.setPosColorImages(this.posColorImage);
        this.geneColumnHeaderSP.updateSize(-1);
        this.geneRowHeaderSP.updateSize(-1);
        this.geneColumnHeaderSP.repaint();
        this.geneRowHeaderSP.repaint();
        this.updateSize(-1);
        this.repaint();
    }

    private void onAnnotationWidthChanged() {
        GDMAnnotationSizeDialog dialog = new GDMAnnotationSizeDialog(this.mainframe);
        if (dialog.showModal() == 0) {
            int annotationSize = dialog.getAnnotationSize();
            this.geneColumnHeaderSP.setAnnotationSize(annotationSize);
            this.geneRowHeaderSP.setAnnotationSize(annotationSize);
            this.geneColumnHeaderSP.setSize(this.geneColumnHeaderSP.getWidth(), annotationSize);
            this.geneColumnHeaderSP.setPreferredSize(new Dimension(this.geneColumnHeaderSP.getWidth(), annotationSize));
            this.geneRowHeaderSP.setSize(annotationSize, this.geneRowHeaderSP.getHeight());
            this.geneRowHeaderSP.setPreferredSize(new Dimension(annotationSize, this.geneRowHeaderSP.getHeight()));
            this.geneColumnHeaderSP.repaint();
            this.geneRowHeaderSP.repaint();
            this.updateSize(annotationSize);
            this.repaint();
        }
    }

    private void setLabelIndex(int style) {
        this.label = style;
    }

    private void onSaveNeighbors() {
        GDMMemberSelectionDialog dialog = new GDMMemberSelectionDialog(new JFrame(), this.num_genes);
        if (dialog.showModal() == 0) {
            int k = dialog.getK();
            if (k <= 0) {
                return;
            }
            if (k > this.num_genes) {
                k = this.num_genes;
            }
            int[] rows = this.getRows(k);
            Object[][] auxData = this.getAuxilaryData(this.num_genes);
            String[] auxHeaders = new String[]{"Scaled Dist.", "Actual Dist.", "Value Pairs"};
            try {
                ExperimentUtil.saveGeneClusterWithAux((Frame)this.framework.getFrame(), (Experiment)this.experiment, (IData)this.expData, (int[])rows, (String[])auxHeaders, (Object[][])auxData);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.framework.getFrame(), "Error saving file: " + e.getMessage(), "Output Error", 2);
            }
        }
    }

    private void onSaveMatrix() {
        JFileChooser chooser = new JFileChooser(TMEV.getDataPath());
        if (chooser.showSaveDialog(this) == 0) {
            try {
                PrintWriter bw = new PrintWriter(new FileWriter(chooser.getSelectedFile()));
                int rows = this.geneDistMatrix.getRowDimension();
                int cols = this.geneDistMatrix.getColumnDimension();
                Date da = new Date(System.currentTimeMillis());
                bw.println("# Save Date: " + da.toString());
                bw.println("# Distance Metric: " + this.distanceMetric);
                bw.println("#");
                String line = "\t";
                for (int i = 0; i < cols; ++i) {
                    line = line + this.framework.getData().getElementAttribute(this.experiment.getGeneIndexMappedToData(this.indices[i]), this.labelIndex);
                    if (i >= cols - 1) continue;
                    line = line + "\t";
                }
                bw.println(line);
                line = "";
                for (int row = 0; row < rows; ++row) {
                    line = line + this.framework.getData().getElementAttribute(this.indices[row], this.labelIndex) + "\t";
                    for (int col = 0; col < cols; ++col) {
                        line = line + Float.toString(this.rawMatrix.get(this.indices[row], this.indices[col]));
                        if (col >= cols - 1) continue;
                        line = line + "\t";
                    }
                    bw.println(line);
                    line = "";
                }
                bw.flush();
                bw.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private int[] getIDataRows(int k) {
        int[] rows = new int[k];
        for (int i = 0; i < k; ++i) {
            rows[i] = this.experiment.getGeneIndexMappedToData(this.indices[i]);
        }
        return rows;
    }

    private int[] getRows(int k) {
        int[] rows = new int[k];
        for (int i = 0; i < k; ++i) {
            rows[i] = this.indices[i];
        }
        return rows;
    }

    private String[][] getAuxilaryData(int k) {
        String[][] data = new String[k][3];
        FloatMatrix matrix = this.experiment.getMatrix();
        for (int i = 0; i < k; ++i) {
            data[i][0] = Float.toString(this.geneDistMatrix.get(this.indices[0], i));
            data[i][1] = Float.toString(this.rawMatrix.get(this.indices[0], i));
            data[i][2] = this.getValuePairCount(matrix, this.indices[0], i);
        }
        return data;
    }

    private String getValuePairCount(FloatMatrix matrix, int row, int col) {
        int cols = matrix.getColumnDimension();
        int count = 0;
        for (int i = 0; i < cols; ++i) {
            if (Float.isNaN(matrix.get(row, i)) || Float.isNaN(matrix.get(col, i))) continue;
            ++count;
        }
        return Integer.toString(count);
    }

    private void imposeClusterOrder() {
        Hashtable results = this.getResultHash();
        boolean noUseableResult = false;
        Hashtable<String, Object> goodResults = new Hashtable<String, Object>();
        Enumeration keys = results.keys();
        String key = "";
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            Object[] result = (Object[])results.get(key);
            if (key.indexOf("HCL") != -1) {
                int[][] clusters = new int[][]{((int[][])result[1])[0]};
                if (clusters[0] == null || this.experiment != result[0] || !this.checkClustersSize(clusters)) continue;
                goodResults.put(key, clusters);
                continue;
            }
            if (this.experiment != result[0] || !this.checkClustersSize((int[][])result[1])) continue;
            goodResults.put(key, result[1]);
        }
        if (goodResults.size() > 0) {
            GDMResultSelectionDialog dialog = new GDMResultSelectionDialog((JFrame)this.framework.getFrame(), goodResults.keys());
            if (dialog.showModal() == 0) {
                int[][] clusters = (int[][])goodResults.get(dialog.getSelectedResult());
                this.imposeClusterOrder(clusters);
            }
        } else {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "There are currently no appropriate clustering results to apply to this GDM.", "No Results Available", 1);
        }
    }

    private boolean checkClustersSize(int[][] clusters) {
        int cnt = 0;
        for (int i = 0; i < clusters.length; ++i) {
            cnt += clusters[i].length;
        }
        return cnt / this.displayEvery == this.num_genes;
    }

    public Hashtable getResultHash() {
        Hashtable<String, Object[]> table = new Hashtable<String, Object[]>();
        DefaultMutableTreeNode analysisNode = this.framework.getResultTree().getAnalysisNode();
        boolean stop = false;
        int childCount = analysisNode.getChildCount();
        String algName = "";
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode analysisRoot = (DefaultMutableTreeNode)analysisNode.getChildAt(i);
            Object object = analysisRoot.getUserObject();
            if (object == null) continue;
            if (object instanceof LeafInfo) {
                algName = ((LeafInfo)object).toString();
            } else if (object instanceof String) {
                algName = (String)object;
            }
            Enumeration<TreeNode> _enum = analysisRoot.depthFirstEnumeration();
            while (!stop && _enum.hasMoreElements()) {
                IViewer viewer;
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)_enum.nextElement();
                if (!(currentNode.getUserObject() instanceof LeafInfo) || (viewer = ((LeafInfo)currentNode.getUserObject()).getViewer()) == null) continue;
                Experiment exp = viewer.getExperiment();
                int[][] clusters = viewer.getClusters();
                if (exp == null || clusters == null) continue;
                Object[] vals = new Object[]{exp, clusters};
                table.put(algName, vals);
                stop = true;
            }
            stop = false;
        }
        return table;
    }

    private void imposeClusterOrder(int[][] newClusters) {
        this.clusters = newClusters;
        this.numOfClusters = this.clusters.length;
        this.onSortByClusterChange();
    }

    protected boolean areProbesColored() {
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.expData.getProbeColor(this.indices[i]) == null) continue;
            return true;
        }
        return false;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        if (cornerIndex == 1) {
            return this.upperRightCornerSB;
        }
        if (cornerIndex == 2) {
            return this.lowerLeftCornerSB;
        }
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public int getViewerType() {
        return 0;
    }

    public int getExperimentID() {
        return 0;
    }

    public void setExperimentID(int id) {
    }

    private class DefaultAction
    extends AbstractAction {
        public DefaultAction(String name, String command) {
            this(name, command, null);
        }

        public DefaultAction(String name, String command, ImageIcon smallIcon) {
            this.putValue("Name", name);
            this.putValue("ShortDescription", name);
            this.putValue("ActionCommandKey", command);
            this.putValue("SmallIcon", smallIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDMGeneViewer.this.listener.actionPerformed(new ActionEvent(this, e.getID(), (String)this.getValue("ActionCommandKey")));
        }
    }

    private class ScaleListener
    extends GDMScaleListener {
        private ScaleListener() {
        }

        @Override
        public void scaleChanged(float lower, float upper) {
            GDMGeneViewer.this.minValue = lower;
            GDMGeneViewer.this.maxValue = upper;
            GDMGeneViewer.this.geneColumnHeaderSP.setValues(GDMGeneViewer.this.minValue, GDMGeneViewer.this.maxValue);
            GDMGeneViewer.this.geneRowHeaderSP.setValues(GDMGeneViewer.this.minValue, GDMGeneViewer.this.maxValue);
            GDMGeneViewer.this.geneColumnHeaderSP.updateSize(-1);
            GDMGeneViewer.this.geneRowHeaderSP.updateSize(-1);
            GDMGeneViewer.this.geneColumnHeaderSP.validate();
            GDMGeneViewer.this.geneRowHeaderSP.validate();
            GDMGeneViewer.this.validate();
            GDMGeneViewer.this.geneColumnHeaderSP.repaint();
            GDMGeneViewer.this.geneRowHeaderSP.repaint();
            GDMGeneViewer.this.repaint();
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener,
    KeyListener,
    WindowListener {
        private int oldRow = -1;
        private int oldColumn = -1;
        private String oldStatusText;

        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals(GDMGeneViewer.DISPLAY_LABEL_CMD)) {
                GDMGeneViewer.this.onLabelChanged((Action)event.getSource());
            } else if (command.equals(GDMGeneViewer.ANNOTATION_WIDTH_CMD)) {
                GDMGeneViewer.this.onAnnotationWidthChanged();
            } else if (command.equals(GDMGeneViewer.DISPLAY_2X2_CMD)) {
                GDMGeneViewer.this.onElementSizeChanged(2, 2);
            } else if (command.equals(GDMGeneViewer.DISPLAY_5X5_CMD)) {
                GDMGeneViewer.this.onElementSizeChanged(5, 5);
            } else if (command.equals(GDMGeneViewer.DISPLAY_10X10_CMD)) {
                GDMGeneViewer.this.onElementSizeChanged(10, 10);
            } else if (command.equals(GDMGeneViewer.DISPLAY_15X15_CMD)) {
                GDMGeneViewer.this.onElementSizeChanged(15, 15);
            } else if (command.equals(GDMGeneViewer.DISPLAY_OTHER_CMD)) {
                GDMGeneViewer.this.onElementSizeChanged();
            } else if (command.equals(GDMGeneViewer.GREEN_RED_COLOR_SCHEME_CMD)) {
                GDMGeneViewer.this.onColorSchemeChange(5);
            } else if (command.equals(GDMGeneViewer.BLUE_YELLOW_COLOR_SCHEME_CMD)) {
                GDMGeneViewer.this.onColorSchemeChange(6);
            } else if (command.equals(GDMGeneViewer.CUSTOM_COLOR_SCHEME_CMD)) {
                GDMGeneViewer.this.onColorSchemeChange(7);
            } else if (command.equals(GDMGeneViewer.DISPLAY_DRAW_BORDERS_CMD)) {
                GDMGeneViewer.this.onDrawBordersChanged(((JCheckBoxMenuItem)event.getSource()).isSelected());
            } else if (command.equals(GDMGeneViewer.BORDER_COLOR_CMD)) {
                GDMGeneViewer.this.onBorderColorChanged();
            } else if (command.equals(GDMGeneViewer.COLOR_SCALE_CMD)) {
                GDMGeneViewer.this.onColorScaleChanged();
            } else if (command.equals(GDMGeneViewer.SORT_BY_LOCATION_CMD)) {
                GDMGeneViewer.this.onSort(9000);
            } else if (command.equals(GDMGeneViewer.SORT_BY_RATIO_CMD)) {
                GDMGeneViewer.this.onSort(9001);
            } else if (command.equals(GDMGeneViewer.SORT_LABEL_CMD)) {
                GDMGeneViewer.this.onSort((Action)event.getSource());
            } else if (command.equals(GDMGeneViewer.SORT_BY_CLUSTER_ORDER_CMD)) {
                GDMGeneViewer.this.onSortByClusterChange();
            } else if (command.equals(GDMGeneViewer.SORT_BY_GENE_PROXIMITY_CMD)) {
                GDMGeneViewer.this.onSortByGeneProximity(event.getID());
            } else if (command.equals(GDMGeneViewer.TOGGLE_PROXIMITY_SORT_CMD)) {
                GDMGeneViewer.this.toggleSortByGeneProximity();
            } else if (command.equals(GDMGeneViewer.SET_CLUSTER_BORDER_CMD)) {
                GDMGeneViewer.this.onDrawClusterBorderChange(((JCheckBoxMenuItem)event.getSource()).isSelected());
            } else if (command.equals(GDMGeneViewer.SAVE_NEIGHBORS_CMD)) {
                GDMGeneViewer.this.onSaveNeighbors();
            } else if (command.equals("impose-cluster-order")) {
                GDMGeneViewer.this.imposeClusterOrder();
            } else if (command.equals(GDMGeneViewer.SAVE_MATRIX_CMD)) {
                GDMGeneViewer.this.onSaveMatrix();
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            GDMGeneViewer.this.requestFocus();
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (SwingUtilities.isLeftMouseButton(event)) {
                int column = GDMGeneViewer.this.findColumn(event.getX());
                int row = GDMGeneViewer.this.findRow(event.getY());
                if (!GDMGeneViewer.this.isLegalPosition(row, column)) {
                    return;
                }
                GDMGeneViewer.this.displayGDMSpotInfo(GDMGeneViewer.this.indices[column], GDMGeneViewer.this.indices[row], column, row);
            } else {
                int column = GDMGeneViewer.this.findColumn(event.getX());
                int row = GDMGeneViewer.this.findRow(event.getY());
                GDMGeneViewer.this.popup.show(event.getComponent(), event.getX(), event.getY());
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (GDMGeneViewer.this.num_genes == 0 || event.isShiftDown()) {
                return;
            }
            int column = GDMGeneViewer.this.findColumn(event.getX());
            int row = GDMGeneViewer.this.findRow(event.getY());
            if (this.isCurrentPosition(row, column)) {
                return;
            }
            Graphics g = null;
            Graphics2D g2D = (Graphics2D)g;
            if (GDMGeneViewer.this.isLegalPosition(row, column)) {
                g = GDMGeneViewer.this.getGraphics();
                GDMGeneViewer.this.drawColoredBoxAt(g, row, column, Color.white);
                GDMGeneViewer.this.framework.setStatusText(" Column: " + (column + 1) + "     " + " Row: " + (row + 1) + "     " + " Scaled Distance: " + GDMGeneViewer.this.geneDistMatrix.get(GDMGeneViewer.this.indices[column], GDMGeneViewer.this.indices[row]) + "     " + " Actual Distance: " + GDMGeneViewer.this.rawMatrix.get(GDMGeneViewer.this.indices[column], GDMGeneViewer.this.indices[row]));
            } else {
                GDMGeneViewer.this.framework.setStatusText(this.oldStatusText);
            }
            if (GDMGeneViewer.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                g2D = g != null ? (Graphics2D)g : (Graphics2D)GDMGeneViewer.this.getGraphics();
                GDMGeneViewer.this.drawSlideDataElement(g2D, this.oldRow, this.oldColumn);
            }
            this.setOldPosition(row, column);
            if (g != null) {
                if (GDMGeneViewer.this.isDrawClusterBorders && GDMGeneViewer.this.numOfClusters > 0) {
                    GDMGeneViewer.this.drawClusterBorder((Graphics2D)g);
                }
            } else if (g2D != null && GDMGeneViewer.this.isDrawClusterBorders && GDMGeneViewer.this.numOfClusters > 0) {
                GDMGeneViewer.this.drawClusterBorder(g2D);
            }
            if (g != null) {
                g.dispose();
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (GDMGeneViewer.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                Graphics g = GDMGeneViewer.this.getGraphics();
                Graphics2D g2D = (Graphics2D)g;
                GDMGeneViewer.this.drawSlideDataElement(g2D, this.oldRow, this.oldColumn);
                g2D.dispose();
                if (GDMGeneViewer.this.isDrawClusterBorders && GDMGeneViewer.this.numOfClusters > 0) {
                    GDMGeneViewer.this.drawClusterBorder(g2D);
                }
            }
            this.setOldPosition(-1, -1);
            GDMGeneViewer.this.framework.setStatusText("  ");
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            this.oldStatusText = GDMGeneViewer.this.framework.getStatusText();
        }

        private void setOldPosition(int row, int column) {
            this.oldColumn = column;
            this.oldRow = row;
        }

        private boolean isCurrentPosition(int row, int column) {
            return row == this.oldRow && column == this.oldColumn;
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }
}

