/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.graph.GraphViewer;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.FloatMatrix;
import org.tigr.util.awt.ActionInfoDialog;
import org.tigr.util.awt.GBA;

public class GDMGeneSpotInfoDisplay
extends ActionInfoDialog {
    private int colIndex;
    private int rowIndex;
    private int colNumber;
    private int rowNumber;
    private FloatMatrix geneDistMatrix;
    private FloatMatrix rawMatrix;
    private int LINEAR = 0;
    private int LOG = 1;
    private String distanceMetric;
    private int vectorSize = 0;
    private int rowMissingValues = 0;
    private int colMissingValues = 0;
    private int distanceBasedOn = 0;
    private IData expData;
    private Experiment experiment;
    private Color rowGeneColor;
    private Color columnGeneColor;
    public static Color zeroColor = Color.black;
    public static Color NaNColor = Color.gray;
    public static Color diagColor = Color.white;
    private boolean haveColor = true;
    FloatMatrix data;

    public GDMGeneSpotInfoDisplay(JFrame parent, Experiment experiment, IData expData, FloatMatrix gdMatrix, FloatMatrix rawMatrix, String distMetric, int colIndex, int rowIndex, int column, int row) {
        super(parent, false);
        this.expData = expData;
        this.experiment = experiment;
        this.data = this.experiment.getMatrix();
        this.geneDistMatrix = gdMatrix;
        this.rawMatrix = rawMatrix;
        this.colIndex = colIndex;
        this.rowIndex = rowIndex;
        this.colNumber = column;
        this.rowNumber = row;
        this.distanceMetric = distMetric;
        this.vectorSize = this.expData.getFeaturesCount();
        this.rowGeneColor = expData.getProbeColor(experiment.getGeneIndexMappedToData(rowIndex));
        this.columnGeneColor = expData.getProbeColor(experiment.getGeneIndexMappedToData(colIndex));
        if (this.rowGeneColor == null && this.columnGeneColor == null) {
            this.haveColor = false;
        } else {
            if (this.rowGeneColor == null) {
                this.rowGeneColor = new Color(Integer.parseInt("FFFFCC", 16));
            }
            if (this.columnGeneColor == null) {
                this.columnGeneColor = new Color(Integer.parseInt("FFFFCC", 16));
            }
        }
        this.setValues(colIndex, rowIndex);
        this.init();
    }

    private void init() {
        Font infoDisplayFont = new Font("monospaced", 0, 10);
        JLabel spotImage = new JLabel(GUIFactory.getIcon("spot.gif"));
        EventListener listener = new EventListener();
        JTextPane infoDisplayTextPane = new JTextPane();
        infoDisplayTextPane.setContentType("text/html");
        infoDisplayTextPane.setFont(infoDisplayFont);
        infoDisplayTextPane.setEditable(false);
        infoDisplayTextPane.setBackground(new Color(Integer.parseInt("FFFFCC", 16)));
        infoDisplayTextPane.setMargin(new Insets(10, 15, 10, 10));
        infoDisplayTextPane.setText(this.createMessage());
        infoDisplayTextPane.setCaretPosition(0);
        infoDisplayTextPane.addKeyListener(listener);
        JButton closeButton = new JButton("Close");
        closeButton.setActionCommand("close");
        closeButton.addActionListener(listener);
        closeButton.setFocusPainted(false);
        JButton graphButton = new JButton("Expression Graph");
        graphButton.setActionCommand("show-graph-command");
        graphButton.addActionListener(listener);
        graphButton.setFocusPainted(false);
        this.contentPane.setLayout(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(infoDisplayTextPane, 20, 30);
        scrollPane.getViewport().setBackground(Color.white);
        scrollPane.getVerticalScrollBar().setValues(0, 10, 0, 100);
        GBA gba = new GBA();
        gba.add(this.contentPane, (Component)scrollPane, 0, 0, 3, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(this.contentPane, (Component)graphButton, 0, 3, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(this.contentPane, (Component)closeButton, 1, 3, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.pack();
        this.setSize(550, 600);
        this.setResizable(true);
        this.setTitle("Gene Distance Spot Information");
        this.setLocation(400, 100);
        this.show();
    }

    private String createMessage() {
        boolean stringLength = false;
        int colTrueRow = this.expData.getProbeRow(0, this.colNumber);
        int colTrueColumn = this.expData.getProbeColumn(0, this.colNumber);
        int rowTrueRow = this.expData.getProbeRow(0, this.rowNumber);
        int rowTrueColumn = this.expData.getProbeColumn(0, this.rowNumber);
        String[] fieldNames = this.expData.getFieldNames();
        int num_fields = fieldNames.length;
        int displayRowNum = this.rowNumber + 1;
        int displayColNum = this.colNumber + 1;
        String colColor = "";
        String rowColor = "";
        if (this.haveColor) {
            colColor = '#' + Integer.toHexString(this.columnGeneColor.getRGB()).substring(2, 8);
            rowColor = '#' + Integer.toHexString(this.rowGeneColor.getRGB()).substring(2, 8);
        }
        String message = "<h3>Annotation</h3>";
        message = message + "<table border=2 cellpadding=4 valign=top><tr><td  valign=top></td><td  align=top><b>Column Gene</b></td><td  align=top><b>Row Gene</b></td></tr><tr><td  valign=top><b>Row</b></td><td  valign=top>" + colTrueRow + "</td><td valign=top>" + rowTrueRow + "</td></tr>" + "<tr><td  valign=top><b>Column</b></td><td  valign=top>" + colTrueColumn + "</td><td valign=top>" + rowTrueColumn + "</td></tr>";
        if (this.haveColor) {
            message = message + "<tr><td valign=top><b>Gene Color</b></td><td   valign=top bgcolor=" + colColor + "></td><td valign=top bgcolor=" + rowColor + "></td></tr>";
        }
        for (int i = 0; i < num_fields; ++i) {
            message = message + "<tr><td valign=top><b>" + fieldNames[i] + "</b></td><td  valign=top>" + this.expData.getElementAttribute(this.experiment.getGeneIndexMappedToData(this.colIndex), i) + "</td><td valign=top>" + this.expData.getElementAttribute(this.experiment.getGeneIndexMappedToData(this.rowIndex), i) + "</td></tr>";
        }
        message = message + "</table>";
        message = message + "<h3>Distance Information</h3><table border=2 cellpadding=4 valign=top><tr><td valign=top><b>GDM Matrix Row</b></td><td valign=top>" + displayRowNum + "</td></tr>" + "<tr><td valign=top><b>GDM Matrix Column</b></td><td valign=top>" + displayColNum + "</td></tr>" + "<tr><td valign=top><b>Scaled Gene Distance</b></td><td valign=top><b>" + this.geneDistMatrix.get(this.colIndex, this.rowIndex) + "<b></td></tr>" + "<tr><td valign=top><b>Actual Gene Distance</b></td><td valign=top><b>" + this.rawMatrix.get(this.colIndex, this.rowIndex) + "<b></td></tr>" + "<tr><td valign=top><b>Distance Metric</b></td><td valign=top>" + this.distanceMetric + "</td></tr>" + "<tr><td valign=top><b>Vector Size</b></td><td valign=top>" + this.vectorSize + "</td></tr>" + "<tr><td  valign=top><b>Missing Values</b></td><td  valign=top>" + this.colMissingValues + ", " + this.rowMissingValues + "</td></tr>" + "<tr><td valign=top><b>Distance Based on</b></td><td valign=top>" + this.distanceBasedOn + "</td></tr>";
        return message;
    }

    public void createGeneGraph() {
        GraphTick gt;
        GraphLine gl;
        int i;
        float[] rowData = this.data.A[this.rowIndex];
        float[] colData = this.data.A[this.colIndex];
        float rowMin = Float.POSITIVE_INFINITY;
        float rowMax = Float.NEGATIVE_INFINITY;
        float colMin = Float.POSITIVE_INFINITY;
        float colMax = Float.NEGATIVE_INFINITY;
        int numberOfExp = this.data.getColumnDimension();
        for (i = 0; i < numberOfExp; ++i) {
            if (!Float.isNaN(rowData[i])) {
                if (rowData[i] < rowMin) {
                    rowMin = rowData[i];
                }
                if (rowData[i] > rowMax) {
                    rowMax = rowData[i];
                }
            }
            if (Float.isNaN(colData[i])) continue;
            if (colData[i] < colMin) {
                colMin = colData[i];
            }
            if (!(colData[i] > colMax)) continue;
            colMax = colData[i];
        }
        rowMin = Math.min(rowMin, colMin);
        rowMax = Math.max(rowMax, colMax);
        rowMin = (int)(rowMin - 1.0f);
        rowMax = (int)(rowMax + 1.0f);
        if (rowMin > 0.0f) {
            rowMin = 0.0f;
        }
        if (rowMax < 0.0f) {
            rowMax = 0.0f;
        }
        JFrame graphFrame = new JFrame("Samples vs. Log Ratio");
        GraphViewer graph = new GraphViewer(graphFrame, 0, 500, 0, 500, 1.0, (double)numberOfExp, (double)rowMin, (double)rowMax, 100, 100, 100, 100, "Sample vs. Log Ratio", "Sample Name", "Log2 (Cy5 / Cy3)");
        graph.setSubTitle("(red line = row gene, blue line = column gene)");
        graph.setXAxisValue(0.0);
        graph.setYAxisValue(1.0);
        for (i = 1; i <= numberOfExp; ++i) {
            gl = new GraphLine((double)i, (double)rowMin, (double)i, (double)rowMax, Color.yellow);
            graph.addGraphElement((GraphElement)gl);
        }
        i = (int)rowMin;
        while ((float)i <= rowMax) {
            if (i != 0) {
                gl = new GraphLine(1.0, (double)i, (double)numberOfExp, (double)i, Color.yellow);
                graph.addGraphElement((GraphElement)gl);
            }
            ++i;
        }
        for (i = 0; i < numberOfExp - 1; ++i) {
            if (!Float.isNaN(rowData[i]) && !Float.isNaN(rowData[i + 1])) {
                gl = new GraphLine((double)(i + 1), (double)rowData[i], (double)(i + 2), (double)rowData[i + 1], Color.red);
                graph.addGraphElement((GraphElement)gl);
            }
            if (Float.isNaN(colData[i]) || Float.isNaN(colData[i + 1])) continue;
            gl = new GraphLine((double)(i + 1), (double)colData[i], (double)(i + 2), (double)colData[i + 1], Color.blue);
            graph.addGraphElement((GraphElement)gl);
        }
        for (i = 0; i < numberOfExp; ++i) {
            GraphPoint gp;
            if (!Float.isNaN(rowData[i])) {
                gp = new GraphPoint((double)(i + 1), (double)rowData[i], Color.blue, 3);
                graph.addGraphElement((GraphElement)gp);
            }
            if (Float.isNaN(colData[i])) continue;
            gp = new GraphPoint((double)(i + 1), (double)colData[i], Color.red, 3);
            graph.addGraphElement((GraphElement)gp);
        }
        i = (int)rowMin;
        while ((float)i <= rowMax) {
            gt = i == 0 ? new GraphTick((double)i, 8, Color.black, 1, 0, "0", Color.black) : new GraphTick((double)i, 8, Color.black, 1, 0, "" + i, Color.black);
            graph.addGraphElement((GraphElement)gt);
            ++i;
        }
        for (i = 1; i <= numberOfExp; ++i) {
            gt = new GraphTick((double)i, 8, Color.black, 0, 0, this.expData.getSampleName(i - 1), Color.black);
            graph.addGraphElement((GraphElement)gt);
        }
        graphFrame.setSize(500, 500);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension d = toolkit.getScreenSize();
        graphFrame.setLocation((int)(d.getWidth() / 2.0 - 250.0), (int)(d.getHeight() / 2.0 - 250.0));
        graph.setVisible(true);
    }

    private void setValues(int colIndex, int rowIndex) {
        float value;
        int column;
        int columns = this.experiment.getNumberOfSamples();
        boolean[] rowMissingVector = new boolean[columns];
        boolean[] colMissingVector = new boolean[columns];
        for (column = 0; column < columns; ++column) {
            rowMissingVector[column] = false;
            colMissingVector[column] = false;
        }
        for (column = 0; column < columns; ++column) {
            value = this.experiment.get(rowIndex, column);
            if (!Float.isNaN(value)) continue;
            rowMissingVector[column] = true;
            ++this.rowMissingValues;
        }
        for (column = 0; column < columns; ++column) {
            value = this.experiment.get(colIndex, column);
            if (!Float.isNaN(value)) continue;
            colMissingVector[column] = true;
            ++this.colMissingValues;
        }
        for (column = 0; column < columns; ++column) {
            if (rowMissingVector[column] || colMissingVector[column] || rowIndex == colIndex) continue;
            ++this.distanceBasedOn;
        }
    }

    private void drawGeneColor() {
        Graphics g = this.getGraphics();
        if (g != null) {
            g.setColor(this.rowGeneColor);
            g.fillRect(0, 0, 10, 10);
            g.setColor(this.columnGeneColor);
            g.fillRect(20, 0, 10, 10);
        }
    }

    class EventListener
    implements ActionListener,
    KeyListener {
        EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("close")) {
                GDMGeneSpotInfoDisplay.this.dispose();
            } else if (command.equals("show-graph-command")) {
                GDMGeneSpotInfoDisplay.this.createGeneGraph();
            }
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                GDMGeneSpotInfoDisplay.this.dispose();
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }
    }
}

