/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMGeneGradientLabelPanel;

public class GDMGeneHeader
extends JPanel {
    private static final String GDM_VECTOR_STRING = "GDM Vector";
    private int[] indices;
    private int labelIndex;
    private Insets insets;
    private int num_genes;
    private boolean showClusters = true;
    private boolean hasColorBar = false;
    private boolean isColumnHeader;
    private IData expData;
    private int contentWidth;
    private int contentHeight;
    private int elementWidth;
    private int elementHeight;
    private int tracespace;
    private int maxGeneNameLength;
    private Experiment experiment;
    private boolean isAntiAliasing = false;
    private boolean isTracing = true;
    private final int OFFSET = 5;
    private final int MIN_LABEL_PANEL_SIZE = 1;
    private final int MAX_LABEL_PANEL_SIZE = 200;
    private static final int NOT_UPDATE_ANNOTATION_SIZE = -1;
    private int annotationSize;
    private GDMGeneGradientLabelPanel gdmGradientLabelPanel;
    private GDMColorBarPanel gdmColorBarPanel;
    private float minValue = 0.0f;
    private float maxValue = 1.0f;
    private final int RECT_HEIGHT = 10;
    private final int RECT_WIDTH = 200;
    private int maxColorScaleTextWidth = 0;
    private int maxColorScaleTextHeight = 0;
    private int probes;
    private int headerWidth;
    private int headerHeight;
    private int gradientPanelWidth;
    private int gradientPanelHeight;
    private int labelPanelWidth;
    private int labelPanelHeight;
    private int colorBarWidth;
    private int colorBarHeight;
    private DecimalFormat decFormat;
    private boolean sortByGeneProximity = true;
    private ActionListener matrixListener;
    private int currentIndex = 0;

    public GDMGeneHeader(Insets insets, int tracespace, boolean colHdr, Experiment experiment, int width, int height, Dimension eSize, int maxGeneLen, int num_genes, int[] indexes) {
        this.setLayout(new BorderLayout());
        this.insets = new Insets(0, 0, 0, 0);
        this.tracespace = tracespace;
        this.experiment = experiment;
        this.elementWidth = eSize.width;
        this.elementHeight = eSize.height;
        this.isColumnHeader = colHdr;
        this.contentWidth = width;
        this.contentHeight = height;
        this.indices = indexes;
        this.probes = experiment.getNumberOfGenes();
        this.num_genes = num_genes;
        this.maxGeneNameLength = maxGeneLen * this.elementWidth;
        this.gdmGradientLabelPanel = new GDMGeneGradientLabelPanel(insets, tracespace, colHdr, experiment, width, height, eSize, maxGeneLen, num_genes, indexes);
        this.gdmColorBarPanel = new GDMColorBarPanel();
        this.setFontSize(this.elementWidth);
        if (this.isColumnHeader) {
            this.add((Component)this.gdmGradientLabelPanel, "North");
            if (this.hasColorBar) {
                this.add((Component)this.gdmColorBarPanel, "Center");
            }
        } else {
            this.add((Component)this.gdmGradientLabelPanel, "West");
            if (this.hasColorBar) {
                this.add((Component)this.gdmColorBarPanel, "Center");
            }
        }
        this.decFormat = new DecimalFormat();
        this.decFormat.setMaximumFractionDigits(3);
        this.decFormat.setMinimumFractionDigits(1);
        Listener listener = new Listener();
        this.gdmGradientLabelPanel.getLabelPanel().addMouseListener(listener);
        this.gdmGradientLabelPanel.getLabelPanel().addMouseMotionListener(listener);
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    public void setLabelIndex(int label) {
        this.labelIndex = label;
        this.gdmGradientLabelPanel.setLabelIndex(label);
    }

    public void setMatrixListener(ActionListener aL) {
        this.matrixListener = aL;
    }

    public void setSortByGeneProximity(boolean allowSort) {
        this.sortByGeneProximity = allowSort;
    }

    public void updateSize(int size) {
        this.updateMaxGeneNameLength();
        int geneNameLength = this.getMaxGeneNameLength();
        int maxTextSize = 0;
        if (size == -1) {
            if (geneNameLength < 1) {
                this.setAnnotationSize(1);
            } else if (geneNameLength > 200) {
                this.setAnnotationSize(200);
            } else {
                this.setAnnotationSize(geneNameLength);
            }
        } else {
            this.setAnnotationSize(size);
        }
        if (this.showClusters) {
            boolean tempBool = this.areProbesColored();
            if (tempBool && !this.hasColorBar) {
                this.add((Component)this.gdmColorBarPanel, "Center");
                this.validate();
            } else if (!tempBool && this.hasColorBar) {
                this.remove(this.gdmColorBarPanel);
                this.validate();
            }
            this.hasColorBar = tempBool;
        } else {
            this.hasColorBar = false;
        }
        if (this.isColumnHeader) {
            this.gradientPanelWidth = this.headerWidth = this.contentWidth + this.elementWidth / 2;
            this.labelPanelWidth = this.headerWidth;
            this.colorBarWidth = this.headerWidth;
            this.colorBarHeight = 0;
        } else {
            this.gradientPanelHeight = this.headerHeight = this.contentHeight + this.elementHeight / 2;
            this.labelPanelHeight = this.headerHeight;
            this.colorBarWidth = 0;
            this.colorBarHeight = this.headerHeight;
        }
        Graphics2D g = (Graphics2D)this.getColorScaleGraphics();
        int textHeight = 0;
        if (g != null) {
            FontMetrics hfm = g.getFontMetrics();
            this.maxColorScaleTextHeight = hfm.getHeight();
            float midValue = (this.minValue + this.maxValue) / 2.0f;
            String minString = this.decFormat.format(this.minValue);
            String maxString = this.decFormat.format(this.maxValue);
            String midString = this.decFormat.format(midValue);
            int textWidth1 = hfm.stringWidth(minString);
            int textWidth2 = hfm.stringWidth(maxString);
            int textWidth3 = hfm.stringWidth(midString);
            this.maxColorScaleTextWidth = Math.max(Math.max(textWidth1, textWidth2), textWidth3);
            textHeight = hfm.getHeight();
        }
        maxTextSize = Math.max(this.maxColorScaleTextWidth, this.maxColorScaleTextHeight);
        if (this.isColumnHeader) {
            this.gradientPanelHeight = 10 + textHeight + 10;
            this.labelPanelHeight = this.annotationSize + 10;
            this.colorBarHeight = this.hasColorBar ? 5 + (this.elementHeight >= 10 ? this.elementHeight : 10) : 0;
            this.headerHeight = this.gradientPanelHeight + this.labelPanelHeight + this.colorBarHeight + 4;
            this.setSize(this.headerWidth, this.headerHeight);
            this.setPreferredSize(new Dimension(this.headerWidth, this.headerHeight));
        } else {
            this.gradientPanelWidth = 10 + this.maxColorScaleTextWidth + 10;
            this.labelPanelWidth = this.annotationSize + 10;
            this.colorBarWidth = this.hasColorBar ? 5 + (this.elementWidth >= 10 ? this.elementWidth : 10) : 0;
            this.headerWidth = this.gradientPanelWidth + this.labelPanelWidth + this.colorBarWidth + 4;
            this.setSize(this.headerWidth, this.headerHeight);
            this.setPreferredSize(new Dimension(this.headerWidth, this.headerHeight));
        }
        this.gdmGradientLabelPanel.updateSize();
        this.gdmColorBarPanel.updateSize();
        this.validate();
    }

    private Graphics getColorScaleGraphics() {
        return this.gdmGradientLabelPanel.getColorScaleGraphics();
    }

    private void updateMaxGeneNameLength() {
        Graphics2D g = (Graphics2D)this.gdmGradientLabelPanel.getLabelPanelGraphics();
        if (g == null) {
            return;
        }
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fm = g.getFontMetrics();
        String geneName = "";
        int maxLength = 0;
        int[] indices = this.getIndices();
        for (int i = 0; i < this.num_genes; ++i) {
            if (indices != null) {
                if (this.labelIndex >= 0) {
                    geneName = this.expData.getElementAttribute(this.experiment.getGeneIndexMappedToData(indices[i]), this.labelIndex);
                }
            } else if (this.labelIndex >= 0) {
                geneName = this.expData.getElementAttribute(this.experiment.getGeneIndexMappedToData(i), this.labelIndex);
            }
            maxLength = Math.max(maxLength, fm.stringWidth(geneName));
        }
        this.maxGeneNameLength = maxLength;
    }

    private int getMaxGeneNameLength() {
        return this.maxGeneNameLength;
    }

    public void setNumGenes(int num_genes) {
        this.num_genes = num_genes;
        this.gdmGradientLabelPanel.setNumGenes(num_genes);
    }

    public void setIndices(int[] indexes) {
        this.indices = indexes;
        this.gdmGradientLabelPanel.setIndices(indexes);
    }

    public int[] getIndices() {
        return this.indices;
    }

    public void setPosColorImages(BufferedImage posColorImage) {
        this.gdmGradientLabelPanel.setPosColorImages(posColorImage);
        this.gdmGradientLabelPanel.repaint();
    }

    public JScrollBar getVerticalScrollBar() {
        return this.gdmGradientLabelPanel.getVerticalScrollBar();
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.gdmGradientLabelPanel.getHorizontalScrollBar();
    }

    public void setLeftInset(int leftMargin) {
        this.insets.left = leftMargin;
        this.setLeftInset(leftMargin);
        this.gdmGradientLabelPanel.setLeftInset(leftMargin);
    }

    public void setTopInset(int topMargin) {
        this.insets.top = topMargin;
        this.gdmGradientLabelPanel.setTopInset(topMargin);
    }

    public void setData(IData data) {
        this.expData = data;
        this.gdmGradientLabelPanel.setData(data);
    }

    public void setAntiAliasing(boolean isAntiAliasing) {
        this.isAntiAliasing = isAntiAliasing;
        this.gdmGradientLabelPanel.setAntiAliasing(isAntiAliasing);
    }

    void setElementWidth(int width) {
        this.elementWidth = width;
        this.setFontSize(width);
        this.gdmGradientLabelPanel.setElementWidth(width);
    }

    void setElementHeight(int height) {
        this.elementHeight = height;
        this.setFontSize(height);
        this.gdmGradientLabelPanel.setElementHeight(height);
    }

    int getElementWidth() {
        return this.elementWidth;
    }

    void setAnnotationSize(int size) {
        this.annotationSize = size;
        this.gdmGradientLabelPanel.setAnnotationSize(size);
    }

    void setContentWidth(int width) {
        this.contentWidth = width;
        this.gdmGradientLabelPanel.setContentWidth(width);
    }

    void setContentHeight(int height) {
        this.contentHeight = height;
        this.gdmGradientLabelPanel.setContentHeight(height);
    }

    void setTracing(boolean isTracing) {
        this.isTracing = isTracing;
        this.gdmGradientLabelPanel.setTracing(isTracing);
    }

    private int getSpacing() {
        if (this.isTracing) {
            return this.tracespace;
        }
        return 0;
    }

    private void setFontSize(int size) {
        if (size > 12) {
            size = 12;
        }
        this.setFont(new Font("monospaced", 0, size));
    }

    public void setValues(float minValue, float maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.gdmGradientLabelPanel.setValues(minValue, maxValue);
    }

    public boolean areProbesColored() {
        if (this.indices == null) {
            return false;
        }
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.expData.getProbeColor(this.experiment.getGeneIndexMappedToData(this.indices[i])) == null) continue;
            return true;
        }
        return false;
    }

    private void fireGDMSortEvent(int index) {
        ActionEvent ae = new ActionEvent(this, index, "sort-by-gene-proximity-cmd");
        if (this.matrixListener != null) {
            this.matrixListener.actionPerformed(ae);
        }
    }

    private class GDMColorBarPanel
    extends JPanel {
        public GDMColorBarPanel() {
            this.setBackground(Color.white);
            this.setSize(0, 0);
            this.setPreferredSize(new Dimension(0, 0));
            this.setOpaque(true);
        }

        private void setFontSize(int width) {
            if (width > 12) {
                width = 12;
            }
            this.setFont(new Font("monospaced", 0, width));
        }

        public void updateSize() {
            this.setSize(GDMGeneHeader.this.colorBarWidth, GDMGeneHeader.this.colorBarHeight);
            this.setPreferredSize(new Dimension(GDMGeneHeader.this.colorBarWidth, GDMGeneHeader.this.colorBarHeight));
        }

        @Override
        public void paint(Graphics g1D) {
            super.paint(g1D);
            if (!GDMGeneHeader.this.hasColorBar) {
                return;
            }
            if (GDMGeneHeader.this.expData == null) {
                return;
            }
            Graphics2D g = (Graphics2D)g1D;
            if (GDMGeneHeader.this.isAntiAliasing) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (GDMGeneHeader.this.isColumnHeader) {
                this.drawColumnColorBar(g);
            } else {
                this.drawRowColorBar(g);
            }
        }

        private void drawRowColorBar(Graphics2D g) {
            Rectangle bounds = g.getClipBounds();
            int top = this.getTopIndex(bounds.y);
            int bottom = 0;
            bottom = this.getBottomIndex(bounds.y + bounds.height, GDMGeneHeader.this.num_genes);
            for (int row = top; row < bottom; ++row) {
                this.fillRowColorRectAt(g, 2, row);
            }
        }

        private void fillRowColorRectAt(Graphics g, int xLoc, int row) {
            Color geneColor = null;
            geneColor = GDMGeneHeader.this.expData.getProbeColor(GDMGeneHeader.this.experiment.getGeneIndexMappedToData(GDMGeneHeader.this.indices[row]));
            if (geneColor == null) {
                geneColor = Color.white;
            }
            g.setColor(geneColor);
            g.fillRect(xLoc, row * GDMGeneHeader.this.elementHeight, GDMGeneHeader.this.colorBarWidth - 5, GDMGeneHeader.this.elementHeight);
        }

        private void drawColumnColorBar(Graphics2D g) {
            Rectangle bounds = g.getClipBounds();
            int left = this.getLeftIndex(bounds.x);
            int right = 0;
            right = this.getRightIndex(bounds.x + bounds.width, GDMGeneHeader.this.num_genes);
            for (int column = left; column < right; ++column) {
                this.fillColumnColorRectAt(g, column, 2);
            }
        }

        private void fillColumnColorRectAt(Graphics g, int column, int yLoc) {
            Color geneColor = null;
            geneColor = GDMGeneHeader.this.expData.getProbeColor(GDMGeneHeader.this.experiment.getGeneIndexMappedToData(GDMGeneHeader.this.indices[column]));
            if (geneColor == null) {
                geneColor = Color.white;
            }
            g.setColor(geneColor);
            g.fillRect(column * GDMGeneHeader.this.elementWidth, yLoc, GDMGeneHeader.this.elementWidth, GDMGeneHeader.this.colorBarHeight - 5);
        }

        private int getTopIndex(int top) {
            if (top < 0) {
                return 0;
            }
            return top / GDMGeneHeader.this.elementHeight;
        }

        private int getLeftIndex(int left) {
            if (left < 0) {
                return 0;
            }
            return left / (GDMGeneHeader.this.elementWidth + GDMGeneHeader.this.getSpacing());
        }

        private int getRightIndex(int right, int limit) {
            if (right < 0) {
                return 0;
            }
            int result = right / (GDMGeneHeader.this.elementWidth + GDMGeneHeader.this.getSpacing()) + 1;
            return result > limit ? limit : result;
        }

        private int getBottomIndex(int bottom, int limit) {
            if (bottom < 0) {
                return 0;
            }
            int result = bottom / GDMGeneHeader.this.elementHeight + 1;
            return result > limit ? limit : result;
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (GDMGeneHeader.this.sortByGeneProximity) {
                int loc = 0;
                loc = GDMGeneHeader.this.isColumnHeader ? evt.getX() : evt.getY();
                int index = (loc - ((GDMGeneHeader)GDMGeneHeader.this).insets.left) / GDMGeneHeader.this.elementWidth;
                GDMGeneHeader.this.fireGDMSortEvent(GDMGeneHeader.this.indices[index]);
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (GDMGeneHeader.this.sortByGeneProximity) {
                int elementIndex;
                Graphics2D g2D = (Graphics2D)GDMGeneHeader.this.gdmGradientLabelPanel.getLabelPanelGraphics();
                if (g2D == null) {
                    return;
                }
                int x = event.getX();
                int y = event.getY();
                if (GDMGeneHeader.this.isColumnHeader) {
                    elementIndex = x / GDMGeneHeader.this.elementWidth;
                    if (elementIndex >= GDMGeneHeader.this.num_genes) {
                        GDMGeneHeader.this.repaint();
                        return;
                    }
                    if (elementIndex != GDMGeneHeader.this.currentIndex) {
                        g2D.setColor(Color.white);
                        g2D.drawRect(GDMGeneHeader.this.currentIndex * GDMGeneHeader.this.elementWidth, 0, GDMGeneHeader.this.elementWidth, GDMGeneHeader.this.gdmGradientLabelPanel.getLabelPanel().getHeight() - 1);
                    }
                    g2D.setColor(Color.blue);
                    g2D.drawRect(elementIndex * GDMGeneHeader.this.elementWidth, 0, GDMGeneHeader.this.elementWidth, GDMGeneHeader.this.gdmGradientLabelPanel.getLabelPanel().getHeight() - 1);
                } else {
                    elementIndex = y / GDMGeneHeader.this.elementWidth;
                    if (elementIndex >= GDMGeneHeader.this.num_genes) {
                        GDMGeneHeader.this.repaint();
                        return;
                    }
                    if (elementIndex != GDMGeneHeader.this.currentIndex) {
                        g2D.setColor(Color.white);
                        g2D.drawRect(0, GDMGeneHeader.this.currentIndex * GDMGeneHeader.this.elementWidth, GDMGeneHeader.this.gdmGradientLabelPanel.getLabelPanel().getWidth() - 1, GDMGeneHeader.this.elementHeight);
                    }
                    g2D.setColor(Color.blue);
                    g2D.drawRect(0, elementIndex * GDMGeneHeader.this.elementWidth, GDMGeneHeader.this.gdmGradientLabelPanel.getLabelPanel().getWidth() - 1, GDMGeneHeader.this.elementHeight);
                }
                GDMGeneHeader.this.currentIndex = elementIndex;
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
            GDMGeneHeader.this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }
    }
}

