/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;

public class GDMGeneGradientLabelPanel
extends JScrollPane {
    private final int OFFSET = 5;
    private final int RECT_HEIGHT = 10;
    private final int RECT_WIDTH = 200;
    private IData expData;
    private Insets insets;
    private int contentWidth;
    private int contentHeight;
    private int elementWidth;
    private int elementHeight;
    private int tracespace;
    private int maxGeneNameLength;
    private int num_genes;
    private int[] indices;
    private int labelIndex;
    private Experiment experiment;
    private boolean isAntiAliasing = false;
    private boolean isTracing = true;
    private boolean isColumnHeader;
    private int annotationSize;
    private GDMLabelPanel gdmLabelPanel;
    private GDMGradientPanel gdmGradientPanel;
    private float minValue = 0.0f;
    private float maxValue = 1.0f;
    private int maxColorScaleTextWidth = 0;
    private int maxColorScaleTextHeight = 0;
    private DecimalFormat decFormat;

    public GDMGeneGradientLabelPanel(Insets insets, int tracespace, boolean colHdr, Experiment experiment, int width, int height, Dimension eSize, int maxGeneLen, int num_genes, int[] indexes) {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.insets = new Insets(0, 0, 0, 0);
        this.tracespace = tracespace;
        this.experiment = experiment;
        this.elementWidth = eSize.width;
        this.elementHeight = eSize.height;
        this.isColumnHeader = colHdr;
        this.contentWidth = width;
        this.contentHeight = height;
        this.indices = indexes;
        this.num_genes = num_genes;
        this.maxGeneNameLength = maxGeneLen * this.elementWidth;
        this.gdmGradientPanel = new GDMGradientPanel();
        this.gdmLabelPanel = new GDMLabelPanel();
        this.setViewportView(this.gdmLabelPanel);
        this.setViewport(this.getViewport());
        if (this.isColumnHeader) {
            this.setColumnHeaderView(this.gdmGradientPanel);
            this.setColumnHeader(this.getColumnHeader());
            this.setViewportBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        } else {
            this.setRowHeaderView(this.gdmGradientPanel);
            this.setRowHeader(this.getRowHeader());
            this.setViewportBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }
        this.updateSize();
        if (this.isColumnHeader) {
            this.setHorizontalScrollBarPolicy(31);
            this.setVerticalScrollBarPolicy(21);
        } else {
            this.setVerticalScrollBarPolicy(21);
            this.setHorizontalScrollBarPolicy(31);
        }
        this.getViewport().setScrollMode(0);
        this.decFormat = new DecimalFormat();
        this.decFormat.setMinimumFractionDigits(1);
        this.decFormat.setMaximumFractionDigits(3);
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    public void setValues(float minValue, float maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public void setData(IData data) {
        this.expData = data;
    }

    public void setNumGenes(int val) {
        this.num_genes = val;
    }

    public void setIndices(int[] indexes) {
        this.indices = indexes;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public void setLabelIndex(int label) {
        this.labelIndex = label;
    }

    public int getLabelIndex() {
        return this.labelIndex;
    }

    public void setAntiAliasing(boolean isAntiAliasing) {
        this.isAntiAliasing = isAntiAliasing;
    }

    void setElementWidth(int width) {
        this.elementWidth = width;
        this.setFontSize(width);
        this.gdmLabelPanel.setFontSize(width);
    }

    int getElementWidth() {
        return this.elementWidth;
    }

    public JComponent getLabelPanel() {
        return this.gdmLabelPanel;
    }

    void setAnnotationSize(int size) {
        this.annotationSize = size;
    }

    void setContentWidth(int width) {
        this.contentWidth = width;
    }

    void setElementHeight(int height) {
        this.elementHeight = height;
        this.setFontSize(height);
        this.gdmLabelPanel.setFontSize(height);
    }

    void setContentHeight(int height) {
        this.contentHeight = height;
    }

    void setTracing(boolean isTracing) {
        this.isTracing = isTracing;
    }

    private int getSpacing() {
        if (this.isTracing) {
            return this.tracespace;
        }
        return 0;
    }

    private void setFontSize(int size) {
        if (size > 12) {
            size = 12;
        }
        this.setFont(new Font("monospaced", 0, size));
    }

    private void updateMaxGeneNameLength() {
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g == null) {
            return;
        }
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fm = g.getFontMetrics();
        String geneName = "";
        int maxLength = 0;
        int[] indices = this.getIndices();
        for (int i = 0; i < this.num_genes; ++i) {
            if (indices != null) {
                if (this.labelIndex >= 0) {
                    geneName = this.expData.getElementAttribute(this.experiment.getGeneIndexMappedToData(indices[i]), this.labelIndex);
                }
            } else if (this.labelIndex >= 0) {
                geneName = this.expData.getElementAttribute(i, this.labelIndex);
            }
            maxLength = Math.max(maxLength, fm.stringWidth(geneName));
        }
        this.maxGeneNameLength = maxLength;
    }

    private int getMaxGeneNameLength() {
        return this.maxGeneNameLength;
    }

    private void setMaxGeneNameLength(int val) {
        this.maxGeneNameLength = val;
    }

    public void updateSize() {
        this.updateMaxGeneNameLength();
        this.gdmGradientPanel.updateSize();
        this.gdmLabelPanel.updateSize();
        if (this.isColumnHeader) {
            this.getVerticalScrollBar().setValues(190, 10, 100, 200);
        } else {
            this.getHorizontalScrollBar().setValues(190, 10, 100, 200);
        }
        if (this.isColumnHeader) {
            int w = this.contentWidth + this.elementWidth / 2;
            int h = 10 + this.maxColorScaleTextHeight + this.annotationSize + 10 + 10 + 4;
            this.setSize(w, h);
            this.setPreferredSize(new Dimension(w, h));
        } else {
            int w = 10 + this.maxColorScaleTextWidth + this.annotationSize + 10 + 10 + 4;
            int h = this.contentHeight + this.elementHeight / 2;
            this.setSize(w, h);
            this.setPreferredSize(new Dimension(w, h));
        }
        this.getViewport().setViewSize(this.gdmLabelPanel.getSize());
        this.validate();
    }

    public void setPosColorImages(BufferedImage posColorImage) {
        this.gdmGradientPanel.setPosColorImages(posColorImage);
        this.gdmGradientPanel.repaint();
    }

    public void setLeftInset(int leftMargin) {
        this.insets.left = leftMargin;
    }

    public void setTopInset(int topMargin) {
        this.insets.top = topMargin;
    }

    public boolean areProbesColored() {
        if (this.indices == null) {
            return false;
        }
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.expData.getProbeColor(this.experiment.getGeneIndexMappedToData(this.indices[i])) == null) continue;
            return true;
        }
        return false;
    }

    public Graphics getColorScaleGraphics() {
        return this.gdmGradientPanel.getGraphics();
    }

    public Graphics getLabelPanelGraphics() {
        return this.gdmLabelPanel.getGraphics();
    }

    private class GDMGradientPanel
    extends JPanel {
        private boolean drawBorders = false;
        private Color missingColor = new Color(128, 128, 128);
        private BufferedImage posColorImage;
        private DecimalFormat decFormat;

        public GDMGradientPanel() {
            this.setBackground(Color.white);
            this.setOpaque(true);
            this.decFormat = new DecimalFormat();
            this.decFormat.setMinimumFractionDigits(1);
            this.decFormat.setMaximumFractionDigits(3);
        }

        public void setPosColorImages(BufferedImage posColorImage) {
            this.posColorImage = posColorImage;
        }

        public void setMissingColor(Color color) {
            this.missingColor = color;
        }

        public void setDrawBorders(boolean draw) {
            this.drawBorders = draw;
        }

        public void updateSize() {
            Graphics2D g = (Graphics2D)this.getGraphics();
            boolean textHeight = false;
            float midValue = (GDMGeneGradientLabelPanel.this.minValue + GDMGeneGradientLabelPanel.this.maxValue) / 2.0f;
            String midString = this.decFormat.format(midValue);
            String maxString = this.decFormat.format(GDMGeneGradientLabelPanel.this.maxValue);
            String minString = this.decFormat.format(GDMGeneGradientLabelPanel.this.minValue);
            if (g != null) {
                FontMetrics hfm = g.getFontMetrics();
                GDMGeneGradientLabelPanel.this.maxColorScaleTextHeight = hfm.getHeight();
                int textWidth1 = hfm.stringWidth(midString);
                int textWidth2 = hfm.stringWidth(maxString);
                int textWidth3 = hfm.stringWidth(minString);
                GDMGeneGradientLabelPanel.this.maxColorScaleTextWidth = Math.max(textWidth1, textWidth2);
                GDMGeneGradientLabelPanel.this.maxColorScaleTextWidth = Math.max(GDMGeneGradientLabelPanel.this.maxColorScaleTextWidth, textWidth3);
            } else {
                GDMGeneGradientLabelPanel.this.maxColorScaleTextHeight = 4;
                GDMGeneGradientLabelPanel.this.maxColorScaleTextWidth = 4;
            }
            if (GDMGeneGradientLabelPanel.this.isColumnHeader) {
                int w = GDMGeneGradientLabelPanel.this.contentWidth + (int)((float)GDMGeneGradientLabelPanel.this.elementWidth / 2.0f);
                int h = 20 + GDMGeneGradientLabelPanel.this.maxColorScaleTextHeight;
                this.setSize(w, h);
                this.setPreferredSize(new Dimension(w, h));
            } else {
                int w = 20 + GDMGeneGradientLabelPanel.this.maxColorScaleTextWidth;
                int h = GDMGeneGradientLabelPanel.this.contentHeight + (int)((float)GDMGeneGradientLabelPanel.this.elementHeight / 2.0f);
                this.setSize(w, h);
                this.setPreferredSize(new Dimension(w, h));
            }
        }

        @Override
        public void paint(Graphics g1D) {
            super.paint(g1D);
            if (GDMGeneGradientLabelPanel.this.expData == null || GDMGeneGradientLabelPanel.this.expData.getFeaturesCount() == 0) {
                return;
            }
            Graphics2D g = (Graphics2D)g1D;
            if (GDMGeneGradientLabelPanel.this.isColumnHeader) {
                g.drawImage(this.posColorImage, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.top, 200, 10, null);
            } else {
                g.rotate(1.5707963267948966);
                g.drawImage(this.posColorImage, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.top, -10 - ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left, 200, 10, null);
            }
            FontMetrics hfm = g.getFontMetrics();
            int descent = hfm.getDescent();
            g.setColor(Color.black);
            if (GDMGeneGradientLabelPanel.this.isAntiAliasing) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            float midValue = (GDMGeneGradientLabelPanel.this.minValue + GDMGeneGradientLabelPanel.this.maxValue) / 2.0f;
            String midString = this.decFormat.format(midValue);
            String minString = this.decFormat.format(GDMGeneGradientLabelPanel.this.minValue);
            String maxString = this.decFormat.format(GDMGeneGradientLabelPanel.this.maxValue);
            int textWidth1 = hfm.stringWidth(minString);
            int textWidth2 = hfm.stringWidth(maxString);
            int textWidth3 = hfm.stringWidth(midString);
            if (GDMGeneGradientLabelPanel.this.isColumnHeader) {
                g.drawString(minString, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left, 10 + GDMGeneGradientLabelPanel.this.maxColorScaleTextHeight);
                g.drawString(midString, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left + 100 - textWidth3 / 2, 10 + GDMGeneGradientLabelPanel.this.maxColorScaleTextHeight);
                g.drawString(maxString, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left + 200 - textWidth2, 10 + GDMGeneGradientLabelPanel.this.maxColorScaleTextHeight);
            } else {
                g.rotate(-1.5707963267948966);
                g.drawString(minString, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left + 10, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.top + GDMGeneGradientLabelPanel.this.maxColorScaleTextHeight);
                g.drawString(midString, (float)(((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left + 10), (float)(((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.top + 100) + (float)GDMGeneGradientLabelPanel.this.maxColorScaleTextHeight / 2.0f);
                g.drawString(maxString, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left + 10, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.top + 200);
            }
        }
    }

    private class GDMLabelPanel
    extends JPanel {
        public GDMLabelPanel() {
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        private void setFontSize(int width) {
            if (width > 12) {
                width = 12;
            }
            this.setFont(new Font("monospaced", 0, width));
        }

        public void updateSize() {
            int h;
            int w;
            if (GDMGeneGradientLabelPanel.this.isColumnHeader) {
                w = GDMGeneGradientLabelPanel.this.contentWidth + (int)((float)GDMGeneGradientLabelPanel.this.elementWidth / 2.0f);
                h = GDMGeneGradientLabelPanel.this.getMaxGeneNameLength() + 10;
            } else {
                w = GDMGeneGradientLabelPanel.this.getMaxGeneNameLength() + 10;
                h = GDMGeneGradientLabelPanel.this.contentHeight + (int)((float)GDMGeneGradientLabelPanel.this.elementHeight / 2.0f);
            }
            this.setSize(w, h);
            this.setMinimumSize(new Dimension(w, h));
            this.setPreferredSize(new Dimension(w, h));
        }

        @Override
        public void paint(Graphics g1D) {
            super.paint(g1D);
            if (GDMGeneGradientLabelPanel.this.expData == null || GDMGeneGradientLabelPanel.this.getElementWidth() <= 2) {
                return;
            }
            Graphics2D g = (Graphics2D)g1D;
            if (GDMGeneGradientLabelPanel.this.isAntiAliasing) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            this.drawLabelHeader(g);
        }

        private void drawLabelHeader(Graphics2D g) {
            if (GDMGeneGradientLabelPanel.this.num_genes == 0) {
                return;
            }
            FontMetrics hfm = g.getFontMetrics();
            int descent = hfm.getDescent();
            if (GDMGeneGradientLabelPanel.this.isColumnHeader) {
                g.rotate(-1.5707963267948966);
            }
            String geneName = "";
            int maxLength = 0;
            int[] indices = GDMGeneGradientLabelPanel.this.getIndices();
            for (int i = 0; i < GDMGeneGradientLabelPanel.this.num_genes; ++i) {
                int y;
                int x;
                if (indices != null) {
                    if (GDMGeneGradientLabelPanel.this.labelIndex >= 0) {
                        geneName = GDMGeneGradientLabelPanel.this.expData.getElementAttribute(GDMGeneGradientLabelPanel.this.experiment.getGeneIndexMappedToData(indices[i]), GDMGeneGradientLabelPanel.this.labelIndex);
                    }
                } else if (GDMGeneGradientLabelPanel.this.labelIndex >= 0) {
                    geneName = GDMGeneGradientLabelPanel.this.expData.getElementAttribute(i, GDMGeneGradientLabelPanel.this.labelIndex);
                }
                maxLength = Math.max(maxLength, hfm.stringWidth(geneName));
                if (GDMGeneGradientLabelPanel.this.isColumnHeader) {
                    x = ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.top - (GDMGeneGradientLabelPanel.this.getMaxGeneNameLength() + 10) + 5;
                    y = ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left + descent + (GDMGeneGradientLabelPanel.this.elementWidth + GDMGeneGradientLabelPanel.this.getSpacing()) * i + GDMGeneGradientLabelPanel.this.elementWidth / 2 + 1;
                } else {
                    x = ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left + 5;
                    y = ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.top + descent + (GDMGeneGradientLabelPanel.this.elementHeight + GDMGeneGradientLabelPanel.this.getSpacing()) * i + GDMGeneGradientLabelPanel.this.elementHeight / 2;
                }
                g.drawString(geneName, x, y);
            }
            if (GDMGeneGradientLabelPanel.this.isColumnHeader) {
                g.rotate(1.5707963267948966);
            }
            GDMGeneGradientLabelPanel.this.setMaxGeneNameLength(maxLength);
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
        }

        @Override
        public void mouseMoved(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }
    }
}

