/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMExpViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMGeneViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMInitDialog;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class GDMGUI
implements IClusterGUI,
IScriptGUI {
    private Experiment experiment;
    private Algorithm algorithm;
    private Progress progress;
    private IFramework framework;
    private FloatMatrix geneDistanceMatrix;
    private float minDist;
    private float maxDist;
    private int num_genes;
    private int num_experiments;
    private boolean useGenes;
    private int displayInterval;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        this.framework = framework;
        this.experiment = framework.getData().getExperiment();
        GeneralInfo info = new GeneralInfo();
        Listener listener = new Listener();
        GDMInitDialog dialog = new GDMInitDialog(framework.getFrame());
        if (dialog.showModal() != 0) {
            return null;
        }
        this.useGenes = dialog.isUseGenes();
        this.displayInterval = this.useGenes ? dialog.getDisplayInterval() : 1;
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("GDM");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "GDM Training", listener);
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            data.addParam("distance-factor", String.valueOf(1.0f));
            if (this.useGenes) {
                data.addMatrix("experiment", framework.getData().getExperiment().getMatrix());
            } else {
                data.addMatrix("experiment", framework.getData().getExperiment().getMatrix().transpose());
            }
            IDistanceMenu menu = framework.getDistanceMenu();
            data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
            int function = menu.getDistanceFunction();
            if (function == 0) {
                function = 1;
            }
            data.addParam("distance-function", String.valueOf(function));
            long startTime = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            info.time = System.currentTimeMillis() - startTime;
            info.function = menu.getFunctionName(function);
            if (this.useGenes) {
                int maxGeneNameLength = this.getMaxGeneNameLength();
                result.addParam("maxGeneNameLength", String.valueOf(maxGeneNameLength));
            } else {
                int maxExpNameLength = this.getMaxExpNameLength();
                result.addParam("maxExpNameLength", String.valueOf(maxExpNameLength));
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        this.framework = framework;
        this.experiment = framework.getData().getExperiment();
        GDMInitDialog dialog = new GDMInitDialog(framework.getFrame());
        if (dialog.showModal() != 0) {
            return null;
        }
        this.useGenes = dialog.isUseGenes();
        this.displayInterval = this.useGenes ? dialog.getDisplayInterval() : 1;
        AlgorithmData data = new AlgorithmData();
        data.addParam("gdm-genes", String.valueOf(this.useGenes));
        data.addParam("display-interval", String.valueOf(this.displayInterval));
        data.addParam("distance-factor", String.valueOf(1.0f));
        IDistanceMenu menu = framework.getDistanceMenu();
        data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        data.addParam("distance-function", String.valueOf(function));
        data.addParam("name", "GDM");
        data.addParam("alg-type", "data-visualization");
        data.addParam("output-class", "single-output");
        String[] outputNodes = new String[]{"Data Visualization"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        this.framework = framework;
        Listener listener = new Listener();
        this.experiment = experiment;
        this.useGenes = algData.getParams().getBoolean("gdm-genes");
        if (this.useGenes) {
            algData.addMatrix("experiment", experiment.getMatrix());
        } else {
            algData.addMatrix("experiment", experiment.getMatrix().transpose());
        }
        this.displayInterval = algData.getParams().getInt("display-interval");
        int function = algData.getParams().getInt("distance-function");
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("GDM");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "GDM Training", listener);
            this.progress.show();
            long startTime = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            GeneralInfo info = new GeneralInfo();
            info.time = System.currentTimeMillis() - startTime;
            info.function = framework.getDistanceMenu().getFunctionName(function);
            if (this.useGenes) {
                int maxGeneNameLength = this.getMaxGeneNameLength();
                algData.addMatrix("experiment", experiment.getMatrix());
                result.addParam("maxGeneNameLength", String.valueOf(maxGeneNameLength));
            } else {
                int maxExpNameLength = this.getMaxExpNameLength();
                algData.addMatrix("experiment", experiment.getMatrix().transpose());
                result.addParam("maxExpNameLength", String.valueOf(maxExpNameLength));
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private int getMaxGeneNameLength() {
        int max = 0;
        int num_genes = this.framework.getData().getExperiment().getNumberOfGenes();
        for (int i = 0; i < num_genes; ++i) {
            String geneName = this.framework.getData().getGeneName(i);
            max = Math.max(max, geneName.length());
        }
        return max;
    }

    private int getMaxExpNameLength() {
        int max = 0;
        int num_experiments = this.framework.getData().getExperiment().getNumberOfSamples();
        for (int i = 0; i < num_experiments; ++i) {
            String expName = this.framework.getData().getSampleName(i);
            max = Math.max(max, expName.length());
        }
        return max;
    }

    private DefaultMutableTreeNode createResultTree(AlgorithmData data, GeneralInfo info) {
        DefaultMutableTreeNode root;
        if (this.useGenes) {
            root = new DefaultMutableTreeNode("GDM - genes");
            root.add(new DefaultMutableTreeNode(new LeafInfo("Matrix View", (IViewer)new GDMGeneViewer(this.framework, data, info.function, this.displayInterval, null, 0))));
            root.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
            root.add(new DefaultMutableTreeNode(info.function));
        } else {
            root = new DefaultMutableTreeNode("GDM - samples");
            root.add(new DefaultMutableTreeNode(new LeafInfo("Matrix View", (IViewer)new GDMExpViewer(this.framework, data, info.function, this.displayInterval, null, 0))));
            root.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
            root.add(new DefaultMutableTreeNode(info.function));
        }
        return root;
    }

    private class GeneralInfo {
        public long time;
        public String function;

        private GeneralInfo() {
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    GDMGUI.this.progress.setUnits(event.getIntValue());
                    GDMGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    GDMGUI.this.progress.setValue(event.getIntValue());
                    GDMGUI.this.progress.setDescription(event.getDescription());
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                GDMGUI.this.algorithm.abort();
                GDMGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            GDMGUI.this.algorithm.abort();
            GDMGUI.this.progress.dispose();
        }
    }
}

