/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMAnnotationSizeDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMBorderColorDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMColorScaleDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMColorSelectionDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMElementSizeDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMExpHeader;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMExpSpotInfoDisplay;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMMemberSelectionDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMResultSelectionDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMScaleListener;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class GDMExpViewer
extends JPanel
implements IViewer {
    private JPanel content;
    private GDMExpHeader expColumnHeaderSP;
    private GDMExpHeader expRowHeaderSP;
    private JScrollBar upperRightCornerSB;
    private JScrollBar lowerLeftCornerSB;
    private FloatMatrix expDistMatrix;
    private FloatMatrix rawMatrix;
    private IData expData;
    private IData arrayData;
    private IFramework framework;
    private JFrame mainframe;
    private static final int TRACE_SPACE = 50;
    private static final int MAX_MATRIX_WIDTH = 400;
    private static final int MAX_COL_WIDTH = 400;
    private static final int MAX_COL_HEIGHT = 500;
    private static final int MAX_ROW_WIDTH = 500;
    private static final int MAX_ROW_HEIGHT = 400;
    private static final int NOT_UPDATE_ANNOTATION_SIZE = -1;
    private int num_experiments;
    private int maxExpNameLength;
    private int probes;
    private int featuresCount;
    private int label;
    private int displayEvery = 1;
    private Insets insets;
    private Color clusterBorderColor;
    private int elementWidth;
    private int paletteStyle;
    private int labelIndex = -1;
    private int maxLabelWidth = 0;
    private boolean isGRScale;
    private boolean isDrawBorders;
    private boolean isAntiAliasing = true;
    private boolean isTracing = false;
    private int tracespace;
    private int xWidth;
    private int xHeight;
    private Dimension elementSize = new Dimension(15, 15);
    public static Color zeroColor = Color.black;
    public static Color NaNColor = Color.gray;
    public static Color diagColor = Color.white;
    private float maxValue;
    private float minValue;
    private float origMaxValue;
    private float origMinValue;
    private int colorScheme = 5;
    private BufferedImage negGreenColorImage = this.createGradientImage(Color.green, Color.black);
    private BufferedImage posRedColorImage = this.createGradientImage(Color.black, Color.red);
    private BufferedImage negBlueColorImage = this.createGradientImage(Color.blue, Color.black);
    private BufferedImage posYellowColorImage = this.createGradientImage(Color.black, Color.yellow);
    private BufferedImage negCustomColorImage;
    private BufferedImage posCustomColorImage;
    private BufferedImage posColorImage = this.posRedColorImage;
    private BufferedImage negColorImage = this.negGreenColorImage;
    private Color borderColor;
    private boolean isDrawClusterBorders = true;
    private String distanceMetric;
    private JPopupMenu popup;
    private Experiment experiment;
    private int[][] clusters;
    private int numOfClusters;
    private int[] clusterlength;
    private int[] indices;
    private boolean sortByProximity = true;
    private boolean imposeClusterOrder = false;
    private static final String PARAMETER = "command-parameter";
    private static final String CHANGE_ANNOTATION_WIDTH = "Change Annotation Width";
    private static final String BORDER_COLOR_CMD = "select-border-color-cmd";
    private static final String COLOR_SCALE_CMD = "set-color-scale-cmd";
    private static final String DISPLAY_LABEL_ACTION = "display--label-action";
    private static final String DISPLAY_LABEL_CMD = "display-label-cmd";
    private static final String GREEN_RED_COLOR_SCHEME_CMD = "display-green-red-scheme-cmd";
    private static final String BLUE_YELLOW_COLOR_SCHEME_CMD = "display-blue-yellow-scheme-cmd";
    private static final String CUSTOM_COLOR_SCHEME_CMD = "display-custom-color-scheme-cmd";
    private static final String DISPLAY_DRAW_BORDERS_CMD = "display-draw-borders-cmd";
    private static final String DISPLAY_2X2_CMD = "display-2x2-cmd";
    private static final String DISPLAY_5X5_CMD = "display-5x5-cmd";
    private static final String DISPLAY_10X10_CMD = "display-10x10-cmd";
    private static final String DISPLAY_15X15_CMD = "display-15x15-cmd";
    private static final String DISPLAY_OTHER_CMD = "display-other-cmd";
    private static final String SET_CLUSTER_BORDER_CMD = "set-cluster-border-cmd";
    private static final String ANNOTATION_WIDTH_ACTION = "annotation-width-action";
    private static final String ANNOTATION_WIDTH_CMD = "annotation-width-cmd";
    private static final String TOGGLE_PROXIMITY_SORT_CMD = "Toggle-proximity-cmd";
    public static final String SORT_BY_EXP_NAME_CMD = "sort-by-experiment-cmd";
    public static final String SORT_BY_ORIGINAL_ORDER_CMD = "sort-by-original-order-cmd";
    public static final String SORT_BY_PROXIMITY_CMD = "sort-by-proximity-cmd";
    private static final String SAVE_NEIGHBORS_CMD = "save-k-neighbors";
    private static final String SAVE_MATRIX_CMD = "save-matrix";

    public GDMExpViewer() {
    }

    public GDMExpViewer(IFramework fmwk, AlgorithmData aData, String distMetric, int displayEvery, int[][] clusters, int numOfClusters) {
        this.setBackground(Color.white);
        this.framework = fmwk;
        this.distanceMetric = distMetric;
        IDisplayMenu menu = this.framework.getDisplayMenu();
        this.setElementWidth(this.elementSize.width);
        this.expData = fmwk.getData();
        this.experiment = this.expData.getExperiment();
        this.probes = this.expData.getFeaturesSize();
        this.featuresCount = this.expData.getFeaturesCount();
        this.displayEvery = displayEvery;
        this.expDistMatrix = aData.getMatrix("gdMatrix").getSubMatrix(displayEvery);
        this.rawMatrix = aData.getMatrix("rawMatrix").getSubMatrix(displayEvery);
        AlgorithmParameters params = aData.getParams();
        this.clusters = clusters;
        this.numOfClusters = numOfClusters;
        this.maxValue = params.getFloat("maxDist");
        this.minValue = params.getFloat("minDist");
        this.origMaxValue = this.maxValue;
        this.origMinValue = this.minValue;
        this.maxExpNameLength = params.getInt("maxExpNameLength");
        this.num_experiments = this.featuresCount / displayEvery;
        this.borderColor = Color.black;
        this.clusterBorderColor = Color.white;
        this.insets = new Insets(1, 1, 1, 1);
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        if (this.displayEvery == 1) {
            this.setIndices(this.createIndices());
        } else if (this.displayEvery > 1) {
            this.setIndices(this.createIndices(this.displayEvery));
        }
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addKeyListener(listener);
        this.expColumnHeaderSP = this.createHeader(50, true, this.xWidth, 500, this.elementSize);
        this.expRowHeaderSP = this.createHeader(50, false, 500, this.xHeight, this.elementSize);
        this.expColumnHeaderSP.setMatrixListener(listener);
        this.expRowHeaderSP.setMatrixListener(listener);
        this.content = this.createContent(400, 400, listener);
        this.upperRightCornerSB = this.createScrollBar(1);
        this.lowerLeftCornerSB = this.createScrollBar(0);
        this.setMaxWidth(this.content, this.expColumnHeaderSP);
        this.setMaxHeight(this.content, this.expRowHeaderSP);
        this.expColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.expRowHeaderSP.setPosColorImages(this.posColorImage);
        this.expColumnHeaderSP.setIndices(this.indices);
        this.expRowHeaderSP.setIndices(this.indices);
        this.add(this.content);
        this.popup = this.createJPopupMenu(listener);
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, this.expDistMatrix, this.rawMatrix, new Integer(this.probes), new Integer(this.featuresCount), new Float(this.minValue), this.distanceMetric, new Float(this.origMaxValue), new Float(this.origMinValue), new Float(this.maxValue), new Integer(this.maxExpNameLength), new Integer(this.displayEvery), this.clusters, new Integer(this.numOfClusters)});
    }

    public GDMExpViewer(Experiment e, FloatMatrix expDistMatrix, FloatMatrix rawMatrix, Integer probes, Integer featuresCount, Float minValue, String distMetric, Float origMaxValue, Float origMinValue, Float maxValue, Integer maxExpNameLength, Integer displayEvery, int[][] clusters, Integer numOfClusters) {
        this.setBackground(Color.white);
        this.distanceMetric = distMetric;
        this.setElementWidth(this.elementSize.width);
        this.probes = probes;
        this.featuresCount = featuresCount;
        this.displayEvery = displayEvery;
        this.expDistMatrix = expDistMatrix;
        this.rawMatrix = rawMatrix;
        this.clusters = clusters;
        this.numOfClusters = numOfClusters;
        this.maxValue = maxValue.floatValue();
        this.minValue = minValue.floatValue();
        this.origMaxValue = origMaxValue.floatValue();
        this.origMinValue = origMinValue.floatValue();
        this.maxExpNameLength = maxExpNameLength;
        this.num_experiments = this.featuresCount / displayEvery;
        this.borderColor = Color.black;
        this.clusterBorderColor = Color.white;
        this.insets = new Insets(1, 1, 1, 1);
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        if (this.displayEvery == 1) {
            this.setIndices(this.createIndices());
        } else if (this.displayEvery > 1) {
            this.setIndices(this.createIndices(this.displayEvery));
        }
        this.experiment = e;
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addKeyListener(listener);
        this.expColumnHeaderSP = this.createHeader(50, true, this.xWidth, 500, this.elementSize);
        this.expRowHeaderSP = this.createHeader(50, false, 500, this.xHeight, this.elementSize);
        this.expColumnHeaderSP.setMatrixListener(listener);
        this.expRowHeaderSP.setMatrixListener(listener);
        this.content = this.createContent(400, 400, listener);
        this.upperRightCornerSB = this.createScrollBar(1);
        this.lowerLeftCornerSB = this.createScrollBar(0);
        this.setMaxWidth(this.content, this.expColumnHeaderSP);
        this.setMaxHeight(this.content, this.expRowHeaderSP);
        this.expColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.expRowHeaderSP.setPosColorImages(this.posColorImage);
        this.expColumnHeaderSP.setIndices(this.indices);
        this.expRowHeaderSP.setIndices(this.indices);
        this.add(this.content);
        this.popup = this.createJPopupMenu(listener);
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    public void setExperiment(Experiment e) {
        this.experiment = e;
    }

    public void setMainFrame(JFrame mframe) {
        this.mainframe = mframe;
    }

    private void setIndices(int[] indexes) {
        this.indices = indexes;
    }

    private int[] getIndices() {
        return this.indices;
    }

    private int[] createIndices(int displayEvery) {
        int indicesSize = this.num_experiments;
        int[] indices = new int[indicesSize];
        int i = 0;
        int total = 0;
        int index = 0;
        for (index = 0; index < this.probes; ++index) {
            if (total % this.displayEvery == 0 && i < indicesSize) {
                indices[i] = index;
                ++i;
            }
            ++total;
        }
        total = 0;
        if (this.numOfClusters > 0) {
            this.clusterlength = new int[this.numOfClusters];
            i = 0;
            for (int j = 0; j < this.numOfClusters; ++j) {
                for (int k = 0; k < this.clusters[j].length; ++k) {
                    if (total % this.displayEvery == 0 && i < indicesSize) {
                        indices[i] = this.clusters[j][k];
                        ++i;
                        int n = j;
                        this.clusterlength[n] = this.clusterlength[n] + 1;
                    }
                    ++total;
                }
            }
        }
        return indices;
    }

    private int[] createIndices() {
        int i;
        int[] indices = new int[this.num_experiments];
        for (i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        if (this.numOfClusters > 0) {
            this.clusterlength = new int[this.num_experiments];
            i = 0;
            for (int j = 0; j < this.numOfClusters; ++j) {
                for (int k = 0; k < this.clusters[j].length; ++k) {
                    indices[i] = this.clusters[j][k];
                    int n = j;
                    this.clusterlength[n] = this.clusterlength[n] + 1;
                    ++i;
                }
            }
        }
        return indices;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    private void setMaxHeight(JComponent content, JComponent header) {
        int c_height = content.getPreferredSize().height;
        int h_height = header.getPreferredSize().height;
        if (c_height > h_height) {
            header.setPreferredSize(new Dimension(header.getPreferredSize().width, c_height));
        } else {
            content.setPreferredSize(new Dimension(content.getPreferredSize().width, h_height));
        }
    }

    public BufferedImage getPosColorImage() {
        return this.posColorImage;
    }

    public BufferedImage getNegColorImage() {
        return this.negColorImage;
    }

    public void setPosColorImage(BufferedImage image) {
        this.posColorImage = image;
    }

    public void setNegColorImage(BufferedImage image) {
        this.negColorImage = image;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    private GDMExpHeader createHeader(int tracespace, boolean colHdr, int width, int height, Dimension eSize) {
        GDMExpHeader hdr = new GDMExpHeader(this.insets, tracespace, colHdr, this.experiment, width, height, eSize, this.maxExpNameLength, this.featuresCount, this.indices);
        return hdr;
    }

    private JPanel createContent(int width, int height, Listener listener) {
        JPanel cPanel = new JPanel(new BorderLayout());
        cPanel.setBackground(Color.white);
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        cPanel.setSize(this.xWidth + 5, this.xHeight + 5);
        cPanel.setPreferredSize(new Dimension(this.xWidth + 5, this.xHeight + 5));
        cPanel.setOpaque(true);
        cPanel.setVisible(true);
        return cPanel;
    }

    private JScrollBar createScrollBar(int orientation) {
        JScrollBar jsb = new JScrollBar(orientation);
        if (orientation == 1) {
            jsb.setModel(this.expColumnHeaderSP.getVerticalScrollBar().getModel());
        } else {
            jsb.setModel(this.expRowHeaderSP.getHorizontalScrollBar().getModel());
        }
        return jsb;
    }

    private int getTopIndex(int top) {
        if (top < 0) {
            return 0;
        }
        return (top - this.insets.top) / this.elementSize.height;
    }

    private int getLeftIndex(int left) {
        if (left < 0) {
            return 0;
        }
        return (left - this.insets.left) / (this.elementSize.width + this.getSpacing());
    }

    private int getRightIndex(int right, int limit) {
        if (right < 0) {
            return 0;
        }
        int result = (right - this.insets.left) / (this.elementSize.width + this.getSpacing()) + 1;
        return result > limit ? limit : result;
    }

    private int getBottomIndex(int bottom, int limit) {
        if (bottom < 0) {
            return 0;
        }
        int result = (bottom - this.insets.top) / this.elementSize.height + 1;
        return result > limit ? limit : result;
    }

    @Override
    public void paint(Graphics g1D) {
        super.paint(g1D);
        if (this.num_experiments == 0 || this.framework == null) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g1D;
        if (this.isAntiAliasing) {
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.drawColumns(g2D);
        if (this.isDrawClusterBorders && this.numOfClusters > 0) {
            this.drawClusterBorder(g2D);
        }
    }

    private void drawClusterBorder(Graphics2D g2d) {
        int xPosition = this.insets.left;
        int yPosition = this.insets.top;
        int width = 0;
        int height = 0;
        Graphics2D g = g2d;
        g.setColor(this.clusterBorderColor);
        for (int i = 0; i < this.numOfClusters; ++i) {
            height = this.clusterlength[i] * (this.elementSize.height + this.getSpacing());
            xPosition = this.insets.left;
            for (int j = 0; j < this.numOfClusters; ++j) {
                width = this.clusterlength[j] * (this.elementSize.width + this.getSpacing());
                g.drawRect(xPosition, yPosition, width, height);
                xPosition += width;
            }
            yPosition += height;
        }
    }

    private void drawRowColorBar(Graphics2D g) {
        Rectangle bounds = g.getClipBounds();
        int top = this.getTopIndex(bounds.y);
        int bottom = 0;
        bottom = this.getBottomIndex(bounds.y + bounds.height, this.featuresCount);
        for (int row = top; row < bottom; ++row) {
            this.fillRowClusterRectAt(g, row, 5);
        }
    }

    private void fillRowClusterRectAt(Graphics g, int row, int xLoc) {
        Color expColor = null;
        expColor = this.expData.getExperimentColor(this.indices[row]);
        if (expColor == null) {
            expColor = Color.white;
        }
        g.setColor(expColor);
        g.fillRect(xLoc, row * this.elementSize.height + this.insets.top, this.elementSize.width, this.elementSize.height);
    }

    private void drawColumnColorBar(Graphics2D g) {
        Rectangle bounds = g.getClipBounds();
        int left = this.getLeftIndex(bounds.x);
        int right = 0;
        right = this.getRightIndex(bounds.x + bounds.width, this.featuresCount);
        for (int column = left; column < right; ++column) {
            this.fillColumnClusterRectAt(g, 5, column);
        }
    }

    private void fillColumnClusterRectAt(Graphics g, int yLoc, int column) {
        Color expColor = null;
        expColor = this.expData.getExperimentColor(this.indices[column]);
        if (expColor == null) {
            expColor = Color.white;
        }
        g.setColor(expColor);
        g.fillRect(column * this.elementSize.width + this.insets.top, yLoc, this.elementSize.width, this.elementSize.height);
    }

    private void drawColumns(Graphics2D g) {
        Rectangle bounds = g.getClipBounds();
        int top = this.getTopIndex(bounds.y);
        int left = this.getLeftIndex(bounds.x);
        int bottom = 0;
        int right = 0;
        bottom = this.getBottomIndex(bounds.y + bounds.height, this.featuresCount);
        right = this.getRightIndex(bounds.x + bounds.width, this.featuresCount);
        for (int column = left; column < right; ++column) {
            this.drawColumn(g, column, top, bottom);
        }
        this.drawPerimeter(g);
    }

    private void drawPerimeter(Graphics2D g) {
        Color color = g.getColor();
        g.setColor(Color.black);
        if (this.isDrawClusterBorders && this.numOfClusters > 0) {
            g.drawRect(0, 0, this.getXSize() - this.insets.right + 1, this.getYSize() - this.insets.bottom + 1);
        } else {
            g.drawRect(0, 0, this.getXSize() - this.insets.right, this.getYSize() - this.insets.bottom);
        }
        g.setColor(color);
    }

    private void drawColumn(Graphics2D g, int column, int top, int bottom) {
        for (int row = top; row < bottom; ++row) {
            this.drawSlideDataElement(g, row, column);
        }
    }

    private void drawSlideDataElement(Graphics g, int row, int column) {
        float distance = this.expDistMatrix.get(this.indices[row], this.indices[column]);
        Color holdColor = Float.isNaN(distance) ? NaNColor : (distance == 0.0f && row == column ? diagColor : (distance == 0.0f && row != column ? zeroColor : this.getColor(distance)));
        g.setColor(holdColor);
        g.fillRect(this.getXPos(column), this.getYPos(row), this.elementSize.width, this.elementSize.height);
        if (this.isDrawBorders && this.elementSize.width > 2) {
            g.setColor(this.borderColor);
            g.drawRect(this.getXPos(column), this.getYPos(row), this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    private BufferedImage createGradientImage(Color color1, Color color2) {
        BufferedImage image = new BufferedImage(256, 1, 5);
        Graphics2D graphics = image.createGraphics();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, 255.0f, 0.0f, color2);
        graphics.setPaint(gp);
        graphics.drawRect(0, 0, 255, 1);
        return image;
    }

    private Color getColor(float value) {
        if (Float.isNaN(value) || this.posColorImage == null || this.negColorImage == null) {
            return NaNColor;
        }
        int colorIndex = (int)(255.0f * (value - this.minValue) / this.maxValue);
        if (colorIndex > 255) {
            colorIndex = 255;
        }
        if (colorIndex < 0) {
            colorIndex = 0;
        }
        int rgb = value < 0.0f ? this.negColorImage.getRGB(255 - colorIndex, 0) : this.posColorImage.getRGB(colorIndex, 0);
        return new Color(rgb);
    }

    private void setFontSize(int width) {
        if (width > 12) {
            width = 12;
        }
        this.setFont(new Font("monspaced", 0, width));
    }

    public void setElementWidth(int width) {
        this.elementWidth = width;
        this.setFontSize(width);
    }

    public int getElementWidth() {
        return this.elementWidth;
    }

    void setTracing(boolean isTracing) {
        this.isTracing = isTracing;
    }

    private int getSpacing() {
        if (this.isTracing) {
            return this.tracespace;
        }
        return 0;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return this.expColumnHeaderSP;
    }

    public JComponent getColumnHeaderComponent() {
        return this.expColumnHeaderSP;
    }

    public JComponent getRowHeaderComponent() {
        return this.expRowHeaderSP;
    }

    public JComponent getUpperRightCornerSB() {
        return this.upperRightCornerSB;
    }

    public JComponent getLowerLeftCornerSB() {
        return this.lowerLeftCornerSB;
    }

    private int getXSize() {
        int size = 0;
        size = this.featuresCount * this.elementSize.width + ((this.featuresCount - 1) * this.getSpacing() + this.insets.left + this.insets.right);
        return size;
    }

    private int getYSize() {
        int size = 0;
        size = this.featuresCount * this.elementSize.height + ((this.featuresCount - 1) * this.getSpacing() + this.insets.top + this.insets.bottom);
        return size;
    }

    private int getMaxExpNameLength() {
        return this.maxExpNameLength;
    }

    private void updateSize(int annotationSize) {
        int width = this.getXSize();
        int height = this.getYSize();
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
        this.expColumnHeaderSP.setNumExperiments(this.featuresCount);
        this.expColumnHeaderSP.updateSize(annotationSize);
        this.expRowHeaderSP.setNumExperiments(this.featuresCount);
        this.expRowHeaderSP.updateSize(annotationSize);
        this.setMaxWidth(this.content, this.expColumnHeaderSP);
        this.setMaxHeight(this.content, this.expRowHeaderSP);
        this.expColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.expRowHeaderSP.setPosColorImages(this.posColorImage);
        this.upperRightCornerSB.setValues(190, 10, 100, 200);
        this.lowerLeftCornerSB.setValues(100, 10, 100, 200);
        this.expColumnHeaderSP.repaint();
        this.expRowHeaderSP.repaint();
        this.repaint();
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.expData = framework.getData();
        this.onDataChanged(this.expData);
        this.probes = this.expData.getFeaturesSize();
        this.featuresCount = this.expData.getFeaturesCount();
        this.num_experiments = this.featuresCount / this.displayEvery;
        IDisplayMenu menu = framework.getDisplayMenu();
        this.setFontSize(this.elementSize.width);
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        this.expColumnHeaderSP.setData(this.expData);
        this.expColumnHeaderSP.setContentWidth(this.xWidth + 10);
        this.expColumnHeaderSP.setElementWidth(this.elementSize.width);
        this.expRowHeaderSP.setData(this.expData);
        this.expRowHeaderSP.setContentHeight(this.xHeight + 10);
        this.expRowHeaderSP.setElementHeight(this.elementSize.height);
        this.expColumnHeaderSP.repaint();
        this.expRowHeaderSP.repaint();
        this.onMenuChanged(menu);
        this.onDataChanged(this.expData);
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.probes = this.expData.getFeaturesSize();
        this.featuresCount = this.expData.getFeaturesCount();
        this.num_experiments = this.featuresCount / this.displayEvery;
        this.paletteStyle = menu.getPaletteStyle();
        this.isGRScale = menu.isGRScale();
        if (menu.isTracing() == this.isTracing && this.labelIndex == menu.getLabelIndex() && this.isAntiAliasing == menu.isAntiAliasing()) {
            return;
        }
        this.isAntiAliasing = menu.isAntiAliasing();
        this.expColumnHeaderSP.setAntiAliasing(this.isAntiAliasing);
        this.expRowHeaderSP.setAntiAliasing(this.isAntiAliasing);
        this.labelIndex = menu.getLabelIndex();
        this.isTracing = menu.isTracing();
        this.setFont(new Font("monospaced", 1, this.elementSize.height));
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        this.expColumnHeaderSP.setContentWidth(this.xWidth);
        this.expColumnHeaderSP.setElementWidth(this.elementSize.width);
        this.expColumnHeaderSP.setTracing(this.isTracing);
        this.expRowHeaderSP.setContentHeight(this.xHeight);
        this.expRowHeaderSP.setElementHeight(this.elementSize.height);
        this.expRowHeaderSP.setTracing(this.isTracing);
        this.expColumnHeaderSP.repaint();
        this.expRowHeaderSP.repaint();
        this.updateSize(-1);
    }

    public void onDataChanged(IData data) {
        this.expData = data;
        this.probes = this.expData.getFeaturesSize();
        this.featuresCount = this.expData.getFeaturesCount();
        this.num_experiments = this.featuresCount / this.displayEvery;
        this.expColumnHeaderSP.setData(data);
        this.expRowHeaderSP.setData(data);
        this.updateSize(-1);
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public BufferedImage getImage() {
        return null;
    }

    private boolean isLegalPosition(int row, int column) {
        return this.isLegalRow(row) && this.isLegalColumn(column);
    }

    private boolean isLegalColumn(int column) {
        return column >= 0 && column <= this.featuresCount - 1;
    }

    private boolean isLegalRow(int row) {
        return row >= 0 && row <= this.featuresCount - 1;
    }

    private int findColumn(int targetx) {
        int columnSize = this.elementSize.width + this.getSpacing();
        if (targetx > this.featuresCount * columnSize - this.getSpacing() + this.insets.left || targetx < this.insets.left) {
            return -1;
        }
        return targetx / columnSize;
    }

    private int findRow(int targety) {
        int rowSize = this.num_experiments * this.elementSize.height;
        if (targety > rowSize + this.insets.top || targety < this.insets.top) {
            return -1;
        }
        return targety / this.elementSize.height;
    }

    private int getXPos(int column) {
        return column * (this.elementSize.width + this.getSpacing()) + this.insets.left;
    }

    private int getYPos(int row) {
        return row * this.elementSize.height + this.insets.top;
    }

    private void drawColoredBoxAt(Graphics g, int row, int column, Color color) {
        g.setColor(color);
        g.drawRect(this.insets.left + column * (this.elementSize.width + this.getSpacing()), this.insets.top + row * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height - 1);
    }

    public void displayGDMSpotInfo(int col, int row) {
        new GDMExpSpotInfoDisplay(this.mainframe, this.expData, this.expDistMatrix, this.rawMatrix, this.distanceMetric, col, row);
    }

    private JCheckBoxMenuItem createJCheckBoxMenuItem(String name, String command, Listener listener, boolean isSelected) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(name);
        item.setActionCommand(command);
        item.addActionListener(listener);
        item.setSelected(isSelected);
        return item;
    }

    private JCheckBoxMenuItem createJCheckBoxMenuItem(String name, String command, Listener listener) {
        return this.createJCheckBoxMenuItem(name, command, listener, false);
    }

    private JRadioButtonMenuItem createJRadioButtonMenuItem(String name, String command, Listener listener, ButtonGroup buttonGroup, boolean isSelected) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(name);
        item.setActionCommand(command);
        item.addActionListener(listener);
        item.setSelected(isSelected);
        if (buttonGroup != null) {
            buttonGroup.add(item);
        }
        return item;
    }

    private JRadioButtonMenuItem createJRadioButtonMenuItem(String name, String command, Listener listener, ButtonGroup buttonGroup) {
        return this.createJRadioButtonMenuItem(name, command, listener, buttonGroup, false);
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    private void addMenuItems(JPopupMenu menu, Listener listener) {
        JMenu colorSchemeMenu = new JMenu("Color Scheme");
        ButtonGroup buttonGroup = new ButtonGroup();
        colorSchemeMenu.add(this.createJRadioButtonMenuItem("Black/Red Scheme", GREEN_RED_COLOR_SCHEME_CMD, listener, buttonGroup, true));
        colorSchemeMenu.add(this.createJRadioButtonMenuItem("Black/Yellow Scheme", BLUE_YELLOW_COLOR_SCHEME_CMD, listener, buttonGroup));
        colorSchemeMenu.add(this.createJRadioButtonMenuItem("Custom Color Scheme", CUSTOM_COLOR_SCHEME_CMD, listener, buttonGroup));
        menu.add(colorSchemeMenu);
        menu.addSeparator();
        JMenu sizeMenu = new JMenu("Element Size");
        buttonGroup = new ButtonGroup();
        sizeMenu.add(this.createJRadioButtonMenuItem("2 x 2", DISPLAY_2X2_CMD, listener, buttonGroup));
        sizeMenu.add(this.createJRadioButtonMenuItem("5 x 5", DISPLAY_5X5_CMD, listener, buttonGroup));
        sizeMenu.add(this.createJRadioButtonMenuItem("10 x 10", DISPLAY_10X10_CMD, listener, buttonGroup));
        sizeMenu.add(this.createJRadioButtonMenuItem("15 x 15", DISPLAY_15X15_CMD, listener, buttonGroup, true));
        sizeMenu.add(this.createJRadioButtonMenuItem("Other", DISPLAY_OTHER_CMD, listener, buttonGroup));
        menu.add(sizeMenu);
        menu.addSeparator();
        menu.add(this.createJCheckBoxMenuItem("Draw Borders", DISPLAY_DRAW_BORDERS_CMD, listener));
        menu.addSeparator();
        JMenuItem item = new JMenuItem("Toggle Sort on Proximity");
        item.setActionCommand(TOGGLE_PROXIMITY_SORT_CMD);
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Save k Neighbors");
        item.setActionCommand(SAVE_NEIGHBORS_CMD);
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Save Distance Matrix");
        item.setActionCommand(SAVE_MATRIX_CMD);
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Impose Cluster Result");
        item.setActionCommand("impose-cluster-order");
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Restore Loaded Order");
        item.setActionCommand(SORT_BY_ORIGINAL_ORDER_CMD);
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Select Border Color");
        item.setActionCommand(BORDER_COLOR_CMD);
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Set Color Scale");
        item.setActionCommand(COLOR_SCALE_CMD);
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(CHANGE_ANNOTATION_WIDTH);
        item.setActionCommand(ANNOTATION_WIDTH_CMD);
        item.addActionListener(listener);
        menu.add(item);
    }

    private void onElementSizeChanged(int width, int height) {
        this.elementSize = new Dimension(width, height);
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        this.expColumnHeaderSP.setContentWidth(this.xWidth);
        this.expColumnHeaderSP.setElementWidth(this.elementSize.width);
        this.expColumnHeaderSP.setElementHeight(this.elementSize.height);
        this.expRowHeaderSP.setContentHeight(this.xHeight);
        this.expRowHeaderSP.setElementWidth(this.elementSize.width);
        this.expRowHeaderSP.setElementHeight(this.elementSize.height);
        this.expColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.expRowHeaderSP.setPosColorImages(this.posColorImage);
        this.updateSize(-1);
    }

    private void onElementSizeChanged() {
        GDMElementSizeDialog dialog = new GDMElementSizeDialog(this.mainframe, this.elementSize);
        if (dialog.showModal() == 0) {
            Dimension size = dialog.getElementSize();
            this.onElementSizeChanged(size.width, size.height);
        }
    }

    private void onDrawBordersChanged(boolean state) {
        this.isDrawBorders = state;
        this.expColumnHeaderSP.repaint();
        this.repaint();
    }

    private void onDrawClusterBorderChange(boolean state) {
        if (this.numOfClusters > 0) {
            this.isDrawClusterBorders = state;
            this.expColumnHeaderSP.repaint();
            this.repaint();
        }
    }

    private void onColorSchemeChange(int scheme) {
        if (this.colorScheme == scheme && scheme != 7) {
            return;
        }
        if (scheme == 5) {
            this.setPosColorImage(this.posRedColorImage);
            this.colorScheme = scheme;
        } else if (scheme == 6) {
            this.setPosColorImage(this.posYellowColorImage);
            this.colorScheme = scheme;
        } else {
            GDMColorSelectionDialog dialog = new GDMColorSelectionDialog((Frame)this.mainframe, true, this.getPosColorImage());
            if (dialog.showModal() != 0) {
                return;
            }
            this.setPosColorImage(dialog.getPositiveGradient());
            this.colorScheme = scheme;
        }
        this.expColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.expRowHeaderSP.setPosColorImages(this.posColorImage);
        this.expColumnHeaderSP.repaint();
        this.expRowHeaderSP.repaint();
        this.repaint();
    }

    private void onBorderColorChanged() {
        GDMBorderColorDialog dialog = new GDMBorderColorDialog((Frame)this.mainframe, true, this.borderColor);
        if (dialog.showModal() != 0) {
            return;
        }
        this.setBorderColor(dialog.getBorderColor());
        this.expColumnHeaderSP.repaint();
        this.repaint();
    }

    private void onColorScaleChanged() {
        BufferedImage grad = this.getPosColorImage();
        Color lowerColor = new Color(grad.getRGB(0, 0));
        Color upperColor = new Color(grad.getRGB(grad.getWidth() - 1, 0));
        GDMColorScaleDialog dialog = new GDMColorScaleDialog(this.mainframe, this.minValue, this.maxValue, this.expDistMatrix, this.num_experiments, lowerColor, upperColor);
        dialog.setGDMScaleListener(new ScaleListener());
        int res = dialog.showModal();
        this.minValue = dialog.getLowerLimit();
        this.maxValue = dialog.getUpperLimit();
        this.expColumnHeaderSP.setValues(this.minValue, this.maxValue);
        this.expRowHeaderSP.setValues(this.minValue, this.maxValue);
        this.expColumnHeaderSP.updateSize(-1);
        this.expRowHeaderSP.updateSize(-1);
        this.validate();
        this.expColumnHeaderSP.repaint();
        this.expRowHeaderSP.repaint();
        this.repaint();
    }

    private void onAnnotationWidthChanged() {
        GDMAnnotationSizeDialog dialog = new GDMAnnotationSizeDialog(this.mainframe);
        if (dialog.showModal() == 0) {
            int annotationSize = dialog.getAnnotationSize();
            this.expColumnHeaderSP.setAnnotationSize(annotationSize);
            this.expRowHeaderSP.setAnnotationSize(annotationSize);
            this.updateSize(annotationSize);
        }
    }

    private void toggleSortByProximity() {
        this.sortByProximity = !this.sortByProximity;
        this.expColumnHeaderSP.setSortByProximity(this.sortByProximity);
        this.expRowHeaderSP.setSortByProximity(this.sortByProximity);
    }

    private void onSortByProximity(int baseIndex) {
        this.isDrawClusterBorders = false;
        this.numOfClusters = 0;
        QSort qsort = new QSort(this.expDistMatrix.A[baseIndex]);
        int[] sortedIndices = qsort.getOrigIndx();
        if (sortedIndices[0] != baseIndex) {
            boolean notFound = true;
            for (int i = 0; i < sortedIndices.length && notFound; ++i) {
                if (sortedIndices[i] != baseIndex) continue;
                sortedIndices[i] = sortedIndices[0];
                sortedIndices[0] = baseIndex;
                notFound = false;
            }
        }
        this.setIndices(sortedIndices);
        this.expColumnHeaderSP.setIndices(sortedIndices);
        this.expRowHeaderSP.setIndices(sortedIndices);
        this.onDataChanged(this.expData);
        this.validate();
        this.expColumnHeaderSP.repaint();
        this.expRowHeaderSP.repaint();
    }

    private void onSortByExperimentName() {
        int i;
        String[] expNames = new String[this.indices.length];
        Object[] sortedExpNames = new String[this.indices.length];
        int[] sortedIndices = new int[this.indices.length];
        for (i = 0; i < this.indices.length; ++i) {
            expNames[i] = this.expData.getSampleName(this.indices[i]);
            sortedExpNames[i] = this.expData.getSampleName(this.indices[i]);
        }
        Arrays.sort(sortedExpNames);
        for (i = 0; i < this.indices.length; ++i) {
            for (int j = 0; j < this.indices.length; ++j) {
                if (!expNames[i].equals(sortedExpNames[j])) continue;
                sortedIndices[i] = this.indices[j];
            }
        }
        this.expColumnHeaderSP.setIndices(sortedIndices);
        this.expRowHeaderSP.setIndices(sortedIndices);
        this.onDataChanged(this.expData);
        this.validate();
        this.expColumnHeaderSP.repaint();
        this.expRowHeaderSP.repaint();
    }

    private void onSortByClusterChange() {
        if (this.numOfClusters > 0) {
            this.isDrawClusterBorders = true;
            if (this.displayEvery == 1) {
                this.setIndices(this.createIndices());
            } else if (this.displayEvery > 1) {
                this.setIndices(this.createIndices(this.displayEvery));
            }
            this.expColumnHeaderSP.setIndices(this.indices);
            this.expRowHeaderSP.setIndices(this.indices);
            this.onDataChanged(this.expData);
        }
    }

    private void onRestoreOriginalOrder() {
        this.numOfClusters = 0;
        this.setIndices(this.createIndices(this.displayEvery));
        this.isDrawClusterBorders = false;
        this.expColumnHeaderSP.setIndices(this.indices);
        this.expRowHeaderSP.setIndices(this.indices);
        this.onDataChanged(this.expData);
        this.validate();
        this.expColumnHeaderSP.repaint();
        this.expRowHeaderSP.repaint();
    }

    private void setLabelIndex(int style) {
        this.label = style;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        if (cornerIndex == 1) {
            return this.upperRightCornerSB;
        }
        if (cornerIndex == 2) {
            return this.lowerLeftCornerSB;
        }
        return null;
    }

    private void onSaveNeighbors() {
        GDMMemberSelectionDialog dialog = new GDMMemberSelectionDialog(new JFrame(), this.num_experiments);
        if (dialog.showModal() == 0) {
            int k = dialog.getK();
            if (k <= 0) {
                return;
            }
            if (k > this.num_experiments) {
                k = this.num_experiments;
            }
            int[] rows = this.getRows(k);
            Object[][] auxData = this.getAuxilaryData(k);
            String[] auxHeaders = new String[]{"Scaled Dist.", "Actual Dist.", "Value Pairs"};
            try {
                ExperimentUtil.saveExperimentClusterWithAux((Frame)this.framework.getFrame(), (Experiment)this.experiment, (IData)this.expData, (int[])rows, (String[])auxHeaders, (Object[][])auxData);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error saving file: " + e.getMessage(), "Output Error", 2);
            }
        }
    }

    private void onSaveMatrix() {
        JFileChooser chooser = new JFileChooser(TMEV.getDataPath());
        if (chooser.showSaveDialog(this) == 0) {
            try {
                PrintWriter bw = new PrintWriter(new FileWriter(chooser.getSelectedFile()));
                int rows = this.expDistMatrix.getRowDimension();
                int cols = this.expDistMatrix.getColumnDimension();
                Date da = new Date(System.currentTimeMillis());
                bw.println("# Save Date: " + da.toString());
                bw.println("# Distance Metric: " + this.distanceMetric);
                bw.println("#");
                String line = "\t";
                for (int i = 0; i < cols; ++i) {
                    line = line + this.framework.getData().getSampleName(this.indices[i]);
                    if (i >= cols - 1) continue;
                    line = line + "\t";
                }
                bw.println(line);
                line = "";
                for (int row = 0; row < rows; ++row) {
                    line = line + this.framework.getData().getSampleName(this.indices[row]) + "\t";
                    for (int col = 0; col < cols; ++col) {
                        line = line + Float.toString(this.rawMatrix.get(this.indices[row], this.indices[col]));
                        if (col >= cols - 1) continue;
                        line = line + "\t";
                    }
                    bw.println(line);
                    line = "";
                }
                bw.flush();
                bw.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private int[] getRows(int k) {
        int[] rows = new int[k];
        for (int i = 0; i < k; ++i) {
            rows[i] = this.indices[i];
        }
        return rows;
    }

    private String[][] getAuxilaryData(int k) {
        String[][] data = new String[k][3];
        FloatMatrix matrix = this.experiment.getMatrix().transpose();
        for (int i = 0; i < k; ++i) {
            data[i][0] = Float.toString(this.expDistMatrix.get(this.indices[0], i));
            data[i][1] = Float.toString(this.rawMatrix.get(this.indices[0], i));
            data[i][2] = this.getValuePairCount(matrix, this.indices[0], i);
        }
        return data;
    }

    private String getValuePairCount(FloatMatrix matrix, int row, int col) {
        int cols = matrix.getColumnDimension();
        int count = 0;
        for (int i = 0; i < cols; ++i) {
            if (Float.isNaN(matrix.get(row, i)) || Float.isNaN(matrix.get(col, i))) continue;
            ++count;
        }
        return Integer.toString(count);
    }

    private void imposeClusterOrder() {
        Hashtable results = this.getResultHash();
        boolean noUseableResult = false;
        Hashtable<String, Object> goodResults = new Hashtable<String, Object>();
        Enumeration keys = results.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object[] result = (Object[])results.get(key);
            if (key.indexOf("HCL") != -1) {
                int[][] clusters = new int[][]{((int[][])result[1])[1]};
                if (clusters[0] == null || this.experiment != result[0] || !this.checkClustersSize(clusters)) continue;
                goodResults.put(key, clusters);
                continue;
            }
            if (this.experiment != result[0] || !this.checkClustersSize((int[][])result[1])) continue;
            goodResults.put(key, result[1]);
        }
        if (goodResults.size() > 0) {
            GDMResultSelectionDialog dialog = new GDMResultSelectionDialog((JFrame)this.framework.getFrame(), goodResults.keys());
            if (dialog.showModal() == 0) {
                int[][] clusters = (int[][])goodResults.get(dialog.getSelectedResult());
                this.imposeClusterOrder(clusters);
            }
        } else {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "There are currently no appropriate clustering results to apply to this GDM.", "No Results Available", 1);
        }
    }

    private boolean checkClustersSize(int[][] clusters) {
        int cnt = 0;
        for (int i = 0; i < clusters.length; ++i) {
            cnt += clusters[i].length;
        }
        return cnt / this.displayEvery == this.num_experiments;
    }

    public Hashtable getResultHash() {
        Hashtable<String, Object[]> table = new Hashtable<String, Object[]>();
        DefaultMutableTreeNode analysisNode = this.framework.getResultTree().getAnalysisNode();
        boolean stop = false;
        int childCount = analysisNode.getChildCount();
        String algName = "";
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode analysisRoot = (DefaultMutableTreeNode)analysisNode.getChildAt(i);
            Object object = analysisRoot.getUserObject();
            if (object == null) continue;
            if (object instanceof LeafInfo) {
                algName = ((LeafInfo)object).toString();
            } else if (object instanceof String) {
                algName = (String)object;
            }
            Enumeration<TreeNode> _enum = analysisRoot.depthFirstEnumeration();
            while (!stop && _enum.hasMoreElements()) {
                IViewer viewer;
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)_enum.nextElement();
                if (!(currentNode.getUserObject() instanceof LeafInfo) || (viewer = ((LeafInfo)currentNode.getUserObject()).getViewer()) == null) continue;
                Experiment exp = viewer.getExperiment();
                int[][] clusters = viewer.getClusters();
                if (exp == null || clusters == null) continue;
                Object[] vals = new Object[]{exp, clusters};
                table.put(algName, vals);
                stop = true;
            }
            stop = false;
        }
        return table;
    }

    private void imposeClusterOrder(int[][] newClusters) {
        this.clusters = newClusters;
        this.numOfClusters = this.clusters.length;
        this.onSortByClusterChange();
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public int getViewerType() {
        return 1;
    }

    public int getExperimentID() {
        return 0;
    }

    public void setExperimentID(int id) {
    }

    private class ScaleListener
    extends GDMScaleListener {
        private ScaleListener() {
        }

        @Override
        public void scaleChanged(float lower, float upper) {
            GDMExpViewer.this.minValue = lower;
            GDMExpViewer.this.maxValue = upper;
            GDMExpViewer.this.expColumnHeaderSP.setValues(GDMExpViewer.this.minValue, GDMExpViewer.this.maxValue);
            GDMExpViewer.this.expRowHeaderSP.setValues(GDMExpViewer.this.minValue, GDMExpViewer.this.maxValue);
            GDMExpViewer.this.expColumnHeaderSP.updateSize(-1);
            GDMExpViewer.this.expRowHeaderSP.updateSize(-1);
            GDMExpViewer.this.validate();
            GDMExpViewer.this.expColumnHeaderSP.repaint();
            GDMExpViewer.this.expRowHeaderSP.repaint();
            GDMExpViewer.this.repaint();
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener,
    KeyListener,
    WindowListener {
        private int oldRow = -1;
        private int oldColumn = -1;
        private String oldStatusText;

        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals(GDMExpViewer.ANNOTATION_WIDTH_CMD)) {
                GDMExpViewer.this.onAnnotationWidthChanged();
            } else if (command.equals(GDMExpViewer.DISPLAY_2X2_CMD)) {
                GDMExpViewer.this.onElementSizeChanged(2, 2);
            } else if (command.equals(GDMExpViewer.DISPLAY_5X5_CMD)) {
                GDMExpViewer.this.onElementSizeChanged(5, 5);
            } else if (command.equals(GDMExpViewer.DISPLAY_10X10_CMD)) {
                GDMExpViewer.this.onElementSizeChanged(10, 10);
            } else if (command.equals(GDMExpViewer.DISPLAY_15X15_CMD)) {
                GDMExpViewer.this.onElementSizeChanged(15, 15);
            } else if (command.equals(GDMExpViewer.DISPLAY_OTHER_CMD)) {
                GDMExpViewer.this.onElementSizeChanged();
            } else if (command.equals(GDMExpViewer.GREEN_RED_COLOR_SCHEME_CMD)) {
                GDMExpViewer.this.onColorSchemeChange(5);
            } else if (command.equals(GDMExpViewer.BLUE_YELLOW_COLOR_SCHEME_CMD)) {
                GDMExpViewer.this.onColorSchemeChange(6);
            } else if (command.equals(GDMExpViewer.CUSTOM_COLOR_SCHEME_CMD)) {
                GDMExpViewer.this.onColorSchemeChange(7);
            } else if (command.equals(GDMExpViewer.DISPLAY_DRAW_BORDERS_CMD)) {
                GDMExpViewer.this.onDrawBordersChanged(((JCheckBoxMenuItem)event.getSource()).isSelected());
            } else if (command.equals(GDMExpViewer.BORDER_COLOR_CMD)) {
                GDMExpViewer.this.onBorderColorChanged();
            } else if (command.equals(GDMExpViewer.COLOR_SCALE_CMD)) {
                GDMExpViewer.this.onColorScaleChanged();
            } else if (command.equals(GDMExpViewer.SET_CLUSTER_BORDER_CMD)) {
                GDMExpViewer.this.onDrawClusterBorderChange(((JCheckBoxMenuItem)event.getSource()).isSelected());
            } else if (command.equals(GDMExpViewer.TOGGLE_PROXIMITY_SORT_CMD)) {
                GDMExpViewer.this.toggleSortByProximity();
            } else if (command.equals(GDMExpViewer.SORT_BY_PROXIMITY_CMD)) {
                GDMExpViewer.this.onSortByProximity(event.getID());
            } else if (command.equals(GDMExpViewer.SAVE_NEIGHBORS_CMD)) {
                GDMExpViewer.this.onSaveNeighbors();
            } else if (command.equals(GDMExpViewer.SORT_BY_EXP_NAME_CMD)) {
                GDMExpViewer.this.onSortByExperimentName();
            } else if (command.equals(GDMExpViewer.SORT_BY_ORIGINAL_ORDER_CMD)) {
                GDMExpViewer.this.onRestoreOriginalOrder();
            } else if (command.equals("impose-cluster-order")) {
                GDMExpViewer.this.imposeClusterOrder();
            } else if (command.equals(GDMExpViewer.SAVE_MATRIX_CMD)) {
                GDMExpViewer.this.onSaveMatrix();
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            GDMExpViewer.this.requestFocus();
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (SwingUtilities.isLeftMouseButton(event)) {
                int column = GDMExpViewer.this.findColumn(event.getX());
                int row = GDMExpViewer.this.findRow(event.getY());
                if (!GDMExpViewer.this.isLegalPosition(row, column)) {
                    return;
                }
                GDMExpViewer.this.displayGDMSpotInfo(GDMExpViewer.this.indices[column], GDMExpViewer.this.indices[row]);
            } else {
                int column = GDMExpViewer.this.findColumn(event.getX());
                int row = GDMExpViewer.this.findRow(event.getY());
                GDMExpViewer.this.popup.show(event.getComponent(), event.getX(), event.getY());
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (GDMExpViewer.this.num_experiments == 0 || event.isShiftDown()) {
                return;
            }
            int column = GDMExpViewer.this.findColumn(event.getX());
            int row = GDMExpViewer.this.findRow(event.getY());
            if (this.isCurrentPosition(row, column)) {
                return;
            }
            Graphics g = null;
            Graphics2D g2D = (Graphics2D)g;
            if (GDMExpViewer.this.isLegalPosition(row, column)) {
                g = GDMExpViewer.this.getGraphics();
                GDMExpViewer.this.drawColoredBoxAt(g, row, column, Color.white);
                GDMExpViewer.this.framework.setStatusText(" Column " + column + "     " + " Row " + row + "     " + " Scaled Distance: " + GDMExpViewer.this.expDistMatrix.get(GDMExpViewer.this.indices[column], GDMExpViewer.this.indices[row]) + "     " + " Actual Distance: " + GDMExpViewer.this.rawMatrix.get(GDMExpViewer.this.indices[column], GDMExpViewer.this.indices[row]));
            } else {
                GDMExpViewer.this.framework.setStatusText(this.oldStatusText);
            }
            if (GDMExpViewer.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                g2D = g != null ? (Graphics2D)g : (Graphics2D)GDMExpViewer.this.getGraphics();
                GDMExpViewer.this.drawSlideDataElement(g2D, this.oldRow, this.oldColumn);
            }
            this.setOldPosition(row, column);
            if (g != null) {
                if (GDMExpViewer.this.isDrawClusterBorders && GDMExpViewer.this.numOfClusters > 0) {
                    GDMExpViewer.this.drawClusterBorder((Graphics2D)g);
                }
            } else if (g2D != null && GDMExpViewer.this.isDrawClusterBorders && GDMExpViewer.this.numOfClusters > 0) {
                GDMExpViewer.this.drawClusterBorder(g2D);
            }
            if (g != null) {
                if (GDMExpViewer.this.isDrawClusterBorders && GDMExpViewer.this.numOfClusters > 0) {
                    GDMExpViewer.this.drawClusterBorder((Graphics2D)g);
                }
                g.dispose();
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (GDMExpViewer.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                Graphics g = GDMExpViewer.this.getGraphics();
                Graphics2D g2D = (Graphics2D)g;
                GDMExpViewer.this.drawSlideDataElement(g2D, this.oldRow, this.oldColumn);
                g2D.dispose();
                if (GDMExpViewer.this.isDrawClusterBorders && GDMExpViewer.this.numOfClusters > 0) {
                    GDMExpViewer.this.drawClusterBorder(g2D);
                }
            }
            this.setOldPosition(-1, -1);
            GDMExpViewer.this.framework.setStatusText("  ");
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            this.oldStatusText = GDMExpViewer.this.framework.getStatusText();
        }

        private void setOldPosition(int row, int column) {
            this.oldColumn = column;
            this.oldRow = row;
        }

        private boolean isCurrentPosition(int row, int column) {
            return row == this.oldRow && column == this.oldColumn;
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }
}

