/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMExpGradientLabelPanel;

public class GDMExpHeader
extends JPanel {
    private static final String GDM_VECTOR_STRING = "GDM Vector";
    private int[] indices;
    private int labelIndex;
    private Insets insets;
    private int num_experiments;
    private boolean showClusters = true;
    private boolean hasColorBar = false;
    private boolean isColumnHeader;
    private IData expData;
    private int contentWidth;
    private int contentHeight;
    private int elementWidth;
    private int elementHeight;
    private int tracespace;
    private int maxExpNameLength;
    private Experiment experiment;
    private boolean isAntiAliasing = false;
    private boolean isTracing = true;
    private final int OFFSET = 2;
    private int annotationSize = 100;
    private final int MIN_LABEL_PANEL_SIZE = 1;
    private final int MAX_LABEL_PANEL_SIZE = 200;
    private static final int NOT_UPDATE_ANNOTATION_SIZE = -1;
    private GDMExpGradientLabelPanel gdmGradientLabelPanel;
    private GDMColorBarPanel gdmColorBarPanel;
    private float minValue = 0.0f;
    private float maxValue = 1.0f;
    private final int RECT_HEIGHT = 10;
    private final int RECT_WIDTH = 200;
    private int maxColorScaleTextWidth = 0;
    private int maxColorScaleTextHeight = 0;
    private int probes;
    private int headerWidth;
    private int headerHeight;
    private int gradientPanelWidth;
    private int gradientPanelHeight;
    private int labelPanelWidth;
    private int labelPanelHeight;
    private int colorBarWidth;
    private int colorBarHeight;
    private DecimalFormat decFormat;
    private boolean sortByProximity = true;
    private ActionListener matrixListener;
    private int currentIndex = 0;

    public GDMExpHeader(Insets insets, int tracespace, boolean colHdr, Experiment experiment, int width, int height, Dimension eSize, int maxExpLen, int num_experiments, int[] indexes) {
        this.setLayout(new BorderLayout());
        this.insets = new Insets(0, 0, 0, 0);
        this.indices = indexes;
        this.insets.left = insets.left;
        this.insets.right = insets.right;
        this.insets.top = insets.top;
        this.insets.bottom = insets.bottom;
        this.tracespace = tracespace;
        this.experiment = experiment;
        this.elementWidth = eSize.width;
        this.elementHeight = eSize.height;
        this.isColumnHeader = colHdr;
        this.contentWidth = width;
        this.contentHeight = height;
        this.probes = experiment.getNumberOfGenes();
        this.num_experiments = num_experiments;
        this.maxExpNameLength = maxExpLen * this.elementWidth;
        this.gdmGradientLabelPanel = new GDMExpGradientLabelPanel(insets, tracespace, colHdr, width, height, eSize, maxExpLen, num_experiments, this.indices);
        this.gdmColorBarPanel = new GDMColorBarPanel();
        this.setFontSize(this.elementWidth);
        if (this.isColumnHeader) {
            this.add((Component)this.gdmGradientLabelPanel, "North");
            if (this.hasColorBar) {
                this.add((Component)this.gdmColorBarPanel, "Center");
            }
        } else {
            this.add((Component)this.gdmGradientLabelPanel, "West");
            if (this.hasColorBar) {
                this.add((Component)this.gdmColorBarPanel, "Center");
            }
        }
        this.decFormat = new DecimalFormat();
        this.decFormat.setMaximumFractionDigits(3);
        this.decFormat.setMinimumFractionDigits(1);
        Listener listener = new Listener();
        this.gdmGradientLabelPanel.getLabelPanel().addMouseListener(listener);
        this.gdmGradientLabelPanel.getLabelPanel().addMouseMotionListener(listener);
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    public void setLabelIndex(int label) {
        this.labelIndex = label;
        this.gdmGradientLabelPanel.setLabelIndex(label);
    }

    public void updateSize(int size) {
        this.updateMaxExpNameLength();
        int expNameLength = this.getMaxExpNameLength();
        if (size == -1) {
            if (expNameLength < 1) {
                this.setAnnotationSize(1);
            } else if (expNameLength > 200) {
                this.setAnnotationSize(200);
            } else {
                this.setAnnotationSize(expNameLength);
            }
        } else {
            this.setAnnotationSize(size);
        }
        boolean tempBool = false;
        if (this.showClusters) {
            tempBool = this.areExperimentsColored();
            if (tempBool && !this.hasColorBar) {
                this.add((Component)this.gdmColorBarPanel, "Center");
                this.validate();
            } else if (!tempBool && this.hasColorBar) {
                this.remove(this.gdmColorBarPanel);
                this.validate();
            }
            this.hasColorBar = tempBool;
        } else {
            this.hasColorBar = false;
        }
        if (this.isColumnHeader) {
            this.gradientPanelWidth = this.headerWidth = this.contentWidth + this.elementWidth / 2;
            this.labelPanelWidth = this.headerWidth;
            this.colorBarWidth = this.headerWidth;
            this.colorBarHeight = 0;
        } else {
            this.gradientPanelHeight = this.headerHeight = this.contentHeight + this.elementHeight / 2;
            this.labelPanelHeight = this.headerHeight;
            this.colorBarWidth = 0;
            this.colorBarHeight = this.headerHeight;
        }
        Graphics2D g = (Graphics2D)this.getColorScaleGraphics();
        if (g != null) {
            FontMetrics hfm = g.getFontMetrics();
            this.maxColorScaleTextHeight = hfm.getHeight();
            float midValue = (this.minValue + this.maxValue) / 2.0f;
            String minString = this.decFormat.format(this.minValue);
            String maxString = this.decFormat.format(this.maxValue);
            String midString = this.decFormat.format(midValue);
            int textWidth1 = hfm.stringWidth(minString);
            int textWidth2 = hfm.stringWidth(maxString);
            int textWidth3 = hfm.stringWidth(midString);
            this.maxColorScaleTextWidth = Math.max(Math.max(textWidth1, textWidth2), textWidth3);
        }
        int maxTextSize = Math.max(this.maxColorScaleTextWidth, this.maxColorScaleTextHeight);
        if (this.isColumnHeader) {
            this.gradientPanelHeight = 14 + this.maxColorScaleTextHeight;
            this.labelPanelHeight = this.annotationSize + 10;
            this.colorBarHeight = this.hasColorBar ? 2 + (this.elementHeight >= 10 ? this.elementHeight : 10) : 0;
            this.headerHeight = this.gradientPanelHeight + this.labelPanelHeight + this.colorBarHeight;
        } else {
            this.gradientPanelWidth = 14 + this.maxColorScaleTextWidth;
            this.labelPanelWidth = this.annotationSize + 10;
            this.colorBarWidth = this.hasColorBar ? 2 + (this.elementWidth >= 10 ? this.elementWidth : 10) : 0;
            this.headerWidth = this.gradientPanelWidth + this.labelPanelWidth + this.colorBarWidth;
        }
        this.setSize(this.headerWidth, this.headerHeight);
        this.setPreferredSize(new Dimension(this.headerWidth, this.headerHeight));
        this.gdmGradientLabelPanel.updateSize();
        this.gdmColorBarPanel.updateSize();
    }

    private Graphics getColorScaleGraphics() {
        return this.gdmGradientLabelPanel.getColorScaleGraphics();
    }

    public void setMatrixListener(ActionListener aL) {
        this.matrixListener = aL;
    }

    public void setSortByProximity(boolean allowSort) {
        this.sortByProximity = allowSort;
    }

    private void updateMaxExpNameLength() {
        Graphics2D g = (Graphics2D)this.gdmGradientLabelPanel.getLabelPanelGraphics();
        if (g == null) {
            return;
        }
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fm = g.getFontMetrics();
        double maxLength = 0.0;
        for (int i = 0; i < this.num_experiments; ++i) {
            String expName = this.expData.getSampleName(i);
            maxLength = Math.max(maxLength, (double)fm.stringWidth(expName));
        }
        this.maxExpNameLength = (int)maxLength;
    }

    private int getMaxExpNameLength() {
        return this.maxExpNameLength;
    }

    private void setMaxExpNameLength(int val) {
        this.maxExpNameLength = val;
    }

    public void setNumExperiments(int num_experiments) {
        this.num_experiments = num_experiments;
        this.gdmGradientLabelPanel.setNumExperiments(num_experiments);
    }

    public void setIndices(int[] indexes) {
        this.indices = indexes;
        this.gdmGradientLabelPanel.setIndices(indexes);
    }

    public int[] getIndices() {
        return this.indices;
    }

    public void setPosColorImages(BufferedImage posColorImage) {
        this.gdmGradientLabelPanel.setPosColorImages(posColorImage);
        this.gdmGradientLabelPanel.repaint();
    }

    public JScrollBar getVerticalScrollBar() {
        return this.gdmGradientLabelPanel.getVerticalScrollBar();
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.gdmGradientLabelPanel.getHorizontalScrollBar();
    }

    public void setLeftInset(int leftMargin) {
        this.insets.left = leftMargin;
        this.setLeftInset(leftMargin);
        this.gdmGradientLabelPanel.setLeftInset(leftMargin);
    }

    public void setTopInset(int topMargin) {
        this.insets.top = topMargin;
        this.gdmGradientLabelPanel.setTopInset(topMargin);
    }

    public void setData(IData data) {
        this.expData = data;
        this.gdmGradientLabelPanel.setData(data);
    }

    public void setAntiAliasing(boolean isAntiAliasing) {
        this.isAntiAliasing = isAntiAliasing;
        this.gdmGradientLabelPanel.setAntiAliasing(isAntiAliasing);
    }

    void setElementWidth(int width) {
        this.elementWidth = width;
        this.setFontSize(width);
        this.gdmGradientLabelPanel.setElementWidth(width);
    }

    void setElementHeight(int height) {
        this.elementHeight = height;
        this.setFontSize(height);
        this.gdmGradientLabelPanel.setElementHeight(height);
    }

    int getElementWidth() {
        return this.elementWidth;
    }

    void setAnnotationSize(int size) {
        this.annotationSize = size;
        this.gdmGradientLabelPanel.setAnnotationSize(size);
    }

    void setContentWidth(int width) {
        this.contentWidth = width;
        this.gdmGradientLabelPanel.setContentWidth(width);
    }

    void setContentHeight(int height) {
        this.contentHeight = height;
        this.gdmGradientLabelPanel.setContentHeight(height);
    }

    void setTracing(boolean isTracing) {
        this.isTracing = isTracing;
        this.gdmGradientLabelPanel.setTracing(isTracing);
    }

    private int getSpacing() {
        if (this.isTracing) {
            return this.tracespace;
        }
        return 0;
    }

    private void setFontSize(int size) {
        if (size > 12) {
            size = 12;
        }
        this.setFont(new Font("monospaced", 0, size));
    }

    public void setValues(float minValue, float maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.gdmGradientLabelPanel.setValues(minValue, maxValue);
    }

    protected boolean areExperimentsColored() {
        for (int i = 0; i < this.num_experiments; ++i) {
            if (this.expData.getExperimentColor(i) == null) continue;
            return true;
        }
        return false;
    }

    private void fireGDMSortEvent(int index) {
        ActionEvent ae = new ActionEvent(this, index, "sort-by-proximity-cmd");
        if (this.matrixListener != null) {
            this.matrixListener.actionPerformed(ae);
        }
    }

    private class GDMColorBarPanel
    extends JPanel {
        public GDMColorBarPanel() {
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        private void setFontSize(int width) {
            if (width > 12) {
                width = 12;
            }
            this.setFont(new Font("monospaced", 0, width));
        }

        public void updateSize() {
            this.setSize(GDMExpHeader.this.colorBarWidth, GDMExpHeader.this.colorBarHeight);
            this.setPreferredSize(new Dimension(GDMExpHeader.this.colorBarWidth, GDMExpHeader.this.colorBarHeight));
        }

        @Override
        public void paint(Graphics g1D) {
            super.paint(g1D);
            if (GDMExpHeader.this.expData == null) {
                return;
            }
            if (!GDMExpHeader.this.hasColorBar) {
                return;
            }
            Graphics2D g = (Graphics2D)g1D;
            if (GDMExpHeader.this.isAntiAliasing) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (GDMExpHeader.this.isColumnHeader) {
                this.drawColumnColorBar(g);
            } else {
                this.drawRowColorBar(g);
            }
        }

        private void drawRowColorBar(Graphics2D g) {
            Rectangle bounds = g.getClipBounds();
            int top = this.getTopIndex(bounds.y);
            int bottom = 0;
            bottom = this.getBottomIndex(bounds.y + bounds.height, GDMExpHeader.this.num_experiments);
            for (int row = top; row < bottom; ++row) {
                this.fillRowColorRectAt(g, 1, row);
            }
        }

        private void fillRowColorRectAt(Graphics g, int xLoc, int row) {
            Color expColor = null;
            expColor = GDMExpHeader.this.expData.getExperimentColor(GDMExpHeader.this.indices[row]);
            if (expColor == null) {
                expColor = Color.white;
            }
            g.setColor(expColor);
            g.fillRect(xLoc, row * GDMExpHeader.this.elementHeight, GDMExpHeader.this.colorBarWidth - 2, GDMExpHeader.this.elementHeight);
        }

        private void drawColumnColorBar(Graphics2D g) {
            Rectangle bounds = g.getClipBounds();
            int left = this.getLeftIndex(bounds.x);
            int right = 0;
            right = this.getRightIndex(bounds.x + bounds.width, GDMExpHeader.this.num_experiments);
            for (int column = left; column < right; ++column) {
                this.fillColumnColorRectAt(g, column, 1);
            }
        }

        private void fillColumnColorRectAt(Graphics g, int column, int yLoc) {
            Color expColor = null;
            expColor = GDMExpHeader.this.expData.getExperimentColor(GDMExpHeader.this.indices[column]);
            if (expColor == null) {
                expColor = Color.white;
            }
            g.setColor(expColor);
            g.fillRect(column * GDMExpHeader.this.elementWidth, yLoc, GDMExpHeader.this.elementWidth, GDMExpHeader.this.colorBarHeight - 2);
        }

        private int getTopIndex(int top) {
            if (top < 0) {
                return 0;
            }
            return top / GDMExpHeader.this.elementHeight;
        }

        private int getLeftIndex(int left) {
            if (left < 0) {
                return 0;
            }
            return left / (GDMExpHeader.this.elementWidth + GDMExpHeader.this.getSpacing());
        }

        private int getRightIndex(int right, int limit) {
            if (right < 0) {
                return 0;
            }
            int result = right / (GDMExpHeader.this.elementWidth + GDMExpHeader.this.getSpacing()) + 1;
            return result > limit ? limit : result;
        }

        private int getBottomIndex(int bottom, int limit) {
            if (bottom < 0) {
                return 0;
            }
            int result = bottom / GDMExpHeader.this.elementHeight + 1;
            return result > limit ? limit : result;
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (GDMExpHeader.this.sortByProximity) {
                int loc = 0;
                loc = GDMExpHeader.this.isColumnHeader ? evt.getX() : evt.getY();
                int index = (loc - ((GDMExpHeader)GDMExpHeader.this).insets.left) / GDMExpHeader.this.elementWidth;
                GDMExpHeader.this.fireGDMSortEvent(GDMExpHeader.this.indices[index]);
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (GDMExpHeader.this.sortByProximity) {
                int elementIndex;
                Graphics2D g2D = (Graphics2D)GDMExpHeader.this.gdmGradientLabelPanel.getLabelPanelGraphics();
                if (g2D == null) {
                    return;
                }
                int x = event.getX();
                int y = event.getY();
                if (GDMExpHeader.this.isColumnHeader) {
                    elementIndex = x / GDMExpHeader.this.elementWidth;
                    if (elementIndex >= GDMExpHeader.this.num_experiments) {
                        GDMExpHeader.this.repaint();
                        return;
                    }
                    if (elementIndex != GDMExpHeader.this.currentIndex) {
                        g2D.setColor(Color.white);
                        g2D.drawRect(GDMExpHeader.this.currentIndex * GDMExpHeader.this.elementWidth, 0, GDMExpHeader.this.elementWidth, GDMExpHeader.this.gdmGradientLabelPanel.getLabelPanel().getHeight() - 1);
                    }
                    g2D.setColor(Color.blue);
                    g2D.drawRect(elementIndex * GDMExpHeader.this.elementWidth, 0, GDMExpHeader.this.elementWidth, GDMExpHeader.this.gdmGradientLabelPanel.getLabelPanel().getHeight() - 1);
                } else {
                    elementIndex = y / GDMExpHeader.this.elementWidth;
                    if (elementIndex >= GDMExpHeader.this.num_experiments) {
                        GDMExpHeader.this.repaint();
                        return;
                    }
                    if (elementIndex != GDMExpHeader.this.currentIndex) {
                        g2D.setColor(Color.white);
                        g2D.drawRect(0, GDMExpHeader.this.currentIndex * GDMExpHeader.this.elementWidth, GDMExpHeader.this.gdmGradientLabelPanel.getLabelPanel().getWidth() - 1, GDMExpHeader.this.elementHeight);
                    }
                    g2D.setColor(Color.blue);
                    g2D.drawRect(0, elementIndex * GDMExpHeader.this.elementWidth, GDMExpHeader.this.gdmGradientLabelPanel.getLabelPanel().getWidth() - 1, GDMExpHeader.this.elementHeight);
                }
                GDMExpHeader.this.currentIndex = elementIndex;
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
            GDMExpHeader.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }
}

