/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tigr.microarray.mev.cluster.gui.IData;

public class GDMExpGradientLabelPanel
extends JScrollPane {
    private final int OFFSET = 2;
    private final int RECT_HEIGHT = 10;
    private final int RECT_WIDTH = 200;
    private IData expData;
    private Insets insets;
    private int contentWidth;
    private int contentHeight;
    private int elementWidth;
    private int elementHeight;
    private int tracespace;
    private int maxExpNameLength;
    private int num_experiments;
    private int[] indices;
    private int labelIndex;
    private boolean isAntiAliasing = false;
    private boolean isTracing = true;
    private boolean isColumnHeader;
    private int annotationSize;
    private GDMLabelPanel gdmLabelPanel;
    private GDMGradientPanel gdmGradientPanel;
    private float minValue = 0.0f;
    private float maxValue = 1.0f;
    private int maxTextWidth = 0;
    private int maxTextHeight = 0;

    public GDMExpGradientLabelPanel(Insets insets, int tracespace, boolean colHdr, int width, int height, Dimension eSize, int maxExperimentLen, int num_experiments, int[] indices) {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.insets = new Insets(0, 0, 0, 0);
        this.insets.left = insets.left;
        this.insets.right = insets.right;
        this.insets.top = insets.top;
        this.insets.bottom = insets.bottom;
        this.tracespace = tracespace;
        this.elementWidth = eSize.width;
        this.elementHeight = eSize.height;
        this.isColumnHeader = colHdr;
        this.contentWidth = width;
        this.contentHeight = height;
        this.indices = indices;
        this.num_experiments = num_experiments;
        this.maxExpNameLength = maxExperimentLen * this.elementWidth;
        this.gdmLabelPanel = new GDMLabelPanel();
        this.setViewportView(this.gdmLabelPanel);
        this.setViewport(this.getViewport());
        this.gdmGradientPanel = new GDMGradientPanel();
        if (this.isColumnHeader) {
            this.setColumnHeaderView(this.gdmGradientPanel);
            this.setColumnHeader(this.getColumnHeader());
        } else {
            this.setRowHeaderView(this.gdmGradientPanel);
            this.setRowHeader(this.getRowHeader());
        }
        this.updateSize();
        if (this.isColumnHeader) {
            this.setHorizontalScrollBarPolicy(31);
            this.setVerticalScrollBarPolicy(20);
        } else {
            this.setVerticalScrollBarPolicy(21);
            this.setHorizontalScrollBarPolicy(30);
        }
        this.getViewport().setScrollMode(0);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    public void setValues(float minValue, float maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public void setData(IData expData) {
        this.expData = expData;
    }

    public void setNumExperiments(int val) {
        this.num_experiments = val;
    }

    public void setLabelIndex(int label) {
        this.labelIndex = label;
    }

    public void setIndices(int[] indexes) {
        this.indices = indexes;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public int getLabelIndex() {
        return this.labelIndex;
    }

    public Graphics getLabelPanelGraphics() {
        return this.gdmLabelPanel.getGraphics();
    }

    public JComponent getLabelPanel() {
        return this.gdmLabelPanel;
    }

    public void setAntiAliasing(boolean isAntiAliasing) {
        this.isAntiAliasing = isAntiAliasing;
    }

    void setElementWidth(int width) {
        this.elementWidth = width;
        this.setFontSize(width);
        this.gdmLabelPanel.setFontSize(width);
    }

    int getElementWidth() {
        return this.elementWidth;
    }

    void setAnnotationSize(int size) {
        this.annotationSize = size;
    }

    void setContentWidth(int width) {
        this.contentWidth = width;
    }

    void setElementHeight(int height) {
        this.elementHeight = height;
        this.setFontSize(height);
        this.gdmLabelPanel.setFontSize(height);
    }

    void setContentHeight(int height) {
        this.contentHeight = height;
    }

    void setTracing(boolean isTracing) {
        this.isTracing = isTracing;
    }

    private int getSpacing() {
        if (this.isTracing) {
            return this.tracespace;
        }
        return 0;
    }

    private void setFontSize(int size) {
        if (size > 12) {
            size = 12;
        }
        this.setFont(new Font("monospaced", 0, size));
    }

    private void updateMaxExpNameLength() {
        Graphics2D g = (Graphics2D)this.getLabelPanelGraphics();
        if (g == null) {
            return;
        }
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fm = g.getFontMetrics();
        double maxLength = 0.0;
        int i = 0;
        for (i = 0; i < this.num_experiments; ++i) {
            String expName = this.expData.getSampleName(i);
            maxLength = Math.max(maxLength, (double)fm.stringWidth(expName));
        }
        this.maxExpNameLength = (int)maxLength;
    }

    private int getMaxExpNameLength() {
        return this.maxExpNameLength;
    }

    private void setMaxExpNameLength(int val) {
        this.maxExpNameLength = val;
    }

    protected boolean areExperimentsColored() {
        if (this.indices == null) {
            return false;
        }
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.expData.getExperimentColor(this.indices[i]) == null) continue;
            return true;
        }
        return false;
    }

    public void updateSize() {
        this.updateMaxExpNameLength();
        this.gdmGradientPanel.updateSize();
        this.gdmLabelPanel.updateSize();
        if (this.isColumnHeader) {
            this.getVerticalScrollBar().setValues(190, 10, 100, 200);
        }
        if (this.isColumnHeader) {
            int w = this.contentWidth + this.elementWidth / 2;
            int h = 10 + this.maxTextHeight + this.annotationSize + 4 + 10;
            this.setSize(w, h);
            this.setPreferredSize(new Dimension(w, h));
        } else {
            int w = 10 + this.maxTextWidth + this.annotationSize + 4 + 10;
            int h = this.contentHeight + this.elementHeight / 2;
            this.setSize(w, h);
            this.setPreferredSize(new Dimension(w, h));
        }
        this.validate();
    }

    public void setPosColorImages(BufferedImage posColorImage) {
        this.gdmGradientPanel.setPosColorImages(posColorImage);
        this.gdmGradientPanel.repaint();
    }

    public void setLeftInset(int leftMargin) {
        this.insets.left = leftMargin;
    }

    public void setTopInset(int topMargin) {
        this.insets.top = topMargin;
    }

    public Graphics getColorScaleGraphics() {
        return this.gdmGradientPanel.getGraphics();
    }

    private class GDMGradientPanel
    extends JPanel {
        private boolean drawBorders = false;
        private Color missingColor = new Color(128, 128, 128);
        private BufferedImage posColorImage;
        private DecimalFormat decFormat;

        public GDMGradientPanel() {
            this.setBackground(Color.white);
            this.decFormat = new DecimalFormat();
            this.decFormat.setMinimumFractionDigits(1);
            this.decFormat.setMaximumFractionDigits(3);
        }

        private void setFontSize(int width) {
            if (width > 10) {
                width = 10;
            }
            this.setFont(new Font("monospaced", 0, width));
        }

        public void setPosColorImages(BufferedImage posColorImage) {
            this.posColorImage = posColorImage;
        }

        public void setMissingColor(Color color) {
            this.missingColor = color;
        }

        public void setDrawBorders(boolean draw) {
            this.drawBorders = draw;
        }

        public void updateSize() {
            Graphics2D g = (Graphics2D)this.getGraphics();
            float midValue = (GDMExpGradientLabelPanel.this.minValue + GDMExpGradientLabelPanel.this.maxValue) / 2.0f;
            String midString = this.decFormat.format(midValue);
            String maxString = this.decFormat.format(GDMExpGradientLabelPanel.this.maxValue);
            String minString = this.decFormat.format(GDMExpGradientLabelPanel.this.minValue);
            if (g != null) {
                FontMetrics hfm = g.getFontMetrics();
                GDMExpGradientLabelPanel.this.maxTextHeight = hfm.getHeight();
                int textWidth1 = hfm.stringWidth(midString);
                int textWidth2 = hfm.stringWidth(maxString);
                int textWidth3 = hfm.stringWidth(minString);
                GDMExpGradientLabelPanel.this.maxTextWidth = Math.max(textWidth1, textWidth2);
                GDMExpGradientLabelPanel.this.maxTextWidth = Math.max(GDMExpGradientLabelPanel.this.maxTextWidth, textWidth3);
            } else {
                GDMExpGradientLabelPanel.this.maxTextHeight = 4;
                GDMExpGradientLabelPanel.this.maxTextWidth = 4;
            }
            if (GDMExpGradientLabelPanel.this.isColumnHeader) {
                int w = GDMExpGradientLabelPanel.this.contentWidth + (int)((float)GDMExpGradientLabelPanel.this.elementWidth / 2.0f);
                int h = 14 + GDMExpGradientLabelPanel.this.maxTextHeight;
                this.setSize(w, h);
                this.setPreferredSize(new Dimension(w, h));
            } else {
                int w = 14 + GDMExpGradientLabelPanel.this.maxTextWidth;
                int h = GDMExpGradientLabelPanel.this.contentWidth + (int)((float)GDMExpGradientLabelPanel.this.elementWidth / 2.0f);
                this.setSize(w, h);
                this.setPreferredSize(new Dimension(w, h));
            }
        }

        @Override
        public void paint(Graphics g1D) {
            super.paint(g1D);
            if (GDMExpGradientLabelPanel.this.expData == null || GDMExpGradientLabelPanel.this.expData.getFeaturesCount() == 0) {
                return;
            }
            Graphics2D g = (Graphics2D)g1D;
            if (GDMExpGradientLabelPanel.this.isColumnHeader) {
                g.drawImage(this.posColorImage, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.top, 200, 10, null);
            } else {
                g.rotate(1.5707963267948966);
                g.drawImage(this.posColorImage, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.top, -10 - ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left, 200, 10, null);
            }
            FontMetrics hfm = g.getFontMetrics();
            int descent = hfm.getDescent();
            g.setColor(Color.black);
            if (GDMExpGradientLabelPanel.this.isAntiAliasing) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            float midValue = (GDMExpGradientLabelPanel.this.minValue + GDMExpGradientLabelPanel.this.maxValue) / 2.0f;
            String midString = this.decFormat.format(midValue);
            String minString = this.decFormat.format(GDMExpGradientLabelPanel.this.minValue);
            String maxString = this.decFormat.format(GDMExpGradientLabelPanel.this.maxValue);
            int textWidth1 = hfm.stringWidth(minString);
            int textWidth2 = hfm.stringWidth(midString);
            int textWidth3 = hfm.stringWidth(maxString);
            if (GDMExpGradientLabelPanel.this.isColumnHeader) {
                g.drawString(minString, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left, 10 + GDMExpGradientLabelPanel.this.maxTextHeight);
                g.drawString(midString, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left + 100 - textWidth1 / 2, 10 + GDMExpGradientLabelPanel.this.maxTextHeight);
                g.drawString(maxString, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left + 200 - textWidth2, 10 + GDMExpGradientLabelPanel.this.maxTextHeight);
            } else {
                g.rotate(-1.5707963267948966);
                g.drawString(minString, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left + 10, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.top + GDMExpGradientLabelPanel.this.maxTextHeight);
                g.drawString(midString, (float)(((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left + 10), (float)(((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.top + 100) + (float)GDMExpGradientLabelPanel.this.maxTextHeight / 2.0f);
                g.drawString(maxString, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left + 10, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.top + 200);
            }
        }
    }

    private class GDMLabelPanel
    extends JPanel {
        public GDMLabelPanel() {
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        private void setFontSize(int width) {
            if (width > 12) {
                width = 12;
            }
            this.setFont(new Font("monospaced", 0, width));
        }

        public void updateSize() {
            if (GDMExpGradientLabelPanel.this.isColumnHeader) {
                int w = GDMExpGradientLabelPanel.this.num_experiments * GDMExpGradientLabelPanel.this.elementWidth;
                int h = GDMExpGradientLabelPanel.this.maxExpNameLength + 10;
                this.setSize(w, h);
                this.setPreferredSize(new Dimension(w, h));
            } else {
                int w = GDMExpGradientLabelPanel.this.maxExpNameLength + 10;
                int h = GDMExpGradientLabelPanel.this.num_experiments * GDMExpGradientLabelPanel.this.elementHeight;
                this.setSize(w, h);
                this.setPreferredSize(new Dimension(w, h));
            }
        }

        @Override
        public void paint(Graphics g1D) {
            super.paint(g1D);
            if (GDMExpGradientLabelPanel.this.expData == null || GDMExpGradientLabelPanel.this.getElementWidth() <= 2) {
                return;
            }
            Graphics2D g = (Graphics2D)g1D;
            if (GDMExpGradientLabelPanel.this.isAntiAliasing) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            this.drawLabelHeader(g);
        }

        private void drawLabelHeader(Graphics2D g) {
            if (GDMExpGradientLabelPanel.this.num_experiments == 0) {
                return;
            }
            FontMetrics hfm = g.getFontMetrics();
            int descent = hfm.getDescent();
            if (GDMExpGradientLabelPanel.this.isColumnHeader) {
                g.rotate(-1.5707963267948966);
            }
            String expName = "";
            int maxLength = 0;
            int samples = GDMExpGradientLabelPanel.this.expData.getFeaturesCount();
            if (samples == 0) {
                return;
            }
            for (int i = 0; i < samples; ++i) {
                int y;
                int x;
                expName = GDMExpGradientLabelPanel.this.indices != null ? GDMExpGradientLabelPanel.this.expData.getSampleName(GDMExpGradientLabelPanel.this.indices[i]) : GDMExpGradientLabelPanel.this.expData.getSampleName(i);
                maxLength = Math.max(maxLength, hfm.stringWidth(expName));
                if (GDMExpGradientLabelPanel.this.isColumnHeader) {
                    x = ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.top - this.getSize().height + 1;
                    y = ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left + descent + (GDMExpGradientLabelPanel.this.elementWidth + GDMExpGradientLabelPanel.this.getSpacing()) * i + GDMExpGradientLabelPanel.this.elementWidth / 2 + 1;
                } else {
                    x = ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left + 1;
                    y = ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.top + descent + (GDMExpGradientLabelPanel.this.elementHeight + GDMExpGradientLabelPanel.this.getSpacing()) * i + GDMExpGradientLabelPanel.this.elementHeight / 2;
                }
                g.drawString(expName, x, y);
            }
            if (GDMExpGradientLabelPanel.this.isColumnHeader) {
                g.rotate(1.5707963267948966);
            }
            GDMExpGradientLabelPanel.this.setMaxExpNameLength(maxLength);
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
        }
    }
}

