/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMScaleListener;
import org.tigr.util.FloatMatrix;

public class GDMColorScaleDialog
extends AlgorithmDialog {
    public static final String OK_CMD = "ok-cmd";
    public static final String CANCEL_CMD = "cancel-cmd";
    public static final String REFRESH_CMD = "refresh-cmd";
    public static final String RESET_CMD = "reset-cmd";
    public static final int REFRESH_RES = 100;
    public static final int RESET_RES = 101;
    private int result;
    private JLabel lowerJL = new JLabel("Lower Limit [0,1):  ", 4);
    private JLabel upperJL = new JLabel("Upper Limit (0,1]: ", 4);
    private JLabel saturationJL = new JLabel("% Saturation: ", 4);
    private JTextField lowerJTF;
    private JTextField upperJTF;
    private JTextField saturationJTF;
    private JPanel buttonsPanel;
    private JButton refreshBut;
    private JButton resetBut;
    private JButton cancelBut;
    private JButton okBut;
    private JButton infoButton;
    private RangePreviewPanel previewPanel;
    private FloatMatrix geneMatrix;
    private int num_genes;
    private float origLower;
    private float origUpper;
    private GDMScaleListener listener;

    public GDMColorScaleDialog(Frame parent, float lower, float upper, FloatMatrix matrix, int genes, Color lowerColor, Color upperColor) {
        super(parent, "Set Color Scale", true);
        this.geneMatrix = matrix;
        this.num_genes = genes;
        this.origLower = lower;
        this.origUpper = upper;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel paramsPanel = new JPanel(new GridBagLayout());
        paramsPanel.setBackground(Color.white);
        paramsPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets.left = 40;
        gbc.insets.right = 10;
        gbc.insets.top = 25;
        this.lowerJL.setBackground(Color.white);
        this.lowerJL.setOpaque(true);
        this.lowerJL.setHorizontalAlignment(4);
        this.lowerJL.setHorizontalTextPosition(4);
        paramsPanel.add((Component)this.lowerJL, gbc);
        gbc.insets.top = 10;
        gbc.gridy = 1;
        paramsPanel.add((Component)this.upperJL, gbc);
        gbc.gridy = 2;
        gbc.insets.bottom = 25;
        paramsPanel.add((Component)this.saturationJL, gbc);
        gbc.insets.bottom = 0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets.left = 10;
        gbc.insets.top = 25;
        Float lowerF = new Float(lower);
        this.lowerJTF = new JTextField(lowerF.toString(), 10);
        paramsPanel.add((Component)this.lowerJTF, gbc);
        gbc.gridy = 1;
        gbc.insets.top = 10;
        Float upperF = new Float(upper);
        this.upperJTF = new JTextField(upperF.toString(), 10);
        paramsPanel.add((Component)this.upperJTF, gbc);
        gbc.gridy = 2;
        gbc.insets.top = 10;
        gbc.insets.bottom = 25;
        Float saturationF = new Float(this.calcPercentSaturation(lower, upper));
        this.saturationJTF = new JTextField(saturationF.toString(), 10);
        this.saturationJTF.setEditable(false);
        paramsPanel.add((Component)this.saturationJTF, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        JPanel mainButtonPanel = new JPanel(new GridBagLayout());
        this.buttonsPanel = new JPanel(new GridLayout(1, 4, 10, 10));
        this.refreshBut = new JButton("Preview");
        this.refreshBut.setBorder(BorderFactory.createBevelBorder(0));
        this.refreshBut.setSize(60, 30);
        this.refreshBut.setPreferredSize(new Dimension(60, 30));
        this.refreshBut.setFocusPainted(false);
        this.refreshBut.setActionCommand(REFRESH_CMD);
        this.refreshBut.addActionListener(listener);
        this.buttonsPanel.add(this.refreshBut);
        this.resetBut = new JButton("Reset");
        this.resetBut.setBorder(BorderFactory.createBevelBorder(0));
        this.resetBut.setFocusPainted(false);
        this.resetBut.setActionCommand(RESET_CMD);
        this.resetBut.addActionListener(listener);
        this.buttonsPanel.add(this.resetBut);
        this.cancelBut = new JButton("Cancel");
        this.cancelBut.setBorder(BorderFactory.createBevelBorder(0));
        this.cancelBut.setSize(60, 30);
        this.cancelBut.setPreferredSize(new Dimension(60, 30));
        this.cancelBut.setFocusPainted(false);
        this.cancelBut.setActionCommand(CANCEL_CMD);
        this.cancelBut.addActionListener(listener);
        this.buttonsPanel.add(this.cancelBut);
        this.okBut = new JButton("OK");
        this.okBut.setBorder(BorderFactory.createBevelBorder(0, new Color(240, 240, 240), new Color(180, 180, 180), new Color(10, 0, 0), new Color(10, 10, 10)));
        this.okBut.setSize(60, 30);
        this.okBut.setPreferredSize(new Dimension(60, 30));
        this.okBut.setFocusPainted(false);
        this.okBut.setActionCommand(OK_CMD);
        this.okBut.addActionListener(listener);
        this.buttonsPanel.add(this.okBut);
        this.infoButton = new JButton(null, GUIFactory.getIcon("Information24.gif"));
        this.infoButton.setActionCommand("info-command");
        this.infoButton.setBorder(BorderFactory.createBevelBorder(0));
        this.infoButton.setSize(30, 30);
        this.infoButton.setPreferredSize(new Dimension(30, 30));
        this.infoButton.setFocusPainted(false);
        this.infoButton.addActionListener(listener);
        mainButtonPanel.add((Component)this.infoButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        mainButtonPanel.add((Component)this.buttonsPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.previewPanel = new RangePreviewPanel(lowerColor, upperColor, lower, upper);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        paramsPanel.add((Component)this.previewPanel, gbc);
        this.addContent(paramsPanel);
        this.supplantButtonPanel(mainButtonPanel);
        this.pack();
    }

    public void setGDMScaleListener(GDMScaleListener scaleListener) {
        this.listener = scaleListener;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        Float lowerF = new Float(this.lowerJTF.getText());
        Float upperF = new Float(this.upperJTF.getText());
        Float satF = new Float(this.calcPercentSaturation(lowerF.floatValue(), upperF.floatValue()));
        this.saturationJTF.setText(satF.toString());
        this.previewPanel.changeLimits(lowerF.floatValue(), upperF.floatValue());
        this.show();
        return this.result;
    }

    public float getLowerLimit() {
        return Float.parseFloat(this.lowerJTF.getText());
    }

    public float getUpperLimit() {
        return Float.parseFloat(this.upperJTF.getText());
    }

    public float calcPercentSaturation(float lowerf, float upperf) {
        int out_minmax = 0;
        for (int i = 0; i < this.num_genes; ++i) {
            for (int j = 0; j < this.num_genes; ++j) {
                float dist = this.geneMatrix.get(i, j);
                if (!(dist < lowerf) && !(dist > upperf)) continue;
                ++out_minmax;
            }
        }
        float sat = (float)out_minmax / (float)(this.num_genes * this.num_genes) * 100.0f;
        return sat;
    }

    private boolean isValidInput(float low, float high) {
        if (high <= low) {
            JOptionPane.showMessageDialog(this, "The lower limit must be less than or equal to the upper limit.  Please enter new limits.", "Invalid Range Input", 2);
            return false;
        }
        if ((double)high > 1.0) {
            JOptionPane.showMessageDialog(this, "The upper limit must be equal to or less than 1.0. Please enter a new value.", "Invalid Range Input", 2);
            return false;
        }
        if ((double)low < 0.0) {
            JOptionPane.showMessageDialog(this, "The lower limit must be equal to or greater than 0.0. Please enter a new value.", "Invalid Range Input", 2);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        FloatMatrix matrix = new FloatMatrix(3, 3);
        matrix.set(0, 0, 1.0f);
        matrix.set(1, 0, 0.1f);
        matrix.set(2, 0, 0.8f);
        matrix.set(0, 1, 1.0f);
        matrix.set(1, 1, 0.134f);
        matrix.set(2, 1, 0.25f);
        matrix.set(0, 2, 0.43f);
        matrix.set(1, 2, 0.37f);
        matrix.set(2, 2, 0.04f);
        GDMColorScaleDialog dialog = new GDMColorScaleDialog(new Frame(), 0.0f, 0.1f, matrix, matrix.getRowDimension(), Color.black, Color.red);
        dialog.setDefaultCloseOperation(2);
        dialog.showModal();
    }

    private class Listener
    extends DialogListener {
        Float lowerF;
        Float upperF;

        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(GDMColorScaleDialog.OK_CMD)) {
                try {
                    this.lowerF = new Float(GDMColorScaleDialog.this.lowerJTF.getText());
                    this.upperF = new Float(GDMColorScaleDialog.this.upperJTF.getText());
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(GDMColorScaleDialog.this, "The entered values are not valid numberical entries. Please enter new values", "Invalid Range Input", 2);
                    return;
                }
                if (!GDMColorScaleDialog.this.isValidInput(this.lowerF.floatValue(), this.upperF.floatValue())) {
                    return;
                }
                GDMColorScaleDialog.this.result = 0;
                GDMColorScaleDialog.this.dispose();
            } else if (command.equals(GDMColorScaleDialog.CANCEL_CMD)) {
                GDMColorScaleDialog.this.result = 2;
                GDMColorScaleDialog.this.lowerJTF.setText(String.valueOf(GDMColorScaleDialog.this.origLower));
                GDMColorScaleDialog.this.upperJTF.setText(String.valueOf(GDMColorScaleDialog.this.origUpper));
                this.lowerF = new Float(GDMColorScaleDialog.this.lowerJTF.getText());
                this.upperF = new Float(GDMColorScaleDialog.this.upperJTF.getText());
                Float satF = new Float(GDMColorScaleDialog.this.calcPercentSaturation(this.lowerF.floatValue(), this.upperF.floatValue()));
                GDMColorScaleDialog.this.saturationJTF.setText(satF.toString());
                GDMColorScaleDialog.this.dispose();
            } else if (command.equals(GDMColorScaleDialog.RESET_CMD)) {
                GDMColorScaleDialog.this.result = 101;
                GDMColorScaleDialog.this.lowerJTF.setText(String.valueOf(GDMColorScaleDialog.this.origLower));
                GDMColorScaleDialog.this.upperJTF.setText(String.valueOf(GDMColorScaleDialog.this.origUpper));
                this.lowerF = new Float(GDMColorScaleDialog.this.lowerJTF.getText());
                this.upperF = new Float(GDMColorScaleDialog.this.upperJTF.getText());
                Float satF = new Float(GDMColorScaleDialog.this.calcPercentSaturation(this.lowerF.floatValue(), this.upperF.floatValue()));
                GDMColorScaleDialog.this.saturationJTF.setText(satF.toString());
                GDMColorScaleDialog.this.previewPanel.changeLimits(this.lowerF.floatValue(), this.upperF.floatValue());
            } else if (command.equals(GDMColorScaleDialog.REFRESH_CMD)) {
                try {
                    this.lowerF = new Float(GDMColorScaleDialog.this.lowerJTF.getText());
                    this.upperF = new Float(GDMColorScaleDialog.this.upperJTF.getText());
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(GDMColorScaleDialog.this, "The entered values are not valid numberical entries. Please enter new values", "Invalid Range Input", 2);
                    return;
                }
                if (!GDMColorScaleDialog.this.isValidInput(this.lowerF.floatValue(), this.upperF.floatValue())) {
                    return;
                }
                Float satF = new Float(GDMColorScaleDialog.this.calcPercentSaturation(this.lowerF.floatValue(), this.upperF.floatValue()));
                GDMColorScaleDialog.this.saturationJTF.setText(satF.toString());
                GDMColorScaleDialog.this.previewPanel.changeLimits(this.lowerF.floatValue(), this.upperF.floatValue());
                if (GDMColorScaleDialog.this.listener != null) {
                    GDMColorScaleDialog.this.listener.scaleChanged(this.lowerF.floatValue(), this.upperF.floatValue());
                }
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(GDMColorScaleDialog.this, "GDM Color Range Dialog");
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            GDMColorScaleDialog.this.result = -1;
            GDMColorScaleDialog.this.dispose();
        }
    }

    private class RangePreviewPanel
    extends JPanel {
        int GRADIENT_HEIGHT = 40;
        Color lowerColor;
        Color upperColor;
        float lower;
        float upper;
        JPanel lowerPanel;
        JPanel upperPanel;
        GradientPanel midPanel;
        JPanel previewPanel;
        ScalePanel gradientPanel;

        public RangePreviewPanel(Color lowerColor, Color upperColor, float lower, float upper) {
            this.lower = lower;
            this.upper = upper;
            this.lowerColor = lowerColor;
            this.upperColor = upperColor;
            this.setBackground(Color.white);
            this.lowerPanel = new JPanel();
            this.lowerPanel.setBackground(lowerColor);
            Dimension prefSize = new Dimension(10, 40);
            this.lowerPanel.setPreferredSize(prefSize);
            this.upperPanel = new JPanel();
            this.upperPanel.setBackground(upperColor);
            this.upperPanel.setPreferredSize(prefSize);
            this.midPanel = new GradientPanel();
            this.midPanel.setPreferredSize(prefSize);
            this.previewPanel = new JPanel(new GridBagLayout());
            this.previewPanel.setBorder(BorderFactory.createTitledBorder("Effective Range Preview"));
            this.previewPanel.setBackground(Color.white);
            this.gradientPanel = new ScalePanel();
            this.gradientPanel.setLayout(new GridBagLayout());
            this.gradientPanel.setBackground(Color.white);
            this.gradientPanel.add((Component)this.lowerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 20, 0), 0, 0));
            this.gradientPanel.add((Component)this.midPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 20, 0), 0, 0));
            this.gradientPanel.add((Component)this.upperPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 20, 10), 0, 0));
            this.previewPanel.add((Component)this.gradientPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.setLayout(new GridBagLayout());
            this.add((Component)this.previewPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public void changeLimits(float low, float high) {
            this.lower = low;
            this.upper = high;
            int w = this.gradientPanel.getWidth() - 20;
            int h = this.lowerPanel.getHeight();
            this.lowerPanel.setSize((int)((float)w * low), h);
            this.lowerPanel.setPreferredSize(new Dimension((int)((float)w * low), h));
            this.upperPanel.setSize((int)((double)w * (1.0 - (double)high)), h);
            this.upperPanel.setPreferredSize(new Dimension((int)((double)w * (1.0 - (double)high)), h));
            this.midPanel.setSize((int)((float)w * (high - low)), h);
            this.midPanel.setPreferredSize(new Dimension((int)((float)w * (high - low)), h));
            this.validate();
            this.gradientPanel.repaint();
        }

        private class ScalePanel
        extends JPanel {
            int[] x;
            int[] y;

            public ScalePanel() {
                Font font = this.getFont();
                this.setFont(new Font(font.getFontName(), 1, font.getSize()));
                this.x = new int[3];
                this.y = new int[3];
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                int h = this.getHeight();
                int w = this.getWidth() - 20;
                int gradientH = this.getHeight() - 20;
                int xLower = (int)(RangePreviewPanel.this.lower * (float)w) + 10;
                int xUpper = (int)(RangePreviewPanel.this.upper * (float)w) + 10;
                this.x[0] = xLower;
                this.x[1] = xLower - 5;
                this.x[2] = xLower + 5;
                this.y[0] = 10;
                this.y[1] = 1;
                this.y[2] = 1;
                g.setColor(Color.blue);
                g.fillPolygon(this.x, this.y, 3);
                this.x[0] = xUpper;
                this.x[1] = xUpper - 5;
                this.x[2] = xUpper + 5;
                g.fillPolygon(this.x, this.y, 3);
                g.setColor(RangePreviewPanel.this.upperColor);
                g.fillRect(xLower - 1, 10, 3, RangePreviewPanel.this.midPanel.getHeight());
                g.setColor(RangePreviewPanel.this.lowerColor);
                g.fillRect(xUpper - 1, 10, 3, RangePreviewPanel.this.midPanel.getHeight());
                g.setColor(Color.black);
                FontMetrics fm = g.getFontMetrics();
                g.drawString("0.0", 10, RangePreviewPanel.this.midPanel.getHeight() + 10 + fm.getHeight());
                g.drawString("0.5", this.getWidth() / 2 - fm.stringWidth("0.5") / 2, RangePreviewPanel.this.midPanel.getHeight() + 10 + fm.getHeight());
                g.drawString("1.0", this.getWidth() - 10 - fm.stringWidth("1.0"), RangePreviewPanel.this.midPanel.getHeight() + 10 + fm.getHeight());
            }
        }

        private class GradientPanel
        extends JPanel {
            GradientPaint gp;

            private GradientPanel() {
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                Graphics2D g2 = (Graphics2D)g;
                Dimension dim = this.getSize();
                this.gp = new GradientPaint(0.0f, dim.height / 2, RangePreviewPanel.this.lowerColor, dim.width, dim.height / 2, RangePreviewPanel.this.upperColor);
                g2.setPaint(this.gp);
                g2.fillRect(0, 0, dim.width, dim.height);
                g2.setColor(Color.black);
            }
        }
    }
}

