/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.tigr.util.awt.GBA;

public class GDMAnnotationSizeDialog
extends JDialog {
    private int result;
    private int size = 100;
    private JLabel sizeLabel;
    private JTextField sizeTextField;
    private GBA gba;
    private final int maxSize = 300;

    public GDMAnnotationSizeDialog(JFrame parent) {
        super((Frame)parent, true);
        this.setTitle("Set Annotation Size");
        this.gba = new GBA();
        this.sizeLabel = new JLabel("Annotation Size (max = 300):  ");
        this.sizeTextField = new JTextField(10);
        JButton okButton = new JButton("Okay");
        okButton.setActionCommand("ok-command");
        okButton.addActionListener(new Listener());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("cancel-command");
        cancelButton.addActionListener(new Listener());
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        this.gba.add(content, (Component)this.sizeLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(content, (Component)this.sizeTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(content, (Component)cancelButton, 0, 2, 1, 1, 0, 0, 0, 17, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(content, (Component)okButton, 1, 2, 1, 1, 0, 0, 0, 13, new Insets(5, 5, 5, 5), 0, 0);
        this.setResizable(false);
        this.sizeTextField.grabFocus();
        this.getRootPane().setDefaultButton(okButton);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public int getAnnotationSize() {
        return this.size;
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                String sz = GDMAnnotationSizeDialog.this.sizeTextField.getText();
                try {
                    int i_sz = Integer.parseInt(sz);
                    if (i_sz > 300) {
                        i_sz = 300;
                    } else if (i_sz < 1) {
                        i_sz = 1;
                    }
                    GDMAnnotationSizeDialog.this.size = i_sz;
                    GDMAnnotationSizeDialog.this.result = 0;
                }
                catch (Exception e) {
                    GDMAnnotationSizeDialog.this.result = 2;
                }
                GDMAnnotationSizeDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                GDMAnnotationSizeDialog.this.result = 2;
                GDMAnnotationSizeDialog.this.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            GDMAnnotationSizeDialog.this.result = -1;
            GDMAnnotationSizeDialog.this.dispose();
        }
    }
}

