/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.fom;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class FOMInitDialog
extends AlgorithmDialog {
    public static final int CAST = 1;
    public static final int KMEANS = 2;
    IterationPanel iPanel;
    KMCPanel kPanel;
    CASTPanel cPanel;
    JTabbedPane methodTabPane;
    JCheckBox takeAverageBox;
    SampleSelectionPanel sPanel;
    boolean okPressed = false;

    public FOMInitDialog(JFrame parentFrame, boolean modality) {
        super(parentFrame, "FOM: Figure of Merit", modality);
        this.setBounds(0, 0, 450, 400);
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.white);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 10;
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        pane.setBackground(Color.white);
        this.sPanel = new SampleSelectionPanel();
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 10);
        gridbag.setConstraints(this.sPanel, constraints);
        pane.add(this.sPanel);
        this.iPanel = new IterationPanel();
        this.buildConstraints(constraints, 0, 1, 1, 1, 100, 20);
        gridbag.setConstraints(this.iPanel, constraints);
        pane.add(this.iPanel);
        UIManager.put("TabbedPane.selected", Color.white);
        this.methodTabPane = new JTabbedPane();
        this.kPanel = new KMCPanel();
        this.cPanel = new CASTPanel();
        this.methodTabPane.add("K-Means / K-Medians", this.kPanel);
        this.methodTabPane.add("CAST", this.cPanel);
        this.buildConstraints(constraints, 0, 2, 1, 1, 100, 90);
        gridbag.setConstraints(this.methodTabPane, constraints);
        pane.add(this.methodTabPane);
        this.takeAverageBox = new JCheckBox("Take Average", true);
        this.takeAverageBox.setEnabled(false);
        constraints.fill = 1;
        this.buildConstraints(constraints, 0, 2, 1, 1, 0, 30);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
        this.methodTabPane.addChangeListener(listener);
        this.pack();
        this.setSize(600, 450);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            this.okButton.requestFocus();
        }
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public int getMethod() {
        int method = 0;
        if (this.methodTabPane.getSelectedIndex() == 0) {
            method = 2;
        } else if (this.methodTabPane.getSelectedIndex() == 1) {
            method = 1;
        }
        return method;
    }

    public boolean useMeans() {
        return this.kPanel.meansButton.isSelected();
    }

    public float getInterval() {
        String s2 = this.cPanel.thresholdInputField.getText();
        float interval = Float.parseFloat(s2);
        return interval;
    }

    public int getIterations() {
        String s1 = this.kPanel.intervalInputField.getText();
        int k = Integer.parseInt(s1);
        return k;
    }

    public int getKMCIterations() {
        String s1 = this.kPanel.iterationInputField.getText();
        int iterations = Integer.parseInt(s1);
        return iterations;
    }

    public int getFOMIterations() {
        String s = this.iPanel.iterationField.getText();
        return Integer.parseInt(s);
    }

    public boolean isAverage() {
        return this.takeAverageBox.isSelected();
    }

    public boolean isClusterGenes() {
        return this.sPanel.calcGenes.isSelected();
    }

    private void resetControls() {
        this.sPanel.calcGenes.setSelected(true);
        this.kPanel.meansButton.setSelected(true);
        this.kPanel.intervalInputField.setText("20");
        this.kPanel.iterationInputField.setText("50");
        this.cPanel.thresholdInputField.setText("0.1");
        this.iPanel.iterationField.setText("1");
    }

    public static void main(String[] args) {
        JFrame dummyFrame = new JFrame();
        FOMInitDialog fDialog = new FOMInitDialog(dummyFrame, true);
        fDialog.show();
        System.out.println(fDialog.getIterations());
        System.exit(0);
    }

    protected class EventListener
    extends WindowAdapter
    implements ActionListener,
    ChangeListener {
        protected EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                FOMInitDialog.this.okPressed = true;
                int method = FOMInitDialog.this.methodTabPane.getSelectedIndex();
                int fomI = 1;
                int k = -1;
                float inter = -1.0f;
                float kmcIter = -1.0f;
                float progress = -1.0f;
                try {
                    if (method == 0) {
                        fomI = Integer.parseInt(FOMInitDialog.this.iPanel.iterationField.getText());
                        progress += 1.0f;
                        k = Integer.parseInt(FOMInitDialog.this.kPanel.intervalInputField.getText());
                        progress += 1.0f;
                        kmcIter = Integer.parseInt(FOMInitDialog.this.kPanel.iterationInputField.getText());
                        progress += 1.0f;
                    } else {
                        inter = Float.parseFloat(FOMInitDialog.this.cPanel.thresholdInputField.getText());
                    }
                }
                catch (NumberFormatException e) {
                    if (progress == -1.0f) {
                        JOptionPane.showMessageDialog(FOMInitDialog.this, "Number format error. Expecting an integer for FOM iteration parameter.", "Number Format Error", 0);
                        FOMInitDialog.this.iPanel.iterationField.requestFocus();
                        FOMInitDialog.this.iPanel.iterationField.selectAll();
                    } else if (method == 0) {
                        JOptionPane.showMessageDialog(FOMInitDialog.this, "Number format error.", "Number Format Error", 0);
                        if (progress == 0.0f) {
                            FOMInitDialog.this.kPanel.intervalInputField.requestFocus();
                            FOMInitDialog.this.kPanel.intervalInputField.selectAll();
                        } else {
                            FOMInitDialog.this.kPanel.iterationInputField.requestFocus();
                            FOMInitDialog.this.kPanel.iterationInputField.selectAll();
                        }
                    } else {
                        JOptionPane.showMessageDialog(FOMInitDialog.this, "Number format error.", "Number Format Error", 0);
                        FOMInitDialog.this.cPanel.thresholdInputField.requestFocus();
                        FOMInitDialog.this.cPanel.thresholdInputField.selectAll();
                    }
                    return;
                }
                if (method == 0) {
                    if (fomI < 1) {
                        JOptionPane.showMessageDialog(FOMInitDialog.this, "FOM iterations must be > 0", "Invalid Input Error", 0);
                        FOMInitDialog.this.iPanel.iterationField.requestFocus();
                        FOMInitDialog.this.iPanel.iterationField.selectAll();
                        return;
                    }
                    if (k < 1) {
                        JOptionPane.showMessageDialog(FOMInitDialog.this, "Maximum Number of Clusters must be > 0", "Number Format Error", 0);
                        FOMInitDialog.this.kPanel.intervalInputField.requestFocus();
                        FOMInitDialog.this.kPanel.intervalInputField.selectAll();
                        return;
                    }
                    if (kmcIter < 1.0f) {
                        JOptionPane.showMessageDialog(FOMInitDialog.this, "Maximum Number of intervals per KMC run must be > 0", "Number Format Error", 0);
                        FOMInitDialog.this.kPanel.iterationInputField.requestFocus();
                        FOMInitDialog.this.kPanel.iterationInputField.selectAll();
                        return;
                    }
                } else if (inter <= 0.0f || inter >= 1.0f) {
                    JOptionPane.showMessageDialog(FOMInitDialog.this, "Interval must be > 0 and < 1.0", "Number Format Error", 0);
                    FOMInitDialog.this.cPanel.thresholdInputField.requestFocus();
                    FOMInitDialog.this.cPanel.thresholdInputField.selectAll();
                    return;
                }
                UIManager.put("TabbedPane.selected", Color.lightGray);
                FOMInitDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                UIManager.put("TabbedPane.selected", Color.lightGray);
                FOMInitDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                FOMInitDialog.this.resetControls();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(FOMInitDialog.this, "FOM Initialization Dialog");
            }
        }

        @Override
        public void windowClosing(WindowEvent we) {
            UIManager.put("TabbedPane.selected", Color.lightGray);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane tPane = (JTabbedPane)changeEvent.getSource();
            if (tPane.getSelectedIndex() == 0) {
                FOMInitDialog.this.iPanel.setEnabled(true);
            } else {
                FOMInitDialog.this.iPanel.setEnabled(false);
            }
        }
    }

    private class IterationPanel
    extends ParameterPanel {
        JLabel iterationLabel;
        JTextField iterationField;

        public IterationPanel() {
            super("FOM Iteration Selection");
            this.setLayout(new GridBagLayout());
            this.iterationLabel = new JLabel("Number of FOM Iterations");
            this.iterationLabel.setOpaque(false);
            this.iterationField = new JTextField("1", 5);
            this.add((Component)this.iterationLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
            this.add((Component)this.iterationField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        }

        @Override
        public void setEnabled(boolean enable) {
            this.iterationLabel.setEnabled(enable);
            this.iterationField.setEnabled(enable);
            if (enable) {
                this.iterationField.setBackground(Color.white);
            } else {
                this.iterationField.setBackground(Color.lightGray);
            }
        }
    }

    class SampleSelectionPanel
    extends JPanel {
        JRadioButton calcGenes;
        JRadioButton calcExperiments;

        SampleSelectionPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Sample Selection", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.calcGenes = new JRadioButton("Gene Cluster FOM", true);
            this.calcGenes.setFocusPainted(false);
            this.calcGenes.setBackground(Color.white);
            this.calcGenes.setForeground(UIManager.getColor("Label.foreground"));
            FOMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 0);
            gridbag.setConstraints(this.calcGenes, constraints);
            this.add(this.calcGenes);
            this.calcExperiments = new JRadioButton("Sample Cluster FOM");
            this.calcExperiments.setFocusPainted(false);
            this.calcExperiments.setBackground(Color.white);
            this.calcExperiments.setForeground(UIManager.getColor("Label.foreground"));
            FOMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            gridbag.setConstraints(this.calcExperiments, constraints);
            this.add(this.calcExperiments);
            ButtonGroup group = new ButtonGroup();
            group.add(this.calcGenes);
            group.add(this.calcExperiments);
        }
    }

    class CASTPanel
    extends JPanel {
        JTextField thresholdInputField;

        CASTPanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            JPanel pane = new JPanel();
            this.setLayout(gridbag);
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createLineBorder(Color.lightGray, 2));
            JPanel panel1 = new JPanel();
            GridBagLayout grid1 = new GridBagLayout();
            panel1.setLayout(grid1);
            panel1.setBackground(Color.white);
            JLabel thresholdLabel = new JLabel("Interval ( enter a value between 0 and 1):    ");
            thresholdLabel.setBackground(Color.white);
            FOMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
            constraints.anchor = 13;
            grid1.setConstraints(thresholdLabel, constraints);
            panel1.add(thresholdLabel);
            this.thresholdInputField = new JTextField("0.1", 7);
            FOMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            constraints.anchor = 17;
            grid1.setConstraints(this.thresholdInputField, constraints);
            panel1.add(this.thresholdInputField);
            FOMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 60);
            constraints.anchor = 10;
            gridbag.setConstraints(panel1, constraints);
            this.add(panel1);
            JPanel textPanel = new JPanel();
            GridBagLayout textGrid = new GridBagLayout();
            textPanel.setLayout(textGrid);
            textPanel.setBackground(Color.white);
            textPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JLabel label2 = new JLabel("CAST will be run with threshold affinities starting with above interval,");
            label2.setBackground(Color.white);
            FOMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 100, 33);
            constraints.anchor = 16;
            textGrid.setConstraints(label2, constraints);
            textPanel.add(label2);
            JLabel label3 = new JLabel("with affinity being incremented by the interval value in subsequent");
            label3.setBackground(Color.white);
            FOMInitDialog.this.buildConstraints(constraints, 0, 2, 1, 1, 0, 33);
            constraints.anchor = 17;
            textGrid.setConstraints(label3, constraints);
            textPanel.add(label3);
            JLabel label4 = new JLabel("iterations, up to a maximum threshold affinity of 1.0");
            label4.setBackground(Color.white);
            FOMInitDialog.this.buildConstraints(constraints, 0, 3, 1, 1, 0, 34);
            constraints.anchor = 18;
            textGrid.setConstraints(label4, constraints);
            textPanel.add(label4);
            constraints.anchor = 10;
            FOMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 40);
            gridbag.setConstraints(textPanel, constraints);
            this.add(textPanel);
        }
    }

    class KMCPanel
    extends JPanel {
        JRadioButton meansButton;
        JRadioButton mediansButton;
        JTextField intervalInputField;
        JTextField iterationInputField;

        KMCPanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createLineBorder(Color.lightGray, 2));
            JPanel panel1 = new JPanel();
            GridBagLayout grid1 = new GridBagLayout();
            panel1.setLayout(grid1);
            panel1.setBackground(Color.white);
            panel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 15, 10));
            this.meansButton = new JRadioButton("Calculate means", true);
            this.meansButton.setBackground(Color.white);
            this.meansButton.setForeground(UIManager.getColor("Label.foreground"));
            this.meansButton.setFocusPainted(false);
            this.mediansButton = new JRadioButton("Calculate medians", false);
            this.mediansButton.setBackground(Color.white);
            this.mediansButton.setForeground(UIManager.getColor("Label.foreground"));
            this.mediansButton.setFocusPainted(false);
            ButtonGroup chooseMeansOrMedians = new ButtonGroup();
            chooseMeansOrMedians.add(this.meansButton);
            chooseMeansOrMedians.add(this.mediansButton);
            FOMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
            grid1.setConstraints(this.meansButton, constraints);
            panel1.add(this.meansButton);
            FOMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            grid1.setConstraints(this.mediansButton, constraints);
            panel1.add(this.mediansButton);
            FOMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 40);
            constraints.fill = 1;
            gridbag.setConstraints(panel1, constraints);
            this.add(panel1);
            JPanel panel2 = new JPanel();
            GridBagLayout grid2 = new GridBagLayout();
            panel2.setLayout(grid2);
            panel2.setBackground(Color.white);
            constraints.fill = 0;
            JLabel intervalLabel = new JLabel("Maximum number of clusters (enter an integer > 0):   ");
            intervalLabel.setBackground(Color.white);
            FOMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
            constraints.anchor = 13;
            grid2.setConstraints(intervalLabel, constraints);
            panel2.add(intervalLabel);
            this.intervalInputField = new JTextField("20", 7);
            FOMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            constraints.anchor = 17;
            grid2.setConstraints(this.intervalInputField, constraints);
            panel2.add(this.intervalInputField);
            JLabel iterationLabel = new JLabel("Maximum number of iterations (enter an integer > 0):   ");
            iterationLabel.setBackground(Color.white);
            FOMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 50, 100);
            constraints.anchor = 13;
            constraints.insets.top = 10;
            grid2.setConstraints(iterationLabel, constraints);
            panel2.add(iterationLabel);
            this.iterationInputField = new JTextField("50", 7);
            FOMInitDialog.this.buildConstraints(constraints, 1, 1, 1, 1, 50, 0);
            constraints.anchor = 17;
            grid2.setConstraints(this.iterationInputField, constraints);
            panel2.add(this.iterationInputField);
            constraints.insets.top = 0;
            constraints.anchor = 10;
            FOMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 20);
            gridbag.setConstraints(panel2, constraints);
            this.add(panel2);
            JPanel textPanel = new JPanel();
            GridBagLayout textGrid = new GridBagLayout();
            textPanel.setLayout(textGrid);
            textPanel.setBackground(Color.white);
            textPanel.setBorder(BorderFactory.createEmptyBorder(20, 10, 20, 10));
            JLabel label2 = new JLabel("K-Means / K-Medians will be run using a starting K (number of clusters) = 1,");
            label2.setBackground(Color.white);
            constraints.anchor = 16;
            FOMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 100, 33);
            textGrid.setConstraints(label2, constraints);
            textPanel.add(label2);
            JLabel label3 = new JLabel("with K being incremented by 1 in each subsequent iteration, up to the");
            label3.setBackground(Color.white);
            constraints.anchor = 17;
            FOMInitDialog.this.buildConstraints(constraints, 0, 2, 1, 1, 0, 33);
            textGrid.setConstraints(label3, constraints);
            textPanel.add(label3);
            JLabel label4 = new JLabel("maximum number of clusters specified above");
            label4.setBackground(Color.white);
            constraints.anchor = 18;
            FOMInitDialog.this.buildConstraints(constraints, 0, 3, 1, 1, 0, 34);
            textGrid.setConstraints(label4, constraints);
            textPanel.add(label4);
            constraints.anchor = 10;
            FOMInitDialog.this.buildConstraints(constraints, 0, 2, 1, 1, 0, 40);
            gridbag.setConstraints(textPanel, constraints);
            this.add(textPanel);
        }
    }
}

