/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.fom;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class FOMGraph
extends JPanel
implements Serializable {
    public static final long serialVersionUID = 202003060001L;
    private float[] values;
    private float[][] iValues;
    private float[] variances;
    private String[] xItems;
    private String[] yItems;
    private String title;
    private String xLabel;
    private String yLabel;
    private Insets insets;
    private boolean isAntiAliasing = false;
    private int maxXItem;
    private int maxYItem;
    private float maxYValue = 1.0f;
    private Color pointColor = Color.red;
    private Color valuesLineColor = Color.blue;
    private Color iterationLineColor = Color.lightGray;
    private Color sdLineColor = Color.darkGray;
    private Color mouseLineColor = Color.magenta;
    private Color gridLineColor = Color.yellow;
    private Color axisLineColor = Color.black;
    private int pointSize = 5;
    private boolean haveIValues;
    private boolean showVariance;
    private boolean showIValues;
    private JPopupMenu menu;
    private JCheckBoxMenuItem menuItem;
    private MouseHandler mouseHandler;

    public FOMGraph(float[] values, float[] variances, String title, String xLabel, String yLabel, boolean showVariance) {
        if (values == null) {
            throw new IllegalArgumentException("values == null");
        }
        this.setBackground(Color.white);
        this.insets = new Insets(60, 60, 60, 60);
        this.showVariance = showVariance;
        this.values = values;
        this.variances = variances;
        this.title = title;
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.mouseHandler = new MouseHandler();
        this.addMouseMotionListener(this.mouseHandler);
        this.addMouseListener(this.mouseHandler);
    }

    public FOMGraph() {
        this.setBackground(Color.white);
        this.mouseHandler = new MouseHandler();
        this.addMouseMotionListener(this.mouseHandler);
        this.addMouseListener(this.mouseHandler);
    }

    public void setItems(String[] xItems, String[] yItems) {
        this.xItems = xItems;
        this.yItems = yItems;
        this.maxXItem = this.getMaxWidth(xItems);
        this.maxYItem = this.getMaxWidth(yItems);
    }

    public void setFOMIterationValues(float[][] values) {
        this.iValues = values;
        if (this.iValues != null) {
            this.haveIValues = true;
            this.showIValues = false;
            this.createJPopupMenu();
        }
    }

    public void createJPopupMenu() {
        MouseHandler mh = new MouseHandler();
        this.menuItem = new JCheckBoxMenuItem("Show Iteration Values", false);
        this.menuItem.addActionListener(mh);
        this.menuItem.setFocusPainted(false);
        this.menu = new JPopupMenu();
        this.menu.add(this.menuItem);
    }

    public void setMaxYValue(float value) {
        this.maxYValue = value;
    }

    public BufferedImage getImage() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        this.paint(g);
        return image;
    }

    public void setAntiAliasing(boolean value) {
        this.isAntiAliasing = value;
    }

    @Override
    public void paint(Graphics g1D) {
        int y2;
        int x2;
        int y1;
        int i;
        float xItemsStep;
        int i2;
        float yItemsStep;
        super.paint(g1D);
        Graphics2D g = (Graphics2D)g1D;
        FontMetrics metrics = g.getFontMetrics();
        int descent = metrics.getDescent();
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Dimension size = this.getSize();
        int left = this.insets.left + this.maxYItem;
        int top = this.insets.top;
        int width = size.width - left - this.insets.right;
        int height = size.height - this.insets.bottom - top - this.maxXItem;
        float xScale = (float)width / (float)(this.values.length - 1);
        float yScale = (float)height / this.maxYValue;
        int strWidth = metrics.stringWidth(this.title);
        g.drawString(this.title, left + (width - strWidth) / 2, (this.insets.top + descent) / 2);
        strWidth = metrics.stringWidth(this.xLabel);
        g.drawString(this.xLabel, left + (width - strWidth) / 2, this.insets.top + height + this.maxXItem + (this.insets.top + descent) / 2);
        strWidth = metrics.stringWidth(this.yLabel);
        g.rotate(-1.5707963267948966);
        g.drawString(this.yLabel, -(this.insets.top + (height + strWidth) / 2), (this.insets.left + descent) / 2);
        g.rotate(1.5707963267948966);
        g.setColor(this.gridLineColor);
        if (this.yItems != null) {
            yItemsStep = (float)height / (float)(this.yItems.length - 1);
            for (i2 = 0; i2 < this.yItems.length; ++i2) {
                if (this.yItems[this.yItems.length - i2 - 1] == null) continue;
                g.drawLine(left, top + Math.round((float)i2 * yItemsStep), left + width, top + Math.round((float)i2 * yItemsStep));
            }
        }
        if (this.xItems != null) {
            xItemsStep = (float)width / (float)(this.xItems.length - 1);
            for (i2 = 0; i2 < this.xItems.length; ++i2) {
                if (this.xItems[i2] == null) continue;
                g.drawLine(left + Math.round((float)i2 * xItemsStep), top, left + Math.round((float)i2 * xItemsStep), top + height);
            }
        }
        g.setColor(this.axisLineColor);
        g.drawLine(left, top, left, top + height);
        if (this.yItems != null) {
            yItemsStep = (float)height / (float)(this.yItems.length - 1);
            for (i2 = 0; i2 < this.yItems.length; ++i2) {
                g.drawLine(left - 5, top + Math.round((float)i2 * yItemsStep), left + 5, top + Math.round((float)i2 * yItemsStep));
                if (this.yItems[this.yItems.length - i2 - 1] == null) continue;
                g.drawString(this.yItems[this.yItems.length - i2 - 1], left - 7 - metrics.stringWidth(this.yItems[this.yItems.length - i2 - 1]), top + Math.round((float)i2 * yItemsStep) + descent);
            }
        }
        if (this.xItems != null) {
            xItemsStep = (float)width / (float)(this.xItems.length - 1);
            for (i2 = 0; i2 < this.xItems.length; ++i2) {
                g.drawLine(left + Math.round((float)i2 * xItemsStep), top + height - 5, left + Math.round((float)i2 * xItemsStep), top + height + 5);
            }
            g.rotate(-1.5707963267948966);
            int bottom = top + height + 7;
            for (int i3 = 0; i3 < this.xItems.length; ++i3) {
                if (this.xItems[i3] == null) continue;
                g.drawString(this.xItems[i3], -(bottom + metrics.stringWidth(this.xItems[i3])), left + Math.round((float)i3 * xItemsStep) + descent);
            }
            g.rotate(1.5707963267948966);
        }
        g.drawLine(left, top + height, left + width, top + height);
        g.setColor(this.valuesLineColor);
        if (this.showIValues) {
            g.setColor(this.iterationLineColor);
            for (i = 0; i < this.iValues.length; ++i) {
                for (int j = 0; j < this.iValues[i].length - 1; ++j) {
                    int x1 = left + Math.round((float)j * xScale);
                    y1 = top + height - Math.round(this.iValues[i][j] * yScale);
                    x2 = left + Math.round((float)(j + 1) * xScale);
                    y2 = top + height - Math.round(this.iValues[i][j + 1] * yScale);
                    g.drawLine(x1, y1, x2, y2);
                }
            }
        }
        for (i = 0; i < this.values.length - 1; ++i) {
            g.setColor(this.valuesLineColor);
            int x1 = left + Math.round((float)i * xScale);
            y1 = top + height - Math.round(this.values[i] * yScale);
            x2 = left + Math.round((float)(i + 1) * xScale);
            y2 = top + height - Math.round(this.values[i + 1] * yScale);
            g.drawLine(x1, y1, x2, y2);
            g.drawLine(x1, y1 - 1, x2, y2 - 1);
            if (!this.showVariance) continue;
            g.setColor(this.sdLineColor);
            int sdX = x2;
            int sdY = y2;
            x1 = left + Math.round((float)(i + 1) * xScale) - 3;
            y1 = top + height - Math.round((this.values[i + 1] + this.variances[i + 1]) * yScale);
            y2 = top + height - Math.round((this.values[i + 1] - this.variances[i + 1]) * yScale);
            g.drawLine(x1, y1, x2 += 3, y1);
            g.drawLine(x1, y2, x2, y2);
            g.drawLine(sdX, sdY, sdX, y1);
            g.drawLine(sdX, sdY, sdX, y2);
        }
        g.setColor(this.pointColor);
        for (i = 0; i < this.values.length; ++i) {
            g.fillOval(left + Math.round((float)i * xScale) - this.pointSize / 2, top + height - Math.round(this.values[i] * yScale) - this.pointSize / 2, this.pointSize, this.pointSize);
        }
        this.mouseHandler.validate();
    }

    private int getMaxWidth(String[] items) {
        if (items == null) {
            return 0;
        }
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int width = 0;
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            width = Math.max(width, metrics.stringWidth(items[i]));
        }
        return width;
    }

    private void drawMouseCross(int x, int y) {
        Graphics2D g = (Graphics2D)this.getGraphics();
        g.setColor(this.mouseLineColor);
        g.setXORMode(this.getBackground());
        Dimension size = this.getSize();
        int left = this.insets.left + this.maxYItem;
        int right = size.width - this.insets.right;
        int top = this.insets.top;
        int bottom = size.height - this.insets.bottom - this.maxXItem;
        g.drawLine(x, top, x, bottom);
        g.drawLine(left, y, right, y);
        g.setPaintMode();
        g.dispose();
    }

    public boolean isHaveIValues() {
        return this.haveIValues;
    }

    public void setHaveIValues(boolean haveIValues) {
        this.haveIValues = haveIValues;
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public float[][] getIValues() {
        return this.iValues;
    }

    public void setIValues(float[][] values) {
        this.iValues = values;
    }

    public int getMaxXItem() {
        return this.maxXItem;
    }

    public void setMaxXItem(int maxXItem) {
        this.maxXItem = maxXItem;
    }

    public int getMaxYItem() {
        return this.maxYItem;
    }

    public void setMaxYItem(int maxYItem) {
        this.maxYItem = maxYItem;
    }

    public boolean isShowIValues() {
        return this.showIValues;
    }

    public void setShowIValues(boolean showIValues) {
        this.showIValues = showIValues;
    }

    public boolean isShowVariance() {
        return this.showVariance;
    }

    public void setShowVariance(boolean showVariance) {
        this.showVariance = showVariance;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public float[] getValues() {
        return this.values;
    }

    public void setValues(float[] values) {
        this.values = values;
    }

    public float[] getVariances() {
        return this.variances;
    }

    public void setVariances(float[] variances) {
        this.variances = variances;
    }

    public String[] getXItems() {
        return this.xItems;
    }

    public void setXItems(String[] items) {
        this.xItems = items;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public void setXLabel(String label) {
        this.xLabel = label;
    }

    public String[] getYItems() {
        return this.yItems;
    }

    public void setYItems(String[] items) {
        this.yItems = items;
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public void setYLabel(String label) {
        this.yLabel = label;
    }

    public boolean isAntiAliasing() {
        return this.isAntiAliasing;
    }

    public float getMaxYValue() {
        return this.maxYValue;
    }

    private class MouseHandler
    extends MouseMotionAdapter
    implements ActionListener,
    MouseListener,
    Serializable {
        private Point prevCoords = new Point(-1, -1);

        private MouseHandler() {
        }

        public void validate() {
            if (this.isCoordsValid(this.prevCoords.x, this.prevCoords.y)) {
                FOMGraph.this.drawMouseCross(this.prevCoords.x, this.prevCoords.y);
            }
            this.prevCoords.setLocation(-1, -1);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (this.isCoordsValid(this.prevCoords.x, this.prevCoords.y)) {
                FOMGraph.this.drawMouseCross(this.prevCoords.x, this.prevCoords.y);
            }
            if (this.isCoordsValid(x, y)) {
                FOMGraph.this.drawMouseCross(x, y);
            }
            this.prevCoords.setLocation(x, y);
        }

        private boolean isCoordsValid(int x, int y) {
            Dimension size = FOMGraph.this.getSize();
            int left = ((FOMGraph)FOMGraph.this).insets.left + FOMGraph.this.maxYItem;
            int top = ((FOMGraph)FOMGraph.this).insets.top;
            int right = size.width - ((FOMGraph)FOMGraph.this).insets.right;
            int bottom = size.height - ((FOMGraph)FOMGraph.this).insets.bottom - FOMGraph.this.maxXItem;
            return left < x && x < right && top < y && y < bottom;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (FOMGraph.this.menu != null && e.isPopupTrigger()) {
                FOMGraph.this.menu.show(FOMGraph.this, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (FOMGraph.this.menu != null && e.isPopupTrigger()) {
                FOMGraph.this.menu.show(FOMGraph.this, e.getX(), e.getY());
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (FOMGraph.this.menuItem.isSelected()) {
                FOMGraph.this.showIValues = true;
                FOMGraph.this.repaint();
            } else {
                FOMGraph.this.showIValues = false;
                FOMGraph.this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

