/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.fom;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.fom.CastFOMViewerA;
import org.tigr.microarray.mev.cluster.gui.impl.fom.CastFOMViewerB;
import org.tigr.microarray.mev.cluster.gui.impl.fom.FOMInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.fom.KFOMViewer;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class FOMGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Progress progress;
    private boolean clusterGenes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        FOMInitDialog fom_dialog = new FOMInitDialog((JFrame)framework.getFrame(), true);
        fom_dialog.setVisible(true);
        if (!fom_dialog.isOkPressed()) {
            return null;
        }
        int fomIterations = fom_dialog.getFOMIterations();
        int method = fom_dialog.getMethod();
        float interval = fom_dialog.getInterval();
        int numberOfClusters = fom_dialog.getIterations();
        int iterations = fom_dialog.getKMCIterations();
        boolean average = fom_dialog.isAverage();
        boolean calculateMeans = fom_dialog.useMeans();
        this.clusterGenes = fom_dialog.isClusterGenes();
        Experiment experiment = framework.getData().getExperiment();
        Listener listener = new Listener();
        try {
            FloatMatrix fm;
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("FOM");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            int genes = experiment.getNumberOfGenes();
            this.progress = new Progress(framework.getFrame(), "Calculating FOM values", listener);
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            FloatMatrix matrix = experiment.getMatrix();
            if (!this.clusterGenes) {
                matrix = matrix.transpose();
            }
            data.addMatrix("experiment", matrix);
            data.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu menu = framework.getDistanceMenu();
            data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
            int function = menu.getDistanceFunction();
            if (function == 0) {
                function = 4;
            }
            data.addParam("distance-function", String.valueOf(function));
            if (method != 2) {
                fomIterations = 1;
            }
            data.addParam("fom-iterations", String.valueOf(fomIterations));
            data.addParam("method", String.valueOf(method));
            data.addParam("cluster-genes", String.valueOf(this.clusterGenes));
            data.addParam("number-of-clusters", String.valueOf(numberOfClusters));
            data.addParam("interval", String.valueOf(interval));
            data.addParam("iterations", String.valueOf(iterations));
            data.addParam("average", String.valueOf(average));
            data.addParam("calculate-means", String.valueOf(calculateMeans));
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            float[] fom_values = null;
            if (method != 2 && (fm = result.getMatrix("fom-values")) != null) {
                fom_values = fm.A[0];
            }
            int[] numOfCastClusters = result.getIntArray("numOfCastClusters");
            GeneralInfo info = new GeneralInfo();
            info.fomIterations = fomIterations;
            info.average = average;
            info.function = menu.getFunctionName(function);
            info.interval = interval;
            info.iterations = iterations;
            info.method = method;
            if (method == 2) {
                info.kMeansOrKMedians = calculateMeans ? "Calculated Means" : "Calculated Medians";
            }
            info.time = time;
            if (method == 2) {
                FloatMatrix resultMatrix = result.getMatrix("fom-matrix");
                float[] means = this.getMeans(resultMatrix);
                float[] variances = null;
                if (resultMatrix != null && resultMatrix.getRowDimension() > 1) {
                    variances = this.getVariances(resultMatrix, means);
                }
                DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(means, variances, resultMatrix.A, info, interval, numOfCastClusters);
                return defaultMutableTreeNode;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(fom_values, null, null, info, interval, numOfCastClusters);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        FOMInitDialog fom_dialog = new FOMInitDialog((JFrame)framework.getFrame(), true);
        fom_dialog.setVisible(true);
        if (!fom_dialog.isOkPressed()) {
            return null;
        }
        int fomIterations = fom_dialog.getFOMIterations();
        int method = fom_dialog.getMethod();
        float interval = fom_dialog.getInterval();
        int numberOfClusters = fom_dialog.getIterations();
        int iterations = fom_dialog.getKMCIterations();
        boolean average = fom_dialog.isAverage();
        boolean calculateMeans = fom_dialog.useMeans();
        this.clusterGenes = fom_dialog.isClusterGenes();
        Experiment experiment = framework.getData().getExperiment();
        int genes = experiment.getNumberOfGenes();
        AlgorithmData data = new AlgorithmData();
        data.addParam("distance-factor", String.valueOf(1.0f));
        IDistanceMenu menu = framework.getDistanceMenu();
        data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 4;
        }
        data.addParam("distance-function", String.valueOf(function));
        if (method != 2) {
            fomIterations = 1;
        }
        data.addParam("fom-iterations", String.valueOf(fomIterations));
        data.addParam("method", String.valueOf(method));
        data.addParam("cluster-genes", String.valueOf(this.clusterGenes));
        data.addParam("number-of-clusters", String.valueOf(numberOfClusters));
        data.addParam("interval", String.valueOf(interval));
        data.addParam("iterations", String.valueOf(iterations));
        data.addParam("average", String.valueOf(average));
        data.addParam("calculate-means", String.valueOf(calculateMeans));
        data.addParam("name", "FOM");
        data.addParam("alg-type", "cluster");
        data.addParam("output-class", "single-output");
        String[] outputNodes = new String[]{"FOM Result"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        AlgorithmParameters params = algData.getParams();
        this.clusterGenes = params.getBoolean("cluster-genes");
        int method = params.getInt("method");
        float interval = params.getFloat("interval");
        boolean calculateMeans = true;
        if (method == 2) {
            calculateMeans = params.getBoolean("calculate-means");
        }
        Listener listener = new Listener();
        try {
            FloatMatrix fm;
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("FOM");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            int genes = experiment.getNumberOfGenes();
            this.progress = new Progress(framework.getFrame(), "Calculating FOM values", listener);
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            FloatMatrix matrix = experiment.getMatrix();
            if (!this.clusterGenes) {
                matrix = matrix.transpose();
            }
            algData.addMatrix("experiment", matrix);
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            float[] fom_values = null;
            if (method != 2 && (fm = result.getMatrix("fom-values")) != null) {
                fom_values = fm.A[0];
            }
            int[] numOfCastClusters = result.getIntArray("numOfCastClusters");
            GeneralInfo info = new GeneralInfo();
            info.fomIterations = params.getInt("fom-iterations");
            info.average = params.getBoolean("average");
            int function = params.getInt("distance-function");
            info.function = framework.getDistanceMenu().getFunctionName(function);
            info.interval = params.getFloat("interval");
            info.iterations = params.getInt("iterations");
            info.method = method;
            if (method == 2) {
                info.kMeansOrKMedians = calculateMeans ? "Calculated Means" : "Calculated Medians";
            }
            info.time = time;
            if (method == 2) {
                FloatMatrix resultMatrix = result.getMatrix("fom-matrix");
                float[] means = this.getMeans(resultMatrix);
                float[] variances = null;
                if (resultMatrix != null && resultMatrix.getRowDimension() > 1) {
                    variances = this.getVariances(resultMatrix, means);
                }
                DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(means, variances, resultMatrix.A, info, interval, numOfCastClusters);
                return defaultMutableTreeNode;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(fom_values, null, null, info, interval, numOfCastClusters);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private DefaultMutableTreeNode createResultTree(float[] fom_values, float[] fom_vars, float[][] iValues, GeneralInfo info, float interval, int[] numOfCastClusters) {
        DefaultMutableTreeNode root = this.clusterGenes ? new DefaultMutableTreeNode("FOM - genes") : new DefaultMutableTreeNode("FOM - samples");
        this.addResultNodes(root, fom_values, fom_vars, iValues, info, interval, numOfCastClusters);
        return root;
    }

    private void addResultNodes(DefaultMutableTreeNode root, float[] fom_values, float[] fom_vars, float[][] iValues, GeneralInfo info, float interval, int[] numOfCastClusters) {
        this.addGraphViewer(root, fom_values, fom_vars, iValues, info, interval, numOfCastClusters);
        this.addGeneralInfo(root, info);
    }

    private void addGraphViewer(DefaultMutableTreeNode root, float[] fom_values, float[] variances, float[][] iValues, GeneralInfo info, float interval, int[] numOfCastClusters) {
        ViewerAdapter viewer = null;
        if (info.method == 2) {
            viewer = new KFOMViewer(fom_values, variances);
            if (variances != null && iValues != null) {
                ((KFOMViewer)viewer).setFOMIterationValues(iValues);
            }
            root.add(new DefaultMutableTreeNode(new LeafInfo("Graph - FOM value vs. # of Clusters", (IViewer)viewer)));
        } else {
            viewer = new CastFOMViewerA(fom_values, interval, numOfCastClusters);
            CastFOMViewerB viewer2 = new CastFOMViewerB(fom_values, interval, numOfCastClusters);
            root.add(new DefaultMutableTreeNode(new LeafInfo("Graph - FOM value vs. Threshold", (IViewer)viewer)));
            root.add(new DefaultMutableTreeNode(new LeafInfo("Graph - FOM value vs. # of Clusters", (IViewer)viewer2)));
        }
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        if (info.method == 1) {
            node.add(new DefaultMutableTreeNode("Method: " + info.getMethod()));
        }
        if (info.method == 2) {
            node.add(new DefaultMutableTreeNode("Method: " + info.getMethod() + " : " + info.kMeansOrKMedians));
            node.add(new DefaultMutableTreeNode("FOM Iterations: " + String.valueOf(info.fomIterations)));
            node.add(new DefaultMutableTreeNode("Max KMC Iterations: " + String.valueOf(info.iterations)));
        } else {
            node.add(new DefaultMutableTreeNode("Interval: " + String.valueOf(info.interval)));
        }
        node.add(new DefaultMutableTreeNode("Average: " + String.valueOf(info.average)));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
        node.add(new DefaultMutableTreeNode(info.function));
        root.add(node);
    }

    private float[] getMeans(FloatMatrix data) {
        int nSamples = data.getColumnDimension();
        int nFOMI = data.getRowDimension();
        float[] means = new float[nSamples];
        float sum = 0.0f;
        float n = 0.0f;
        for (int i = 0; i < nSamples; ++i) {
            n = 0.0f;
            sum = 0.0f;
            for (int j = 0; j < nFOMI; ++j) {
                float value = data.get(j, i);
                if (Float.isNaN(value)) continue;
                sum += value;
                n += 1.0f;
            }
            means[i] = n > 0.0f ? sum / n : Float.NaN;
        }
        return means;
    }

    private float[] getVariances(FloatMatrix values, float[] means) {
        int iterations = values.getRowDimension();
        int nSamples = values.getColumnDimension();
        float[] vars = new float[nSamples];
        if (iterations == 1) {
            return vars;
        }
        for (int sample = 0; sample < nSamples; ++sample) {
            for (int iter = 0; iter < iterations; ++iter) {
                int n = sample;
                vars[n] = (float)((double)vars[n] + Math.pow(values.A[iter][sample] - means[sample], 2.0));
            }
            vars[sample] = (float)Math.sqrt(vars[sample] / (float)(iterations - 1));
        }
        return vars;
    }

    private class GeneralInfo {
        public int method;
        public String kMeansOrKMedians;
        public float interval;
        public int iterations;
        public boolean average;
        public long time;
        public String function;
        public int fomIterations;

        private GeneralInfo() {
        }

        public String getMethod() {
            return this.method == 1 ? "CAST" : "KMC";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    FOMGUI.this.progress.setUnits(event.getIntValue());
                    FOMGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    FOMGUI.this.progress.setValue(event.getIntValue());
                    FOMGUI.this.progress.setDescription(event.getDescription());
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                FOMGUI.this.algorithm.abort();
                FOMGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            FOMGUI.this.algorithm.abort();
            FOMGUI.this.progress.dispose();
        }
    }
}

