/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.fom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.fom.FOMGraph;

public class FOMContentComponent
extends JPanel
implements Serializable {
    private FOMGraph fomGraph;
    private float[] fom_values;
    private float[] variances;
    private boolean showVariance = false;
    private GridBagConstraints gbc;

    public FOMContentComponent(float[] fom_values, float[] variances) {
        this.setLayout(new GridBagLayout());
        this.fom_values = fom_values;
        this.variances = variances;
        if (this.variances != null) {
            this.showVariance = true;
            this.fomGraph = new FOMGraph(fom_values, variances, "Mean Adjusted FOM values (\u00b1 SD)  vs.  Number of Clusters", "Number of Clusters", "Mean Adjusted FOM", true);
        } else {
            this.fomGraph = new FOMGraph(fom_values, variances, "FOM value vs. # of clusters", "Number of Clusters", "Adjusted FOM", false);
        }
        this.fomGraph.setItems(this.createXItems(fom_values.length), this.createYItems(fom_values));
        this.fomGraph.setMaxYValue((float)Math.ceil(this.getMaxValue(fom_values)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.9;
        gbc.weighty = 1.0;
        this.add((Component)this.fomGraph, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.1;
        this.add((Component)this.createValuesList(fom_values), gbc);
    }

    public static String[] getPersistenceDelegateArgs() {
        return new String[]{"fom_values", "variances"};
    }

    public void setFOMIterationValues(float[][] values) {
        this.fomGraph.setFOMIterationValues(values);
    }

    public BufferedImage getImage() {
        return this.fomGraph.getImage();
    }

    private JComponent createValuesList(float[] fom_values) {
        String[] items = new String[fom_values.length];
        for (int i = 0; i < fom_values.length; ++i) {
            items[i] = String.valueOf(i + 1) + "---->" + String.valueOf((float)Math.round(fom_values[i] * 1000.0f) / 1000.0f);
            if (!this.showVariance) continue;
            int n = i;
            items[n] = items[n] + " \u00b1 " + String.valueOf((float)Math.round(this.variances[i] * 1000.0f) / 1000.0f);
        }
        JPanel listPanel = new JPanel(new GridBagLayout());
        JScrollPane scroll = new JScrollPane(new JList<String>(items));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        listPanel.add((Component)scroll, gbc);
        gbc.fill = 2;
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        JButton button = new JButton("Details");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FOMContentComponent.this.onDetails();
            }
        });
        listPanel.add((Component)button, gbc);
        return listPanel;
    }

    private void onDetails() {
        JFrame f = new JFrame("Details");
        JTextArea t = new JTextArea();
        t.setEditable(false);
        JScrollPane sp = new JScrollPane(t);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.fom_values.length; ++i) {
            sb.append(String.valueOf(i + 1) + "\t" + String.valueOf((float)Math.round(this.fom_values[i] * 1000.0f) / 1000.0f) + "\n");
        }
        t.setText(sb.toString());
        t.setCaretPosition(0);
        f.getContentPane().add(sp);
        f.setSize(200, 200);
        Dimension screenSize = f.getToolkit().getScreenSize();
        f.setLocation(screenSize.width / 2 - f.getSize().width / 2, screenSize.height / 2 - f.getSize().height / 2);
        f.setVisible(true);
    }

    public void onSelected(IFramework framework) {
        this.fomGraph.setAntiAliasing(framework.getDisplayMenu().isAntiAliasing());
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.fomGraph.setAntiAliasing(menu.isAntiAliasing());
    }

    private String[] createXItems(int iterations) {
        String[] items = new String[iterations];
        for (int i = 0; i < items.length; ++i) {
            if ((i + 1) % 5 != 0 && i != 0 && i != items.length - 1) continue;
            items[i] = String.valueOf(i + 1);
        }
        return items;
    }

    private float getMaxValue(float[] fom_values) {
        float max_value = -3.4028235E38f;
        for (int i = 0; i < fom_values.length; ++i) {
            max_value = Math.max(max_value, fom_values[i]);
        }
        return max_value;
    }

    private String[] createYItems(float[] fom_values) {
        int number_of_items = (int)Math.ceil(this.getMaxValue(fom_values)) + 1;
        String[] items = new String[number_of_items];
        for (int i = 0; i < items.length; ++i) {
            if (i % 2 != 0 && i != items.length - 1) continue;
            items[i] = String.valueOf(i);
        }
        return items;
    }

    public float[] getFom_values() {
        return this.fom_values;
    }

    public void setFom_values(float[] fom_values) {
        this.fom_values = fom_values;
        this.gbc.gridx = 1;
        this.gbc.weightx = 0.1;
        this.add((Component)this.createValuesList(fom_values), this.gbc);
    }

    public FOMGraph getFomGraph() {
        return this.fomGraph;
    }

    public void setFomGraph(FOMGraph fomGraph) {
        this.fomGraph = fomGraph;
        this.gbc.gridx = 0;
        this.gbc.weightx = 0.9;
        this.add((Component)this.fomGraph, this.gbc);
    }

    public boolean isShowVariance() {
        return this.showVariance;
    }

    public void setShowVariance(boolean showVariance) {
        this.showVariance = showVariance;
    }

    public float[] getVariances() {
        return this.variances;
    }

    public void setVariances(float[] variances) {
        this.variances = variances;
    }
}

