/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.fom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.fom.FOMGraph;

public class CastFOMContentComponentB
extends JPanel
implements Serializable {
    public static final long serialVersionUID = 202003030001L;
    private FOMGraph fomGraphB;
    private int[] numOfCastClusters;
    private float[] fom_values;
    float interval;
    float[] sortedFomValues;
    int[] sortedNumCastClusters;
    JPanel listPanel;
    private GridBagConstraints gbc;

    public CastFOMContentComponentB(float[] fom_values, float interval, int[] numOfCastClusters) {
        this.setLayout(new GridBagLayout());
        this.fom_values = fom_values;
        this.interval = interval;
        this.numOfCastClusters = numOfCastClusters;
        this.sortedFomValues = this.createSortedFomValues(fom_values, numOfCastClusters);
        this.sortedNumCastClusters = this.createSortedClusterArray(numOfCastClusters);
        this.fomGraphB = new FOMGraph(this.sortedFomValues, null, "FOM value vs. # of Clusters", "# of Clusters", "Adjusted FOM", false);
        this.fomGraphB.setItems(this.createXItems(this.sortedFomValues.length), this.createYItems(this.sortedFomValues));
        this.fomGraphB.setMaxYValue((float)Math.ceil(this.getMaxValue(this.sortedFomValues)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.9;
        gbc.weighty = 1.0;
        this.add((Component)this.fomGraphB, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.1;
        this.add((Component)this.createValuesList(this.sortedFomValues, numOfCastClusters), gbc);
    }

    public static String[] getPersistenceDelegateArgs() {
        return new String[]{"fom_values", "interval", "numOfCastClusters"};
    }

    public CastFOMContentComponentB() {
        this.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.gbc.gridy = 0;
        this.gbc.weighty = 1.0;
    }

    public FOMGraph getFomGraphB() {
        return this.fomGraphB;
    }

    public void setFomGraphB(FOMGraph fomGraphB) {
        this.gbc.gridx = 0;
        this.gbc.weightx = 0.9;
        this.fomGraphB = fomGraphB;
    }

    public BufferedImage getImageB() {
        return this.fomGraphB.getImage();
    }

    private JComponent createValuesList(float[] fom_values, int[] numOfCastClusters) {
        String[] items = new String[fom_values.length];
        int[] sortedNumCastClusters = this.createSortedClusterArray(numOfCastClusters);
        for (int i = 0; i < fom_values.length; ++i) {
            items[i] = String.valueOf(sortedNumCastClusters[i]) + "---->" + String.valueOf((float)Math.round(fom_values[i] * 1000.0f) / 1000.0f);
        }
        JPanel listPanel = new JPanel(new GridBagLayout());
        JScrollPane scroll = new JScrollPane(new JList<String>(items));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        listPanel.add((Component)scroll, gbc);
        gbc.fill = 2;
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        JButton button = new JButton("Details");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CastFOMContentComponentB.this.onDetails();
            }
        });
        listPanel.add((Component)button, gbc);
        this.listPanel = listPanel;
        return listPanel;
    }

    private void onDetails() {
        JFrame f = new JFrame("Details");
        JTextArea t = new JTextArea();
        t.setEditable(false);
        JScrollPane sp = new JScrollPane(t);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.sortedFomValues.length; ++i) {
            sb.append(String.valueOf(this.sortedNumCastClusters[i]) + "\t" + String.valueOf((float)Math.round(this.sortedFomValues[i] * 1000.0f) / 1000.0f) + "\n");
        }
        t.setText(sb.toString());
        t.setCaretPosition(0);
        f.getContentPane().add(sp);
        f.setSize(200, 200);
        Dimension screenSize = f.getToolkit().getScreenSize();
        f.setLocation(screenSize.width / 2 - f.getSize().width / 2, screenSize.height / 2 - f.getSize().height / 2);
        f.setVisible(true);
    }

    public void onSelected(IFramework framework) {
        boolean test = framework.getDisplayMenu().isAntiAliasing();
        this.fomGraphB.setAntiAliasing(framework.getDisplayMenu().isAntiAliasing());
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.fomGraphB.setAntiAliasing(menu.isAntiAliasing());
    }

    private String[] createXItems(int iterations) {
        String[] items = new String[iterations];
        for (int i = 0; i < items.length; ++i) {
            items[i] = String.valueOf(this.sortedNumCastClusters[i]);
        }
        return items;
    }

    private int[] createSortedClusterArray(int[] numOfCastClusters) {
        int[] localNumClusters = new int[numOfCastClusters.length];
        for (int i = 0; i < localNumClusters.length; ++i) {
            localNumClusters[i] = numOfCastClusters[i];
        }
        Vector<Integer> localVector = new Vector<Integer>();
        for (int i = 0; i < localNumClusters.length; ++i) {
            localVector.add(new Integer(localNumClusters[i]));
        }
        HashSet s = new HashSet(localVector);
        Vector setVector = new Vector();
        Iterator it = s.iterator();
        while (it.hasNext()) {
            setVector.add(it.next());
        }
        int[] setArray = new int[setVector.size()];
        for (int i = 0; i < setArray.length; ++i) {
            setArray[i] = (Integer)setVector.get(i);
        }
        Arrays.sort(setArray);
        int[] lastElementDeductedArray = new int[setArray.length - 1];
        for (int i = 0; i < lastElementDeductedArray.length; ++i) {
            lastElementDeductedArray[i] = setArray[i];
        }
        return lastElementDeductedArray;
    }

    private float[] createSortedFomValues(float[] fom_values, int[] numOfCastClusters) {
        int[] sortedCastClusters = this.createSortedClusterArray(numOfCastClusters);
        Vector<Float> sortedFomVector = new Vector<Float>();
        for (int i = 0; i < sortedCastClusters.length; ++i) {
            float currentFomValue = 0.0f;
            int count = 0;
            for (int j = 0; j < numOfCastClusters.length; ++j) {
                if (numOfCastClusters[j] != sortedCastClusters[i]) continue;
                currentFomValue += fom_values[j];
                ++count;
            }
            sortedFomVector.add(new Float(currentFomValue /= (float)count));
        }
        float[] sortedFomValues = new float[sortedFomVector.size()];
        for (int i = 0; i < sortedFomValues.length; ++i) {
            sortedFomValues[i] = ((Float)sortedFomVector.get(i)).floatValue();
        }
        return sortedFomValues;
    }

    private float getMaxValue(float[] fom_values) {
        float max_value = -3.4028235E38f;
        for (int i = 0; i < fom_values.length; ++i) {
            max_value = Math.max(max_value, fom_values[i]);
        }
        return max_value;
    }

    private String[] createYItems(float[] fom_values) {
        int number_of_items = (int)Math.ceil(this.getMaxValue(fom_values)) + 1;
        String[] items = new String[number_of_items];
        for (int i = 0; i < items.length; ++i) {
            if (i % 2 != 0 && i != items.length - 1) continue;
            items[i] = String.valueOf(i);
        }
        return items;
    }

    public float[] getFom_values() {
        return this.fom_values;
    }

    public void setFom_values(float[] fom_values) {
        this.fom_values = fom_values;
    }

    public float getInterval() {
        return this.interval;
    }

    public void setInterval(float interval) {
        this.interval = interval;
    }

    public int[] getNumOfCastClusters() {
        return this.numOfCastClusters;
    }

    public float[] getSortedFomValues() {
        return this.sortedFomValues;
    }

    public int[] getSortedNumCastClusters() {
        return this.sortedNumCastClusters;
    }
}

