/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.fom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.fom.FOMGraph;

public class CastFOMContentComponentA
extends JPanel
implements Serializable {
    private FOMGraph fomGraphA;
    private FOMGraph fomGraphB;
    private float[] fom_values;
    float interval;
    GridBagConstraints gbc;
    int[] numOfCastClusters;

    public CastFOMContentComponentA(float[] fom_values, float interval, int[] numOfCastClusters) {
        this.setLayout(new GridBagLayout());
        this.fom_values = fom_values;
        this.interval = interval;
        this.numOfCastClusters = numOfCastClusters;
        this.fomGraphA = new FOMGraph(fom_values, null, "FOM value vs. Threshold", "Threshold", "Adjusted FOM", false);
        this.fomGraphA.setItems(this.createXThresholdItems(fom_values.length), this.createYItems(fom_values));
        this.fomGraphA.setMaxYValue((float)Math.ceil(this.getMaxValue(fom_values)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.9;
        gbc.weighty = 1.0;
        this.add((Component)this.fomGraphA, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.1;
        this.add((Component)this.createValuesList(fom_values), gbc);
    }

    public static String[] getPersistenceDelegateArgs() {
        return new String[]{"fom_values", "interval", "numOfCastClusters"};
    }

    public BufferedImage getImageA() {
        return this.fomGraphA.getImage();
    }

    public BufferedImage getImageB() {
        return this.fomGraphB.getImage();
    }

    private JComponent createValuesList(float[] fom_values) {
        String[] items = new String[fom_values.length];
        float threshold = this.interval;
        for (int i = 0; i < fom_values.length; ++i) {
            String s = "0.";
            int d = (int)Math.floor(threshold * 100.0f);
            if (d < 10) {
                s = s + "0";
            }
            s = s + d;
            if (d >= 100) {
                s = "1.00";
            }
            threshold += this.interval;
            items[i] = s + "---->" + String.valueOf((float)Math.round(fom_values[i] * 1000.0f) / 1000.0f);
        }
        JPanel listPanel = new JPanel(new GridBagLayout());
        JScrollPane scroll = new JScrollPane(new JList<String>(items));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        listPanel.add((Component)scroll, gbc);
        gbc.fill = 2;
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        JButton button = new JButton("Details");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CastFOMContentComponentA.this.onDetails();
            }
        });
        listPanel.add((Component)button, gbc);
        return listPanel;
    }

    private void onDetails() {
        JFrame f = new JFrame("Details");
        JTextArea t = new JTextArea();
        t.setEditable(false);
        JScrollPane sp = new JScrollPane(t);
        StringBuffer sb = new StringBuffer();
        float threshold = this.interval;
        for (int i = 0; i < this.fom_values.length; ++i) {
            String s = "0.";
            int d = (int)Math.floor(threshold * 100.0f);
            if (d < 10) {
                s = s + "0";
            }
            s = s + d;
            if (d >= 100) {
                s = "1.00";
            }
            threshold += this.interval;
            sb.append(s + "\t" + String.valueOf((float)Math.round(this.fom_values[i] * 1000.0f) / 1000.0f) + "\n");
        }
        t.setText(sb.toString());
        t.setCaretPosition(0);
        f.getContentPane().add(sp);
        f.setSize(200, 200);
        Dimension screenSize = f.getToolkit().getScreenSize();
        f.setLocation(screenSize.width / 2 - f.getSize().width / 2, screenSize.height / 2 - f.getSize().height / 2);
        f.setVisible(true);
    }

    public void onSelected(IFramework framework) {
        this.fomGraphA.setAntiAliasing(framework.getDisplayMenu().isAntiAliasing());
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.fomGraphA.setAntiAliasing(menu.isAntiAliasing());
    }

    private String[] createXItems(int iterations) {
        String[] items = new String[iterations];
        for (int i = 0; i < items.length; ++i) {
            if ((i + 1) % 5 != 0 && i != 0 && i != items.length - 1) continue;
            items[i] = String.valueOf(i + 1);
        }
        return items;
    }

    private String[] createXThresholdItems(int iterations) {
        String[] items = new String[iterations];
        float threshold = this.interval;
        for (int i = 0; i < items.length; ++i) {
            String s = "0.";
            int d = (int)Math.floor(threshold * 100.0f);
            if (d < 10) {
                s = s + "0";
            }
            s = s + d;
            if (d >= 100) {
                s = "1.00";
            }
            items[i] = s;
            threshold += this.interval;
        }
        return items;
    }

    private float getMaxValue(float[] fom_values) {
        float max_value = -3.4028235E38f;
        for (int i = 0; i < fom_values.length; ++i) {
            max_value = Math.max(max_value, fom_values[i]);
        }
        return max_value;
    }

    private String[] createYItems(float[] fom_values) {
        int number_of_items = (int)Math.ceil(this.getMaxValue(fom_values)) + 1;
        String[] items = new String[number_of_items];
        for (int i = 0; i < items.length; ++i) {
            if (i % 2 != 0 && i != items.length - 1) continue;
            items[i] = String.valueOf(i);
        }
        return items;
    }

    public float[] getFom_values() {
        return this.fom_values;
    }

    public float getInterval() {
        return this.interval;
    }

    public int[] getNumOfCastClusters() {
        return this.numOfCastClusters;
    }
}

