/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.edger;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.IRNASeqSlide;
import org.tigr.microarray.mev.RNASeqElement;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.edger.EDGERInitBox;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class EDGERGUI
implements IClusterGUI,
IScriptGUI {
    protected Algorithm algorithm;
    protected Progress progress;
    protected Experiment experiment;
    boolean debug = true;
    protected String methodName = null;
    protected String estimatorName = null;
    protected int bins = 0;
    protected ArrayList<String> geneLabels;
    protected ArrayList<String> sampleLabels;
    Vector<String> exptNamesVector;
    protected int[] groupAssignments;
    protected IData data;
    protected int dataDesign;
    FloatMatrix resultMatrix;
    String[] resultRowNames;
    float sigCutOff = 0.05f;
    String sigMethod = "fdr";
    Object[][] auxData;
    int[][] clusters;
    String[] headerNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        int i;
        if (this.sysMsg("R 2.11.x", "edgeR") != 0) {
            return null;
        }
        this.data = framework.getData();
        this.exptNamesVector = new Vector();
        for (int i2 = 0; i2 < this.data.getFeaturesCount(); ++i2) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(i2));
        }
        EDGERInitBox EDGERDialog = new EDGERInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getClusterRepository(1));
        EDGERDialog.setVisible(true);
        if (!EDGERDialog.isOkPressed()) {
            return null;
        }
        this.methodName = EDGERDialog.methodsPanel.getMethodName();
        this.sigMethod = EDGERDialog.getCutOffField();
        this.sigCutOff = EDGERDialog.getPValue();
        this.dataDesign = EDGERDialog.getTestDesign();
        if (EDGERDialog.getTestDesign() == 8) {
            if (EDGERDialog.getSelectionDesign() == 11) {
                this.groupAssignments = EDGERDialog.getClusterTwoClassAssignments();
            }
            if (EDGERDialog.getSelectionDesign() == 10) {
                this.groupAssignments = EDGERDialog.getTwoClassAssignments();
            }
        }
        int samplesUsed = 0;
        for (int i3 = 0; i3 < this.groupAssignments.length; ++i3) {
            if (this.groupAssignments[i3] == 0) continue;
            ++samplesUsed;
        }
        int[] sampleIndices = new int[samplesUsed];
        int ii = 0;
        for (int i4 = 0; i4 < this.groupAssignments.length; ++i4) {
            if (this.groupAssignments[i4] == 0) continue;
            sampleIndices[ii++] = i4;
        }
        int[] twoClassGrps = new int[samplesUsed];
        int ii2 = 0;
        for (i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 0) continue;
            twoClassGrps[ii2++] = this.groupAssignments[i];
        }
        this.experiment = framework.getData().getExperiment();
        this.sampleLabels = new ArrayList();
        this.geneLabels = new ArrayList();
        for (i = 0; i < samplesUsed; ++i) {
            this.sampleLabels.add(framework.getData().getFullSampleName(sampleIndices[i]));
        }
        for (i = 0; i < this.data.getFeaturesSize(); ++i) {
            this.geneLabels.add(String.valueOf(i));
        }
        int numGenes = this.data.getFeaturesSize();
        System.out.println("data.getFeaturesCount(): " + this.data.getFeaturesCount() + " data.getFeaturesSize(): " + this.data.getFeaturesSize());
        ArrayList temp = this.data.getFeaturesList();
        int[][] countMatrix = new int[numGenes][samplesUsed];
        int[] transcriptLen = new int[numGenes];
        int[] libSize = new int[samplesUsed];
        for (int row = 0; row < numGenes; ++row) {
            for (int col = 0; col < sampleIndices.length; ++col) {
                countMatrix[row][col] = ((IRNASeqSlide)temp.get(sampleIndices[col])).getCount(row);
            }
            transcriptLen[row] = ((RNASeqElement)((IRNASeqSlide)temp.get(0)).getSlideDataElement(row)).getTranscriptLength();
        }
        for (int col = 0; col < sampleIndices.length; ++col) {
            libSize[col] = ((IRNASeqSlide)temp.get(sampleIndices[col])).getLibrarySize();
        }
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("EDGER");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Running edgeR ...", listener);
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            data.addIntMatrix("experiment", countMatrix);
            data.addParam("dataDesign", String.valueOf(this.dataDesign));
            data.addIntArray("group_assignments", twoClassGrps);
            data.addIntArray("libSize", libSize);
            data.addIntArray("transcriptLen", transcriptLen);
            data.addParam("numGenes", String.valueOf(numGenes));
            data.addParam("numExps", String.valueOf(samplesUsed));
            data.addParam("methodName", this.methodName);
            data.addStringArray("geneLabels", this.geneLabels.toArray(new String[this.geneLabels.size()]));
            data.addStringArray("sampleLabels", this.sampleLabels.toArray(new String[this.sampleLabels.size()]));
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            this.resultMatrix = result.getMatrix("result");
            this.resultRowNames = result.getStringArray("rownames");
            this.createHeaderNames();
            this.createAuxData();
            this.createResultClusters();
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            System.out.println("Creating Viewers for edgeR...");
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private void createHeaderNames() {
        this.headerNames = new String[4];
        this.headerNames[0] = "logConc";
        this.headerNames[1] = "logFC";
        this.headerNames[2] = "PValue";
        this.headerNames[3] = "FDR";
    }

    private void createAuxData() {
        this.auxData = new Object[this.resultRowNames.length][this.headerNames.length];
        for (int i = 0; i < this.resultRowNames.length; ++i) {
            int j = 0;
            int ind = Integer.parseInt(this.resultRowNames[i]);
            this.auxData[ind][j++] = Float.valueOf(this.resultMatrix.get(0, i));
            this.auxData[ind][j++] = Float.valueOf(this.resultMatrix.get(1, i));
            this.auxData[ind][j++] = Float.valueOf(this.resultMatrix.get(2, i));
            this.auxData[ind][j++] = Float.valueOf(this.resultMatrix.get(3, i));
        }
    }

    private void createResultClusters() {
        int i;
        this.clusters = new int[2][];
        int methodInd = 3;
        if (this.sigMethod.equals("pvalue")) {
            methodInd = 2;
        }
        int sigCnt = 0;
        for (i = 0; i < this.resultMatrix.getColumnDimension(); ++i) {
            if (!(this.resultMatrix.get(methodInd, i) <= this.sigCutOff)) continue;
            ++sigCnt;
        }
        this.clusters[0] = new int[sigCnt];
        this.clusters[1] = new int[this.resultMatrix.getColumnDimension() - sigCnt];
        int j = 0;
        int k = 0;
        for (i = 0; i < this.resultMatrix.getColumnDimension(); ++i) {
            int ind = Integer.parseInt(this.resultRowNames[i]);
            if (this.resultMatrix.get(methodInd, i) <= this.sigCutOff) {
                this.clusters[0][k++] = ind;
                continue;
            }
            this.clusters[1][j++] = ind;
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        this.experiment = framework.getData().getExperiment();
        this.exptNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(this.experiment.getSampleIndex(i)));
        }
        EDGERInitBox EDGERDialog = new EDGERInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getClusterRepository(1));
        EDGERDialog.setVisible(true);
        if (!EDGERDialog.isOkPressed()) {
            return null;
        }
        if (EDGERDialog.getTestDesign() == 8) {
            this.groupAssignments = EDGERDialog.getTwoClassAssignments();
        }
        AlgorithmData data = new AlgorithmData();
        data.addParam("name", "edgeR");
        data.addParam("alg-type", "data-visualization");
        data.addParam("output-class", "partition-output");
        String[] outputNodes = new String[]{"Significant Genes", "Non-significant Genes"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        Listener listener = new Listener();
        this.experiment = experiment;
        this.data = framework.getData();
        this.groupAssignments = algData.getIntArray("condition_assignments");
        this.exptNamesVector = new Vector();
        int number_of_samples = experiment.getNumberOfSamples();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(this.data.getFullSampleName(i));
        }
        try {
            algData.addMatrix("experiment", experiment.getMatrix());
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("MINET");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Running MINET Analysis...", listener);
            this.progress.show();
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            AlgorithmParameters params = algData.getParams();
            GeneralInfo info = new GeneralInfo();
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    protected String getSigMethod(int sigMethod) {
        String methodName = "";
        if (sigMethod == 1) {
            methodName = "Just alpha (uncorrected)";
        } else if (sigMethod == 2) {
            methodName = "Standard Bonferroni correction";
        } else if (sigMethod == 3) {
            methodName = "Adjusted Bonferroni correction";
        } else if (sigMethod == 4) {
            methodName = "Westfall Young stepdown - MaxT";
        } else if (sigMethod == 5 || sigMethod == 6) {
            // empty if block
        }
        return methodName;
    }

    protected DefaultMutableTreeNode createResultTree(GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("edgeR");
        this.addResultNodes(root, info);
        return root;
    }

    protected void addResultNodes(DefaultMutableTreeNode root, GeneralInfo info) {
        this.addExpressionImages(root);
        this.addTableViews(root);
        this.addGeneralInfo(root, info);
    }

    protected void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(this.getConditionAssignmentInfo());
        node.add(new DefaultMutableTreeNode("Inference Algorithm: " + this.methodName));
        node.add(new DefaultMutableTreeNode("Mutual Info Estimator: " + this.estimatorName));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time - 1L) + " ms"));
        root.add(node);
    }

    protected DefaultMutableTreeNode getConditionAssignmentInfo() {
        DefaultMutableTreeNode groupAssignmentInfo = new DefaultMutableTreeNode("Group assignments ");
        DefaultMutableTreeNode notInGroups = new DefaultMutableTreeNode("Samples Excluded");
        DefaultMutableTreeNode inGroup = new DefaultMutableTreeNode("Samples Included");
        groupAssignmentInfo.add(inGroup);
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            int currentGroup = this.groupAssignments[i];
            if (currentGroup == 0) {
                notInGroups.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
                continue;
            }
            inGroup.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
        }
        if (notInGroups.getChildCount() > 0) {
            groupAssignmentInfo.add(notInGroups);
        }
        return groupAssignmentInfo;
    }

    protected void addExpressionImages(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        ExperimentViewer expViewer = new ExperimentViewer(this.experiment, this.clusters);
        node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)expViewer, (Object)new Integer(0))));
        node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)expViewer, (Object)new Integer(1))));
        root.add(node);
    }

    protected void addTableViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table Views");
        ClusterTableViewer tabViewer = new ClusterTableViewer(this.data.getExperiment(), (int[][])null, this.data, this.headerNames, this.auxData);
        node.add(new DefaultMutableTreeNode(new LeafInfo("Gene List", (IViewer)tabViewer, (Object)new Integer(0))));
        tabViewer = new ClusterTableViewer(this.experiment, this.clusters, this.data, this.headerNames, this.auxData);
        node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Gene List", (IViewer)tabViewer, (Object)new Integer(0))));
        node.add(new DefaultMutableTreeNode(new LeafInfo("Non-Significant Gene List", (IViewer)tabViewer, (Object)new Integer(1))));
        root.add(node);
    }

    public int[] getResultCluster() {
        return this.clusters[0];
    }

    private int sysMsg(String rVer, String module) {
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        String ver = System.getProperty("os.version");
        String message = "System Config:\n";
        message = message + "OS: " + os + " | Architecture: " + arch + " | Version: " + ver + "\n";
        message = message + "Please note:\n";
        if (arch.toLowerCase().contains("64") && os.toLowerCase().contains("mac")) {
            message = message + "You need to have 32Bit JVM as default for " + module + "\n";
            message = message + "Please contact MeV Support if you need help.\n";
            message = message + "You also need to have" + rVer + " installed for " + module + "\n";
            message = message + "Cancel if either is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        if (arch.toLowerCase().contains("64")) {
            message = message + "You need to have 32Bit JVM as default for " + module + "\n";
            message = message + "Please contact MeV Support if you need help.\n";
            message = message + "Cancel if 32 Bit JVM is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        if (os.toLowerCase().contains("mac")) {
            message = message + "You need to have" + rVer + " installed for " + module + "\n";
            message = message + "Cancel if R is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        return 0;
    }

    private static String getUniqueFileID() {
        Date now = new Date();
        String dateString = now.toString();
        SimpleDateFormat formatDt = new SimpleDateFormat("MMM_dd_yy_HHmmssSSS");
        dateString = formatDt.format(now);
        return dateString;
    }

    protected class GeneralInfo {
        public int clusters;
        public String correctionMethod;
        public float alpha;
        public long time;
        public String function;
        protected boolean hcl;
        protected boolean usePerms;
        protected int hcl_method;
        protected int numPerms;
        protected boolean hcl_genes;
        protected boolean hcl_samples;

        protected GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    protected class Listener
    extends DialogListener
    implements AlgorithmListener {
        protected Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    EDGERGUI.this.progress.setUnits(event.getIntValue());
                    EDGERGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    EDGERGUI.this.progress.setValue(event.getIntValue());
                    EDGERGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    int value = event.getIntValue();
                    if (value != -1) break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                EDGERGUI.this.algorithm.abort();
                EDGERGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            EDGERGUI.this.algorithm.abort();
            EDGERGUI.this.progress.dispose();
        }
    }
}

