/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease.gotree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.impl.ease.gotree.GONode;
import org.tigr.microarray.mev.cluster.gui.impl.ease.gotree.GOTreeViewer;

public class GOTreeHeader
extends JPanel {
    private GONode displayNode;
    private GOTreeViewer parent;
    private double lowerThr = 0.01;
    private double upperThr = 0.05;
    private String lowerStr = "0.01";
    private String upperStr = "0.05";
    private String nonsigStr = "";

    public GOTreeHeader(GONode node, GOTreeViewer parentViewer, double upper, double lower) {
        super.setBackground(Color.white);
        this.setBackground(Color.white);
        this.displayNode = new GONode(node);
        this.displayNode.setRenderingHint(0);
        this.parent = parentViewer;
        this.setThresholds(upper, lower);
    }

    public void updateSize(int x, int y) {
        this.setPreferredSize(new Dimension(x + 125, y));
        this.setSize(x + 125, y);
    }

    public void update() {
        this.displayNode.setRenderingHint(0);
        this.updateSize(this.parent.getViewerWidth(), 35);
        this.repaint();
    }

    public void setThresholds(double upper, double lower) {
        DecimalFormat format;
        this.upperThr = upper;
        this.lowerThr = lower;
        if (this.upperThr < 1.0E-4) {
            format = new DecimalFormat("0.#####E00");
            this.upperStr = format.format(this.upperThr);
        } else {
            format = new DecimalFormat("0.#####");
            this.upperStr = format.format(this.upperThr);
        }
        this.upperStr = "p <= " + this.upperStr + " ";
        if (this.lowerThr < 1.0E-4) {
            format = new DecimalFormat("0.#####E00");
            this.lowerStr = format.format(this.lowerThr);
        } else {
            format = new DecimalFormat("0.#####");
            this.lowerStr = format.format(this.lowerThr);
        }
        this.lowerStr = "p <= " + this.lowerStr + " ";
        if (this.upperThr < 1.0E-4) {
            format = new DecimalFormat("0.#####E00");
            this.nonsigStr = format.format(this.upperThr);
        } else {
            format = new DecimalFormat("0.#####");
            this.nonsigStr = format.format(this.upperThr);
        }
        this.nonsigStr = "p > " + this.nonsigStr;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics fm = g.getFontMetrics();
        LineMetrics lm = fm.getLineMetrics(this.lowerStr, g);
        g.drawRect(25, 5 + (int)lm.getHeight() - (int)lm.getAscent(), 30, (int)lm.getAscent());
        g.setColor(Color.red);
        g.fillRect(26, 5 + (int)lm.getHeight() - (int)lm.getAscent() + 1, 29, (int)lm.getAscent() - 1);
        g.setColor(Color.black);
        g.drawString(this.lowerStr, 60, 5 + (int)lm.getHeight());
        int textWidth = g.getFontMetrics().stringWidth(this.lowerStr);
        int currX = 60 + textWidth;
        lm = fm.getLineMetrics(this.upperStr, g);
        g.drawRect(currX + 25, 5 + (int)lm.getHeight() - (int)lm.getAscent(), 30, (int)lm.getAscent());
        g.setColor(Color.orange);
        g.fillRect(currX + 26, 5 + (int)lm.getHeight() - (int)lm.getAscent() + 1, 29, (int)lm.getAscent() - 1);
        g.setColor(Color.black);
        g.drawString(this.upperStr, currX + 60, 5 + (int)lm.getHeight());
        textWidth = g.getFontMetrics().stringWidth(this.upperStr);
        lm = fm.getLineMetrics(this.nonsigStr, g);
        g.drawRect((currX += 60 + textWidth) + 25, 5 + (int)lm.getHeight() - (int)lm.getAscent(), 30, (int)lm.getAscent());
        g.setColor(Color.green);
        g.fillRect(currX + 26, 5 + (int)lm.getHeight() - (int)lm.getAscent() + 1, 29, (int)lm.getAscent() - 1);
        g.setColor(Color.black);
        g.drawString(this.nonsigStr, currX + 60, 5 + (int)lm.getHeight());
    }
}

