/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease.gotree;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class EaseThresholdDialog
extends AlgorithmDialog {
    private int result = 2;
    private double origTOne;
    private double origTTwo;
    private JTextField tOneField;
    private JTextField tTwoField;

    public EaseThresholdDialog(JFrame parent, double T1, double T2) {
        super(parent, "EASE Tree Thresholds", true);
        this.origTOne = T1;
        this.origTTwo = T2;
        ParameterPanel params = new ParameterPanel("Threshold Selection");
        params.setLayout(new GridBagLayout());
        JLabel label = new JLabel("Lower Threshold");
        this.tOneField = new JTextField("0.01", 8);
        params.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 15), 0, 0));
        params.add((Component)this.tOneField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        label = new JLabel("Upper Threshold");
        this.tTwoField = new JTextField("0.05", 8);
        params.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(15, 0, 10, 15), 0, 0));
        params.add((Component)this.tTwoField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(15, 0, 10, 0), 0, 0));
        this.addContent(params);
        this.setActionListeners(new EventListener());
        this.pack();
    }

    public double getLowerThreshold() {
        return Double.parseDouble(this.tOneField.getText());
    }

    public double getUpperThreshold() {
        return Double.parseDouble(this.tTwoField.getText());
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void resetControls() {
        this.tOneField.setText(String.valueOf(this.origTOne));
        this.tTwoField.setText(String.valueOf(this.origTTwo));
        this.tOneField.grabFocus();
        this.tOneField.selectAll();
    }

    private boolean validate(String a, String b) {
        double t2;
        double t1;
        try {
            t1 = Double.parseDouble(a);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, "Number format error, entered value is not recognized as a number", "Input Error", 0);
            this.tOneField.grabFocus();
            this.tOneField.selectAll();
            return false;
        }
        try {
            t2 = Double.parseDouble(b);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, "Number format error, entered value is not recognized as a number", "Input Error", 0);
            this.tTwoField.grabFocus();
            this.tTwoField.selectAll();
            return false;
        }
        if (t1 <= 0.0 || t1 >= 1.0) {
            JOptionPane.showMessageDialog(this, "Threshold should be > 0 and < 1.0", "Input Error", 0);
            this.tOneField.grabFocus();
            this.tOneField.selectAll();
            return false;
        }
        if (t2 <= 0.0 || t2 >= 1.0) {
            JOptionPane.showMessageDialog(this, "Threshold should be > 0 and < 1.0", "Input Error", 0);
            this.tTwoField.grabFocus();
            this.tTwoField.selectAll();
            return false;
        }
        if (t1 >= t2) {
            JOptionPane.showMessageDialog(this, "The lower threshold should be less that the upper threshold.", "Input Error", 0);
            this.tOneField.grabFocus();
            this.tOneField.selectAll();
            return false;
        }
        return true;
    }

    private class EventListener
    extends DialogListener {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                if (EaseThresholdDialog.this.validate(EaseThresholdDialog.this.tOneField.getText(), EaseThresholdDialog.this.tTwoField.getText())) {
                    EaseThresholdDialog.this.result = 0;
                    EaseThresholdDialog.this.dispose();
                }
            } else if (command.equals("cancel-command")) {
                EaseThresholdDialog.this.result = 2;
                EaseThresholdDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    EaseThresholdDialog.this.resetControls();
                    EaseThresholdDialog.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(EaseThresholdDialog.this, "EASE Threshold Dialog");
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            EaseThresholdDialog.this.result = -1;
            EaseThresholdDialog.this.dispose();
        }
    }
}

