/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.helpers.TableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEURLFactory;
import org.tigr.microarray.mev.persistence.EASETableViewerPersistenceDelegate;
import org.tigr.util.BrowserLauncher;

public class EASETableViewer
extends TableViewer
implements Serializable {
    private static final String LAUNCH_BROWSER_COMMAND = "launch-browser-command";
    private static final String SAVE_EASE_TABLE_COMMAND = "save-ease-table-command";
    private static final String LAUNCH_EXPRESSION_GRAPH_COMMAND = "launch-expression-graph-command";
    protected static final String LAUNCH_CENTROID_GRAPH_COMMAND = "launch-centroid-graph-command";
    protected static final String LAUNCH_EXPRESSION_IMAGE_COMMAND = "launch-expression-image-command";
    protected static final String STORE_CLUSTER_COMMAND = "store-cluster-command";
    protected DefaultMutableTreeNode easeRoot;
    protected JPopupMenu menu;
    protected Experiment experiment;
    protected int[][] clusters;
    protected String[] headerNames;
    protected boolean clusterAnalysis;
    protected boolean haveAccessionNumbers;
    protected JMenuItem launchMenuItem;
    protected Object[][] data;
    protected boolean isEaseConsolidatedResult = false;

    public EASETableViewer(String[] headerNames, Object[][] data, DefaultMutableTreeNode analysisNode, Experiment experiment, ClusterWrapper clusters, boolean haveAccessionNumbers, boolean clusterAnalysis, boolean isEaseConsolidatedResult) {
        this(headerNames, data, analysisNode, experiment, clusters.getClusters(), haveAccessionNumbers, clusterAnalysis, isEaseConsolidatedResult);
    }

    public EASETableViewer(String[] headerNames, Object[][] data, DefaultMutableTreeNode analysisNode, Experiment experiment, int[][] clusters, boolean haveAccessionNumbers, boolean clusterAnalysis) {
        this(headerNames, data, analysisNode, experiment, clusters, haveAccessionNumbers, clusterAnalysis, false);
    }

    public EASETableViewer(String[] headerNames, Object[][] data, DefaultMutableTreeNode analysisNode, Experiment experiment, int[][] clusters, boolean haveAccessionNumbers, boolean clusterAnalysis, boolean isEaseConsolidatedResult) {
        super(headerNames, data);
        this.headerNames = headerNames;
        this.clusterAnalysis = clusterAnalysis;
        this.haveAccessionNumbers = haveAccessionNumbers;
        this.data = data;
        this.setNumerical(0, true);
        if (clusterAnalysis) {
            if (!haveAccessionNumbers) {
                this.setNumerical(3, true);
            }
            for (int i = 4; i < headerNames.length; ++i) {
                this.setNumerical(i, true);
            }
        } else {
            if (!haveAccessionNumbers) {
                this.setNumerical(3, true);
            } else {
                this.setNumerical(5, true);
            }
            this.setNumerical(4, true);
        }
        this.isEaseConsolidatedResult = isEaseConsolidatedResult;
        if (this.isEaseConsolidatedResult) {
            if (haveAccessionNumbers) {
                this.setNumerical(12, true);
            } else {
                this.setNumerical(8, true);
            }
            this.setNumerical(9, true);
            this.setNumerical(10, true);
            this.setNumerical(11, true);
        }
        this.easeRoot = analysisNode;
        this.menu = this.createPopupMenu();
        this.experiment = experiment;
        this.clusters = clusters;
        this.table.addMouseListener(new Listener());
        if (this.table.getRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public EASETableViewer(String[] headerNames, Object[][] data) {
        super(headerNames, data);
    }

    protected JPopupMenu createPopupMenu() {
        Listener listener = new Listener();
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Store Selection as Cluster");
        item.setActionCommand(STORE_CLUSTER_COMMAND);
        item.addActionListener(listener);
        menu.add(item);
        JMenu launchMenu = new JMenu("Open Viewer");
        item = new JMenuItem("Expression Image");
        item.setActionCommand(LAUNCH_EXPRESSION_IMAGE_COMMAND);
        item.addActionListener(listener);
        launchMenu.add(item);
        item = new JMenuItem("Centroid Graph");
        item.setActionCommand(LAUNCH_CENTROID_GRAPH_COMMAND);
        item.addActionListener(listener);
        launchMenu.add(item);
        item = new JMenuItem("Expression Graph");
        item.setActionCommand(LAUNCH_EXPRESSION_GRAPH_COMMAND);
        item.addActionListener(listener);
        launchMenu.add(item);
        menu.add(launchMenu);
        menu.addSeparator();
        item = this.isEaseConsolidatedResult ? new JMenuItem("Save Nested EASE Summary Table") : (this.checkHeaderFor("nEASE Gene Enrich.") ? new JMenuItem("Save Nested EASE Table") : new JMenuItem("Save EASE Table"));
        item.setActionCommand(SAVE_EASE_TABLE_COMMAND);
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Broadcast Selection as Matrix to Gaggle", GUIFactory.getIcon("gaggle_icon_16.gif"));
        item.setActionCommand("broadcast-matrix-to-gaggle");
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Broadcast Selection as Gene List to Gaggle", GUIFactory.getIcon("gaggle_icon_16.gif"));
        item.setActionCommand("broadcast-namelist-to-gaggle");
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        if (this.haveAccessionNumbers) {
            this.launchMenuItem = new JMenuItem("Open Web Page");
            this.launchMenuItem.setActionCommand(LAUNCH_BROWSER_COMMAND);
            this.launchMenuItem.addActionListener(listener);
            menu.add(this.launchMenuItem);
        }
        return menu;
    }

    public boolean checkHeaderFor(String targetHeader) {
        for (int i = 0; i < this.headerNames.length; ++i) {
            if (!targetHeader.equalsIgnoreCase(this.headerNames[i])) continue;
            return true;
        }
        return false;
    }

    public void onSelected(IFramework framework) {
        super.onSelected(framework);
        if (this.easeRoot == null) {
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)framework.getCurrentNode().getParent();
                Object userObject = node.getUserObject();
                if (userObject instanceof String && ((String)userObject).indexOf("EASE") != -1) {
                    this.easeRoot = node;
                }
            }
            catch (Exception e) {
                System.out.println("selection exception");
                e.printStackTrace();
            }
        }
    }

    protected void onOpenViewer(String viewerType) {
        int index = this.table.getSelectedRow();
        if (index == -1 || this.easeRoot == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.easeRoot.getChildAt(1);
        if (this.isEaseConsolidatedResult) {
            int fileindex = 1;
            int termindex = 14;
            String term = (String)this.table.getValueAt(index, fileindex) + ": " + (String)this.table.getValueAt(index, termindex);
            int neaseindex = 0;
            for (int i = 1; i < this.easeRoot.getChildCount(); ++i) {
                if (!((DefaultMutableTreeNode)this.easeRoot.getChildAt(i)).getUserObject().toString().endsWith(term)) continue;
                neaseindex = i;
                break;
            }
            DefaultMutableTreeNode neasenode = (DefaultMutableTreeNode)this.easeRoot.getChildAt(neaseindex);
            node = (DefaultMutableTreeNode)neasenode.getChildAt(1);
        }
        index = new Integer((String)this.table.getValueAt(index, 0)) - 1;
        if (node.getChildCount() < index) {
            return;
        }
        node = (DefaultMutableTreeNode)node.getChildAt(index);
        if (viewerType.equals("expression image")) {
            node = (DefaultMutableTreeNode)node.getChildAt(0);
        } else if (viewerType.equals("centroid graph")) {
            node = (DefaultMutableTreeNode)node.getChildAt(1);
        } else if (viewerType.equals("expression graph")) {
            node = (DefaultMutableTreeNode)node.getChildAt(2);
        }
        if (this.framework != null) {
            this.framework.setTreeNode(node);
        }
    }

    protected void onStoreCluster() {
        int[] tableIndices = this.table.getSelectedRows();
        if (tableIndices == null || tableIndices.length == 0) {
            return;
        }
        for (int i = 0; i < tableIndices.length; ++i) {
            tableIndices[i] = ((TableViewer.DefaultViewerTableModel)this.model).getRow(tableIndices[i]);
        }
        int[] geneIndices = this.getGeneIndices(tableIndices);
        geneIndices = this.mapExperimentIndicesToIData(geneIndices);
        this.framework.storeSubCluster(geneIndices, this.experiment, 0);
    }

    protected void onOpenBrowser() {
        int[] tableIndices = this.table.getSelectedRows();
        if (tableIndices == null || tableIndices.length < 1) {
            return;
        }
        String file = (String)this.table.getValueAt(tableIndices[0], 1);
        String acc = (String)this.table.getValueAt(tableIndices[0], 2);
        if (acc == null || acc.equals("") || acc.equals(" ")) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "No accession exists for this entry.", "Web access denial", 1);
            return;
        }
        String url = EASEURLFactory.constructURL(file, acc);
        if (url == null) {
            return;
        }
        try {
            BrowserLauncher.openURL((String)url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void onSaveEaseTable() {
        JFileChooser chooser = new JFileChooser(TMEV.getDataPath());
        String fileName = "";
        if (chooser.showSaveDialog((Component)((Object)this)) == 0) {
            File file = chooser.getSelectedFile();
            fileName = file.getName();
            try {
                PrintWriter pw = new PrintWriter(new FileOutputStream(file));
                int rows = this.table.getRowCount();
                int cols = this.table.getColumnCount();
                for (String headerName : this.headerNames) {
                    pw.print(headerName + "\t");
                }
                pw.print("\n");
                for (int row = 0; row < rows; ++row) {
                    for (int col = 0; col < cols; ++col) {
                        pw.print((String)this.table.getValueAt(row, col) + "\t");
                    }
                    pw.print("\n");
                }
                pw.flush();
                pw.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                JOptionPane.showMessageDialog((Component)((Object)this), "Error Saving Table to file: " + fileName, "Output Error", 2);
            }
        }
    }

    protected int[] getGeneIndices(int[] rows) {
        int numGenes = 0;
        for (int i = 0; i < rows.length; ++i) {
            numGenes += this.clusters[rows[i]].length;
        }
        int[] indices = new int[numGenes];
        int cnt = 0;
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < this.clusters[rows[i]].length; ++j) {
                indices[cnt] = this.clusters[rows[i]][j];
                ++cnt;
            }
        }
        return indices;
    }

    protected int[] mapExperimentIndicesToIData(int[] indices) {
        int[] idataIndices = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            idataIndices[i] = this.experiment.getGeneIndexMappedToData(indices[i]);
        }
        return idataIndices;
    }

    protected void validateMenuOptions() {
        int row = this.getSelectedRow();
        if (row < 0) {
            return;
        }
        this.launchMenuItem.setEnabled(this.table.getValueAt(row, 1) != null && !this.table.getValueAt(row, 1).equals(" "));
    }

    public Expression getExpression(PrintWriter pw, String filename) {
        this.writeData(pw);
        return new Expression(this, this.getClass(), "new", new Object[]{this.headerNames, this.easeRoot, this.experiment, ClusterWrapper.wrapClusters((int[][])this.clusters), this.haveAccessionNumbers, this.clusterAnalysis, this.isEaseConsolidatedResult, filename});
    }

    public static PersistenceDelegate getPersistenceDelegate() {
        return new EASETableViewerPersistenceDelegate();
    }

    public void writeData(PrintWriter pw) {
        if (this.data != null) {
            for (int i = 0; i < this.data.length; ++i) {
                for (int j = 0; j < this.data[i].length; ++j) {
                    pw.print(this.data[i][j]);
                    if (j == this.data[i].length - 1) {
                        pw.print("\n");
                        continue;
                    }
                    pw.print("\t");
                }
            }
        }
    }

    public static Object[][] readData(BufferedReader br) {
        Vector<String[]> datatemp = new Vector<String[]>();
        try {
            while (br.ready()) {
                datatemp.add(br.readLine().split("\t"));
            }
            return (Object[][])datatemp.toArray((T[])new Object[datatemp.size()][]);
        }
        catch (IOException ioe) {
            System.out.println("Unable to read EASETableViewer data.");
            return null;
        }
    }

    protected void broadcastClusterGaggle() {
        this.framework.broadcastGeneCluster(this.framework.getData().getExperiment(), this.getGeneIndices(this.table.getSelectedRows()), null);
    }

    protected void broadcastNamelistGaggle() {
        this.framework.broadcastNamelist(this.framework.getData().getExperiment(), this.getGeneIndices(this.table.getSelectedRows()));
    }

    protected class Listener
    extends MouseAdapter
    implements ActionListener {
        protected Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals(EASETableViewer.STORE_CLUSTER_COMMAND)) {
                EASETableViewer.this.onStoreCluster();
            } else if (command.equals(EASETableViewer.LAUNCH_EXPRESSION_IMAGE_COMMAND)) {
                EASETableViewer.this.onOpenViewer("expression image");
            } else if (command.equals(EASETableViewer.LAUNCH_CENTROID_GRAPH_COMMAND)) {
                EASETableViewer.this.onOpenViewer("centroid graph");
            } else if (command.equals(EASETableViewer.LAUNCH_EXPRESSION_GRAPH_COMMAND)) {
                EASETableViewer.this.onOpenViewer("expression graph");
            } else if (command.equals(EASETableViewer.LAUNCH_BROWSER_COMMAND)) {
                EASETableViewer.this.onOpenBrowser();
            } else if (command.equals(EASETableViewer.SAVE_EASE_TABLE_COMMAND)) {
                EASETableViewer.this.onSaveEaseTable();
            } else if (command.equals("broadcast-matrix-to-gaggle")) {
                EASETableViewer.this.broadcastClusterGaggle();
            } else if (command.equals("broadcast-namelist-to-gaggle")) {
                EASETableViewer.this.broadcastNamelistGaggle();
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                if (EASETableViewer.this.launchMenuItem != null) {
                    EASETableViewer.this.validateMenuOptions();
                }
                EASETableViewer.this.menu.show(me.getComponent(), me.getX(), me.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                if (EASETableViewer.this.launchMenuItem != null) {
                    EASETableViewer.this.validateMenuOptions();
                }
                EASETableViewer.this.menu.show(me.getComponent(), me.getX(), me.getY());
            }
        }
    }
}

