/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class EASEStatParam
extends AlgorithmDialog {
    private static final long serialVersionUID = -8638108335416140953L;
    protected int result = 2;
    protected JCheckBox fisherBox;
    protected JCheckBox easeBox;
    protected JCheckBox bonferroniBox;
    protected JCheckBox sidakBox;
    protected JCheckBox hochbergBox;
    protected JCheckBox bonferroniStepBox;
    protected JCheckBox permBox;
    protected JTextField permField;
    protected JLabel permLabel;
    protected JCheckBox trimBox;
    protected JCheckBox trimNBox;
    protected JLabel trimNLabel;
    protected JTextField trimNField;
    protected JCheckBox trimPercentBox;
    protected JLabel trimPercentLabel;
    protected JTextField trimPercentField;
    protected Frame parent;
    protected Font font;
    protected EventListener listener;

    public EASEStatParam(Frame parent) {
        super(parent, "EASE: Statistical Parameters", true);
        this.parent = parent;
        this.font = new Font("Dialog", 1, 12);
        this.setBackground(Color.white);
        this.listener = new EventListener();
        this.addWindowListener(this.listener);
        JPanel statPanel = new JPanel(new GridBagLayout());
        statPanel.setBackground(Color.white);
        statPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Reported Statistic", 0, 0, this.font, Color.black));
        ButtonGroup bg = new ButtonGroup();
        this.fisherBox = new JCheckBox("Fisher Exact Probability", true);
        this.fisherBox.setBackground(Color.white);
        this.fisherBox.setFocusPainted(false);
        bg.add(this.fisherBox);
        this.easeBox = new JCheckBox("EASE Score", false);
        this.easeBox.setBackground(Color.white);
        this.easeBox.setFocusPainted(false);
        bg.add(this.easeBox);
        statPanel.add((Component)this.fisherBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        statPanel.add((Component)this.easeBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        JPanel correctionPanel = new JPanel(new GridBagLayout());
        correctionPanel.setBackground(Color.white);
        correctionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Multiplicity Corrections", 0, 0, this.font, Color.black));
        this.bonferroniBox = new JCheckBox("Bonferroni Correction", false);
        this.bonferroniBox.setBackground(Color.white);
        this.bonferroniBox.setFocusPainted(false);
        this.bonferroniStepBox = new JCheckBox("Bonferroni Step Down Correction", false);
        this.bonferroniStepBox.setBackground(Color.white);
        this.bonferroniStepBox.setFocusPainted(false);
        this.sidakBox = new JCheckBox("Sidak Method", false);
        this.sidakBox.setBackground(Color.white);
        this.sidakBox.setFocusPainted(false);
        this.hochbergBox = new JCheckBox("Benjamini-Hochberg Method", true);
        this.hochbergBox.setBackground(Color.white);
        this.hochbergBox.setFocusPainted(false);
        this.permBox = new JCheckBox("Resampling Probability Analysis", false);
        this.permBox.setActionCommand("permutation-analysis-command");
        this.permBox.setBackground(Color.white);
        this.permBox.setFocusPainted(false);
        this.permBox.addActionListener(this.listener);
        this.permField = new JTextField("1000", 10);
        this.permField.setBackground(Color.white);
        this.permField.setEnabled(false);
        this.permLabel = new JLabel("Number of Permutations");
        this.permLabel.setBackground(Color.white);
        this.permLabel.setEnabled(false);
        correctionPanel.add((Component)this.bonferroniBox, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        correctionPanel.add((Component)this.bonferroniStepBox, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 10, 0), 0, 0));
        correctionPanel.add((Component)this.sidakBox, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        correctionPanel.add((Component)this.hochbergBox, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 10, 0), 0, 0));
        correctionPanel.add((Component)this.permBox, new GridBagConstraints(4, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        correctionPanel.add((Component)this.permLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        correctionPanel.add((Component)this.permField, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 15, 0), 0, 0));
        JPanel trimPanel = new JPanel(new GridBagLayout());
        trimPanel.setBackground(Color.white);
        trimPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Trim Parameters", 0, 0, this.font, Color.black));
        this.trimBox = new JCheckBox("Trim Resulting Groups", false);
        this.trimBox.setActionCommand("trim-result-command");
        this.trimBox.addActionListener(this.listener);
        this.trimBox.setBackground(Color.white);
        this.trimBox.setHorizontalAlignment(0);
        this.trimBox.setFocusPainted(false);
        bg = new ButtonGroup();
        this.trimNBox = new JCheckBox("Select Minimum Hit Number", true);
        this.trimNBox.setActionCommand("trim-result-command");
        this.trimNBox.addActionListener(this.listener);
        this.trimNBox.setEnabled(false);
        this.trimNBox.setBackground(Color.white);
        this.trimNBox.setFocusPainted(false);
        bg.add(this.trimNBox);
        this.trimNLabel = new JLabel("Min. Hits");
        this.trimNLabel.setBackground(Color.white);
        this.trimNLabel.setEnabled(false);
        this.trimNField = new JTextField("5", 10);
        this.trimNField.setEnabled(false);
        this.trimPercentBox = new JCheckBox("Select Minimum Hit Percentage", false);
        this.trimPercentBox.setActionCommand("trim-result-command");
        this.trimPercentBox.addActionListener(this.listener);
        this.trimPercentBox.setEnabled(false);
        this.trimPercentBox.setBackground(Color.white);
        this.trimPercentBox.setFocusPainted(false);
        bg.add(this.trimPercentBox);
        this.trimPercentLabel = new JLabel("Percent Hits");
        this.trimPercentLabel.setBackground(Color.white);
        this.trimPercentLabel.setEnabled(false);
        this.trimPercentField = new JTextField("5", 10);
        this.trimPercentField.setEnabled(false);
        trimPanel.add((Component)this.trimBox, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        trimPanel.add((Component)this.trimNBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        trimPanel.add((Component)this.trimNLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 20, 0, 15), 0, 0));
        trimPanel.add((Component)this.trimNField, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        trimPanel.add((Component)this.trimPercentBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        trimPanel.add((Component)this.trimPercentLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(10, 20, 0, 15), 0, 0));
        trimPanel.add((Component)this.trimPercentField, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        JPanel parameters = new JPanel(new GridBagLayout());
        parameters.setBackground(Color.white);
        parameters.add((Component)statPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)correctionPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)trimPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(parameters);
        this.setActionListeners(this.listener);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.setVisible(true);
        return this.result;
    }

    protected void resetControls() {
        this.fisherBox.setSelected(true);
        this.hochbergBox.setSelected(true);
        this.trimBox.setSelected(false);
        this.bonferroniBox.setSelected(false);
        this.bonferroniStepBox.setSelected(false);
        this.sidakBox.setSelected(false);
        this.permBox.setSelected(false);
        this.permLabel.setEnabled(false);
        this.permField.setText("1000");
        this.permField.setEnabled(false);
        this.trimBox.setSelected(false);
        this.trimNBox.setEnabled(false);
        this.trimNBox.setSelected(true);
        this.trimNLabel.setEnabled(false);
        this.trimNField.setText("5");
        this.trimNField.setEnabled(false);
        this.trimPercentBox.setEnabled(false);
        this.trimPercentLabel.setEnabled(false);
        this.trimPercentField.setText("5");
        this.trimPercentField.setEnabled(false);
    }

    public boolean performPermutations() {
        return this.permBox.isSelected();
    }

    public void setEnablePermutations() {
        this.permLabel.setEnabled(this.permBox.isSelected());
        this.permField.setEnabled(this.permBox.isSelected());
    }

    public void validateTrimOptions() {
        if (this.trimBox.isSelected()) {
            this.trimNBox.setEnabled(true);
            this.trimPercentBox.setEnabled(true);
            this.trimNLabel.setEnabled(this.trimNBox.isSelected());
            this.trimNField.setEnabled(this.trimNBox.isSelected());
            this.trimPercentLabel.setEnabled(!this.trimNBox.isSelected());
            this.trimPercentField.setEnabled(!this.trimNBox.isSelected());
        } else {
            this.trimNBox.setEnabled(false);
            this.trimPercentBox.setEnabled(false);
            this.trimNLabel.setEnabled(false);
            this.trimNField.setEnabled(false);
            this.trimPercentLabel.setEnabled(false);
            this.trimPercentField.setEnabled(false);
        }
    }

    public static void main(String[] args) {
        EASEStatParam stats = new EASEStatParam(new JFrame());
        stats.showModal();
    }

    protected class EventListener
    extends DialogListener
    implements ItemListener {
        protected EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("permutation-analysis-command")) {
                EASEStatParam.this.setEnablePermutations();
            } else if (command.equals("trim-result-command")) {
                EASEStatParam.this.validateTrimOptions();
            } else if (command.equals("ok-command")) {
                EASEStatParam.this.result = 0;
                EASEStatParam.this.dispose();
            } else if (command.equals("cancel-command")) {
                EASEStatParam.this.result = 2;
                EASEStatParam.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    EASEStatParam.this.resetControls();
                    EASEStatParam.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(EASEStatParam.this, "EASE StatisticalParams Dialog");
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            EASEStatParam.this.result = -1;
            EASEStatParam.this.dispose();
        }
    }
}

