/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import org.tigr.microarray.mev.ShowThrowableDialog;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterBrowser;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEAdvancedFeatures;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEEntrezSupportDataFile;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEStatParam;
import org.tigr.microarray.mev.resources.FileResourceManager;
import org.tigr.microarray.mev.resources.IResourceManager;
import org.tigr.microarray.mev.resources.ISupportFileDefinition;
import org.tigr.microarray.mev.resources.PipelinedAnnotationsFileDefinition;
import org.tigr.microarray.mev.resources.RepositoryInitializationError;
import org.tigr.microarray.mev.resources.ResourcererAnnotationFileDefinition;
import org.tigr.microarray.mev.resources.SupportFileAccessError;

public class EASEInitDialog
extends AlgorithmDialog {
    private static final long serialVersionUID = -8572561763028404439L;
    private int result = 2;
    private int resultStat = 2;
    private int resultAdvanced = 2;
    private ConfigPanel configPanel;
    private ModePanel modePanel;
    private ClusterBrowser browser;
    private EASEStatParam statParam;
    private EASEStatParam statParamTemp;
    private EASEAdvancedFeatures advancedFeat;
    private EASEAdvancedFeatures advancedFeatTemp;
    private NEasePanel nEasePanel;
    private EventListener listener;
    private Font font;
    private String sep;
    private Frame parent;
    private String arrayName;
    private String speciesName;
    private Hashtable<String, Vector<String>> speciestoarrays;
    private IResourceManager resourceManager;
    private static String ANNOTATION_LINK = "ENTREZ_ID";
    private boolean useLoadedAnnotationFile = false;
    protected File annotationFile;
    private String defaultFileBaseLocation;
    private String defaultFileLocation;
    private boolean easeScore = false;
    private boolean bonferroni = false;
    private boolean stepDownBonf = false;
    private boolean sidak = false;
    private boolean hochberg = true;
    private boolean probAnalysis = false;
    private boolean trimSelect = false;
    private boolean percentSelect = false;
    private String percentField = "5";
    private String hitField = "5";
    private int permCount = 1000;
    private boolean isSelected = false;
    private String supportFileLocation = null;
    private boolean isAdvancedAnnotParams = false;
    private boolean isAdvancedStatParams = false;
    private String[] labels;
    private JPanel popNClusterPanel;
    private File f = null;
    ClusterRepository repository;

    public File getAnnotationFile() {
        return this.annotationFile;
    }

    public EASEInitDialog(Frame parent, ClusterRepository repository, String[] annotationLabels, String defaultFileL, IResourceManager rm, String speciesName, String arrayName, Hashtable<String, Vector<String>> speciestoarrays, boolean isAnnotationLoaded) {
        this(parent, repository, annotationLabels, defaultFileL, rm, speciesName, arrayName, speciestoarrays, isAnnotationLoaded, true);
    }

    public EASEInitDialog(Frame parent, ClusterRepository repository, String[] annotationLabels, String defaultFileL, IResourceManager rm, String speciesName, String arrayName, Hashtable<String, Vector<String>> speciestoarrays, boolean isAnnotationLoaded, boolean isDataAppropriate) {
        super(parent, "EASE: EASE Annotation Analysis", true, isDataAppropriate);
        this.parent = parent;
        this.speciesName = speciesName;
        this.arrayName = arrayName;
        this.resourceManager = rm;
        this.speciestoarrays = speciestoarrays;
        this.useLoadedAnnotationFile = isAnnotationLoaded;
        this.defaultFileLocation = defaultFileL;
        this.repository = repository;
        this.labels = annotationLabels;
        this.defaultFileBaseLocation = this.defaultFileLocation == null ? TMEV.getSettingForOption((String)"last-ease-file-location") : this.defaultFileLocation;
        if (this.defaultFileBaseLocation == null || !new File(this.defaultFileBaseLocation).canRead()) {
            this.defaultFileBaseLocation = "./data/ease";
        }
        this.supportFileLocation = this.defaultFileBaseLocation;
        this.sep = System.getProperty("file.separator");
        this.font = new Font("Dialog", 1, 12);
        this.listener = new EventListener();
        this.addWindowListener(this.listener);
        this.configPanel = new ConfigPanel();
        this.nEasePanel = new NEasePanel();
        this.popNClusterPanel = new JPanel(new GridBagLayout());
        this.popNClusterPanel.setBackground(Color.white);
        this.browser = new ClusterBrowser(repository);
        this.popNClusterPanel.add((Component)this.browser, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel parameters = new JPanel(new GridBagLayout());
        this.popNClusterPanel.setPreferredSize(new Dimension(500, 350));
        parameters.setBackground(Color.white);
        this.modePanel = new ModePanel(repository != null && !repository.isEmpty());
        parameters.add((Component)this.configPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.modePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.popNClusterPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.nEasePanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(parameters);
        this.setActionListeners(this.listener);
        if (repository == null || repository.isEmpty()) {
            this.disableClusterSelection();
        }
        this.setSize(550, 700);
    }

    public void disableClusterSelection() {
        JPanel temporaryPanel = this.popNClusterPanel;
        temporaryPanel.setLayout(new GridBagLayout());
        temporaryPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Cluster Selection", 0, 0, this.font, Color.black));
        temporaryPanel.removeAll();
        temporaryPanel.validate();
        temporaryPanel.setOpaque(false);
        temporaryPanel.add((Component)new JLabel("Empty Cluster Repository"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(15, 0, 10, 0), 0, 0));
        temporaryPanel.add((Component)new JLabel("Only Annotation Survey is Enabled"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void enableClusterSelection() {
        JPanel tempPanel = this.popNClusterPanel;
        tempPanel.setLayout(new GridBagLayout());
        tempPanel.setBorder(BorderFactory.createEmptyBorder());
        tempPanel.removeAll();
        tempPanel.validate();
        tempPanel.setOpaque(false);
        tempPanel.add((Component)this.browser, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public EASEInitDialog(Frame parent, String[] annotationLabels) {
        super(parent, "EASE: EASE Annotation Analysis", true);
        this.parent = parent;
        this.font = new Font("Dialog", 1, 12);
        this.listener = new EventListener();
        this.addWindowListener(this.listener);
        this.configPanel = new ConfigPanel();
        JPanel popNClusterPanel = new JPanel(new GridBagLayout());
        popNClusterPanel.setBackground(Color.white);
        this.browser = new ClusterBrowser(this.repository);
        JPanel emptyClusterPanel = new JPanel(new GridBagLayout());
        String text = "<center><b>Note: When running EASE in script mode the cluster<br>";
        text = text + "under analysis is determined by the preceding algorithm<br>";
        text = text + "that feeds source data into EASE.</center>";
        JTextPane textArea = new JTextPane();
        textArea.setEditable(false);
        textArea.setBackground(Color.lightGray);
        textArea.setContentType("text/html");
        textArea.setText(text);
        emptyClusterPanel.add((Component)textArea, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        popNClusterPanel.add((Component)emptyClusterPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel parameters = new JPanel(new GridBagLayout());
        popNClusterPanel.setPreferredSize(new Dimension(500, 350));
        parameters.setBackground(Color.white);
        this.modePanel = new ModePanel(true);
        this.nEasePanel = new NEasePanel();
        parameters.add((Component)this.configPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.modePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)popNClusterPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.nEasePanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(parameters);
        this.setActionListeners(this.listener);
        this.setSize(550, 700);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.setVisible(true);
        return this.result;
    }

    public void resetControls() {
        if (this.speciestoarrays == null || this.speciestoarrays.size() == 0) {
            this.configPanel.organismListBox = new JComboBox();
            this.configPanel.organismListBox.addItem("No organisms listed");
            this.configPanel.organismListBox.setEnabled(false);
            this.configPanel.arrayListBox = new JComboBox();
            this.configPanel.arrayListBox.addItem("No species listed");
            this.configPanel.arrayListBox.setEnabled(false);
            this.configPanel.getEaseSupportFileButton.setEnabled(false);
        } else {
            try {
                if (this.speciesName != null && this.arrayName != null) {
                    this.configPanel.organismListBox.setSelectedItem(this.speciesName);
                    this.configPanel.arrayListBox.setSelectedItem(this.arrayName);
                } else {
                    this.configPanel.organismListBox.setSelectedIndex(0);
                }
            }
            catch (NullPointerException npe) {
                this.configPanel.arrayListBox.setSelectedItem(0);
            }
        }
        if (this.repository != null && !this.repository.isEmpty()) {
            this.modePanel.clusterAnalysisButton.setSelected(true);
            this.enableClusterSelection();
        }
        this.nEasePanel.nEaseBox.setSelected(false);
    }

    public boolean isClusterModeSelected() {
        return this.modePanel.clusterAnalysisButton.isSelected();
    }

    public Cluster getSelectedCluster() {
        return this.browser.getSelectedCluster();
    }

    public boolean wasCustomDataSet() {
        return this.isAdvancedAnnotParams;
    }

    public boolean isPopFileModeSelected() {
        if (this.isAdvancedAnnotParams) {
            return this.advancedFeat.isPopFileModeSelected();
        }
        return false;
    }

    public String getPopulationFileName() {
        if (this.isAdvancedAnnotParams && this.advancedFeat.isPopFileModeSelected()) {
            return this.advancedFeat.getPopFieldText();
        }
        return null;
    }

    public boolean isPreloadedAnnotationSelected() {
        return this.useLoadedAnnotationFile;
    }

    public String getConverterFileName() {
        if (this.isAdvancedAnnotParams && this.advancedFeat.isAnnBoxSelected()) {
            return this.advancedFeat.getConverterFileName();
        }
        return null;
    }

    public String getBaseFileLocation() {
        return this.supportFileLocation;
    }

    public String getAnnotationKeyType() {
        if (this.isAdvancedAnnotParams) {
            return this.advancedFeat.getAnnotationKeyType();
        }
        return ANNOTATION_LINK;
    }

    public String[] getAnnToGOFileList() {
        if (this.isAdvancedAnnotParams) {
            return this.advancedFeat.getAnnToGOFileList();
        }
        return this.getAnnFileList();
    }

    public String[] getAnnFileList() {
        File[] list = null;
        String[] paths = null;
        String base = this.getBaseFileLocation();
        String sep = System.getProperty("file.separator");
        File file = new File(base + sep + "Data" + sep + "Class" + sep);
        if (file.isDirectory()) {
            list = file.listFiles();
            paths = new String[list.length];
            for (int i = 0; i < list.length; ++i) {
                paths[i] = list[i].getAbsolutePath();
            }
        }
        return paths;
    }

    public boolean isEaseScoreSelected() {
        if (this.isAdvancedStatParams) {
            return this.statParam.easeBox.isSelected();
        }
        return this.easeScore;
    }

    public boolean isCorrectPvaluesSelected() {
        return this.isBonferroniSelected() || this.isStepDownBonferroniSelected() || this.isSidakSelected() || this.isHochbergSelected();
    }

    public boolean isBonferroniSelected() {
        if (this.isAdvancedStatParams) {
            return this.statParam.bonferroniBox.isSelected();
        }
        return this.bonferroni;
    }

    public boolean isStepDownBonferroniSelected() {
        if (this.isAdvancedStatParams) {
            return this.statParam.bonferroniStepBox.isSelected();
        }
        return this.stepDownBonf;
    }

    public boolean isSidakSelected() {
        if (this.isAdvancedStatParams) {
            return this.statParam.sidakBox.isSelected();
        }
        return this.sidak;
    }

    public boolean isHochbergSelected() {
        if (this.isAdvancedStatParams) {
            return this.statParam.hochbergBox.isSelected();
        }
        return this.hochberg;
    }

    public boolean isPermutationAnalysisSelected() {
        if (this.isAdvancedStatParams) {
            return this.statParam.permBox.isSelected();
        }
        return this.probAnalysis;
    }

    public int getPermutationCount() {
        if (this.isAdvancedStatParams) {
            return Integer.parseInt(this.statParam.permField.getText());
        }
        return this.permCount;
    }

    public boolean getTrimSelected() {
        if (this.isAdvancedStatParams) {
            return this.statParam.trimBox.isSelected();
        }
        return this.trimSelect;
    }

    public boolean getTrimPercentSelected() {
        if (this.isAdvancedStatParams) {
            return this.statParam.trimPercentBox.isSelected();
        }
        return this.percentSelect;
    }

    public String getTrimPercentValue() {
        if (this.isAdvancedStatParams) {
            return this.statParam.trimPercentField.getText();
        }
        return this.percentField;
    }

    public String getTrimMinHits() {
        if (this.isAdvancedStatParams) {
            return this.statParam.trimNField.getText();
        }
        return this.hitField;
    }

    public String[] getTrimOptions() {
        String[] options = new String[2];
        if (this.getTrimSelected()) {
            if (this.getTrimPercentSelected()) {
                options[0] = "PERCENT_TRIM";
                options[1] = this.getTrimPercentValue();
            } else {
                options[0] = "N_TRIM";
                options[1] = this.getTrimMinHits();
            }
        } else {
            options[0] = "NO_TRIM";
            options[1] = "0";
        }
        return options;
    }

    public boolean isNEaseSelected() {
        return this.nEasePanel.nEaseBox.isSelected();
    }

    public String summarizeSelections() {
        if (this.isAdvancedAnnotParams) {
            String returnString = "";
            returnString = returnString + this.advancedFeat.getAnnBoxText() + ": " + this.advancedFeat.isAnnBoxSelected();
            return returnString;
        }
        return "Annotation box was not selected";
    }

    public static void main(String[] args) {
        try {
            FileResourceManager rm = new FileResourceManager(new File(new File(System.getProperty("user.home"), ".mev"), "repository"));
            String[] labels = new String[]{"TC#", "GB#", "Role"};
            Hashtable speciestoarrays = new Hashtable();
            PipelinedAnnotationsFileDefinition speciestoarray = new PipelinedAnnotationsFileDefinition();
            try {
                File f = rm.getSupportFile((ISupportFileDefinition)speciestoarray, true);
                speciestoarrays = speciestoarray.parseAnnotationListFile(f);
            }
            catch (SupportFileAccessError sfae) {
                sfae.printStackTrace();
                Vector<String> temp = new Vector<String>();
                temp.add("HG_U133A");
                temp.add("APPLERA_ABI1700");
                speciestoarrays.put("Human", temp);
                Vector<String> temp2 = new Vector<String>();
                temp2.add("junk");
                temp2.add("junk2");
                speciestoarrays.put("Junk", temp2);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                Vector<String> temp = new Vector<String>();
                temp.add("HG_U133A");
                temp.add("APPLERA_ABI1700");
                speciestoarrays.put("Human", temp);
                Vector<String> temp2 = new Vector<String>();
                temp2.add("junk");
                temp2.add("junk2");
                speciestoarrays.put("Junk", temp2);
            }
            EASEInitDialog eid = new EASEInitDialog(new JFrame(), new ClusterRepository(0), labels, "", (IResourceManager)rm, "Human", "HG_U133A", speciestoarrays, false);
            eid.showModal();
        }
        catch (RepositoryInitializationError rie) {
            rie.printStackTrace();
        }
    }

    public String getImpliesFileLocation() {
        String[] path = this.getAnnToGOFileList();
        String anyPath = "";
        String temporary = "";
        if (path.length > 0) {
            StringTokenizer tok = new StringTokenizer(path[0], this.sep);
            while (tok.hasMoreTokens()) {
                anyPath = tok.nextToken();
                temporary = temporary + anyPath + this.sep;
                if (!anyPath.equals("Class")) continue;
            }
        }
        return temporary + "Implies";
    }

    protected class EventListener
    extends DialogListener
    implements ItemListener {
        protected EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("select_stat_parameters")) {
                if (!EASEInitDialog.this.isAdvancedStatParams) {
                    EASEInitDialog.this.statParam = new EASEStatParam(EASEInitDialog.this.parent);
                    EASEInitDialog.this.statParamTemp = new EASEStatParam(EASEInitDialog.this.parent);
                    EASEInitDialog.this.resultStat = EASEInitDialog.this.statParam.showModal();
                } else {
                    this.copyStatElements(EASEInitDialog.this.statParam, EASEInitDialog.this.statParamTemp);
                    EASEInitDialog.this.resultStat = EASEInitDialog.this.statParam.showModal();
                }
                if (EASEInitDialog.this.resultStat == 0) {
                    EASEInitDialog.this.isAdvancedStatParams = true;
                } else {
                    this.copyStatElements(EASEInitDialog.this.statParamTemp, EASEInitDialog.this.statParam);
                }
            } else if (command.equals("select_extra_parameters")) {
                if (!EASEInitDialog.this.isAdvancedAnnotParams) {
                    EASEInitDialog.this.advancedFeat = new EASEAdvancedFeatures(EASEInitDialog.this.parent, EASEInitDialog.this.supportFileLocation, EASEInitDialog.this.isClusterModeSelected(), EASEInitDialog.this.repository, EASEInitDialog.this.labels);
                    EASEInitDialog.this.advancedFeatTemp = new EASEAdvancedFeatures(EASEInitDialog.this.parent, EASEInitDialog.this.supportFileLocation, EASEInitDialog.this.isClusterModeSelected(), EASEInitDialog.this.repository, EASEInitDialog.this.labels);
                    EASEInitDialog.this.resultAdvanced = EASEInitDialog.this.advancedFeat.showModal();
                } else {
                    this.copyAnnotationElements(EASEInitDialog.this.advancedFeat, EASEInitDialog.this.advancedFeatTemp);
                    EASEInitDialog.this.resultAdvanced = EASEInitDialog.this.advancedFeat.showModal();
                }
                if (EASEInitDialog.this.resultAdvanced == 0) {
                    this.updateSupportFileSelection();
                    EASEInitDialog.this.isAdvancedAnnotParams = true;
                    ((EASEInitDialog)EASEInitDialog.this).configPanel.configureExtras.setText("Configured");
                    ((EASEInitDialog)EASEInitDialog.this).configPanel.statusLabel.setText("     Selected");
                    ((EASEInitDialog)EASEInitDialog.this).configPanel.getEaseSupportFileButton.setText("Done");
                    ((EASEInitDialog)EASEInitDialog.this).configPanel.getEaseSupportFileButton.setEnabled(false);
                } else {
                    this.copyAnnotationElements(EASEInitDialog.this.advancedFeatTemp, EASEInitDialog.this.advancedFeat);
                }
            } else if (command.equals("organism-selected-command")) {
                EASEInitDialog.this.configPanel.selectSpecies();
                EASEInitDialog.this.configPanel.updateSelection();
            } else if (command.equals("array-selected-command")) {
                EASEInitDialog.this.configPanel.updateSelection();
            } else if (command.equals("download-support-file-command")) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            EASEInitDialog.this.configPanel.onDownloadSupportFile();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                thread.setPriority(1);
                thread.start();
            } else if (command.equals("ok-command")) {
                EASEInitDialog.this.result = 0;
                if (EASEInitDialog.this.isSelected && !EASEInitDialog.this.isAdvancedAnnotParams) {
                    if (!EASEInitDialog.this.useLoadedAnnotationFile) {
                        JOptionPane.showMessageDialog(EASEInitDialog.this.parent, "You have not provided Annotation Files for the organism/array selected.\nPlease load annotation files into Mev by selecting Import Resourcerer Gene Annotation on the utilities menu.", "EASE Initialization: Missing Parameter", 2);
                    } else {
                        EASEInitDialog.this.dispose();
                    }
                } else if (!EASEInitDialog.this.isSelected && !EASEInitDialog.this.isAdvancedAnnotParams) {
                    JOptionPane.showMessageDialog(EASEInitDialog.this.parent, "You have not selected a source for support files.\nPlease select an organism/array plataform or go to advanced options to browse for a directory.", "EASE Initialization: Missing Parameter", 2);
                    ((EASEInitDialog)EASEInitDialog.this).configPanel.getEaseSupportFileButton.requestFocusInWindow();
                } else {
                    EASEInitDialog.this.dispose();
                }
            } else if (command.equals("cancel-command")) {
                EASEInitDialog.this.result = 2;
                EASEInitDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    EASEInitDialog.this.resetControls();
                    EASEInitDialog.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(EASEInitDialog.this, "EASE Initialization Dialog");
                }
            }
        }

        public void copyAnnotationElements(EASEAdvancedFeatures source, EASEAdvancedFeatures destination) {
            destination.configPanelExtension.supportFileLocationField.setText(source.configPanelExtension.supportFileLocationField.getText());
            destination.popPanel.fileButton.setSelected(source.popPanel.fileButton.isSelected());
            destination.popPanel.dataButton.setSelected(source.popPanel.dataButton.isSelected());
            destination.popPanel.popField.setText(source.popPanel.popField.getText());
            destination.popPanel.popField.setBackground(source.popPanel.popField.getBackground());
            destination.popPanel.popField.setEnabled(source.popPanel.popField.isEnabled());
            destination.popPanel.browseButton.setEnabled(source.popPanel.browseButton.isEnabled());
            destination.popPanel.fileLabel.setEnabled(source.popPanel.fileLabel.isEnabled());
            destination.paramPanel.fieldNamesBox.setSelectedIndex(source.paramPanel.fieldNamesBox.getSelectedIndex());
            destination.paramPanel.useAnnBox.setSelected(source.paramPanel.useAnnBox.isSelected());
            destination.paramPanel.browserButton.setEnabled(source.paramPanel.browserButton.isEnabled());
            destination.paramPanel.converterFileField.setText(source.paramPanel.converterFileField.getText());
            destination.paramPanel.converterFileField.setEnabled(source.paramPanel.converterFileField.isEnabled());
            destination.paramPanel.converterFileField.setBackground(source.paramPanel.converterFileField.getBackground());
            destination.paramPanel.fileLabel.setEnabled(source.paramPanel.fileLabel.isEnabled());
            destination.paramPanel.removeButton.setEnabled(source.paramPanel.removeButton.isEnabled());
            int sourceSize = source.paramPanel.annFileList.getModel().getSize();
            Object[] baseFiles = ((DefaultListModel)source.paramPanel.annFileList.getModel()).toArray();
            ((DefaultListModel)destination.paramPanel.annFileList.getModel()).clear();
            for (int i = 0; i < sourceSize; ++i) {
                ((DefaultListModel)destination.paramPanel.annFileList.getModel()).addElement(baseFiles[i]);
            }
        }

        public void copyStatElements(EASEStatParam source, EASEStatParam destination) {
            destination.fisherBox.setSelected(source.fisherBox.isSelected());
            destination.hochbergBox.setSelected(source.hochbergBox.isSelected());
            destination.trimBox.setSelected(source.trimBox.isSelected());
            destination.bonferroniBox.setSelected(source.bonferroniBox.isSelected());
            destination.bonferroniStepBox.setSelected(source.bonferroniStepBox.isSelected());
            destination.sidakBox.setSelected(source.sidakBox.isSelected());
            destination.permBox.setSelected(source.permBox.isSelected());
            destination.permField.setText(source.permField.getText());
            destination.trimNBox.setSelected(source.trimNBox.isSelected());
            destination.trimNField.setText(source.trimNField.getText());
            destination.trimPercentBox.setSelected(source.trimPercentBox.isSelected());
            destination.trimPercentField.setText(source.trimPercentField.getText());
            destination.permLabel.setEnabled(source.permLabel.isEnabled());
            destination.permField.setEnabled(source.permField.isEnabled());
            destination.trimNBox.setEnabled(source.trimNBox.isEnabled());
            destination.trimNLabel.setEnabled(source.trimNLabel.isEnabled());
            destination.trimNField.setEnabled(source.trimNField.isEnabled());
            destination.trimPercentBox.setEnabled(source.trimPercentBox.isEnabled());
            destination.trimPercentLabel.setEnabled(source.trimPercentLabel.isEnabled());
            destination.trimPercentField.setEnabled(source.trimPercentField.isEnabled());
        }

        public void updateSupportFileSelection() {
            EASEInitDialog.this.supportFileLocation = EASEInitDialog.this.advancedFeat.getNewSupportFileLocation();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            EASEInitDialog.this.result = -1;
            EASEInitDialog.this.dispose();
        }
    }

    protected class ConfigPanel
    extends ParameterPanel {
        private static final long serialVersionUID = -5298900627241870503L;
        JComboBox organismListBox;
        JComboBox arrayListBox;
        JLabel chooseOrg;
        JLabel chooseArray;
        JLabel statusLabel;
        JButton getEaseSupportFileButton;
        JButton configureExtras;

        public ConfigPanel() {
            super("Support Directory /Annotation Parameter Selection");
            this.setLayout(new GridBagLayout());
            this.getEaseSupportFileButton = new JButton("Download");
            this.getEaseSupportFileButton.setActionCommand("download-support-file-command");
            this.getEaseSupportFileButton.addActionListener(EASEInitDialog.this.listener);
            this.getEaseSupportFileButton.setToolTipText("<html>Downloads EASE annotation files<br>for a selected species and array type.</html>");
            this.configureExtras = new JButton("Custom");
            this.configureExtras.setActionCommand("select_extra_parameters");
            this.configureExtras.addActionListener(EASEInitDialog.this.listener);
            this.configureExtras.setToolTipText("Specifies support directories, population and Annotation files.");
            this.chooseOrg = new JLabel("         Organism");
            this.chooseArray = new JLabel("Array Platform");
            this.statusLabel = new JLabel("Select This");
            if (EASEInitDialog.this.speciestoarrays == null || EASEInitDialog.this.speciestoarrays.size() == 0) {
                this.organismListBox = new JComboBox();
                this.organismListBox.addItem("No organisms listed");
                this.organismListBox.setEnabled(false);
                this.arrayListBox = new JComboBox();
                this.arrayListBox.addItem("No species listed");
                this.arrayListBox.setEnabled(false);
                this.getEaseSupportFileButton.setEnabled(false);
            } else {
                if (EASEInitDialog.this.speciestoarrays.size() > 0) {
                    this.organismListBox = new JComboBox(new Vector(EASEInitDialog.this.speciestoarrays.keySet()));
                    try {
                        this.organismListBox.setSelectedItem(EASEInitDialog.this.speciesName);
                    }
                    catch (NullPointerException npe) {
                        this.organismListBox.setSelectedIndex(0);
                    }
                    if (this.organismListBox.getSelectedItem() == null) {
                        this.arrayListBox = new JComboBox();
                    } else {
                        this.arrayListBox = new JComboBox();
                        Vector arraysForThisSpecies = (Vector)EASEInitDialog.this.speciestoarrays.get(this.organismListBox.getSelectedItem());
                        for (int i = 0; i < arraysForThisSpecies.size(); ++i) {
                            this.arrayListBox.addItem(arraysForThisSpecies.elementAt(i));
                        }
                    }
                    try {
                        this.arrayListBox.setSelectedItem(EASEInitDialog.this.arrayName);
                    }
                    catch (NullPointerException npe) {
                        this.arrayListBox.setSelectedIndex(0);
                    }
                }
                this.arrayListBox.setEnabled(true);
            }
            this.arrayListBox.addActionListener(EASEInitDialog.this.listener);
            this.arrayListBox.setActionCommand("array-selected-command");
            this.organismListBox.addActionListener(EASEInitDialog.this.listener);
            this.organismListBox.setActionCommand("organism-selected-command");
            this.add((Component)this.organismListBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 30, 0, 0), 0, 0));
            this.add((Component)this.arrayListBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 30, 0, 0), 0, 0));
            this.add((Component)this.chooseOrg, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(10, 30, 0, 0), 0, 0));
            this.add((Component)this.chooseArray, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 30, 0, 0), 0, 0));
            this.add((Component)this.statusLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 25, 0, 20), 0, 0));
            this.add((Component)this.getEaseSupportFileButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 25, 0, 20), 0, 0));
            this.add((Component)this.configureExtras, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 25, 0, 20), 0, 0));
            try {
                boolean b = EASEInitDialog.this.resourceManager.fileIsInRepository((ISupportFileDefinition)new EASEEntrezSupportDataFile(this.organismListBox.getSelectedItem().toString(), this.arrayListBox.getSelectedItem().toString()));
                if (b) {
                    this.getEaseSupportFileButton.setText("Select This");
                } else {
                    this.getEaseSupportFileButton.setText("Download");
                }
            }
            catch (NullPointerException npe) {
                this.getEaseSupportFileButton.setText("Download");
            }
            this.updateSelection();
        }

        private void onDownloadSupportFile() {
            EASEEntrezSupportDataFile esdf = null;
            try {
                String species = this.organismListBox.getSelectedItem().toString();
                String array = this.arrayListBox.getSelectedItem().toString();
                esdf = new EASEEntrezSupportDataFile(species, array);
                EASEInitDialog.this.f = EASEInitDialog.this.resourceManager.getSupportFile((ISupportFileDefinition)esdf, true);
                EASEInitDialog.this.supportFileLocation = EASEInitDialog.this.f.getAbsolutePath();
                this.getEaseSupportFileButton.setText("Done");
                this.statusLabel.setText("     Selected");
                this.getEaseSupportFileButton.setEnabled(false);
                this.configureExtras.setText("Advanced");
                EASEInitDialog.this.isSelected = true;
            }
            catch (SupportFileAccessError sfae) {
                this.statusLabel.setText("Failure");
                String easeURL = null;
                try {
                    easeURL = esdf.getURL().toString();
                }
                catch (MalformedURLException mue) {
                    // empty catch block
                }
                ShowThrowableDialog.show((Frame)EASEInitDialog.this.parent, (String)"Unable to download EASE files", (boolean)true, (int)64, (Throwable)sfae, (String)("unable to download file from " + easeURL));
                sfae.printStackTrace();
            }
            catch (NullPointerException npe) {
                this.statusLabel.setText("Failure");
                ShowThrowableDialog.show((Frame)EASEInitDialog.this.parent, (String)"Unable to download EASE files", (boolean)true, (int)64, (Throwable)npe, (String)"Unable to download EASE files at this time. ");
            }
        }

        public void selectSpecies() {
            this.arrayListBox.removeAllItems();
            Vector arraysForThisSpecies = (Vector)EASEInitDialog.this.speciestoarrays.get(this.organismListBox.getSelectedItem());
            for (int i = 0; i < arraysForThisSpecies.size(); ++i) {
                this.arrayListBox.addItem(arraysForThisSpecies.elementAt(i));
            }
        }

        public void updateSelection() {
            if (this.arrayListBox.getSelectedItem() == null) {
                return;
            }
            String selectedOrganism = this.organismListBox.getSelectedItem().toString();
            String selectedArray = this.arrayListBox.getSelectedItem().toString();
            if (selectedOrganism != null && selectedArray != null) {
                if (EASEInitDialog.this.resourceManager.fileIsInRepository((ISupportFileDefinition)new EASEEntrezSupportDataFile(selectedOrganism, selectedArray))) {
                    this.statusLabel.setText("Click to Select");
                    this.getEaseSupportFileButton.setText("Select");
                } else {
                    this.statusLabel.setText("Click to Download");
                    this.getEaseSupportFileButton.setText("Download");
                }
                this.getEaseSupportFileButton.setEnabled(true);
                try {
                    ResourcererAnnotationFileDefinition def = new ResourcererAnnotationFileDefinition(EASEInitDialog.this.speciesName, EASEInitDialog.this.arrayName);
                    if (EASEInitDialog.this.speciesName != null && EASEInitDialog.this.arrayName != null) {
                        EASEInitDialog.this.annotationFile = EASEInitDialog.this.resourceManager.getSupportFile((ISupportFileDefinition)def, false);
                    }
                }
                catch (SupportFileAccessError sfae) {
                    sfae.printStackTrace();
                    EASEInitDialog.this.useLoadedAnnotationFile = false;
                }
            } else {
                this.getEaseSupportFileButton.setEnabled(false);
            }
        }
    }

    protected class ModePanel
    extends JPanel {
        private static final long serialVersionUID = -4927037409254942407L;
        protected JRadioButton clusterAnalysisButton;
        protected JRadioButton slideSurveyButton;

        public ModePanel(boolean haveClusters) {
            super(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Mode Selection", 0, 0, EASEInitDialog.this.font, Color.black));
            ButtonGroup bg = new ButtonGroup();
            this.clusterAnalysisButton = new JRadioButton("Cluster Analysis", haveClusters);
            this.clusterAnalysisButton.setFocusPainted(false);
            this.clusterAnalysisButton.setBackground(Color.white);
            this.clusterAnalysisButton.setHorizontalAlignment(0);
            bg.add(this.clusterAnalysisButton);
            this.clusterAnalysisButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    EASEInitDialog.this.enableClusterSelection();
                }
            });
            this.slideSurveyButton = new JRadioButton("Annotation Survey");
            this.slideSurveyButton.setToolTipText("Surveys annotation loaded in the CURRENT viewer.");
            this.slideSurveyButton.setFocusPainted(false);
            this.slideSurveyButton.setBackground(Color.white);
            this.slideSurveyButton.setHorizontalAlignment(0);
            bg.add(this.slideSurveyButton);
            this.slideSurveyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    EASEInitDialog.this.disableClusterSelection();
                }
            });
            if (!haveClusters) {
                this.slideSurveyButton.setSelected(true);
                this.clusterAnalysisButton.setEnabled(false);
            }
            this.add((Component)this.clusterAnalysisButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.slideSurveyButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    protected class NEasePanel
    extends JPanel {
        protected JCheckBox nEaseBox;
        protected JLabel paramLabel;
        JButton configureAdvancedOptions;

        public NEasePanel() {
            this.setBackground(Color.white);
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Statistical Parameter Selection", 0, 0, EASEInitDialog.this.font, Color.black));
            this.nEaseBox = new JCheckBox("Run Nested EASE", false);
            this.nEaseBox.setActionCommand("run-nease");
            this.nEaseBox.addActionListener(EASEInitDialog.this.listener);
            this.nEaseBox.setBackground(Color.white);
            this.configureAdvancedOptions = new JButton("Advanced");
            this.configureAdvancedOptions.setActionCommand("select_stat_parameters");
            this.configureAdvancedOptions.addActionListener(EASEInitDialog.this.listener);
            this.configureAdvancedOptions.setToolTipText("Specifies statistical parameters.");
            this.paramLabel = new JLabel("  Modify Statistical Parameters");
            this.add((Component)this.nEaseBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 95, 1, 0), 0, 0));
            this.add((Component)this.paramLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 95, 0, 0), 0, 0));
            this.add((Component)this.configureAdvancedOptions, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 130), 0, 0));
        }
    }
}

