/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease;

import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.ShowThrowableDialog;
import org.tigr.microarray.mev.annotation.AnnotationFileReader;
import org.tigr.microarray.mev.annotation.IAnnotation;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ease.EaseAlgorithmData;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Logger;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASECentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEEntrezSupportDataFile;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEImpliesAndURLDataFile;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASETableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ease.gotree.GOTreeViewer;
import org.tigr.microarray.mev.resources.ISupportFileDefinition;
import org.tigr.microarray.mev.resources.PipelinedAnnotationsFileDefinition;
import org.tigr.microarray.mev.resources.SupportFileAccessError;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;

public class EASEGUI
implements IClusterGUI,
IScriptGUI {
    protected Algorithm algorithm;
    protected EaseAlgorithmData algorithmData;
    protected Experiment experiment;
    protected Cluster cluster;
    protected int[][] clusters;
    protected String[] categoryNames;
    protected String[][] resultMatrix;
    protected boolean haveAccessionNumbers;
    protected boolean isClusterAnalysis;
    protected Logger logger;
    protected Progress progress;
    protected Listener listener;
    protected boolean stop = false;
    protected String annotationKeyType;
    protected String baseFileSystem;
    protected boolean isScripting = false;
    protected File annotationFile;
    String baseImpliesFileLocation = "";
    String baseTagFileLocation = "";
    public static final String LAST_EASE_FILE_LOCATION = "last-ease-file-location";
    protected boolean isNestedEase = false;

    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        String[] populationKeys;
        String[] annotationFileList;
        String converterFileName;
        EASEInitDialog dialog;
        block30: {
            String sep = System.getProperty("file.separator");
            this.algorithmData = new EaseAlgorithmData();
            ClusterRepository repository = framework.getClusterRepository(0);
            String easeFileLocation = null;
            String chipType = null;
            String species = null;
            Vector<ISupportFileDefinition> defs = new Vector<ISupportFileDefinition>();
            EASEEntrezSupportDataFile edf = null;
            if (framework.getData().isAnnotationLoaded()) {
                chipType = framework.getData().getChipAnnotation().getChipType();
                species = framework.getData().getChipAnnotation().getSpeciesName();
                edf = new EASEEntrezSupportDataFile(species, chipType);
                defs.add(edf);
            }
            Hashtable speciestoarrays = null;
            PipelinedAnnotationsFileDefinition aafd = new PipelinedAnnotationsFileDefinition();
            defs.add((ISupportFileDefinition)aafd);
            EASEImpliesAndURLDataFile eiudf = new EASEImpliesAndURLDataFile();
            defs.add(eiudf);
            try {
                Hashtable supportFiles = framework.getSupportFiles(defs, true);
                File impliesFile = (File)supportFiles.get((Object)eiudf);
                this.baseImpliesFileLocation = eiudf.getImpliesLocation(impliesFile);
                if (this.baseImpliesFileLocation == null) {
                    this.baseImpliesFileLocation = "";
                }
                this.baseTagFileLocation = eiudf.getTagsLocation(impliesFile);
                if (this.baseTagFileLocation == null) {
                    this.baseTagFileLocation = "";
                }
                File speciesarraymapping = (File)supportFiles.get(aafd);
                try {
                    speciestoarrays = aafd.parseAnnotationListFile(speciesarraymapping);
                }
                catch (IOException ioe) {
                    speciestoarrays = null;
                }
                easeFileLocation = edf != null || framework.getData().isAnnotationLoaded() ? ((File)supportFiles.get((Object)edf)).getAbsolutePath() : "./data/ease" + sep + "ease_" + chipType;
            }
            catch (SupportFileAccessError sfae) {
                easeFileLocation = "./data/ease" + sep + "ease_" + chipType;
            }
            catch (NullPointerException npe) {
                easeFileLocation = "./data/ease" + sep + "ease_" + chipType;
            }
            dialog = new EASEInitDialog(framework.getFrame(), repository, framework.getData().getAllFilledAnnotationFields(), easeFileLocation, framework.getResourceManager(), species, chipType, speciestoarrays, framework.getData().isAnnotationLoaded(), framework.getData().getDataType() != 6);
            if (dialog.showModal() != 0) {
                return null;
            }
            this.listener = new Listener();
            this.logger = new Logger(framework.getFrame(), "EASE Analysis", this.listener);
            this.logger.show();
            this.progress = new Progress(framework.getFrame(), "Probability Analysis Resampling Progress", this.listener);
            this.baseFileSystem = dialog.getBaseFileLocation();
            this.algorithmData.addParam("base-file-system", this.baseFileSystem);
            this.isClusterAnalysis = dialog.isClusterModeSelected();
            converterFileName = dialog.getConverterFileName();
            this.annotationKeyType = dialog.getAnnotationKeyType();
            this.algorithmData.addParam("annotation-key-type", this.annotationKeyType);
            this.isNestedEase = dialog.isNEaseSelected();
            annotationFileList = dialog.getAnnToGOFileList();
            if (!dialog.isPreloadedAnnotationSelected()) {
                this.algorithmData.setImpliesFileLocation(this.baseFileSystem + sep + "Data" + sep + "Class" + sep + "Implies");
                this.algorithmData.setTagFileLocation(this.baseFileSystem + sep + "Data" + sep + "Class" + sep + "URL data" + sep + "Tags");
            }
            if (this.algorithmData.getImpliesFileLocation() == null || !new File(this.algorithmData.getImpliesFileLocation()).exists() || !new File(this.algorithmData.getImpliesFileLocation()).isDirectory()) {
                if (dialog.wasCustomDataSet()) {
                    this.algorithmData.setImpliesFileLocation(dialog.getImpliesFileLocation());
                    this.algorithmData.setTagFileLocation(this.baseFileSystem + sep + "Data" + sep + "Class" + sep + "URL data" + sep + "Tags");
                } else {
                    this.algorithmData.setImpliesFileLocation(this.baseImpliesFileLocation);
                }
            }
            if (this.algorithmData.getTagFileLocation() == null || !new File(this.algorithmData.getTagFileLocation()).exists() || !new File(this.algorithmData.getTagFileLocation()).isDirectory()) {
                this.algorithmData.setTagFileLocation(this.baseTagFileLocation);
            }
            this.experiment = framework.getData().getExperiment();
            if (this.isClusterAnalysis) {
                this.cluster = dialog.getSelectedCluster();
                this.experiment = this.cluster.getExperiment();
                int[] indices = this.cluster.getIndices();
                this.algorithmData.setReportEaseScore(dialog.isEaseScoreSelected());
                boolean isPvalueCorrectionSelected = dialog.isCorrectPvaluesSelected();
                this.algorithmData.setPvalueCorrectionsOption(String.valueOf(isPvalueCorrectionSelected));
                if (isPvalueCorrectionSelected) {
                    this.algorithmData.addParam("bonferroni-correction", String.valueOf(dialog.isBonferroniSelected()));
                    this.algorithmData.addParam("bonferroni-step-down-correction", String.valueOf(dialog.isStepDownBonferroniSelected()));
                    this.algorithmData.addParam("sidak-correction", String.valueOf(dialog.isSidakSelected()));
                    this.algorithmData.setHochbergCorrection(dialog.isHochbergSelected());
                }
                this.algorithmData.setRunNease(dialog.isNEaseSelected());
                this.algorithmData.setRunPermutationAnalysis(dialog.isPermutationAnalysisSelected());
                if (dialog.isPermutationAnalysisSelected()) {
                    this.algorithmData.addParam("permutation-count", String.valueOf(dialog.getPermutationCount()));
                }
                this.logger.append("Extracting Annotation Key Lists\n");
                String[] clusterKeys = framework.getData().getAnnotationList(this.annotationKeyType, indices);
                this.algorithmData.setSampleList(clusterKeys);
                this.algorithmData.setSampleIndices(this.cluster.getExperimentIndices());
            }
            if (this.isClusterAnalysis && dialog.isPreloadedAnnotationSelected()) {
                try {
                    populationKeys = this.loadGeneIDs(dialog.getAnnotationFile());
                }
                catch (IOException ioe) {
                    ShowThrowableDialog.show((Frame)framework.getFrame(), (String)"Error loading population file.", (Throwable)ioe);
                    return null;
                }
                if (populationKeys == null) {
                    JOptionPane.showMessageDialog(framework.getFrame(), "Error loading population file:.", "Population File Load Error", 0);
                    return null;
                }
            } else {
                if (this.isClusterAnalysis && dialog.isPopFileModeSelected()) {
                    try {
                        populationKeys = this.getPopulationKeysFromFile(dialog.getPopulationFileName());
                        if (populationKeys == null) {
                            return null;
                        }
                        break block30;
                    }
                    catch (IOException ioe) {
                        ShowThrowableDialog.show((Frame)framework.getFrame(), (String)"Population File is not formatted correctly.", (Throwable)ioe);
                        return null;
                    }
                }
                populationKeys = framework.getData().getAnnotationList(this.annotationKeyType, framework.getData().getExperiment().getRowMappingArrayCopy());
            }
        }
        this.algorithmData.setPerformClusterAnalysis(this.isClusterAnalysis);
        this.algorithmData.setPopulationList(populationKeys);
        if (converterFileName != null) {
            this.algorithmData.setConverterFileName(converterFileName);
        }
        this.algorithmData.setAnnotationFileList(annotationFileList);
        this.algorithmData.setExpression(this.experiment.getMatrix());
        String[] trimOptions = dialog.getTrimOptions();
        this.algorithmData.setTrimOption(trimOptions[0]);
        this.algorithmData.setTrimValue(new Float(trimOptions[1]).floatValue());
        this.algorithm = framework.getAlgorithmFactory().getAlgorithm("EASE");
        this.algorithm.addAlgorithmListener((AlgorithmListener)this.listener);
        this.algorithm.execute((AlgorithmData)this.algorithmData);
        if (this.stop) {
            return null;
        }
        this.progress.dispose();
        this.categoryNames = this.algorithmData.getStringArray("category-names");
        this.clusters = this.algorithmData.getClusterMatrix();
        this.resultMatrix = this.algorithmData.getResultMatrix();
        this.haveAccessionNumbers = this.algorithmData.isHaveAccessions();
        this.logger.append("Creating Result Viewers\n");
        DefaultMutableTreeNode node = this.resultMatrix == null ? this.createEmptyResultNode((AlgorithmData)this.algorithmData) : this.createResultNode((AlgorithmData)this.algorithmData, this.clusters);
        if (this.algorithm != null) {
            this.algorithm.removeAlgorithmListener((AlgorithmListener)this.listener);
        }
        if (this.logger != null) {
            this.logger.dispose();
        }
        return node;
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        this.algorithmData = new EaseAlgorithmData();
        EASEInitDialog dialog = new EASEInitDialog(framework.getFrame(), framework.getData().getFieldNames());
        if (dialog.showModal() != 0) {
            return null;
        }
        this.baseFileSystem = dialog.getBaseFileLocation();
        this.algorithmData.addParam("base-file-system", this.baseFileSystem);
        this.isClusterAnalysis = dialog.isClusterModeSelected();
        String converterFileName = dialog.getConverterFileName();
        this.annotationKeyType = dialog.getAnnotationKeyType();
        this.algorithmData.addParam("annotation-key-type", this.annotationKeyType);
        String[] annotationFileList = dialog.getAnnToGOFileList();
        this.experiment = framework.getData().getExperiment();
        if (this.isClusterAnalysis) {
            this.algorithmData.addParam("report-ease-score", String.valueOf(dialog.isEaseScoreSelected()));
            boolean isPvalueCorrectionSelected = dialog.isCorrectPvaluesSelected();
            this.algorithmData.addParam("p-value-corrections", String.valueOf(isPvalueCorrectionSelected));
            if (isPvalueCorrectionSelected) {
                this.algorithmData.addParam("bonferroni-correction", String.valueOf(dialog.isBonferroniSelected()));
                this.algorithmData.addParam("bonferroni-step-down-correction", String.valueOf(dialog.isStepDownBonferroniSelected()));
                this.algorithmData.addParam("sidak-correction", String.valueOf(dialog.isSidakSelected()));
                this.algorithmData.addParam("hochberg-correction", String.valueOf(dialog.isHochbergSelected()));
            }
            this.algorithmData.addParam("run-nease", String.valueOf(dialog.isNEaseSelected()));
            this.algorithmData.addParam("run-permutation-analysis", String.valueOf(dialog.isPermutationAnalysisSelected()));
            if (dialog.isPermutationAnalysisSelected()) {
                this.algorithmData.addParam("permutation-count", String.valueOf(dialog.getPermutationCount()));
            }
        }
        if (this.isClusterAnalysis && dialog.isPopFileModeSelected()) {
            this.algorithmData.addParam("population-file-name", dialog.getPopulationFileName());
        }
        this.algorithmData.addParam("perform-cluster-analysis", String.valueOf(this.isClusterAnalysis));
        if (converterFileName != null) {
            this.algorithmData.addParam("converter-file-name", converterFileName);
        }
        this.algorithmData.addStringArray("annotation-file-list", annotationFileList);
        String[] trimOptions = dialog.getTrimOptions();
        this.algorithmData.addParam("trim-option", trimOptions[0]);
        this.algorithmData.addParam("trim-value", trimOptions[1]);
        this.algorithmData.addParam("name", "EASE");
        this.algorithmData.addParam("alg-type", "cluster-genes");
        this.algorithmData.addParam("output-class", "multi-gene-cluster-output");
        String[] outputNodes = new String[]{"Multi-cluster"};
        this.algorithmData.addStringArray("output-nodes", outputNodes);
        return this.algorithmData;
    }

    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        String[] populationKeys;
        block9: {
            this.isScripting = true;
            this.algorithmData = (EaseAlgorithmData)algData;
            this.experiment = experiment;
            algData.addMatrix("expression", framework.getData().getExperiment().getMatrix());
            AlgorithmParameters params = algData.getParams();
            this.isClusterAnalysis = params.getBoolean("perform-cluster-analysis");
            this.annotationKeyType = params.getString("annotation-key-type");
            this.isNestedEase = params.getBoolean("run-nease");
            this.listener = new Listener();
            this.logger = new Logger(framework.getFrame(), "EASE Analysis", this.listener);
            this.logger.show();
            this.progress = new Progress(framework.getFrame(), "Probability Analysis Resampling Progress", this.listener);
            if (this.isClusterAnalysis) {
                int[] indices = experiment.getRowMappingArrayCopy();
                String[] clusterKeys = framework.getData().getAnnotationList(this.annotationKeyType, indices);
                algData.addStringArray("sample-list", clusterKeys);
                int[] tempArray = new int[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    tempArray[i] = i;
                }
                algData.addIntArray("sample-indices", tempArray);
            }
            String popFileName = params.getString("population-file-name");
            if (this.isClusterAnalysis && popFileName != null) {
                try {
                    populationKeys = this.getPopulationKeysFromFile(params.getString("population-file-name"));
                    if (populationKeys == null) {
                        return null;
                    }
                    break block9;
                }
                catch (IOException ioe) {
                    ShowThrowableDialog.show((Frame)framework.getFrame(), (String)"Error loading population file.", (Throwable)ioe);
                    return null;
                }
            }
            populationKeys = framework.getData().getAnnotationList(this.annotationKeyType, framework.getData().getExperiment().getRowMappingArrayCopy());
        }
        algData.addStringArray("population-list", populationKeys);
        this.algorithm = framework.getAlgorithmFactory().getAlgorithm("EASE");
        this.algorithm.addAlgorithmListener((AlgorithmListener)this.listener);
        this.algorithm.execute((AlgorithmData)this.algorithmData);
        if (this.stop) {
            return null;
        }
        this.progress.dispose();
        this.categoryNames = this.algorithmData.getStringArray("category-names");
        this.clusters = this.algorithmData.getIntMatrix("cluster-matrix");
        this.resultMatrix = (String[][])this.algorithmData.getObjectMatrix("result-matrix");
        this.haveAccessionNumbers = this.algorithmData.getParams().getBoolean("have-accession-numbers", false);
        this.logger.append("Creating Result Viewers\n");
        DefaultMutableTreeNode node = this.resultMatrix == null ? this.createEmptyResultNode((AlgorithmData)this.algorithmData) : this.createResultNode((AlgorithmData)this.algorithmData, this.clusters);
        if (this.algorithm != null) {
            this.algorithm.removeAlgorithmListener((AlgorithmListener)this.listener);
        }
        if (this.logger != null) {
            this.logger.dispose();
        }
        return node;
    }

    protected String[] getPopulationKeysFromFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.exists()) {
            String key;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            Vector<String> ann = new Vector<String>();
            while ((key = reader.readLine()) != null) {
                ann.add(key.trim());
            }
            String[] annot = new String[ann.size()];
            for (int i = 0; i < annot.length; ++i) {
                annot[i] = (String)ann.elementAt(i);
            }
            return annot;
        }
        return null;
    }

    protected String[] loadGeneIDs(File annotationFile) throws IOException {
        if (annotationFile != null && annotationFile.exists()) {
            AnnotationFileReader afr = AnnotationFileReader.createAnnotationFileReader((File)annotationFile);
            Hashtable annotations = afr.getAffyAnnotation();
            String[] annot = new String[annotations.size()];
            Enumeration allAnnotations = annotations.keys();
            int i = 0;
            while (allAnnotations.hasMoreElements()) {
                String thisKey = (String)allAnnotations.nextElement();
                IAnnotation thisAnnotation = (IAnnotation)annotations.get(thisKey);
                annot[i] = thisAnnotation.getAttributeObj(this.annotationKeyType).getAttributeAt(0).toString();
                ++i;
            }
            return annot;
        }
        throw new IOException();
    }

    protected DefaultMutableTreeNode createResultNode(AlgorithmData r, int[][] clusters) {
        int nEaseCount;
        EaseAlgorithmData result = (EaseAlgorithmData)r;
        DefaultMutableTreeNode root = this.isClusterAnalysis ? new DefaultMutableTreeNode("EASE Analysis") : new DefaultMutableTreeNode("EASE Survey");
        this.addTableViewer(root, (AlgorithmData)result, clusters);
        this.addExpressionViewers(root, (AlgorithmData)result, clusters);
        this.addGeneralInfo(root, (AlgorithmData)result);
        if (this.isClusterAnalysis) {
            this.addGOTree(root, result, result.getHeaderNames());
        }
        if (this.isNestedEase && (nEaseCount = new Integer(result.getParams().getString("nested-ease-count")).intValue()) > 0) {
            DefaultMutableTreeNode nestedEaseRoot = new DefaultMutableTreeNode("Nested EASE: " + nEaseCount + " Terms");
            String[] nestedEaseTerms = result.getStringArray("selected-nested-ease-terms");
            Object[][] neaseConsolidatedResults = result.getNeaseConsolidatedResults();
            String[] headerNames = result.getStringArray("nease-headers");
            if (headerNames == null) {
                System.out.println("headernames is null");
            }
            EASETableViewer tv = new EASETableViewer(headerNames, neaseConsolidatedResults, nestedEaseRoot, this.experiment, clusters, this.haveAccessionNumbers, true, true);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new LeafInfo("Nested Ease Summary Table", (IViewer)tv));
            nestedEaseRoot.add(node);
            for (int i = 0; i < nEaseCount; ++i) {
                DefaultMutableTreeNode nestedEaseNode = new DefaultMutableTreeNode("nEASE run: " + nestedEaseTerms[i]);
                EaseAlgorithmData thisNeaseResult = result.getNEASEResults(new Integer(i).intValue());
                String[][] thisEaseResultData = thisNeaseResult.getResultMatrix();
                if (thisEaseResultData != null && thisEaseResultData.length != 0) {
                    int[][] theseClusters = thisNeaseResult.getClusterMatrix();
                    this.addTableViewer(nestedEaseNode, (AlgorithmData)thisNeaseResult, theseClusters);
                    this.addExpressionViewers(nestedEaseNode, (AlgorithmData)thisNeaseResult, theseClusters);
                    this.addGeneralInfo(nestedEaseNode, (AlgorithmData)thisNeaseResult);
                    nestedEaseRoot.add(nestedEaseNode);
                    continue;
                }
                nestedEaseRoot.add(this.createEmptyResultNode((AlgorithmData)thisNeaseResult, nestedEaseTerms[i]));
            }
            root.add(nestedEaseRoot);
        }
        return root;
    }

    protected void addGOTree(DefaultMutableTreeNode root, EaseAlgorithmData data, String[] headerNames) {
        GOTreeViewer viewer;
        String category;
        String categories = new String("");
        for (int i = 0; i < this.categoryNames.length; ++i) {
            categories = categories + this.categoryNames[i];
        }
        if (categories.indexOf("GO Biological Process") != -1) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode();
            category = "GO Biological Process";
            viewer = new GOTreeViewer(category, headerNames, data, root);
            node.setUserObject(new LeafInfo("GO Hierarchy -- Biological Process", (IViewer)viewer));
            root.add(node);
        }
        if (categories.indexOf("GO Cellular Component") != -1) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode();
            category = "GO Cellular Component";
            viewer = new GOTreeViewer(category, headerNames, data, root);
            node.setUserObject(new LeafInfo("GO Hierarchy -- Cellular Component", (IViewer)viewer));
            root.add(node);
        }
        if (categories.indexOf("GO Molecular Function") != -1) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode();
            category = "GO Molecular Function";
            viewer = new GOTreeViewer(category, headerNames, data, root);
            node.setUserObject(new LeafInfo("GO Hierarchy -- Molecular Function", (IViewer)viewer));
            root.add(node);
        }
    }

    protected DefaultMutableTreeNode createEmptyResultNode(AlgorithmData result) {
        return this.createEmptyResultNode(result, "EASE");
    }

    protected DefaultMutableTreeNode createEmptyResultNode(AlgorithmData result, String label) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(label);
        root.add(new DefaultMutableTreeNode("No Annotation Hits"));
        this.addGeneralInfo(root, result);
        return root;
    }

    protected void addExpressionViewers(DefaultMutableTreeNode root, AlgorithmData thisresult, int[][] theseclusters) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Viewers");
        EASEExperimentViewer expViewer = new EASEExperimentViewer(this.experiment, theseclusters);
        EASECentroidViewer graphViewer = new EASECentroidViewer(this.experiment, theseclusters);
        String[][] thisResultMatrix = (String[][])thisresult.getObjectMatrix("result-matrix");
        graphViewer.setMeans(thisresult.getMatrix((String)"means").A);
        graphViewer.setVariances(thisresult.getMatrix((String)"variances").A);
        int accindex = 1;
        accindex = this.haveAccessionNumbers ? 1 : 0;
        for (int i = 0; i < theseclusters.length; ++i) {
            DefaultMutableTreeNode clusterNode = new DefaultMutableTreeNode("Term " + String.valueOf(i + 1) + ": " + thisResultMatrix[i][accindex + 2]);
            clusterNode.add(new DefaultMutableTreeNode(new LeafInfo("Expression Image", (IViewer)expViewer, (Object)new Integer(i))));
            clusterNode.add(new DefaultMutableTreeNode(new LeafInfo("Centroid Graph", (IViewer)graphViewer, (Object)new CentroidUserObject(i, 0))));
            clusterNode.add(new DefaultMutableTreeNode(new LeafInfo("Expression Graph", (IViewer)graphViewer, (Object)new CentroidUserObject(i, 1))));
            clusterNode.add(new DefaultMutableTreeNode(thisResultMatrix[i][1]));
            if (this.haveAccessionNumbers) {
                clusterNode.add(new DefaultMutableTreeNode(thisResultMatrix[i][2]));
            }
            clusterNode.add(new DefaultMutableTreeNode("Number of Genes: " + theseclusters[i].length));
            node.add(clusterNode);
        }
        root.add(node);
    }

    protected void addTableViewer(DefaultMutableTreeNode root, AlgorithmData thisresult, int[][] clusters) {
        Object[][] data = thisresult.getObjectMatrix("result-matrix");
        String[] headerNames = thisresult.getStringArray("header-names");
        if (data == null || data.length < 1) {
            return;
        }
        EASETableViewer tv = new EASETableViewer(headerNames, data, root, this.experiment, clusters, this.haveAccessionNumbers, this.isClusterAnalysis, false);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new LeafInfo("Table Viewer", (IViewer)tv));
        root.add(node);
    }

    protected int[] getDataIndices(int[] indices) {
        int[] dataIndices = new int[indices.length];
        for (int i = 0; i < dataIndices.length; ++i) {
            dataIndices[i] = this.experiment.getGeneIndexMappedToData(indices[i]);
        }
        return dataIndices;
    }

    protected void addGeneralInfo(DefaultMutableTreeNode root, AlgorithmData result) {
        DefaultMutableTreeNode newNode;
        DefaultMutableTreeNode generalInfo = new DefaultMutableTreeNode("General Information");
        if (this.isClusterAnalysis && !this.isScripting) {
            newNode = new DefaultMutableTreeNode("Input Cluster Info");
            newNode.add(new DefaultMutableTreeNode("Cluster Serial # :" + String.valueOf(this.cluster.getSerialNumber())));
            newNode.add(new DefaultMutableTreeNode("Cluster Source: " + String.valueOf(this.cluster.getSource())));
            newNode.add(new DefaultMutableTreeNode("Cluster Analysis Node: " + String.valueOf(this.cluster.getAlgorithmName())));
            newNode.add(new DefaultMutableTreeNode("Cluster Cluster Node: " + String.valueOf(this.cluster.getClusterID())));
            newNode.add(new DefaultMutableTreeNode("Cluster Label: " + String.valueOf(this.cluster.getClusterLabel())));
            newNode.add(new DefaultMutableTreeNode("Cluster Size: " + String.valueOf(this.cluster.getSize())));
            generalInfo.add(newNode);
        }
        if (this.isScripting) {
            newNode = new DefaultMutableTreeNode("Input Data: Script Data Input");
        }
        newNode = new DefaultMutableTreeNode("Analysis Options");
        DefaultMutableTreeNode fileNode = new DefaultMutableTreeNode("Selected Index and Files");
        String popFileName = result.getParams().getString("population-file-name");
        if (popFileName == null) {
            fileNode.add(new DefaultMutableTreeNode("Population Selection: Data in Current Viewer"));
        } else {
            fileNode.add(new DefaultMutableTreeNode("Population Selection: File Input (" + popFileName + ")"));
        }
        fileNode.add(new DefaultMutableTreeNode("MeV Index: " + this.annotationKeyType));
        AlgorithmParameters params = this.algorithmData.getParams();
        fileNode.add(new DefaultMutableTreeNode("Conversion File: " + params.getString("converter-file-name", "Not Selected")));
        DefaultMutableTreeNode annFileNode = new DefaultMutableTreeNode("Annotation-to-Theme Files");
        String[] annFiles = this.algorithmData.getStringArray("annotation-file-list");
        if (annFiles != null) {
            for (int i = 0; i < annFiles.length; ++i) {
                annFileNode.add(new DefaultMutableTreeNode("File: " + annFiles[i]));
            }
        }
        fileNode.add(annFileNode);
        newNode.add(fileNode);
        if (this.isClusterAnalysis || !this.algorithmData.getTrimOption().equals("NO_TRIM")) {
            DefaultMutableTreeNode statNode = new DefaultMutableTreeNode("Stat Parameters");
            if (this.isClusterAnalysis) {
                statNode.add(new DefaultMutableTreeNode("Reported Statistic:" + (params.getBoolean("report-ease-score") ? "EASE Score" : "Fisher's Exact")));
                if (params.getBoolean("bonferroni-correction", false)) {
                    statNode.add(new DefaultMutableTreeNode("Mult.-Correct.: Bonferroni"));
                }
                if (params.getBoolean("bonferroni-step-down-correction", false)) {
                    statNode.add(new DefaultMutableTreeNode("Mult.-Correct.: Bonferroni Step Down"));
                }
                if (params.getBoolean("sidak-correction", false)) {
                    statNode.add(new DefaultMutableTreeNode("Mult.-Correct.: Sidak Method"));
                }
                if (params.getBoolean("hochberg-correction", false)) {
                    statNode.add(new DefaultMutableTreeNode("Mult.-Correct.: Hochberg Method"));
                }
            }
            if (!params.getString("trim-option").equals("NO_TRIM")) {
                if (params.getString("trim-option").equals("N_TRIM")) {
                    statNode.add(new DefaultMutableTreeNode("Trim out if hit number < " + this.algorithmData.getTrimValue()));
                } else {
                    statNode.add(new DefaultMutableTreeNode("Trim out if hit percent < " + this.algorithmData.getTrimValue()));
                }
            }
            newNode.add(statNode);
        }
        generalInfo.add(newNode);
        root.add(generalInfo);
    }

    public EaseAlgorithmData getAlgData() {
        return this.algorithmData;
    }

    protected class Listener
    extends DialogListener
    implements AlgorithmListener {
        String eventDescription;

        protected Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String command = actionEvent.getActionCommand();
            if (command.equals("cancel-command")) {
                System.out.println("abort execution");
                EASEGUI.this.stop = true;
                EASEGUI.this.algorithm.abort();
                EASEGUI.this.progress.dispose();
                EASEGUI.this.logger.dispose();
            }
        }

        public void valueChanged(AlgorithmEvent event) {
            if (event.getId() == 3) {
                EASEGUI.this.logger.append(event.getDescription());
            } else {
                this.eventDescription = event.getDescription();
                if (this.eventDescription.equals("SET_VALUE")) {
                    EASEGUI.this.progress.setValue(event.getIntValue());
                    return;
                }
                if (this.eventDescription.equals("SET_UNITS")) {
                    EASEGUI.this.progress.setDescription("Resampling Analysis Iterations");
                    EASEGUI.this.progress.setValue(0);
                    EASEGUI.this.progress.setUnits(event.getIntValue());
                    EASEGUI.this.progress.show();
                    Point p = EASEGUI.this.progress.getLocation();
                    Point loggerP = EASEGUI.this.logger.getLocation();
                    EASEGUI.this.progress.setLocation(p.x, loggerP.y - EASEGUI.this.progress.getHeight());
                    return;
                }
                EASEGUI.this.progress.setVisible(false);
                EASEGUI.this.progress.dispose();
            }
        }
    }
}

