/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class EASEAdvancedFeatures
extends AlgorithmDialog {
    private EventListener listener;
    private String defaultFileLocation;
    private Frame parent;
    protected String sep;
    private int result = 2;
    private ClusterRepository repository;
    protected Font font;
    private int index = 0;
    private boolean isClusterAnalysis = false;
    private boolean useLoadedAnnotationFile = false;
    protected ConfigPanelExtension configPanelExtension;
    protected PopSelectionPanel popPanel;
    protected EaseParameterPanel paramPanel;

    public EASEAdvancedFeatures(Frame parent, String defaultFileLocation, boolean isClusterAnalysis, ClusterRepository repository, String[] annotationLabels) {
        super(parent, "EASEAdvancedParamters", true);
        this.parent = parent;
        this.defaultFileLocation = defaultFileLocation;
        this.isClusterAnalysis = isClusterAnalysis;
        this.repository = repository;
        this.font = new Font("Dialog", 1, 12);
        this.addWindowListener(this.listener);
        this.listener = new EventListener();
        this.configPanelExtension = new ConfigPanelExtension();
        this.popPanel = new PopSelectionPanel();
        if (isClusterAnalysis) {
            this.popPanel.setEnableControls(true);
        } else {
            this.popPanel.setEnableControls(false);
        }
        this.paramPanel = new EaseParameterPanel(annotationLabels);
        JPanel parameters = new JPanel(new GridBagLayout());
        parameters.setBackground(Color.white);
        parameters.add((Component)this.configPanelExtension, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.popPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.paramPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(parameters);
        this.setActionListeners(this.listener);
        if (repository == null || repository.isEmpty()) {
            PopSelectionPanel panel = this.popPanel;
            panel.removeAll();
            panel.validate();
            panel.setOpaque(false);
            panel.add((Component)new JLabel("Empty Cluster Repository"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(15, 0, 10, 0), 0, 0));
        }
        this.pack();
    }

    public String getNewSupportFileLocation() {
        return this.configPanelExtension.supportFileLocationField.getText();
    }

    public boolean isPopFileModeSelected() {
        return this.popPanel.fileButton.isSelected();
    }

    public String getPopFieldText() {
        return this.popPanel.popField.getText();
    }

    public String getConverterFileName() {
        return this.paramPanel.converterFileField.getText();
    }

    public boolean isAnnBoxSelected() {
        return this.paramPanel.useAnnBox.isSelected();
    }

    public String getAnnBoxText() {
        return this.paramPanel.useAnnBox.getText();
    }

    public String getAnnotationKeyType() {
        return (String)this.paramPanel.fieldNamesBox.getSelectedItem();
    }

    public String[] getAnnToGOFileList() {
        String[] fileNames = new String[((DefaultListModel)this.paramPanel.annFileList.getModel()).size()];
        for (int i = 0; i < fileNames.length; ++i) {
            fileNames[i] = ((File)((DefaultListModel)this.paramPanel.annFileList.getModel()).elementAt(i)).getPath();
        }
        return fileNames;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.setVisible(true);
        return this.result;
    }

    public void resetControls() {
        this.configPanelExtension.supportFileLocationField.setText("Please select a directory");
        this.popPanel.fileButton.setSelected(true);
        this.popPanel.popField.setText(" ");
        this.popPanel.popField.setBackground(Color.white);
        this.popPanel.popField.setEnabled(true);
        this.popPanel.browseButton.setEnabled(true);
        this.popPanel.fileLabel.setEnabled(true);
        this.paramPanel.fieldNamesBox.setSelectedIndex(this.index);
        this.paramPanel.useAnnBox.setSelected(false);
        this.paramPanel.browserButton.setEnabled(false);
        this.paramPanel.converterFileField.setText(" ");
        this.paramPanel.converterFileField.setEnabled(false);
        this.paramPanel.converterFileField.setBackground(Color.lightGray);
        this.paramPanel.fileLabel.setEnabled(false);
        ((DefaultListModel)this.paramPanel.annFileList.getModel()).removeAllElements();
        this.paramPanel.removeButton.setEnabled(false);
        this.paramPanel.annFileList.validate();
    }

    public static void main(String[] args) {
        String[] labels = new String[]{"TC#", "GB#", "Role"};
        EASEAdvancedFeatures advancedFeat = new EASEAdvancedFeatures(new JFrame(), "/ease", false, new ClusterRepository(1), labels);
        advancedFeat.showModal();
    }

    protected class EventListener
    extends DialogListener
    implements ItemListener {
        protected EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("select-file-base-command")) {
                EASEAdvancedFeatures.this.configPanelExtension.browseForSupportFiles();
            } else if (command.equals("use-converter-command")) {
                if (EASEAdvancedFeatures.this.paramPanel.useAnnBox.isSelected()) {
                    EASEAdvancedFeatures.this.paramPanel.browserButton.setEnabled(true);
                    EASEAdvancedFeatures.this.paramPanel.converterFileField.setEnabled(true);
                    EASEAdvancedFeatures.this.paramPanel.converterFileField.setBackground(Color.white);
                    EASEAdvancedFeatures.this.paramPanel.fileLabel.setEnabled(true);
                    EASEAdvancedFeatures.this.paramPanel.converterFileField.setText("Please select a conversion file");
                } else {
                    EASEAdvancedFeatures.this.paramPanel.browserButton.setEnabled(false);
                    EASEAdvancedFeatures.this.paramPanel.converterFileField.setEnabled(false);
                    EASEAdvancedFeatures.this.paramPanel.converterFileField.setBackground(Color.lightGray);
                    EASEAdvancedFeatures.this.paramPanel.fileLabel.setEnabled(false);
                }
            } else {
                if (command.equals("converter-file-browser-command")) {
                    File convertFile = new File(EASEAdvancedFeatures.this.getNewSupportFileLocation() + EASEAdvancedFeatures.this.sep + "Data" + EASEAdvancedFeatures.this.sep + "Convert");
                    JFileChooser chooser = new JFileChooser(convertFile);
                    chooser.setDialogTitle("Annotation Converter Selection");
                    chooser.setMultiSelectionEnabled(false);
                    if (chooser.showOpenDialog(EASEAdvancedFeatures.this.parent) == 0) {
                        EASEAdvancedFeatures.this.paramPanel.converterFileField.setText(chooser.getSelectedFile().getPath());
                    }
                    return;
                }
                if (command.equals("ann-file-browser-command")) {
                    File classFile = new File(EASEAdvancedFeatures.this.getNewSupportFileLocation() + EASEAdvancedFeatures.this.sep + "Data" + EASEAdvancedFeatures.this.sep + "Class" + EASEAdvancedFeatures.this.sep);
                    if (!classFile.canRead()) {
                        classFile = new File("." + EASEAdvancedFeatures.this.sep + "data" + EASEAdvancedFeatures.this.sep + "ease");
                    }
                    JFileChooser chooser = new JFileChooser(classFile);
                    chooser.setDialogTitle("Annotation --> GO Term, File(s) Selection");
                    chooser.setMultiSelectionEnabled(true);
                    if (chooser.showOpenDialog(EASEAdvancedFeatures.this.parent) == 0) {
                        EASEAdvancedFeatures.this.paramPanel.updateAnnFileList(chooser.getSelectedFiles());
                        EASEAdvancedFeatures.this.paramPanel.removeButton.setEnabled(true);
                    }
                } else if (command.equals("remove-ann-file-command")) {
                    EASEAdvancedFeatures.this.paramPanel.removeSelectedFiles();
                } else if (command.equals("ok-command")) {
                    String fileName;
                    if (EASEAdvancedFeatures.this.getNewSupportFileLocation() == null || EASEAdvancedFeatures.this.getNewSupportFileLocation().equals("") || EASEAdvancedFeatures.this.getNewSupportFileLocation().equals(" ") || EASEAdvancedFeatures.this.getNewSupportFileLocation().equals("Please select a directory")) {
                        JOptionPane.showMessageDialog(EASEAdvancedFeatures.this.parent, "Please enter a directory or use the file browser to select a directory for support files.", "EASE Initialization: Missing Parameter", 2);
                        return;
                    }
                    if (EASEAdvancedFeatures.this.isClusterAnalysis && EASEAdvancedFeatures.this.isPopFileModeSelected() && (EASEAdvancedFeatures.this.getPopFieldText() == null || EASEAdvancedFeatures.this.getPopFieldText().equals("") || EASEAdvancedFeatures.this.getPopFieldText().equals(" "))) {
                        JOptionPane.showMessageDialog(EASEAdvancedFeatures.this.parent, "Please enter a background population or use the file browser to select a file of one.", "EASE Initialization: Missing Parameter", 2);
                        return;
                    }
                    if (EASEAdvancedFeatures.this.getAnnToGOFileList().length == 0) {
                        JOptionPane.showMessageDialog(EASEAdvancedFeatures.this.parent, "You have not selected any gene annotation/gene ontology linking files. \nPlease enter files or use the browser to select files.", "EASE Initialization: Missing Parameter", 2);
                        return;
                    }
                    if (EASEAdvancedFeatures.this.isAnnBoxSelected() && ((fileName = EASEAdvancedFeatures.this.getConverterFileName()) == null || fileName.equals("") || fileName.equals(" "))) {
                        JOptionPane.showMessageDialog(EASEAdvancedFeatures.this.parent, "You have selected to use an annotation conversion file but have not made a file selection.\nPlease enter a file name or browse to select a file.", "EASE Initialization: Missing Parameter", 2);
                        return;
                    }
                    EASEAdvancedFeatures.this.result = 0;
                    EASEAdvancedFeatures.this.dispose();
                } else if (command.equals("cancel-command")) {
                    EASEAdvancedFeatures.this.result = 2;
                    EASEAdvancedFeatures.this.dispose();
                } else {
                    if (command.equals("reset-command")) {
                        EASEAdvancedFeatures.this.resetControls();
                        EASEAdvancedFeatures.this.result = 2;
                        return;
                    }
                    if (command.equals("info-command")) {
                        HelpWindow.launchBrowser(EASEAdvancedFeatures.this, "EASE AdvancedParams Dialog");
                    }
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
        }
    }

    protected class PopSelectionPanel
    extends ParameterPanel {
        private static final long serialVersionUID = 4355369410348482259L;
        JRadioButton fileButton;
        JRadioButton dataButton;
        JTextField popField;
        JButton browseButton;
        JLabel fileLabel;

        public PopSelectionPanel() {
            super("Population Selection");
            this.setLayout(new GridBagLayout());
            ButtonGroup bg = new ButtonGroup();
            this.fileButton = new JRadioButton("Select Background Population from File");
            this.fileButton.setBackground(Color.white);
            this.fileButton.setFocusPainted(false);
            this.fileButton.setSelected(true);
            bg.add(this.fileButton);
            this.fileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    EASEAdvancedFeatures.this.paramPanel.fieldNamesBox.setEnabled(true);
                    EASEAdvancedFeatures.this.paramPanel.fieldNamesBox.setSelectedItem("PROBE_ID");
                    EASEAdvancedFeatures.this.paramPanel.useAnnBox.setEnabled(true);
                    PopSelectionPanel.this.browseButton.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                    PopSelectionPanel.this.popField.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                    PopSelectionPanel.this.popField.setBackground(Color.white);
                    PopSelectionPanel.this.popField.setText("Please select a population file");
                    PopSelectionPanel.this.fileLabel.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                }
            });
            this.dataButton = new JRadioButton("Select Background Population from Current Viewer");
            this.dataButton.setBackground(Color.white);
            this.dataButton.setFocusPainted(false);
            bg.add(this.dataButton);
            this.dataButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PopSelectionPanel.this.browseButton.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                    PopSelectionPanel.this.popField.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                    PopSelectionPanel.this.popField.setBackground(Color.lightGray);
                    PopSelectionPanel.this.fileLabel.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                }
            });
            this.browseButton = new JButton("File Browser");
            this.browseButton.setFocusPainted(false);
            this.browseButton.setEnabled(false);
            this.browseButton.setPreferredSize(new Dimension(150, 25));
            this.browseButton.setSize(150, 25);
            this.browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JFileChooser chooser = new JFileChooser(new File(EASEAdvancedFeatures.this.getNewSupportFileLocation(), "Lists"));
                    chooser.setDialogTitle("Population File Selection");
                    chooser.setMultiSelectionEnabled(false);
                    if (chooser.showOpenDialog(EASEAdvancedFeatures.this.parent) == 0) {
                        PopSelectionPanel.this.popField.setText(chooser.getSelectedFile().getPath());
                    }
                }
            });
            this.fileLabel = new JLabel("File: ");
            this.popField = new JTextField(25);
            this.fileButton.setSelected(!EASEAdvancedFeatures.this.useLoadedAnnotationFile);
            this.popField.setEnabled(this.fileButton.isSelected());
            this.fileLabel.setEnabled(this.fileButton.isSelected());
            this.popField.setText("Please select a population file");
            if (this.fileButton.isSelected()) {
                this.popField.setBackground(Color.white);
            } else {
                this.popField.setBackground(Color.lightGray);
            }
            this.add((Component)this.fileButton, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 1, new Insets(10, 30, 0, 0), 0, 0));
            this.add((Component)this.fileLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 30, 0, 0), 0, 0));
            this.add((Component)this.popField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 0, 0), 0, 0));
            this.add((Component)this.browseButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 25, 0, 20), 0, 0));
            this.add((Component)this.dataButton, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 1, new Insets(15, 30, 20, 0), 0, 0));
        }

        protected void setEnableControls(boolean enable) {
            this.fileButton.setEnabled(enable);
            this.dataButton.setEnabled(enable);
            this.popField.setEnabled(enable);
            this.browseButton.setEnabled(enable);
            this.fileLabel.setEnabled(enable);
            this.setOpaque(enable);
        }
    }

    protected class ConfigPanelExtension
    extends ParameterPanel {
        private static final long serialVersionUID = 1L;
        JLabel statusLabel;
        JTextField supportFileLocationField;
        JButton browseSupportFileButton;

        public ConfigPanelExtension() {
            super("Directory Selection for Support Files");
            this.setLayout(new GridBagLayout());
            this.statusLabel = new JLabel("Choose a custom EASE filesystem");
            this.supportFileLocationField = new JTextField(25);
            this.supportFileLocationField.setEditable(true);
            this.supportFileLocationField.setText("Please select a directory");
            this.browseSupportFileButton = new JButton("Browse");
            this.browseSupportFileButton.setActionCommand("select-file-base-command");
            this.browseSupportFileButton.addActionListener(EASEAdvancedFeatures.this.listener);
            this.add((Component)this.statusLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 25, 0, 20), 0, 0));
            this.add((Component)this.supportFileLocationField, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 1, new Insets(10, 30, 5, 0), 0, 0));
            this.add((Component)this.browseSupportFileButton, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 25, 5, 20), 0, 0));
        }

        public void browseForSupportFiles() {
            File file;
            String startDir = TMEV.getSettingForOption((String)"last-ease-file-location");
            if (startDir == null) {
                startDir = this.supportFileLocationField.getText();
            }
            if (!(file = new File(startDir)).exists()) {
                file = TMEV.getFile((String)"data/ease");
                if (file == null) {
                    file = new File(System.getProperty("user.dir"));
                }
                TMEV.storeProperty((String)"last-ease-file-location", (String)file.toString());
            }
            JFileChooser chooser = new JFileChooser(file);
            chooser.setFileSelectionMode(1);
            if (chooser.showOpenDialog(EASEAdvancedFeatures.this) == 0) {
                this.supportFileLocationField.setText(chooser.getSelectedFile().getAbsolutePath());
                TMEV.storeProperty((String)"last-ease-file-location", (String)this.supportFileLocationField.getText());
            }
        }
    }

    protected class EaseParameterPanel
    extends JPanel {
        private static final long serialVersionUID = 3446234672105256730L;
        protected JTextField converterFileField;
        protected JList fileList;
        protected JButton browserButton;
        protected JComboBox fieldNamesBox;
        protected JList annFileList;
        protected JButton removeButton;
        protected JCheckBox useAnnBox;
        protected JLabel fileLabel;
        protected JRadioButton useLoadedAnn;

        public EaseParameterPanel(String[] fieldNames) {
            JPanel convPanel = new JPanel(new GridBagLayout());
            convPanel.setBackground(Color.white);
            convPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Annotation Conversion File", 0, 0, EASEAdvancedFeatures.this.font, Color.black));
            this.useAnnBox = new JCheckBox("Use Annotation Converter", false);
            this.useAnnBox.setActionCommand("use-converter-command");
            this.useAnnBox.addActionListener(EASEAdvancedFeatures.this.listener);
            this.useAnnBox.setBackground(Color.white);
            this.useAnnBox.setFocusPainted(false);
            this.useAnnBox.setEnabled(true);
            this.converterFileField = new JTextField(30);
            this.converterFileField.setBorder(BorderFactory.createBevelBorder(1, Color.lightGray, Color.gray));
            this.converterFileField.setEnabled(false);
            this.converterFileField.setBackground(Color.lightGray);
            this.browserButton = new JButton("File Browser");
            this.browserButton.setActionCommand("converter-file-browser-command");
            this.browserButton.setFocusPainted(false);
            this.browserButton.setPreferredSize(new Dimension(150, 25));
            this.browserButton.setSize(150, 25);
            this.browserButton.addActionListener(EASEAdvancedFeatures.this.listener);
            this.browserButton.setEnabled(false);
            this.fileLabel = new JLabel("File :");
            this.fileLabel.setEnabled(false);
            convPanel.add((Component)this.useAnnBox, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 1, new Insets(0, 15, 15, 0), 0, 0));
            convPanel.add((Component)this.fileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 15, 0), 0, 0));
            convPanel.add((Component)this.browserButton, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 3, new Insets(0, 15, 0, 0), 0, 0));
            convPanel.add((Component)this.converterFileField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 15, 0), 0, 0));
            JPanel annPanel = new JPanel(new GridBagLayout());
            annPanel.setBackground(Color.white);
            annPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Gene Annotation / Gene Ontology Linking Files", 0, 0, EASEAdvancedFeatures.this.font, Color.black));
            this.annFileList = new JList(new DefaultListModel());
            this.annFileList.setCellRenderer(new ListRenderer());
            this.annFileList.setBorder(BorderFactory.createBevelBorder(1));
            this.annFileList.setSelectionMode(0);
            JScrollPane annPane = new JScrollPane(this.annFileList);
            JButton annButton = new JButton("Add Files");
            annButton.setActionCommand("ann-file-browser-command");
            annButton.addActionListener(EASEAdvancedFeatures.this.listener);
            annButton.setFocusPainted(false);
            annButton.setPreferredSize(new Dimension(150, 25));
            annButton.setSize(150, 25);
            this.removeButton = new JButton("Remove Selected");
            this.removeButton.setActionCommand("remove-ann-file-command");
            this.removeButton.addActionListener(EASEAdvancedFeatures.this.listener);
            this.removeButton.setFocusPainted(false);
            this.removeButton.setPreferredSize(new Dimension(150, 25));
            this.removeButton.setSize(150, 25);
            this.removeButton.setEnabled(false);
            JPanel fillPanel = new JPanel();
            fillPanel.setBackground(Color.white);
            annPanel.add((Component)fillPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            annPanel.add((Component)annButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 10, 5), 0, 0));
            annPanel.add((Component)this.removeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 5, 10, 0), 0, 0));
            annPanel.add((Component)new JLabel("Files: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            annPanel.add((Component)annPane, new GridBagConstraints(1, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            EASEAdvancedFeatures.this.sep = System.getProperty("file.separator");
            File file = new File(EASEAdvancedFeatures.this.defaultFileLocation);
            String tempPath = file.getPath();
            Vector<String> fileVector = new Vector<String>();
            this.fileList = new JList(fileVector);
            if (file.exists()) {
                String[] listFileNames = file.list();
                for (int i = 0; i < listFileNames.length; ++i) {
                    File tempFile = new File(tempPath + EASEAdvancedFeatures.this.sep + listFileNames[i]);
                    if (!tempFile.isFile()) continue;
                    fileVector.add(listFileNames[i]);
                }
                if (fileVector.size() > 0) {
                    this.converterFileField.setText(tempPath + EASEAdvancedFeatures.this.sep + (String)fileVector.elementAt(0));
                }
            }
            this.converterFileField.setText("");
            this.fieldNamesBox = new JComboBox<String>(fieldNames);
            this.fieldNamesBox.setEditable(false);
            this.fieldNamesBox.setEnabled(true);
            this.fieldNamesBox.setSelectedItem("PROBE_ID");
            EASEAdvancedFeatures.this.index = this.fieldNamesBox.getSelectedIndex();
            this.setLayout(new GridBagLayout());
            JPanel annotKeyPanel = new JPanel(new GridBagLayout());
            annotKeyPanel.setBackground(Color.white);
            annotKeyPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "MeV Annotation Key  (\"Unique ID\")", 0, 0, EASEAdvancedFeatures.this.font, Color.black));
            annotKeyPanel.add((Component)new JLabel("Annotation Key:  "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            annotKeyPanel.add((Component)this.fieldNamesBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)annotKeyPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)convPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)annPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        protected void updateFileDirectoryField() {
            File file = new File((String)this.fileList.getSelectedValue());
            if (file == null) {
                return;
            }
            String tempPath = file.getParent();
            int fileIndex = this.fileList.getSelectedIndex();
            String fileName = (String)this.fileList.getModel().getElementAt(this.fileList.getSelectedIndex());
            this.converterFileField.setText(tempPath + EASEAdvancedFeatures.this.sep + fileName);
        }

        protected void updateAnnFileList(File[] files) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (((DefaultListModel)this.annFileList.getModel()).contains(file)) continue;
                ((DefaultListModel)this.annFileList.getModel()).addElement(file);
            }
            this.annFileList.validate();
        }

        public void removeSelectedFiles() {
            int[] indices = this.annFileList.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                ((DefaultListModel)this.annFileList.getModel()).removeElementAt(indices[i]);
            }
            if (this.annFileList.getModel().getSize() < 1) {
                this.removeButton.setEnabled(false);
            }
            this.annFileList.validate();
        }

        protected class ListRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = 663620540385920562L;

            protected ListRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                File file = (File)value;
                this.setText(file.getName());
                return this;
            }
        }

        protected class EaseListListener
        implements ListSelectionListener {
            protected EaseListListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EaseParameterPanel.this.updateFileDirectoryField();
            }
        }
    }
}

