/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.tigr.util.BrowserLauncher;
import org.tigr.util.awt.GBA;

public class HelpWindowDialog
extends JDialog
implements Printable,
HyperlinkListener {
    private String text;
    private JEditorPane ed;

    public HelpWindowDialog(Frame parent) {
        this(parent, "");
    }

    public HelpWindowDialog(Frame parent, String labelText) {
        super(parent, "Hint to File Format", false);
        EventListener listener = new EventListener();
        this.text = labelText;
        GBA gba = new GBA();
        Font font = new Font("serif", 0, 12);
        this.ed = new JEditorPane("text/html", labelText);
        this.ed.setEditable(false);
        this.ed.setMargin(new Insets(10, 10, 10, 10));
        this.ed.setBackground(new Color(234, 233, 191));
        this.ed.setCaretPosition(0);
        this.ed.addHyperlinkListener(this);
        JScrollPane scrollPane = new JScrollPane(this.ed, 20, 31);
        JPanel referencesPanel = new JPanel(new GridBagLayout());
        referencesPanel.setBackground(new Color(234, 233, 191));
        gba.add((Container)referencesPanel, (Component)scrollPane, 0, 0, 1, 1, 1, 1, 1, 10);
        JButton printButton = new JButton("Print");
        printButton.setBorder(BorderFactory.createBevelBorder(0));
        printButton.setFocusPainted(false);
        printButton.setActionCommand("print-command");
        printButton.addActionListener(listener);
        JButton closeButton = new JButton("  Close  ");
        closeButton.setBorder(BorderFactory.createBevelBorder(0));
        closeButton.setFocusPainted(false);
        closeButton.setActionCommand("close-command");
        closeButton.addActionListener(listener);
        closeButton.setSize(120, 30);
        closeButton.setPreferredSize(new Dimension(120, 30));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        gba.add((Container)buttonPanel, (Component)closeButton, 0, 0, 1, 1, 1, 1, 0, 10);
        this.getContentPane().setLayout(new GridBagLayout());
        gba.add(this.getContentPane(), (Component)referencesPanel, 0, 0, 1, 2, 1, 1, 1, 10);
        gba.add(this.getContentPane(), (Component)buttonPanel, 0, 2, 1, 1, 0, 0, 0, 10);
        this.setSize(550, 650);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
    }

    public static String createText(String st) {
        String html = "";
        if (st == "Mev") {
            html = html + "<html><body>";
            html = html + "<p><font size = +1><b>MEV(Multiple Experiment Viewer Format)</b></font><br><br>";
            html = html + "<a href=\"http://www.tm4.org/mevfile_external.pdf\"";
            html = html + ">";
            html = html + "MEV(Multiple Experiment Viewer Format)";
            html = html + "</a>";
            html = html + "is a tab delimited text file format which allows a header";
            html = html + "for identification of columns and comments are preceded by the pound (#) sign.";
            html = html + "The first nine columns are a unique identifier, slide row, slide column,";
            html = html + "meta row, meta column, sub row, sub column, intensity 1, intensity 2.  The unique";
            html = html + "identifier is used to match up corresponding annotation which is supplied from";
            html = html + "annotation files which contain spot annotation for each element on the slide.";
            html = html + "</body></html>";
        }
        if (st == "Tav") {
            html = html + "<html><body>";
            html = html + "<p><font size = +1><b>Tav(TIGR Array Viewer)</b></font><br><br>";
            html = html + "<a href=\"http://www.tm4.org/tav_files.pdf\"";
            html = html + ">";
            html = html + "Tav(TIGR Array Viewer)";
            html = html + "</a>";
            html = html + "is similar to the mev format but differs in that it does not permit";
            html = html + "a header row or comment rows and there is no unique ID column.  Each tav file contains";
            html = html + "annotation following the columns for intensity and other spot specific information.";
            html = html + "</body></html>";
        }
        if (st == "GEOaffy") {
            html = html + "<html><body>";
            html = html + "<p><font size = +1><b>GEO SOFT Affymetrix File Format</b></font><br><br>";
            html = html + "<a href=\"http://www.ncbi.nlm.nih.gov/projects/geo/info/soft2.html#SOFTsubmissionexamples\"";
            html = html + ">";
            html = html + "GEO  Simple Omnibus Format in Text (SOFT) file format";
            html = html + "</a>";
            html = html + "is a kind of flexible tab delimited file format for Affymetrix data.";
            html = html + "Users can check the file format in details from web link.";
            html = html + "</body></html>";
        }
        if (st == "GEOtwo") {
            html = html + "<html><body>";
            html = html + "<p><font size = +1><b>GEO SOFT Two Channel File Format</b></font><br><br>";
            html = html + "<a href=\"http://www.ncbi.nlm.nih.gov/projects/geo/info/soft2.html#SOFTsubmissionexamples\"";
            html = html + ">";
            html = html + "GEO  Simple Omnibus Format in Text (SOFT) file format";
            html = html + "</a>";
            html = html + "is a kind of flexible tab delimited file format for Affymetrix data.";
            html = html + "Users can check the file format in details from web link.";
            html = html + "</body></html>";
        }
        if (st == "GenePix") {
            html = html + "<html><body>";
            html = html + "<p><font size = +1><b>GenePix File Format</b></font><br><br>";
            html = html + "<a href=\"http://www.moleculardevices.com/pages/software/gn_genepix_file_formats.html\"";
            html = html + ">";
            html = html + "GenePix File Format";
            html = html + "</a>";
            html = html + " is a standard file format. Please get detail information from web link.";
            html = html + "</body></html>";
        }
        if (st == "Agilent") {
            html = html + "<html><body>";
            html = html + "<p><font size = +1><b>Agilent File Format</b></font><br><br>";
            html = html + "<a href=\"\"";
            html = html + ">";
            html = html + "Agilent File Format";
            html = html + "</a>";
            html = html + " is a standard file format. Please get detail information from web link.";
            html = html + "</body></html>";
        }
        if (st == "MAGE") {
            html = html + "<html><body>";
            html = html + "<p><font size = +1><b>MAGE-TAB File Format</b></font><br><br>";
            html = html + "<a href=\"\"";
            html = html + ">";
            html = html + "MAGE TAB File Format";
            html = html + "</a>";
            html = html + " is a standard file format. For more details, please refer the MeV manual.";
            html = html + "</body></html>";
        }
        return html;
    }

    public static void main(String[] args) {
    }

    @Override
    public int print(Graphics g, PageFormat format, int page) throws PrinterException {
        if (page > 2) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.clip(new Rectangle2D.Double(0.0, 0.0, format.getImageableWidth(), format.getImageableHeight()));
        g2d.translate(format.getImageableX(), (double)(-page) * format.getImageableHeight());
        g2d.scale(1.0, 1.0);
        g2d.drawString("Test String", 0, 20);
        this.ed.paint(g);
        return 0;
    }

    private Book makeBook(PageFormat page, int numPages) {
        Book book = new Book();
        book.append(this, page, numPages);
        return book;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        HyperlinkEvent.EventType type = e.getEventType();
        URL url = e.getURL();
        if (type == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                BrowserLauncher.openURL((String)url.toString());
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    private class EventListener
    implements ActionListener,
    KeyListener {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("close-command")) {
                HelpWindowDialog.this.dispose();
            } else if (command.equals("print-command")) {
                PrinterJob pj = PrinterJob.getPrinterJob();
                pj.setPrintable(HelpWindowDialog.this, pj.defaultPage());
                int numPages = HelpWindowDialog.this.ed.getHeight();
                numPages = (int)((double)numPages / pj.defaultPage().getImageableY());
                pj.setPageable(HelpWindowDialog.this.makeBook(pj.defaultPage(), numPages));
                if (pj.printDialog()) {
                    try {
                        pj.print();
                    }
                    catch (PrinterException pe) {
                        System.out.println(pe);
                    }
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                HelpWindowDialog.this.dispose();
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }
    }
}

