/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.LineMetrics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.IWizardParameterPanel;

public class TwoWaySelectionPanel
extends JPanel
implements IWizardParameterPanel {
    private int numSamples;
    private String factorAName;
    private String factorBName;
    private String[] factorANames;
    private String[] factorBNames;
    private String[] sampleFieldNames;
    private String[][] sampleAnn;
    private DesignGridPanel gridPanel;
    private Vector[][] sampleIndexAssignments;
    private SampleListPanel sampleListPanel;
    private GlassPanel glassPanel;
    private Listener listener;
    private int selectedSampleIndex;
    private JPanel selectorPanel;
    private JScrollPane pane;
    private StupidOverlayHackPanel mainPanel;
    private AlgorithmData algData;

    public TwoWaySelectionPanel(AlgorithmData data, String[] sampleFieldNames, String[][] sampleAnn) {
        super(new GridBagLayout());
        this.algData = data;
        this.numSamples = sampleAnn[0].length;
        this.sampleFieldNames = sampleFieldNames;
        this.sampleAnn = sampleAnn;
        this.selectedSampleIndex = -1;
    }

    public TwoWaySelectionPanel(AlgorithmData data, String factorAName, String factorBName, String[] factorANames, String[] factorBNames, String[] sampleFieldNames, String[][] sampleAnn) {
        super(new GridBagLayout());
        this.algData = data;
        this.listener = new Listener();
        this.numSamples = sampleAnn[0].length;
        this.factorAName = factorAName;
        this.factorBName = factorBName;
        this.factorANames = factorANames;
        this.factorBNames = factorBNames;
        this.sampleFieldNames = sampleFieldNames;
        this.sampleAnn = sampleAnn;
        this.selectedSampleIndex = -1;
        this.selectorPanel = new JPanel(new GridBagLayout());
        this.mainPanel = new StupidOverlayHackPanel();
        this.sampleIndexAssignments = new Vector[factorANames.length][factorBNames.length];
        for (int i = 0; i < this.sampleIndexAssignments.length; ++i) {
            for (int j = 0; j < this.sampleIndexAssignments[i].length; ++j) {
                this.sampleIndexAssignments[i][j] = new Vector();
            }
        }
        this.gridPanel = new DesignGridPanel();
        this.sampleListPanel = new SampleListPanel();
        this.pane = new JScrollPane();
        this.pane.setViewportView(this.sampleListPanel);
        this.pane.setColumnHeaderView(this.sampleListPanel.headerPanel);
        this.pane.setColumnHeaderView(this.sampleListPanel.getHeaderPanel());
        this.pane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Sample List and Assignments"));
        this.selectorPanel.add((Component)this.gridPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.selectorPanel.add((Component)this.pane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.glassPanel = new GlassPanel();
        this.mainPanel.add(this.glassPanel);
        this.mainPanel.add(this.selectorPanel);
        this.glassPanel.setVisible(true);
        this.add((Component)this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.constructButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 2, 5), 0, 0));
    }

    public void initialize(String factorAName, String factorBName, String[] factorANames, String[] factorBNames) {
        this.listener = new Listener();
        this.removeAll();
        this.factorAName = factorAName;
        this.factorBName = factorBName;
        this.factorANames = factorANames;
        this.factorBNames = factorBNames;
        this.selectorPanel = new JPanel(new GridBagLayout());
        this.mainPanel = new StupidOverlayHackPanel();
        this.sampleIndexAssignments = new Vector[factorANames.length][factorBNames.length];
        for (int i = 0; i < this.sampleIndexAssignments.length; ++i) {
            for (int j = 0; j < this.sampleIndexAssignments[i].length; ++j) {
                this.sampleIndexAssignments[i][j] = new Vector();
            }
        }
        this.gridPanel = new DesignGridPanel();
        this.sampleListPanel = new SampleListPanel();
        this.pane = new JScrollPane();
        this.pane.setViewportView(this.sampleListPanel);
        this.pane.setColumnHeaderView(this.sampleListPanel.headerPanel);
        this.pane.setColumnHeaderView(this.sampleListPanel.getHeaderPanel());
        this.pane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Sample List and Assignments"));
        this.selectorPanel.add((Component)this.gridPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.selectorPanel.add((Component)this.pane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.glassPanel = new GlassPanel();
        this.mainPanel.add(this.glassPanel);
        this.mainPanel.add(this.selectorPanel);
        this.glassPanel.setVisible(true);
        this.add((Component)this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.constructButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 2, 5), 0, 0));
    }

    public JPanel constructButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Load 'n Save Assignments"));
        Dimension buttonDim = new Dimension(200, 30);
        JButton loadButton = new JButton("Load Design Assignments");
        loadButton.setToolTipText("<html><center>Loads saved design file.<br>Requires consistent design grid dimensions.</center><html>");
        loadButton.setBorder(BorderFactory.createBevelBorder(0));
        loadButton.setFocusPainted(false);
        loadButton.setActionCommand("load-design-command");
        loadButton.setPreferredSize(buttonDim);
        loadButton.setSize(buttonDim);
        loadButton.addActionListener(this.listener);
        JButton saveButton = new JButton("Save Design Assignments");
        saveButton.setToolTipText("<html><center>Saves design assignments to file.<html>");
        saveButton.setBorder(BorderFactory.createBevelBorder(0));
        saveButton.setFocusPainted(false);
        saveButton.setActionCommand("save-design-command");
        saveButton.setPreferredSize(buttonDim);
        saveButton.setSize(buttonDim);
        saveButton.addActionListener(this.listener);
        buttonPanel.add((Component)loadButton, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(0, 20, 5, 10), 1, 1));
        buttonPanel.add((Component)saveButton, new GridBagConstraints(1, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(0, 10, 5, 20), 1, 1));
        return buttonPanel;
    }

    public void updateSize() {
        int w = this.gridPanel.getWidth();
        int gridH = this.gridPanel.getHeight();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int maxHeight = (int)((float)screenSize.height * 0.65f);
        int maxWidth = (int)((float)screenSize.width * 0.6f);
        int minHeight = (int)((float)screenSize.height * 0.5f);
        int minWidth = (int)((float)screenSize.width * 0.6f);
        w = Math.max(Math.min(Math.max(w, this.sampleListPanel.getPreferredSize().width), maxWidth), minWidth);
        int h = Math.max(Math.min(gridH + this.sampleListPanel.getPreferredSize().height + this.sampleListPanel.getHeaderPanel().getHeight(), maxHeight), minHeight);
        this.mainPanel.setSize(w, h);
        this.mainPanel.setPreferredSize(new Dimension(w, h));
        this.pane.validate();
    }

    private void removeAssignment(int sampleIndex) {
        boolean removed = false;
        Integer sampleInt = new Integer(sampleIndex);
        for (int i = 0; i < this.sampleIndexAssignments.length; ++i) {
            for (int j = 0; j < this.sampleIndexAssignments[i].length && !this.sampleIndexAssignments[i][j].remove(sampleInt); ++j) {
            }
        }
        this.gridPanel.repaint();
    }

    public Vector[][] getAssignments() {
        return this.sampleIndexAssignments;
    }

    private void saveAssignments() {
        JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
        if (fileChooser.showSaveDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                int i;
                PrintWriter pw = new PrintWriter(new FileWriter(file));
                Date currDate = new Date(System.currentTimeMillis());
                String dateString = currDate.toString();
                String userName = System.getProperty("user.name");
                pw.println("# Two Factor Assignment File");
                pw.println("# User: " + userName + " Save Date: " + dateString);
                pw.println("#");
                pw.println("Factor A Label:\t" + this.factorAName);
                pw.print("Factor A Levels:");
                for (i = 0; i < this.factorANames.length; ++i) {
                    pw.print("\t" + this.factorANames[i]);
                }
                pw.println("");
                pw.println("Factor B Label:\t" + this.factorBName);
                pw.print("Factor B Levels:");
                for (i = 0; i < this.factorBNames.length; ++i) {
                    pw.print("\t" + this.factorBNames[i]);
                }
                pw.println("");
                pw.println("#");
                pw.println("SampleIndex\tPrimarySampleName\t" + this.factorAName + "\t" + this.factorBName);
                for (int sample = 0; sample < this.numSamples; ++sample) {
                    pw.print(String.valueOf(sample + 1) + "\t");
                    pw.print(this.sampleAnn[0][sample] + "\t");
                    int[] assignments = this.getGroupAssignments(sample);
                    if (assignments[0] == -1) {
                        pw.println("Exclude\tExclude");
                        continue;
                    }
                    pw.print(this.factorANames[assignments[0]] + "\t");
                    pw.println(this.factorBNames[assignments[1]] + "\t");
                }
                pw.flush();
                pw.close();
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void loadAssignments() {
        JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
        if (fileChooser.showOpenDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                Vector<String> data = new Vector<String>();
                while ((line = br.readLine()) != null) {
                    data.add(line.trim());
                }
                br.close();
                String newFactorAName = "";
                String newFactorBName = "";
                String[] newFactorANames = null;
                String[] newFactorBNames = null;
                Vector<String> factorALevelNames = new Vector<String>();
                Vector<String> factorBLevelNames = new Vector<String>();
                Vector<String> factorALevelAssign = new Vector<String>();
                Vector<String> factorBLevelAssign = new Vector<String>();
                Vector<Integer> newSampleIndices = new Vector<Integer>();
                Vector<String> samplePrimaryNames = new Vector<String>();
                String status = "OK";
                boolean validData = true;
                for (int row = 0; row < data.size(); ++row) {
                    line = (String)data.get(row);
                    if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                    String[] lineArray = line.split("\t");
                    if (line.startsWith("Factor")) {
                        int level;
                        if (line.startsWith("Factor A Label")) {
                            newFactorAName = lineArray[1].trim();
                            continue;
                        }
                        if (line.startsWith("Factor B Label")) {
                            newFactorBName = lineArray[1].trim();
                            continue;
                        }
                        if (line.startsWith("Factor A Levels")) {
                            newFactorANames = new String[lineArray.length - 1];
                            for (level = 1; level < lineArray.length; ++level) {
                                newFactorANames[level - 1] = lineArray[level].trim();
                                factorALevelNames.add(lineArray[level].trim());
                            }
                            continue;
                        }
                        if (!line.startsWith("Factor B Levels")) continue;
                        newFactorBNames = new String[lineArray.length - 1];
                        for (level = 1; level < lineArray.length; ++level) {
                            newFactorBNames[level - 1] = lineArray[level].trim();
                            factorBLevelNames.add(lineArray[level].trim());
                        }
                        continue;
                    }
                    if (lineArray.length != 4) {
                        validData = false;
                        status = "invalid-line-length";
                        System.out.println("incorr. line length");
                        break;
                    }
                    try {
                        int index = Integer.parseInt(lineArray[0]) - 1;
                        newSampleIndices.add(new Integer(index));
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("ERROR: Sample index value (column 1 in the file) is not an integer.");
                        return;
                    }
                    samplePrimaryNames.add(lineArray[1].trim());
                    factorALevelAssign.add(lineArray[2].trim());
                    factorBLevelAssign.add(lineArray[3].trim());
                }
                int numFactorALevels = newFactorANames.length;
                int numFactorBLevels = newFactorBNames.length;
                Vector[][] newAssignments = new Vector[numFactorALevels][numFactorBLevels];
                for (int i = 0; i < numFactorALevels; ++i) {
                    for (int j = 0; j < numFactorBLevels; ++j) {
                        newAssignments[i][j] = new Vector();
                    }
                }
                Vector unassignedSamples = new Vector();
                if (numFactorALevels != this.sampleIndexAssignments.length || numFactorBLevels != this.sampleIndexAssignments[0].length) {
                    status = "design-dimension-mismatch";
                    System.out.println("design dim. error");
                    return;
                }
                if (this.numSamples != newSampleIndices.size()) {
                    status = "number-of-samples-mismatch";
                }
                Vector<String> loadedSampleNames = new Vector<String>();
                for (int sample = 0; sample < this.numSamples; ++sample) {
                    if (loadedSampleNames.contains(this.sampleAnn[0][sample])) continue;
                    loadedSampleNames.add(this.sampleAnn[0][sample]);
                }
                boolean uniqueNames = true;
                if (this.numSamples > loadedSampleNames.size()) {
                    uniqueNames = false;
                }
                int numSamplesWithAssignments = 0;
                for (int sample = 0; sample < this.numSamples; ++sample) {
                    if (!samplePrimaryNames.contains(this.sampleAnn[0][sample])) continue;
                    ++numSamplesWithAssignments;
                }
                boolean isCovered = true;
                if (numSamplesWithAssignments < this.numSamples) {
                    isCovered = false;
                }
                for (int sample = 0; sample < this.numSamples; ++sample) {
                    String sampleName = this.sampleAnn[0][sample];
                    int fileRowIndex = samplePrimaryNames.indexOf(sampleName);
                    if (fileRowIndex == -1) continue;
                    int factorAIndex = factorALevelNames.indexOf(factorALevelAssign.get(fileRowIndex));
                    int factorBIndex = factorBLevelNames.indexOf(factorBLevelAssign.get(fileRowIndex));
                    if (((String)factorALevelAssign.get(fileRowIndex)).equals("Exclude")) continue;
                    newAssignments[factorAIndex][factorBIndex].add(new Integer(sample));
                }
                this.sampleIndexAssignments = newAssignments;
                this.factorANames = newFactorANames;
                this.factorBNames = newFactorBNames;
                this.factorAName = newFactorAName;
                this.factorBName = newFactorBName;
                this.sampleListPanel.refreshFactorLevelAssignments();
                this.gridPanel.areMinDimsSet = false;
                this.repaint();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private int[] getGroupAssignments(int sampleIndex) {
        int[] factorAandBAssignments = new int[2];
        Integer sampleInt = new Integer(sampleIndex);
        int factorBIndex = 0;
        int a = -1;
        int b = -1;
        boolean foundIt = false;
        block0: for (int factorAIndex = 0; factorAIndex < this.sampleIndexAssignments.length; ++factorAIndex) {
            for (factorBIndex = 0; factorBIndex < this.sampleIndexAssignments[factorAIndex].length; ++factorBIndex) {
                if (!this.sampleIndexAssignments[factorAIndex][factorBIndex].contains(sampleInt)) continue;
                foundIt = true;
                a = factorAIndex;
                b = factorBIndex;
                continue block0;
            }
        }
        if (foundIt) {
            factorAandBAssignments[0] = a;
            factorAandBAssignments[1] = b;
        } else {
            factorAandBAssignments[0] = -1;
            factorAandBAssignments[1] = -1;
        }
        return factorAandBAssignments;
    }

    public static void main(String[] args) {
        String factorAName = "Strain";
        String factorBName = "Time";
        String[] factorANames = new String[]{"Wildtype", "Mutant X"};
        String[] factorBNames = new String[]{"10 min.", "20 min.", "30 min.", "40 min."};
        String[] sampleFieldNames = new String[]{"Default Slide Name", "Strain Name", "Exposure Time"};
        String[][] sampleAnn = new String[3][16];
        for (int i = 0; i < sampleAnn.length; ++i) {
            for (int j = 0; j < sampleAnn[i].length; ++j) {
                if (i == 0) {
                    sampleAnn[i][j] = "SamplexxxxxxxxFile " + j;
                    continue;
                }
                if (i == 1) {
                    if (j < 8) {
                        sampleAnn[i][j] = "Strain A";
                        continue;
                    }
                    sampleAnn[i][j] = "Strain B";
                    continue;
                }
                sampleAnn[i][j] = j > 11 ? "T = 40" : (j > 7 ? "T = 30" : (j > 3 ? "T = 20" : "T = 10"));
            }
        }
        TwoWaySelectionPanel twsp = new TwoWaySelectionPanel(new AlgorithmData(), factorAName, factorBName, factorANames, factorBNames, sampleFieldNames, sampleAnn);
        twsp.updateSize();
        JFrame frame = new JFrame();
        frame.getContentPane().add(twsp);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void populateAlgorithmData() {
        this.algData.addParam("factor-A-name", this.factorAName);
        this.algData.addParam("factor-B-name", this.factorBName);
        this.algData.addStringArray("factor-A-level-names", this.factorANames);
        this.algData.addStringArray("factor-B-level-names", this.factorBNames);
        int[][] groupAssignments = this.getFactorAssignmentArrays();
        this.algData.addIntArray("factor-A-group-assignments", groupAssignments[0]);
        this.algData.addIntArray("factor-B-group-assignments", groupAssignments[1]);
        this.algData.addParam("number-of-factor-A-levels", String.valueOf(this.factorANames.length));
        this.algData.addParam("number-of-factor-B-levels", String.valueOf(this.factorBNames.length));
    }

    @Override
    public void clearValuesFromAlgorithmData() {
        this.algData.getParams().getMap().remove("factor-A-name");
        this.algData.getParams().getMap().remove("factor-B-name");
        this.algData.getParams().getMap().remove("factor-A-level-names");
        this.algData.getParams().getMap().remove("factor-B-level-names");
        this.algData.getParams().getMap().remove("factor-A-grouping-array");
        this.algData.getParams().getMap().remove("factor-B-grouping-array");
    }

    @Override
    public void onDisplayed() {
        this.updateSize();
    }

    private int[][] getFactorAssignmentArrays() {
        int[][] factorGroupings = new int[2][this.numSamples];
        for (int sample = 0; sample < this.numSamples; ++sample) {
            int[] factorGroupAssignments = this.getGroupAssignments(sample);
            factorGroupings[0][sample] = factorGroupAssignments[0];
            factorGroupings[1][sample] = factorGroupAssignments[1];
        }
        return factorGroupings;
    }

    public class AnnotationFieldSelectionDialog
    extends AlgorithmDialog {
        private String[] annFields;
        private JList fieldList;
        private int result;

        public AnnotationFieldSelectionDialog(JFrame parent, String[] annotationFields) {
            super(parent, "Annotation Field Selection", true);
            this.annFields = annotationFields;
            this.fieldList = new JList<String>(this.annFields);
            this.fieldList.setSelectionMode(2);
            this.fieldList.setVisibleRowCount(2);
            this.fieldList.setBorder(BorderFactory.createLineBorder(Color.black));
            JLabel label = new JLabel("<html>Select one or more sample annotation fields below.<br>(Use Ctrl left click to select multiple fields)</html>");
            JPanel mainPanel = new JPanel(new GridBagLayout());
            mainPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 10, 0), 0, 0));
            mainPanel.add((Component)this.fieldList, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
            this.addContent(mainPanel);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnnotationFieldSelectionDialog.this.result = 0;
                    AnnotationFieldSelectionDialog.this.dispose();
                }
            });
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnnotationFieldSelectionDialog.this.result = 2;
                    AnnotationFieldSelectionDialog.this.dispose();
                }
            });
            this.pack();
        }

        public String[] getSelectedFieldNames() {
            Object[] selObjs = this.fieldList.getSelectedValues();
            String[] fieldNames = new String[selObjs.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                fieldNames[i] = (String)selObjs[i];
            }
            return fieldNames;
        }

        public int[] getSelectedFieldIndices() {
            return this.fieldList.getSelectedIndices();
        }

        public int showModal() {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
            this.show();
            return this.result;
        }
    }

    public class StupidOverlayHackPanel
    extends JPanel {
        public StupidOverlayHackPanel() {
            this.setLayout(new OverlayLayout(this));
        }
    }

    public class GlassPanel
    extends JPanel {
        private Point p = new Point(0, 0);
        private boolean mouseOverMode;
        private String instructionStr;
        private String instructionStr2;
        private int strH;
        private int strH2;
        private int strW;
        private int w;
        private int h;

        public GlassPanel() {
            this.setOpaque(false);
            MouseHandler mh = new MouseHandler();
            this.addMouseListener(mh);
            this.addMouseMotionListener(mh);
            this.addMouseWheelListener(mh);
            this.setVisible(false);
            this.instructionStr = "Click to select sample, then";
            this.instructionStr2 = "drag into design grid above.";
        }

        public void setMouseOverMode(boolean over) {
            this.mouseOverMode = over;
        }

        public boolean getMouseOverMode() {
            return this.mouseOverMode;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (TwoWaySelectionPanel.this.selectedSampleIndex != -1) {
                String sampleName = TwoWaySelectionPanel.this.sampleListPanel.getSelectedSampleName(TwoWaySelectionPanel.this.selectedSampleIndex);
                FontMetrics fm = g.getFontMetrics();
                LineMetrics lm = fm.getLineMetrics(sampleName, g);
                g.setColor(new Color(Integer.parseInt("FF0000", 16)));
                g.fill3DRect(this.p.x - 5, this.p.y - 5, 10, 10, true);
                this.w = fm.stringWidth(sampleName);
                this.h = (int)lm.getHeight();
                g.setColor(Color.white);
                g.fillRect(this.p.x + 8, this.p.y - this.h / 2 - 2, this.w + 4, this.h + 4);
                g.setColor(Color.black);
                g.drawString(sampleName, this.p.x + 10, this.p.y + 5);
                g.drawRect(this.p.x + 8, this.p.y - this.h / 2 - 2, this.w + 4, this.h + 4);
                g.drawLine(this.p.x - 7, this.p.y, this.p.x + 7, this.p.y);
                g.drawLine(this.p.x - 1, this.p.y - 7, this.p.x - 1, this.p.y + 7);
            } else if (this.mouseOverMode) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                FontMetrics fm = g.getFontMetrics();
                LineMetrics lm = fm.getLineMetrics(this.instructionStr, g);
                this.strW = fm.stringWidth(this.instructionStr);
                this.strH = (int)lm.getHeight();
                lm = fm.getLineMetrics(this.instructionStr2, g);
                this.strH2 = (int)lm.getHeight();
                this.h = this.strH + this.strH2 + 8;
                this.w = this.strW + 10;
                g2.setStroke(new BasicStroke(2.0f));
                g2.setColor(new Color(253, 244, 136));
                Composite comp = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(3, 0.9f));
                g2.fillRoundRect(this.p.x, this.p.y - this.h, this.w, this.h, 8, 8);
                g2.setComposite(comp);
                g2.setColor(Color.black);
                g2.drawRoundRect(this.p.x, this.p.y - this.h, this.w, this.h, 8, 8);
                g2.drawString(this.instructionStr, this.p.x + 5, this.p.y - this.h + this.strH);
                g2.drawString(this.instructionStr2, this.p.x + 5, this.p.y - 5);
                this.mouseOverMode = false;
            }
        }

        final class MouseHandler
        extends MouseInputAdapter
        implements MouseWheelListener {
            MouseHandler() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                GlassPanel.this.p.setLocation(e.getPoint());
                this.redispatchMouseEvent(e, true);
                GlassPanel.this.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                GlassPanel.this.p.setLocation(e.getPoint());
                this.redispatchMouseEvent(e, true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                GlassPanel.this.p.setLocation(e.getPoint());
                this.redispatchMouseEvent(e, true);
                TwoWaySelectionPanel.this.selectedSampleIndex = -1;
                GlassPanel.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                GlassPanel.this.p.setLocation(e.getPoint());
                this.redispatchMouseEvent(e, true);
                TwoWaySelectionPanel.this.gridPanel.onMouseMoved(((GlassPanel)GlassPanel.this).p.x - 5, ((GlassPanel)GlassPanel.this).p.y - 5);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GlassPanel.this.p.setLocation(e.getPoint());
                this.redispatchMouseEvent(e, true);
                TwoWaySelectionPanel.this.gridPanel.onMouseMoved(((GlassPanel)GlassPanel.this).p.x, ((GlassPanel)GlassPanel.this).p.y);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.redispatchMouseEvent(e, true);
            }

            private void redispatchMouseEvent(MouseEvent e, boolean repaint) {
                Point glassPanePoint = e.getPoint();
                JPanel container = TwoWaySelectionPanel.this.selectorPanel;
                Point containerPoint = SwingUtilities.convertPoint(TwoWaySelectionPanel.this.glassPanel, glassPanePoint, TwoWaySelectionPanel.this.selectorPanel);
                if (containerPoint.y >= 0) {
                    Component component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y);
                    if (component != null) {
                        if (e instanceof MouseWheelEvent) {
                            Point componentPoint = SwingUtilities.convertPoint(TwoWaySelectionPanel.this.glassPanel, glassPanePoint, component);
                            MouseWheelEvent mwe = (MouseWheelEvent)e;
                            component.dispatchEvent(new MouseWheelEvent(component, e.getID(), e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger(), mwe.getScrollType(), mwe.getScrollAmount(), mwe.getWheelRotation()));
                        } else {
                            Point componentPoint = SwingUtilities.convertPoint(TwoWaySelectionPanel.this.glassPanel, glassPanePoint, component);
                            component.dispatchEvent(new MouseEvent(component, e.getID(), e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
                        }
                    }
                    if (repaint) {
                        TwoWaySelectionPanel.this.glassPanel.repaint();
                    }
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                this.redispatchMouseEvent(e, true);
            }
        }
    }

    public class Listener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("reset-command")) {
                TwoWaySelectionPanel.this.sampleListPanel.resetSelection(e.getSource());
            } else if (command.equals("select-sample-ann-command")) {
                TwoWaySelectionPanel.this.sampleListPanel.onAnnotationSelection();
                TwoWaySelectionPanel.this.validate();
            } else if (command.equals("save-design-command")) {
                TwoWaySelectionPanel.this.saveAssignments();
            } else if (command.equals("load-design-command")) {
                TwoWaySelectionPanel.this.loadAssignments();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            TwoWaySelectionPanel.this.gridPanel.setIsDragging(true);
            TwoWaySelectionPanel.this.gridPanel.setHaveSample(true);
            int x = e.getX();
            int y = e.getY();
            if (e.getSource() == TwoWaySelectionPanel.this.gridPanel) {
                TwoWaySelectionPanel.this.gridPanel.setCursorX(x);
                TwoWaySelectionPanel.this.gridPanel.setCursorY(y);
                TwoWaySelectionPanel.this.gridPanel.onMouseMoved(x, y);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            TwoWaySelectionPanel.this.gridPanel.setIsDragging(false);
            TwoWaySelectionPanel.this.gridPanel.setHaveSample(false);
            int x = e.getX();
            int y = e.getY();
            if (e.getSource() == TwoWaySelectionPanel.this.gridPanel) {
                TwoWaySelectionPanel.this.gridPanel.onMouseMoved(x, y);
            }
            TwoWaySelectionPanel.this.sampleListPanel.handleMouseOver(e.getSource());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TwoWaySelectionPanel.this.gridPanel.setHaveSample(false);
            TwoWaySelectionPanel.this.gridPanel.setIsDragging(false);
            if (e.getSource() == TwoWaySelectionPanel.this.gridPanel) {
                int x = e.getX();
                int y = e.getY();
                TwoWaySelectionPanel.this.gridPanel.setCursorX(x);
                TwoWaySelectionPanel.this.gridPanel.setCursorY(y);
                TwoWaySelectionPanel.this.gridPanel.onMouseReleased(x, y);
            } else {
                TwoWaySelectionPanel.this.selectedSampleIndex = -1;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Object source = e.getSource();
            TwoWaySelectionPanel.this.sampleListPanel.handleMousePress(source);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object source = e.getSource();
            TwoWaySelectionPanel.this.sampleListPanel.handleMouseClick(source);
        }
    }

    public class DesignGridPanel
    extends JPanel {
        boolean areMinDimsSet = false;
        private int PRE_FACTOR_A_LABEL_WIDTH = 15;
        private int PRE_FACTOR_B_LABEL_HEIGHT = 15;
        private int PRE_LABEL_A_WIDTH = 15;
        private int POST_LABEL_A_WIDTH = 15;
        private int PRE_LABEL_B_HEIGHT = 15;
        private int POST_LABEL_B_HEIGHT = 15;
        private int RIGHT_MARGIN = 25;
        private int BOTTOM_MARGIN = 25;
        private int MIN_LABEL_A_YPAD = 10;
        private int MIN_LABEL_B_XPAD = 10;
        int factorALabelWidth;
        int factorALabelHeight;
        int factorBLabelWidth;
        int factorBLabelHeight;
        FontMetrics fm;
        int currX;
        int currY;
        int xStep;
        int yStep;
        int rectX;
        int rectY;
        int rectW;
        int rectH;
        Rectangle mainRect;
        private int selectedRow;
        private int selectedCol;
        private boolean isOnRect = false;
        private boolean isDragging = false;
        private boolean haveSample = false;
        private int cursorX;
        private int cursorY;
        private Font plainFont;
        private Font boldFont;
        private String sampleCountStr;

        public DesignGridPanel() {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Experimental Design Grid"));
            this.plainFont = new Font("Arial", 0, 14);
            this.boldFont = new Font("Arial", 1, 16);
            this.selectedRow = -1;
            this.selectedCol = -1;
            this.addMouseListener(TwoWaySelectionPanel.this.listener);
            this.addMouseMotionListener(TwoWaySelectionPanel.this.listener);
        }

        @Override
        public void paint(Graphics g) {
            int i;
            super.paint(g);
            if (!this.areMinDimsSet) {
                g.setFont(this.plainFont);
                this.setMinDims(g);
                this.areMinDimsSet = true;
            }
            this.currY = this.fm.getHeight() + this.PRE_FACTOR_B_LABEL_HEIGHT;
            this.currX = this.PRE_FACTOR_A_LABEL_WIDTH + this.PRE_LABEL_A_WIDTH + this.POST_LABEL_A_WIDTH + this.factorALabelWidth;
            g.setFont(this.boldFont);
            g.drawString(TwoWaySelectionPanel.this.factorBName, this.currX + (this.getWidth() - this.currX - this.RIGHT_MARGIN) / 2 - this.fm.stringWidth(TwoWaySelectionPanel.this.factorBName) / 2, this.currY);
            this.currX = this.fm.getHeight() / 2 + this.fm.stringWidth(TwoWaySelectionPanel.this.factorAName) / 2;
            Graphics2D g2 = (Graphics2D)g;
            g2.rotate(-1.5707963267948966);
            FontMetrics fm2 = g2.getFontMetrics();
            g.drawString(TwoWaySelectionPanel.this.factorAName, -fm2.stringWidth(TwoWaySelectionPanel.this.factorAName) / 2 - (this.getHeight() + this.PRE_FACTOR_B_LABEL_HEIGHT + this.factorBLabelHeight + this.PRE_LABEL_B_HEIGHT + this.POST_LABEL_B_HEIGHT) / 2, this.fm.getHeight() + this.PRE_FACTOR_A_LABEL_WIDTH);
            g2.rotate(1.5707963267948966);
            this.currX = this.fm.getHeight() + this.PRE_FACTOR_A_LABEL_WIDTH;
            this.currX += this.PRE_LABEL_A_WIDTH;
            this.currY += this.POST_LABEL_B_HEIGHT;
            g.setFont(this.plainFont);
            g2.setStroke(new BasicStroke(2.0f));
            this.currY = this.PRE_FACTOR_B_LABEL_HEIGHT + this.fm.getHeight() + this.PRE_LABEL_B_HEIGHT + this.POST_LABEL_B_HEIGHT + this.factorBLabelHeight;
            this.yStep = (this.getHeight() - this.currY - this.BOTTOM_MARGIN) / TwoWaySelectionPanel.this.factorANames.length - this.factorALabelHeight;
            this.currY += this.yStep / 2;
            for (int i2 = 0; i2 < TwoWaySelectionPanel.this.factorANames.length; ++i2) {
                this.currY += this.factorALabelHeight;
                if (i2 != this.selectedRow) {
                    g.setFont(this.plainFont);
                } else {
                    g.setFont(this.boldFont);
                }
                g.drawString(TwoWaySelectionPanel.this.factorANames[i2], this.currX, this.currY);
                this.currY += this.yStep;
            }
            this.currY = this.PRE_FACTOR_B_LABEL_HEIGHT + this.fm.getHeight() + this.PRE_LABEL_B_HEIGHT + this.factorBLabelHeight;
            this.currX += this.factorALabelWidth + this.POST_LABEL_A_WIDTH;
            int cornerX = this.currX;
            this.xStep = (this.getWidth() - this.currX - this.RIGHT_MARGIN) / TwoWaySelectionPanel.this.factorBNames.length - this.factorBLabelWidth;
            this.currX += this.xStep / 2;
            for (i = 0; i < TwoWaySelectionPanel.this.factorBNames.length; ++i) {
                if (i != this.selectedCol) {
                    g.setFont(this.plainFont);
                } else {
                    g.setFont(this.boldFont);
                }
                g.drawString(TwoWaySelectionPanel.this.factorBNames[i], this.currX, this.currY);
                this.currX += this.xStep + this.factorBLabelWidth;
            }
            this.currX = cornerX;
            this.currY += this.POST_LABEL_B_HEIGHT;
            this.rectX = this.currX;
            this.rectY = this.currY;
            this.rectW = this.getWidth() - this.currX - this.RIGHT_MARGIN;
            this.rectH = this.getHeight() - this.currY - this.BOTTOM_MARGIN;
            this.mainRect = new Rectangle(this.rectX, this.rectY, this.rectW, this.rectH);
            g.drawRect(this.rectX, this.rectY, this.rectW, this.rectH);
            for (i = 0; i < TwoWaySelectionPanel.this.factorANames.length - 1; ++i) {
                g.drawLine(this.rectX, this.rectY + (i + 1) * this.rectH / TwoWaySelectionPanel.this.factorANames.length, this.rectX + this.rectW, this.rectY + (i + 1) * this.rectH / TwoWaySelectionPanel.this.factorANames.length);
            }
            for (i = 0; i < TwoWaySelectionPanel.this.factorBNames.length - 1; ++i) {
                g.drawLine(this.rectX + (i + 1) * this.rectW / TwoWaySelectionPanel.this.factorBNames.length, this.rectY, this.rectX + (i + 1) * this.rectW / TwoWaySelectionPanel.this.factorBNames.length, this.rectY + this.rectH);
            }
            if (this.isOnRect) {
                Composite comp = g2.getComposite();
                for (int i3 = 0; i3 < TwoWaySelectionPanel.this.factorANames.length; ++i3) {
                    for (int j = 0; j < TwoWaySelectionPanel.this.factorBNames.length; ++j) {
                        if (i3 == this.selectedRow && j == this.selectedCol) {
                            g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
                            g.setColor(Color.yellow);
                        } else {
                            if (i3 != this.selectedRow && j != this.selectedCol || i3 >= this.selectedRow && j >= this.selectedCol) continue;
                            g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
                            g.setColor(Color.blue);
                        }
                        g.fillRect(this.rectX + j * this.rectW / TwoWaySelectionPanel.this.factorBNames.length + 3, this.rectY + (int)((float)(i3 * this.rectH) / (float)TwoWaySelectionPanel.this.factorANames.length) + 3, this.rectW / TwoWaySelectionPanel.this.factorBNames.length - 6, (int)((float)this.rectH / (float)TwoWaySelectionPanel.this.factorANames.length) - 6);
                    }
                }
                g2.setComposite(comp);
                g2.setColor(Color.black);
            }
            g.setFont(this.plainFont);
            for (int i4 = 0; i4 < TwoWaySelectionPanel.this.factorANames.length; ++i4) {
                for (int j = 0; j < TwoWaySelectionPanel.this.factorBNames.length; ++j) {
                    this.sampleCountStr = String.valueOf(TwoWaySelectionPanel.this.sampleIndexAssignments[i4][j].size());
                    this.currX = this.rectX + j * this.rectW / TwoWaySelectionPanel.this.factorBNames.length + this.rectW / TwoWaySelectionPanel.this.factorBNames.length / 2 - this.fm.stringWidth(this.sampleCountStr) / 2;
                    this.currY = this.rectY + i4 * this.rectH / TwoWaySelectionPanel.this.factorANames.length + this.rectH / TwoWaySelectionPanel.this.factorANames.length / 2 + (int)this.fm.getLineMetrics(this.sampleCountStr, g).getHeight() / 2;
                    g.drawString(this.sampleCountStr, this.currX, this.currY);
                }
            }
        }

        private void setOnRect(boolean onRect) {
            this.isOnRect = onRect;
        }

        private void setMinDims(Graphics g) {
            this.fm = g.getFontMetrics();
            int minCurrWidth = 0;
            int minCurrHeight = 0;
            int maxBLabelWidth = 0;
            int maxBLabelHeight = 0;
            for (int i = 0; i < TwoWaySelectionPanel.this.factorBNames.length; ++i) {
                maxBLabelWidth = Math.max(maxBLabelWidth, this.fm.stringWidth(TwoWaySelectionPanel.this.factorBNames[i]));
                maxBLabelHeight = Math.max(maxBLabelHeight, (int)this.fm.getLineMetrics(TwoWaySelectionPanel.this.factorBNames[i], g).getHeight());
            }
            minCurrHeight = maxBLabelHeight;
            minCurrWidth = TwoWaySelectionPanel.this.factorBNames.length * (maxBLabelWidth + this.MIN_LABEL_B_XPAD);
            minCurrWidth += this.MIN_LABEL_B_XPAD + this.RIGHT_MARGIN;
            minCurrWidth += this.PRE_FACTOR_A_LABEL_WIDTH + this.PRE_LABEL_A_WIDTH + this.POST_LABEL_A_WIDTH;
            int maxALabelWidth = 0;
            int maxALabelHeight = 0;
            for (int i = 0; i < TwoWaySelectionPanel.this.factorANames.length; ++i) {
                maxALabelHeight = Math.max(maxALabelHeight, (int)this.fm.getLineMetrics(TwoWaySelectionPanel.this.factorANames[i], g).getHeight());
                maxALabelWidth = Math.max(maxALabelWidth, this.fm.stringWidth(TwoWaySelectionPanel.this.factorANames[i]));
            }
            this.factorALabelHeight = maxALabelHeight;
            this.factorALabelWidth = maxALabelWidth;
            this.factorBLabelHeight = maxBLabelHeight;
            this.factorBLabelWidth = maxBLabelWidth;
            minCurrWidth += maxALabelWidth;
            minCurrWidth = (int)((float)minCurrWidth + this.fm.getLineMetrics(TwoWaySelectionPanel.this.factorAName, g).getHeight());
            minCurrHeight = TwoWaySelectionPanel.this.factorANames.length * (maxALabelHeight + this.MIN_LABEL_A_YPAD);
            minCurrHeight += this.PRE_FACTOR_B_LABEL_HEIGHT + this.PRE_LABEL_B_HEIGHT + this.POST_LABEL_B_HEIGHT;
            minCurrHeight = (int)((float)minCurrHeight + this.fm.getLineMetrics(TwoWaySelectionPanel.this.factorBName, g).getHeight());
            int minWidth = Math.max(minCurrWidth, this.getWidth());
            int minHeight = Math.max(minCurrHeight, this.getHeight());
            this.setPreferredSize(new Dimension(minWidth, minHeight + 100));
            this.setSize(minWidth, minHeight + 100);
            TwoWaySelectionPanel.this.selectorPanel.validate();
        }

        public void onMouseMoved(int x, int y) {
            if (this.mainRect == null) {
                return;
            }
            if (this.mainRect.contains(x, y)) {
                this.isOnRect = true;
                this.selectedRow = (int)((float)(y - this.mainRect.y) / (float)this.mainRect.height * (float)TwoWaySelectionPanel.this.factorANames.length);
                this.selectedCol = (int)((float)(x - this.mainRect.x) / (float)this.mainRect.width * (float)TwoWaySelectionPanel.this.factorBNames.length);
            } else if (this.isOnRect) {
                this.selectedRow = -1;
                this.selectedCol = -1;
                this.isOnRect = false;
            }
        }

        public void onMouseReleased(int x, int y) {
            if (this.mainRect == null || TwoWaySelectionPanel.this.selectedSampleIndex == -1) {
                return;
            }
            if (this.mainRect.contains(x, y)) {
                this.isOnRect = true;
                this.selectedRow = (int)((float)(y - this.mainRect.y) / (float)this.mainRect.height * (float)TwoWaySelectionPanel.this.factorANames.length);
                this.selectedCol = (int)((float)(x - this.mainRect.x) / (float)this.mainRect.width * (float)TwoWaySelectionPanel.this.factorBNames.length);
                TwoWaySelectionPanel.this.removeAssignment(TwoWaySelectionPanel.this.selectedSampleIndex);
                TwoWaySelectionPanel.this.sampleIndexAssignments[this.selectedRow][this.selectedCol].add(new Integer(TwoWaySelectionPanel.this.selectedSampleIndex));
                TwoWaySelectionPanel.this.sampleListPanel.updateAssignment(TwoWaySelectionPanel.this.selectedSampleIndex, this.selectedRow, this.selectedCol);
            } else {
                TwoWaySelectionPanel.this.selectedSampleIndex = -1;
                if (this.isOnRect) {
                    this.selectedRow = -1;
                    this.selectedCol = -1;
                    this.isOnRect = false;
                }
            }
            TwoWaySelectionPanel.this.selectedSampleIndex = -1;
            this.repaint();
        }

        public void setIsDragging(boolean dragging) {
            this.isDragging = dragging;
        }

        public boolean isDragging() {
            return this.isDragging;
        }

        public void setCursorX(int x) {
            this.cursorX = x;
        }

        public void setCursorY(int y) {
            this.cursorY = y;
        }

        public void setHaveSample(boolean withSample) {
            this.haveSample = withSample;
        }
    }

    public class SampleListPanel
    extends JPanel {
        private Vector annFieldVector;
        private Vector factorALabelVector;
        private Vector factorBLabelVector;
        private Vector sampleLabelVector;
        private Vector resetButtonVector;
        private JPanel headerPanel;
        boolean[] isAssigned;

        public SampleListPanel() {
            super(new GridBagLayout());
            this.isAssigned = new boolean[TwoWaySelectionPanel.this.numSamples];
            this.addMouseListener(TwoWaySelectionPanel.this.listener);
            this.addMouseMotionListener(TwoWaySelectionPanel.this.listener);
            this.annFieldVector = new Vector();
            this.annFieldVector.add(new Integer(0));
            this.factorALabelVector = new Vector(TwoWaySelectionPanel.this.numSamples);
            this.factorBLabelVector = new Vector(TwoWaySelectionPanel.this.numSamples);
            this.initialize();
        }

        private void initialize() {
            this.removeAll();
            Dimension resetButtonDim = new Dimension(60, 25);
            this.resetButtonVector = new Vector();
            this.sampleLabelVector = new Vector();
            boolean haveMultipleAnnFields = TwoWaySelectionPanel.this.sampleAnn.length > 1;
            int numAnnFields = this.annFieldVector.size();
            int numCols = numAnnFields + 4;
            int currRow = 0;
            int currCol = 0;
            Insets labelInsets = new Insets(2, 5, 2, 5);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Cursor handCursor = new Cursor(12);
            JComponent lastIndexLabel = null;
            for (int sample = 0; sample < TwoWaySelectionPanel.this.numSamples; ++sample) {
                currCol = 0;
                JLabel indexLabel = new JLabel(String.valueOf(sample + 1));
                lastIndexLabel = indexLabel;
                this.add((Component)indexLabel, new GridBagConstraints(currCol, currRow, 1, 1, 0.0, 1.0, 10, 3, labelInsets, 1, 1));
                ++currCol;
                JButton resetButton = new JButton("Reset");
                resetButton.setEnabled(this.isAssigned[sample]);
                resetButton.setFocusPainted(false);
                resetButton.setBorder(BorderFactory.createBevelBorder(0));
                resetButton.setPreferredSize(resetButtonDim);
                resetButton.setSize(resetButtonDim);
                resetButton.setActionCommand("reset-command");
                resetButton.addActionListener(TwoWaySelectionPanel.this.listener);
                resetButton.addMouseListener(TwoWaySelectionPanel.this.listener);
                this.add((Component)resetButton, new GridBagConstraints(++currCol, currRow, 1, 1, 0.0, 1.0, 10, 0, labelInsets, 1, 1));
                this.resetButtonVector.add(resetButton);
                ++currCol;
                int borderWidth = 3;
                for (int fieldIndex = 0; fieldIndex < numAnnFields; ++fieldIndex) {
                    JLabel sampleLabel = new JLabel(TwoWaySelectionPanel.this.sampleAnn[(Integer)this.annFieldVector.get(fieldIndex)][sample]);
                    sampleLabel.setHorizontalAlignment(0);
                    borderWidth = 1;
                    if (fieldIndex == 0) {
                        if (!this.isAssigned[sample]) {
                            borderWidth = 3;
                        }
                        sampleLabel.setFocusable(true);
                        sampleLabel.addMouseListener(TwoWaySelectionPanel.this.listener);
                        sampleLabel.addMouseMotionListener(TwoWaySelectionPanel.this.listener);
                        this.sampleLabelVector.add(sampleLabel);
                        sampleLabel.setCursor(handCursor);
                    }
                    sampleLabel.setBorder(BorderFactory.createLineBorder(Color.black, borderWidth));
                    this.add((Component)sampleLabel, new GridBagConstraints(currCol, currRow, 1, 1, 1.0, 1.0, 10, 1, labelInsets, 1, 1));
                    ++currCol;
                }
                JLabel factorALabel = !this.isAssigned[sample] ? new JLabel("Exclude") : (JLabel)this.factorALabelVector.get(sample);
                factorALabel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
                factorALabel.setHorizontalAlignment(0);
                if (this.factorALabelVector.size() < TwoWaySelectionPanel.this.numSamples) {
                    this.factorALabelVector.add(factorALabel);
                } else {
                    this.factorALabelVector.set(sample, factorALabel);
                }
                this.add((Component)factorALabel, new GridBagConstraints(currCol, currRow, 1, 1, 1.0, 1.0, 10, 1, labelInsets, 1, 1));
                ++currCol;
                JLabel factorBLabel = !this.isAssigned[sample] ? new JLabel("Exclude") : (JLabel)this.factorBLabelVector.get(sample);
                factorBLabel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
                factorBLabel.setHorizontalAlignment(0);
                if (this.factorBLabelVector.size() < TwoWaySelectionPanel.this.numSamples) {
                    this.factorBLabelVector.add(factorBLabel);
                } else {
                    this.factorBLabelVector.set(sample, factorBLabel);
                }
                this.add((Component)factorBLabel, new GridBagConstraints(currCol, currRow, 1, 1, 1.0, 1.0, 10, 1, labelInsets, 1, 1));
                ++currCol;
                ++currRow;
            }
            this.headerPanel = this.createHeaderPanel(numCols, lastIndexLabel.getPreferredSize(), resetButtonDim);
        }

        public void refreshFactorLevelAssignments() {
            for (int sample = 0; sample < this.factorALabelVector.size(); ++sample) {
                JLabel label;
                int[] factorAandBAssignments = TwoWaySelectionPanel.this.getGroupAssignments(sample);
                if (factorAandBAssignments[0] != -1) {
                    label = (JLabel)this.factorALabelVector.get(sample);
                    label.setText(TwoWaySelectionPanel.this.factorANames[factorAandBAssignments[0]]);
                    label = (JLabel)this.factorBLabelVector.get(sample);
                    label.setText(TwoWaySelectionPanel.this.factorBNames[factorAandBAssignments[1]]);
                    label = (JLabel)this.sampleLabelVector.get(sample);
                    label.setBorder(BorderFactory.createLineBorder(Color.black, 1));
                    this.isAssigned[sample] = true;
                    ((JButton)this.resetButtonVector.get(sample)).setEnabled(true);
                    continue;
                }
                label = (JLabel)this.factorALabelVector.get(sample);
                label.setText("exclude");
                label = (JLabel)this.factorBLabelVector.get(sample);
                label.setText("exclude");
                label = (JLabel)this.sampleLabelVector.get(sample);
                label.setBorder(BorderFactory.createLineBorder(Color.black, 3));
                this.isAssigned[sample] = false;
                ((JButton)this.resetButtonVector.get(sample)).setEnabled(false);
            }
        }

        private JPanel createHeaderPanel(int numCols, Dimension indexDim, Dimension resetDim) {
            JPanel panel = new JPanel(new GridBagLayout());
            int currY = 0;
            int currAnnFieldIndex = 0;
            Insets labelInsets = new Insets(2, 5, 2, 5);
            JButton sampleAnnButton = new JButton("  Select Sample Annotation Fields  ");
            sampleAnnButton.setPreferredSize(new Dimension(200, 30));
            sampleAnnButton.setBorder(BorderFactory.createBevelBorder(0));
            sampleAnnButton.setFocusPainted(false);
            sampleAnnButton.setActionCommand("select-sample-ann-command");
            sampleAnnButton.addActionListener(TwoWaySelectionPanel.this.listener);
            sampleAnnButton.addMouseListener(TwoWaySelectionPanel.this.listener);
            sampleAnnButton.setEnabled(TwoWaySelectionPanel.this.sampleFieldNames.length > 1);
            panel.add((Component)sampleAnnButton, new GridBagConstraints(0, currY, numCols, 1, 1.0, 1.0, 17, 3, new Insets(5, 10, 5, 1), 1, 1));
            ++currY;
            for (int i = 0; i < numCols; ++i) {
                String labelText;
                JPanel fillPanel;
                if (i == 0) {
                    fillPanel = new JPanel();
                    Dimension dim = this.getComponent(i).getPreferredSize();
                    dim.width += 10;
                    dim.height += 4;
                    fillPanel.setPreferredSize(dim);
                    fillPanel.setSize(dim);
                    panel.add((Component)fillPanel, new GridBagConstraints(i, currY, 1, 1, 0.0, 1.0, 10, 3, labelInsets, 1, 1));
                    continue;
                }
                if (i == 1) {
                    fillPanel = new JPanel();
                    fillPanel.setPreferredSize(resetDim);
                    fillPanel.setSize(resetDim);
                    panel.add((Component)fillPanel, new GridBagConstraints(i, currY, 1, 1, 0.0, 1.0, 10, 0, labelInsets, 1, 1));
                    continue;
                }
                if (i == numCols - 2) {
                    labelText = TwoWaySelectionPanel.this.factorAName;
                } else if (i == numCols - 1) {
                    labelText = TwoWaySelectionPanel.this.factorBName;
                } else {
                    labelText = TwoWaySelectionPanel.this.sampleFieldNames[(Integer)this.annFieldVector.get(currAnnFieldIndex)];
                    ++currAnnFieldIndex;
                }
                labelText = "<html><b><u>" + labelText + "</html>";
                JLabel label = new JLabel(labelText);
                label.setFont(new Font("Arial", 1, 16));
                label.setHorizontalAlignment(0);
                label.setPreferredSize(this.getComponent(i).getPreferredSize());
                label.setSize(this.getComponent(i).getPreferredSize());
                panel.add((Component)label, new GridBagConstraints(i, currY, 1, 1, 1.0, 1.0, 17, 1, labelInsets, 1, 1));
            }
            return panel;
        }

        public JPanel getHeaderPanel() {
            return this.headerPanel;
        }

        private void updateAssignment(int sampleNumber, int factorAIndex, int factorBIndex) {
            ((JLabel)this.factorALabelVector.get(sampleNumber)).setText(TwoWaySelectionPanel.this.factorANames[factorAIndex]);
            ((JLabel)this.factorBLabelVector.get(sampleNumber)).setText(TwoWaySelectionPanel.this.factorBNames[factorBIndex]);
            ((JLabel)this.sampleLabelVector.get(sampleNumber)).setBorder(BorderFactory.createLineBorder(Color.gray, 1));
            this.isAssigned[sampleNumber] = true;
            ((JButton)this.resetButtonVector.get(sampleNumber)).setEnabled(true);
            this.validate();
            this.repaint();
        }

        private void resetSelection(Object source) {
            int sampleIndex = this.resetButtonVector.indexOf(source);
            ((JLabel)this.factorALabelVector.get(sampleIndex)).setText("Exclude");
            ((JLabel)this.factorBLabelVector.get(sampleIndex)).setText("Exclude");
            ((JLabel)this.sampleLabelVector.get(sampleIndex)).setBorder(BorderFactory.createLineBorder(Color.black, 3));
            this.isAssigned[sampleIndex] = false;
            ((JButton)this.resetButtonVector.get(sampleIndex)).setEnabled(false);
            this.validate();
            this.repaint();
            TwoWaySelectionPanel.this.removeAssignment(sampleIndex);
        }

        private void resetSelection(int sampleIndex) {
            ((JLabel)this.factorALabelVector.get(sampleIndex)).setText("Exclude");
            ((JLabel)this.factorBLabelVector.get(sampleIndex)).setText("Exclude");
            ((JLabel)this.sampleLabelVector.get(sampleIndex)).setBorder(BorderFactory.createLineBorder(Color.black, 3));
            this.validate();
            this.repaint();
            TwoWaySelectionPanel.this.removeAssignment(sampleIndex);
        }

        private String getSelectedSampleName(int index) {
            return "[" + ((JLabel)this.sampleLabelVector.get(index)).getText() + "]";
        }

        private void modifyDisplayedSampleAnnotation() {
            AnnotationFieldSelectionDialog dialog = new AnnotationFieldSelectionDialog(new JFrame(), TwoWaySelectionPanel.this.sampleFieldNames);
            if (dialog.showModal() == 0) {
                this.annFieldVector.clear();
                this.annFieldVector.add(new Integer(0));
                int[] selectedIndices = dialog.getSelectedFieldIndices();
                for (int i = 0; i < selectedIndices.length; ++i) {
                    if (selectedIndices[i] <= 0) continue;
                    this.annFieldVector.add(new Integer(selectedIndices[i]));
                }
                this.initialize();
                TwoWaySelectionPanel.this.pane.setColumnHeaderView(this.headerPanel);
                this.validate();
            }
        }

        private void handleMouseClick(Point mousePoint) {
            Point myPoint = this.getLocation();
            Component comp = this.getComponentAt(mousePoint.x, mousePoint.y - myPoint.y - TwoWaySelectionPanel.this.gridPanel.getHeight() - this.headerPanel.getHeight());
            int resetButtonIndex = this.resetButtonVector.indexOf(comp);
            if (comp != null && resetButtonIndex != -1) {
                this.resetSelection(resetButtonIndex);
            }
        }

        private void handleMouseClick(Object comp) {
            Point myPoint = this.getLocation();
            int resetButtonIndex = this.resetButtonVector.indexOf(comp);
            if (comp != null) {
                if (resetButtonIndex != -1) {
                    this.resetSelection(resetButtonIndex);
                }
                this.grabFocus();
            }
        }

        private void handleMousePress(Point mousePoint) {
            Point myPoint = this.getLocation();
            Component comp = this.getComponentAt(mousePoint.x, mousePoint.y - myPoint.y - TwoWaySelectionPanel.this.gridPanel.getHeight() - this.headerPanel.getHeight());
            int labelIndex = this.sampleLabelVector.indexOf(comp);
            if (comp != null) {
                TwoWaySelectionPanel.this.selectedSampleIndex = labelIndex;
            }
        }

        public void handleMousePress(Object comp) {
            int labelIndex = this.sampleLabelVector.indexOf(comp);
            if (comp != null) {
                TwoWaySelectionPanel.this.selectedSampleIndex = labelIndex;
            }
        }

        public void handleMouseOver(Object comp) {
            Point myPoint = this.getLocation();
            int labelIndex = this.sampleLabelVector.indexOf(comp);
            if (labelIndex != -1) {
                TwoWaySelectionPanel.this.glassPanel.setMouseOverMode(true);
            } else {
                TwoWaySelectionPanel.this.glassPanel.setMouseOverMode(false);
            }
        }

        public void onAnnotationSelection() {
            AnnotationFieldSelectionDialog dialog = new AnnotationFieldSelectionDialog(new JFrame(), TwoWaySelectionPanel.this.sampleFieldNames);
            if (dialog.showModal() == 0) {
                this.annFieldVector.clear();
                this.annFieldVector.add(new Integer(0));
                int[] selectedIndices = dialog.getSelectedFieldIndices();
                for (int i = 0; i < selectedIndices.length; ++i) {
                    if (selectedIndices[i] <= 0) continue;
                    this.annFieldVector.add(new Integer(selectedIndices[i]));
                }
                this.initialize();
                TwoWaySelectionPanel.this.pane.setColumnHeaderView(this.headerPanel);
            }
            this.grabFocus();
        }
    }
}

