/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class Monitor
extends JDialog {
    private JPanel drawingArea;
    private int position = 0;
    private int stepXFactor = 1;
    private double factor;
    private int[] values = new int[245];

    public Monitor(Frame parent, String title, int x, int y, double factor) {
        super(parent, title);
        this.factor = factor;
        this.enableEvents(64L);
        this.drawingArea = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Monitor.this.onPaint(g);
            }
        };
        this.drawingArea.setPreferredSize(new Dimension(275, 275));
        this.drawingArea.setOpaque(false);
        for (int i = 1; i < 200; ++i) {
            this.values[i] = 0;
        }
        this.getContentPane().add(this.drawingArea);
        ((JPanel)this.getContentPane()).setOpaque(false);
        ImageIcon backgroundImage = GUIFactory.getIcon("monitor.jpg");
        JLabel backgoundLabel = new JLabel(backgroundImage);
        this.drawingArea.add(backgoundLabel);
        this.getLayeredPane().add((Component)backgoundLabel, new Integer(Integer.MIN_VALUE));
        backgoundLabel.setBounds(0, 0, backgroundImage.getIconWidth(), backgroundImage.getIconHeight());
        this.setLocation(x, y);
        this.pack();
    }

    public void update(double value) {
        int dummy = (int)Math.round(value * this.factor);
        if (dummy > 210) {
            dummy = 210;
        }
        this.values[this.position] = 210 - dummy;
        ++this.position;
        if (this.position * this.stepXFactor >= 245) {
            this.position = 0;
        }
        this.drawingArea.repaint();
    }

    public void setStepXFactor(int stepXFactor) {
        this.stepXFactor = stepXFactor;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(e);
    }

    private void onPaint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.clipRect(15, 28, 245, 210);
        g2.setColor(new Color(118, 243, 254));
        for (int i = 1; i < this.position; ++i) {
            g2.drawLine(15 + (i - 1) * this.stepXFactor, 28 + this.values[i - 1], 15 + i * this.stepXFactor, 28 + this.values[i]);
        }
    }
}

