/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;

public class Logger
extends JDialog {
    private JTextArea log = new JTextArea(10, 30);
    GradientPaint gp;
    Color backgroundColor = new Color(25, 25, 169);
    Color fadeColor = new Color(140, 220, 240);

    public Logger(Frame parent, String title, DialogListener listener) {
        super(parent, title);
        JPanel logPanel = this.createLogPanel();
        JPanel btnsPanel = this.createBtnsPanel(listener);
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        content.add((Component)logPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        content.add((Component)btnsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 8, 4, 8), 0, 0));
        this.addWindowListener(listener);
        this.pack();
    }

    @Override
    public void show() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.show();
    }

    public void append(String text) {
        this.log.append(text);
        this.log.setCaretPosition(this.log.getDocument().getLength());
    }

    private JPanel createLogPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.log.setTabSize(3);
        this.log.setEditable(false);
        this.log.setAutoscrolls(true);
        JScrollPane scroll = new JScrollPane(this.log);
        GridBagConstraints gbc = new GridBagConstraints();
        panel.add((Component)new HeaderImagePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 1, 0));
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel.add((Component)scroll, gbc);
        return panel;
    }

    private JPanel createBtnsPanel(ActionListener listener) {
        JPanel panel = new JPanel(new BorderLayout());
        JButton cancelButton = new JButton(" Cancel ");
        cancelButton.setMargin(new Insets(5, 5, 5, 5));
        cancelButton.setActionCommand("cancel-command");
        cancelButton.addActionListener(listener);
        cancelButton.setFocusPainted(false);
        cancelButton.setBorder(BorderFactory.createBevelBorder(0));
        panel.add((Component)cancelButton, "Center");
        this.getRootPane().setDefaultButton(cancelButton);
        return panel;
    }

    public class HeaderImagePanel
    extends JPanel {
        public HeaderImagePanel() {
            this.setLayout(new GridBagLayout());
            JLabel iconLabel = new JLabel(GUIFactory.getIcon("dialog_banner2.gif"));
            iconLabel.setOpaque(false);
            iconLabel.setAlignmentX(0.0f);
            FillPanel fillPanel = new FillPanel();
            fillPanel.setBackground(Color.blue);
            this.add((Component)iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)fillPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public class FillPanel
    extends JPanel {
        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            Dimension dim = this.getSize();
            Logger.this.gp = new GradientPaint(0.0f, dim.height / 2, Logger.this.backgroundColor, dim.width, dim.height / 2, Logger.this.fadeColor);
            g2.setPaint(Logger.this.gp);
            g2.fillRect(0, 0, dim.width, dim.height);
            g2.setColor(Color.black);
        }
    }
}

