/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class ListOrderDialog
extends AlgorithmDialog {
    int result = 2;
    JList list;
    Vector data;

    public ListOrderDialog(JFrame parent, JList list, Vector data, String listTitle, String message) {
        super(parent, "List Sorter", true);
        this.list = list;
        this.data = data;
        EventListener listener = new EventListener();
        ParameterPanel parameters = new ParameterPanel(listTitle);
        list.setSelectionMode(0);
        list.setSelectedIndex(0);
        parameters.setLayout(new GridBagLayout());
        JScrollPane pane = new JScrollPane(list);
        parameters.add((Component)pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(20, 20, 20, 0), 0, 0));
        ParameterPanel buttonPanel = new ParameterPanel("Move");
        buttonPanel.setLayout(new GridBagLayout());
        JButton upButton = new JButton(GUIFactory.getIcon("arrow_up.gif"));
        upButton.setFocusPainted(false);
        upButton.setBorder(BorderFactory.createBevelBorder(0));
        upButton.setPreferredSize(new Dimension(30, 50));
        upButton.setActionCommand("shift-up-command");
        upButton.addActionListener(listener);
        JButton downButton = new JButton(GUIFactory.getIcon("arrow_down.gif"));
        downButton.setFocusPainted(false);
        downButton.setPreferredSize(new Dimension(30, 50));
        downButton.setActionCommand("shift-down-command");
        downButton.setBorder(BorderFactory.createBevelBorder(0));
        downButton.addActionListener(listener);
        buttonPanel.add((Component)upButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 20), 0, 0));
        buttonPanel.add((Component)downButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 20), 0, 0));
        parameters.add((Component)buttonPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(20, 5, 20, 20), 0, 0));
        this.addContent(parameters);
        this.setActionListeners(listener);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public Vector getSortedVector() {
        return this.data;
    }

    public static void main(String[] args) {
        Vector<String> data = new Vector<String>();
        data.add("Label1");
        data.add("Label2");
        data.add("Label3");
        JList list = new JList(data);
        ListOrderDialog dialog = new ListOrderDialog(new JFrame(), list, data, "Sample Label Keys", "Please Arrange Keys in Desired order.");
        dialog.showModal();
    }

    private class EventListener
    extends DialogListener
    implements ItemListener {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                ListOrderDialog.this.result = 0;
                ListOrderDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                ListOrderDialog.this.result = 2;
                ListOrderDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    ListOrderDialog.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(ListOrderDialog.this, "List Sorter Dialog");
                    ListOrderDialog.this.result = 2;
                } else if (command.equals("shift-up-command")) {
                    int index = ListOrderDialog.this.list.getSelectedIndex();
                    if (index == 0) {
                        return;
                    }
                    Object obj = ListOrderDialog.this.list.getSelectedValue();
                    ListOrderDialog.this.data.remove(obj);
                    ListOrderDialog.this.data.insertElementAt(obj, index - 1);
                    ListOrderDialog.this.list.setSelectedIndex(index - 1);
                } else if (command.equals("shift-down-command")) {
                    int index = ListOrderDialog.this.list.getSelectedIndex();
                    if (index == ListOrderDialog.this.data.size() - 1) {
                        return;
                    }
                    Object obj = ListOrderDialog.this.list.getSelectedValue();
                    ListOrderDialog.this.data.remove(obj);
                    ListOrderDialog.this.data.insertElementAt(obj, index + 1);
                    ListOrderDialog.this.list.setSelectedIndex(index + 1);
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ListOrderDialog.this.result = -1;
            ListOrderDialog.this.dispose();
        }
    }
}

