/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileFilter;

public class HTMLMessageFileChooser
extends JDialog {
    private JFileChooser chooser;
    private String approveString;
    private int result = 2;
    private JPanel msgPanel;
    private JButton okButton;
    private JButton cancelButton;

    public HTMLMessageFileChooser(Frame parent, String title, String msg, String filePath, boolean modal) {
        super(parent, title, modal);
        this.chooser = new JFileChooser(filePath);
        this.chooser.setMultiSelectionEnabled(false);
        this.chooser.addActionListener(new Listener());
        JTextPane pane = new JTextPane();
        pane.setEditable(false);
        pane.setContentType("text/html");
        pane.setBackground(Color.white);
        pane.setText(msg);
        this.msgPanel = new JPanel(new GridBagLayout());
        this.msgPanel.add((Component)pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 5, 10, 5), 0, 0));
        this.msgPanel.setBackground(Color.white);
        this.msgPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.add((Component)this.msgPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        contentPanel.add((Component)this.chooser, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setContentPane(contentPanel);
        this.pack();
    }

    public HTMLMessageFileChooser(Frame parent, String title, String msg, File file, boolean modal) {
        super(parent, title, modal);
        this.chooser = new JFileChooser(file);
        this.chooser.setMultiSelectionEnabled(false);
        this.chooser.addActionListener(new Listener());
        JTextPane pane = new JTextPane();
        pane.setEditable(false);
        pane.setContentType("text/html");
        pane.setBackground(Color.white);
        pane.setText(msg);
        JPanel msgPanel = new JPanel(new GridBagLayout());
        msgPanel.add((Component)pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 5, 10, 5), 0, 0));
        msgPanel.setBackground(Color.white);
        msgPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.add((Component)msgPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        contentPanel.add((Component)this.chooser, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setContentPane(contentPanel);
        this.pack();
    }

    public HTMLMessageFileChooser(Frame parent, String title, String msg, JPanel annotationPanel, boolean modal) {
        super(parent, title, modal);
        JTextPane pane = new JTextPane();
        pane.setEditable(false);
        pane.setContentType("text/html");
        pane.setBackground(Color.white);
        pane.setText(msg);
        JPanel msgPanel = new JPanel(new GridBagLayout());
        msgPanel.add((Component)pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 5, 10, 5), 0, 0));
        msgPanel.setBackground(Color.white);
        msgPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.setActionCommand("ok-command");
        this.okButton.setSize(75, 28);
        this.okButton.setPreferredSize(new Dimension(75, 28));
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(new Listener());
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand("cancel-command");
        this.cancelButton.setSize(75, 28);
        this.cancelButton.setPreferredSize(new Dimension(75, 28));
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new Listener());
        buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        buttonPanel.add((Component)this.okButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 30, 0, 0), 0, 0));
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.add((Component)msgPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)annotationPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)buttonPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setContentPane(contentPanel);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.setVisible(true);
        return this.result;
    }

    public File getSelectedFile() {
        return this.chooser.getSelectedFile();
    }

    public JFileChooser getFileChooser() {
        return this.chooser;
    }

    public void setFileFilter(FileFilter filter) {
        this.chooser.setFileFilter(filter);
    }

    public void setApproveButtonText(String s) {
        this.chooser.setApproveButtonText(s);
        this.approveString = s;
    }

    public void setPreferredMessageSize(Dimension dim) {
        this.msgPanel.setSize(dim);
        this.msgPanel.setPreferredSize(dim);
    }

    public static void main(String[] args) {
        String msg = "<html><center><h1>Append Sample Annotation</h1></center>";
        msg = msg + "A sample annotation file can be selected for import so that alternative labels or ";
        msg = msg + "additional sample information can be appended to the exsiting sample annotation.";
        msg = msg + "The file should be a tab-delimited text file containing one header row for annotation labels.";
        msg = msg + "The file may contain multiple columns of annotation with each column containing a header.";
        msg = msg + "The annotation for each sample is organized in rows corresponding to the order of the loaded samples.";
        msg = msg + "If annotation is missing for a sample the entry in that sample row can be left blank.";
        HTMLMessageFileChooser mfc = new HTMLMessageFileChooser(new Frame(), "Test Dialog", msg, "C:/Temp", true);
        mfc.setSize(new Dimension(500, 600));
        mfc.showModal();
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String cmd = ae.getActionCommand();
            if (cmd.equals("ApproveSelection")) {
                HTMLMessageFileChooser.this.result = 0;
                HTMLMessageFileChooser.this.dispose();
            } else if (cmd.equals("CancelSelection")) {
                HTMLMessageFileChooser.this.result = 1;
                HTMLMessageFileChooser.this.dispose();
            } else if (cmd.equalsIgnoreCase("ok-command")) {
                HTMLMessageFileChooser.this.result = 0;
                HTMLMessageFileChooser.this.dispose();
            } else if (cmd.equalsIgnoreCase("cancel-command")) {
                HTMLMessageFileChooser.this.result = 2;
                HTMLMessageFileChooser.this.dispose();
            }
        }
    }
}

