/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.IWizardParameterPanel;

public class GroupSelectionColorPanel
extends JPanel
implements IWizardParameterPanel {
    private String[] groups;
    private String[] factors;
    private String[] samples;
    private String selectedGroupName;
    private Vector assignmentButtons;
    private Vector sampleGroupFields;
    private JPanel selectionPanel;
    private String groupLabelStr = "Current Group to Assign:  ";
    private Font labelFont;
    private AlgorithmData algData;
    private JComboBox groupBox;
    private boolean toggleClickSelection;
    private JLabel toggleLabel;
    private JLabel groupBoxLabel;
    private Color foregroundColor;
    private Color disabledForegroundColor;
    private Listener listener;

    public GroupSelectionColorPanel() {
        super(new GridBagLayout());
        this.toggleClickSelection = true;
        this.foregroundColor = UIManager.getColor("Label.foreground");
        this.disabledForegroundColor = UIManager.getColor("Label.disabledForeground");
    }

    public GroupSelectionColorPanel(AlgorithmData parameters) {
        super(new GridBagLayout());
        this.algData = parameters;
        this.toggleClickSelection = true;
        this.foregroundColor = UIManager.getColor("Label.foreground");
        this.disabledForegroundColor = UIManager.getColor("Label.disabledForeground");
    }

    public GroupSelectionColorPanel(AlgorithmData parameters, String[] groupNames, String[] sampleNames) {
        super(new GridBagLayout());
        this.algData = parameters;
        this.groups = groupNames;
        this.samples = sampleNames;
        this.listener = new Listener();
        this.selectedGroupName = this.groups[0];
        this.toggleClickSelection = true;
        this.foregroundColor = UIManager.getColor("Label.foreground");
        this.disabledForegroundColor = UIManager.getColor("Label.disabledForeground");
        Color[] groupColors = new Color[]{Color.BLUE, Color.YELLOW, Color.GRAY};
        this.assignmentButtons = this.buildAssignmentButtons(sampleNames.length, this.groups, groupColors);
        this.labelFont = new JButton().getFont();
        this.sampleGroupFields = this.buildSampleGroupFields(sampleNames.length, this.labelFont);
        JPanel groupSelectionPanel = this.buildGroupPanelForComboBox("Select Group", "Current Group to Assign:  ", groupNames, this.listener);
        this.selectionPanel = this.buildSelectionPanel(this.assignmentButtons, this.sampleGroupFields);
        this.add((Component)groupSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.selectionPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.buildButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void initializeOneFactor(String[] groupNames, String[] sampleNames) {
        this.removeAll();
        this.groups = groupNames;
        this.samples = sampleNames;
        this.listener = new Listener();
        this.selectedGroupName = this.groups[0];
        Color[] groupColors = new Color[]{Color.BLUE, Color.YELLOW, Color.RED, Color.CYAN, Color.ORANGE, Color.MAGENTA, Color.GREEN, Color.LIGHT_GRAY, Color.PINK, Color.GRAY, Color.BLACK, Color.WHITE, new Color(185, 243, 244), new Color(81, 158, 196), new Color(172, 206, 70), new Color(255, 128, 128), new Color(128, 64, 0), new Color(128, 128, 64), new Color(128, 128, 92), new Color(119, 0, 176)};
        this.assignmentButtons = this.buildAssignmentButtons(this.samples.length, this.groups, groupColors);
        this.labelFont = new JButton().getFont();
        this.sampleGroupFields = this.buildSampleFields(sampleNames, this.labelFont);
        JPanel instructionPanel = this.buildInstructionPanel(groupNames, this.listener);
        this.selectionPanel = this.buildSelectionPanel(this.assignmentButtons, this.sampleGroupFields);
        this.add((Component)instructionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.selectionPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.buildButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        if (this.groups.length > 1) {
            this.selectedGroupName = this.groups[1];
        }
        this.validate();
    }

    private JPanel constructHeader(JPanel lowerPanel) {
        JPanel header = new JPanel(new GridBagLayout());
        Component comp = lowerPanel.getComponent(0);
        JLabel label = new JLabel("<html><u>Sample</u></html>");
        label.setHorizontalAlignment(0);
        header.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        comp = lowerPanel.getComponent(1);
        label = new JLabel("<html><u>Assignment</u></html>");
        label.setHorizontalAlignment(0);
        header.add((Component)label, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        return header;
    }

    public void adjustSizeToResolution() {
        int i;
        int maxSampleWidth = 0;
        int maxGroupWidth = 0;
        FontMetrics metrics = this.getGraphics().getFontMetrics();
        for (i = 0; i < this.groups.length; ++i) {
            maxGroupWidth = Math.max(maxGroupWidth, metrics.stringWidth(this.groups[i]));
        }
        for (i = 0; i < this.samples.length; ++i) {
            maxSampleWidth = Math.max(maxSampleWidth, metrics.stringWidth(this.samples[i]));
        }
        for (i = 0; i < this.assignmentButtons.size(); ++i) {
            ((JButton)this.assignmentButtons.get(i)).setPreferredSize(new Dimension(maxSampleWidth + 50, 35));
        }
        for (i = 0; i < this.sampleGroupFields.size(); ++i) {
            ((JLabel)this.sampleGroupFields.get(i)).setPreferredSize(new Dimension(maxGroupWidth + 50, 35));
        }
        Toolkit toolKit = Toolkit.getDefaultToolkit();
        int h = (int)(0.7f * (float)toolKit.getScreenSize().height);
        int w = Math.max(maxGroupWidth + maxSampleWidth + 150, 350);
        int groupPanelWidth = metrics.stringWidth(this.groupLabelStr) + 30 + maxGroupWidth + 50;
        w = Math.max(w, groupPanelWidth);
        this.setPreferredSize(new Dimension(w, h));
        this.setSize(new Dimension(w, h));
    }

    @Override
    public void onDisplayed() {
        this.adjustSizeToResolution();
    }

    private Vector buildAssignmentButtons(int numSamples, String[] groupNames, Color[] groupColors) {
        Vector<ToggleColorButton> buttons = new Vector<ToggleColorButton>(numSamples);
        for (int i = 0; i < numSamples; ++i) {
            ToggleColorButton button = new ToggleColorButton(groupNames, groupColors, 0);
            button.setFocusPainted(false);
            button.setBorder(BorderFactory.createBevelBorder(0));
            button.setToolTipText("Click to toggle assignment.");
            buttons.add(button);
        }
        return buttons;
    }

    private Vector buildSampleGroupFields(int count, Font groupFont) {
        Vector<JTextField> fields = new Vector<JTextField>(count);
        for (int i = 0; i < count; ++i) {
            JTextField field = new JTextField(this.selectedGroupName);
            field.setEditable(false);
            field.setFont(groupFont);
            if (i % 2 == 0) {
                field.setBackground(Color.lightGray);
            }
            fields.add(field);
        }
        return fields;
    }

    private Vector buildSampleFields(String[] sampleNames, Font groupFont) {
        Vector<JLabel> fields = new Vector<JLabel>(sampleNames.length);
        for (int i = 0; i < sampleNames.length; ++i) {
            JLabel label = new JLabel(sampleNames[i] + " : ");
            label.setFont(groupFont);
            label.setHorizontalAlignment(0);
            label.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            fields.add(label);
        }
        return fields;
    }

    private JPanel buildGroupPanel(String[] groupNames, Listener listener) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Select Group"));
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < groupNames.length; ++i) {
            JRadioButton button = new JRadioButton(groupNames[i]);
            bg.add(button);
            button.setOpaque(false);
            button.setFocusPainted(false);
            if (i == 1) {
                button.setSelected(true);
            }
            button.addActionListener(listener);
            panel.add((Component)button, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 0, 2, 0), 0, 0));
        }
        return panel;
    }

    private JPanel buildGroupPanelForComboBox(String panelTitle, String labelTitle, String[] groupNames, Listener listener) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), panelTitle));
        JComboBox<String> box = new JComboBox<String>(groupNames);
        if (this.groups.length > 1) {
            box.setSelectedIndex(1);
        }
        box.addActionListener(listener);
        JLabel label = new JLabel(labelTitle);
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 0, 2, 0), 0, 0));
        panel.add(box, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 0, 2, 0), 0, 0));
        return panel;
    }

    private JPanel buildInstructionPanel(String[] groupNames, Listener listener) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Selection Instructions"));
        ButtonGroup bg = new ButtonGroup();
        JRadioButton toggleButton = new JRadioButton("Toggle Group Assignments", true);
        toggleButton.setOpaque(false);
        toggleButton.setActionCommand("set-toggle-mode-command");
        toggleButton.addActionListener(listener);
        bg.add(toggleButton);
        String text = "<html><font color=black>Left or right click on the assignment button to the right of the sample to toggle the selected assignment.</font></html>";
        this.toggleLabel = new JLabel(text);
        panel.add((Component)toggleButton, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        panel.add((Component)this.toggleLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(5, 40, 5, 10), 0, 0));
        JRadioButton menuButton = new JRadioButton("Single Click Selection");
        menuButton.setOpaque(false);
        menuButton.setActionCommand("set-menu-mode-command");
        menuButton.addActionListener(listener);
        bg.add(menuButton);
        panel.add((Component)menuButton, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.groupBox = new JComboBox<String>(groupNames);
        if (this.groups.length > 1) {
            this.groupBox.setSelectedIndex(1);
        }
        this.groupBox.addActionListener(listener);
        this.groupBox.setEnabled(false);
        this.groupBoxLabel = new JLabel("Current Group Selection:");
        this.groupBoxLabel.setEnabled(false);
        panel.add((Component)this.groupBoxLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 10, 10, 0), 0, 0));
        panel.add((Component)this.groupBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 10, 10), 0, 0));
        return panel;
    }

    private JPanel buildSelectionPanel(Vector sampleButtons, Vector sampleLabels) {
        JPanel panel = new JPanel(new GridBagLayout());
        for (int i = 0; i < sampleButtons.size(); ++i) {
            panel.add((Component)sampleLabels.get(i), new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 0, 2, 0), 0, 0));
            panel.add((Component)sampleButtons.get(i), new GridBagConstraints(1, i, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 0, 2, 0), 0, 0));
        }
        JScrollPane pane = new JScrollPane(panel);
        JPanel scrollPanel = new JPanel(new GridBagLayout());
        scrollPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Select Samples in Group"));
        scrollPanel.add((Component)pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        pane.setColumnHeaderView(this.constructHeader(panel));
        return scrollPanel;
    }

    public JPanel buildButtonPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Save/Load Group File"));
        JPanel toReturn = new JPanel();
        toReturn.setLayout(new BoxLayout(toReturn, 0));
        Dimension dButton = new Dimension(150, 20);
        String title = "Load 'n Save Assignments";
        Border greyLine = BorderFactory.createLineBorder(Color.black, 1);
        TitledBorder border = BorderFactory.createTitledBorder(greyLine, title, 4, 2);
        toReturn.setBorder(border);
        JButton loadButton = new JButton("Load Assignments");
        loadButton.setPreferredSize(dButton);
        loadButton.setActionCommand("load-groupings-command");
        loadButton.addActionListener(this.listener);
        JButton saveButton = new JButton("Save Assignments");
        saveButton.setPreferredSize(dButton);
        saveButton.setActionCommand("save-groupings-command");
        saveButton.addActionListener(this.listener);
        toReturn.add(Box.createHorizontalGlue());
        toReturn.add(saveButton);
        toReturn.add(Box.createRigidArea(new Dimension(50, 20)));
        toReturn.add(loadButton);
        toReturn.add(Box.createHorizontalGlue());
        return toReturn;
    }

    private void saveAssignments() {
        JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
        if (fileChooser.showSaveDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                PrintWriter pw = new PrintWriter(new FileWriter(file));
                Date currDate = new Date(System.currentTimeMillis());
                String dateString = currDate.toString();
                String userName = System.getProperty("user.name");
                pw.println("# Assignment File");
                pw.println("# User: " + userName + " Save Date: " + dateString);
                pw.println("#");
                pw.print("Module:\t");
                pw.println("NONPAR");
                for (int i = 0; i < this.groups.length - 1; ++i) {
                    pw.print("Group " + String.valueOf(i + 1) + " Label:\t");
                    pw.println(this.groups[i]);
                }
                pw.println("#");
                pw.println("Sample Index\tSample Name\tGroup Assignment");
                for (int sample = 0; sample < this.samples.length; ++sample) {
                    pw.print(String.valueOf(sample + 1) + "\t");
                    pw.print(this.samples[sample] + "\t");
                    pw.println(((JButton)this.assignmentButtons.get(sample)).getText());
                }
                pw.flush();
                pw.close();
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void loadAssignments() {
        JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
        if (fileChooser.showOpenDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                int i;
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                Vector<String> data = new Vector<String>();
                while ((line = br.readLine()) != null) {
                    data.add(line.trim());
                }
                br.close();
                Vector<String> groupNames = new Vector<String>();
                Vector<Integer> sampleIndices = new Vector<Integer>();
                Vector<String> sampleNames = new Vector<String>();
                Vector<String> groupAssignments = new Vector<String>();
                String status = "OK";
                boolean validData = true;
                for (int row = 0; row < data.size(); ++row) {
                    line = (String)data.get(row);
                    if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                    String[] lineArray = line.split("\t");
                    if (lineArray[0].startsWith("Module:")) {
                        if (lineArray[1].equals("NONPAR")) continue;
                        Object[] optionst = new Object[]{"Continue", "Cancel"};
                        if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                        return;
                    }
                    if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                        groupNames.add(lineArray[1]);
                        continue;
                    }
                    try {
                        Integer.parseInt(lineArray[0]);
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                    sampleIndices.add(new Integer(lineArray[0]));
                    sampleNames.add(lineArray[1]);
                    groupAssignments.add(lineArray[2]);
                }
                if (this.samples.length != sampleNames.size()) {
                    status = "number-of-samples-mismatch";
                    System.out.println(this.samples.length + " s length " + sampleNames.size());
                    JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + this.samples.length + ").<br>" + "Assingments are not set.</html>", "File Compatibility Error", 0);
                    return;
                }
                if (this.groups.length != groupNames.size() + 1) {
                    status = "number-of-groups-mismatch";
                    System.out.println(this.groups.length + " g length " + groupNames.size());
                    JOptionPane.showMessageDialog(this, "<html>Error -- number of groups designated in assignment file (" + String.valueOf(groupNames.size()) + ")<br>" + "does not match the number of groups specified in previous step (" + String.valueOf(this.groups.length - 1) + ").<br>" + "Assingments are not set.</html>", "File Compatibility Error", 0);
                    return;
                }
                Vector<String> currSampleVector = new Vector<String>();
                for (i = 0; i < this.samples.length; ++i) {
                    currSampleVector.add(this.samples[i]);
                }
                for (i = 0; i < groupNames.size(); ++i) {
                    this.groups[i] = (String)groupNames.get(i);
                }
                int fileSampleIndex = 0;
                int groupIndex = 0;
                for (int sample = 0; sample < this.samples.length; ++sample) {
                    fileSampleIndex = sampleNames.indexOf(this.samples[sample]);
                    String groupName = (String)groupAssignments.get(fileSampleIndex);
                    groupIndex = groupNames.indexOf(groupName);
                    ToggleColorButton button = (ToggleColorButton)this.assignmentButtons.get(sample);
                    button.setStateNames(this.groups);
                    if (groupIndex != -1) {
                        button.setState(groupIndex);
                        continue;
                    }
                    button.setState(this.groups.length - 1);
                }
                this.repaint();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        String[] groups = new String[]{"Control", "Treated", "Treated 1", "Treated 2", "Treated 3", "Treated 4", "Treated 5", "Exclude"};
        String[] sampleNames = new String[]{"Sample_1.txt", "Sample_2.txt", "Sample_3.txt", "Sample_4.txt", "Sample_5.txt", "Sample_6.txt", "Sample_7.txt", "Sample_8.txt", "Sample_9.txt", "Sample_10.txt", "Sample_11.txt", "Sample_12.txt", "Sample_13.txt", "Sample_14.txt", "Sample_15.txt", "Sample_16.txt", "Sample_17.txt", "Sample_18.txt", "Sample_19.txt", "Sample_20.txt", "Sample_21.txt", "Sample_22.txt", "Sample_23.txt", "Sample_24.txt", "Sample_25.txt", "Sample_26.txt", "Sample_27.txt", "Sample_28.txt", "Sample_29.txt", "Sample_30.txt"};
        if (args.length > 0) {
            int i;
            int groupCnt = Integer.parseInt(args[0]);
            int sampleCnt = Integer.parseInt(args[1]);
            groups = new String[groupCnt];
            sampleNames = new String[sampleCnt];
            for (i = 0; i < groupCnt; ++i) {
                groups[i] = "group_" + String.valueOf(i + 1);
            }
            for (i = 0; i < sampleCnt; ++i) {
                sampleNames[i] = "sample_" + String.valueOf(i + 1);
            }
        }
        String[] factors = new String[]{"Factor 1", "Factor 2"};
        GroupSelectionColorPanel d = new GroupSelectionColorPanel();
        d.initializeOneFactor(groups, sampleNames);
        JFrame frame = new JFrame();
        frame.getContentPane().add(d);
        frame.setLocation(500, 200);
        frame.setVisible(true);
        d.adjustSizeToResolution();
        frame.setSize(d.getPreferredSize());
    }

    @Override
    public void populateAlgorithmData() {
        int i;
        int[] groupAssignments = new int[this.sampleGroupFields.size()];
        Vector<String> groupNamesVector = new Vector<String>(this.groups.length);
        for (i = 0; i < this.groups.length; ++i) {
            groupNamesVector.add(this.groups[i]);
        }
        for (i = 0; i < this.assignmentButtons.size(); ++i) {
            String groupName = ((JButton)this.assignmentButtons.get(i)).getText();
            groupAssignments[i] = groupName.equals("Exclude") ? -1 : groupNamesVector.indexOf(groupName);
        }
        this.algData.addIntArray("group-assignments", groupAssignments);
    }

    @Override
    public void clearValuesFromAlgorithmData() {
        this.algData.getParams().getMap().remove("group-assignments");
    }

    public class ToggleColorButton
    extends JButton {
        String[] titles;
        Color[] colors;
        int state;
        int numStates;
        boolean forward;
        boolean toggleMode;

        public ToggleColorButton(String[] titles, Color[] colorStates, int initialState) {
            super(titles[initialState]);
            this.setLayout(new GridBagLayout());
            this.forward = true;
            this.toggleMode = true;
            this.colors = colorStates;
            this.titles = titles;
            this.state = initialState;
            this.numStates = titles.length;
            this.setIconTextGap(50);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent me) {
                    ToggleColorButton.this.forward = !me.isPopupTrigger();
                    ToggleColorButton.this.toggleState();
                }
            });
        }

        public void toggleState() {
            if (GroupSelectionColorPanel.this.toggleClickSelection) {
                if (this.forward) {
                    ++this.state;
                    this.state %= this.numStates;
                } else {
                    --this.state;
                    if (this.state == -1) {
                        this.state = this.numStates - 1;
                    }
                }
            } else {
                this.state = GroupSelectionColorPanel.this.groupBox.getSelectedIndex();
            }
            this.setText(this.titles[this.state]);
            this.validate();
            this.repaint();
        }

        public void setStateNames(String[] groupNames) {
            this.titles = groupNames;
        }

        public void setState(int s) {
            this.state = s;
            this.setText(this.titles[this.state]);
            this.validate();
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.state != this.numStates - 1) {
                g.setColor(this.colors[this.state]);
                g.fillRect(8, 5, this.getHeight() - 10, this.getHeight() - 10);
                g.setColor(Color.black);
                g.drawRect(8, 5, this.getHeight() - 10, this.getHeight() - 10);
                g.drawRect(9, 6, this.getHeight() - 12, this.getHeight() - 12);
            }
        }
    }

    public class Listener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            String command = e.getActionCommand();
            if (source instanceof JButton) {
                if (command.equals("load-groupings-command")) {
                    GroupSelectionColorPanel.this.loadAssignments();
                } else if (command.equals("save-groupings-command")) {
                    GroupSelectionColorPanel.this.saveAssignments();
                }
            } else if (command.equals("set-toggle-mode-command")) {
                GroupSelectionColorPanel.this.toggleClickSelection = true;
                String text = "<html>Left or right click on the assignment button to the right of the sample to toggle the selected assignment.</html>";
                GroupSelectionColorPanel.this.toggleLabel.setForeground(GroupSelectionColorPanel.this.foregroundColor);
                GroupSelectionColorPanel.this.toggleLabel.setText(text);
                GroupSelectionColorPanel.this.groupBox.setEnabled(false);
                GroupSelectionColorPanel.this.groupBoxLabel.setEnabled(false);
            } else if (command.equals("set-menu-mode-command")) {
                GroupSelectionColorPanel.this.toggleClickSelection = false;
                String text = "<html>Left or right click on the assignment button to the right of the sample to toggle the selected assignment.</html>";
                GroupSelectionColorPanel.this.toggleLabel.setForeground(GroupSelectionColorPanel.this.disabledForegroundColor);
                GroupSelectionColorPanel.this.toggleLabel.setText(text);
                GroupSelectionColorPanel.this.groupBox.setEnabled(true);
                GroupSelectionColorPanel.this.groupBoxLabel.setEnabled(true);
            } else {
                GroupSelectionColorPanel.this.selectedGroupName = (String)((JComboBox)source).getSelectedItem();
            }
        }
    }
}

