/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.IWizardParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.StatProcessWizard;

public class GroupNumberAndNameSelectionPanel
extends JPanel
implements IWizardParameterPanel {
    private boolean isOneFactor;
    private boolean isVarGroupCount;
    private AlgorithmData algData;
    private JTextField[] groupNameFields;
    private JTextField countField;
    private JTextField countAField;
    private JTextField countBField;
    protected Vector textFieldVector;
    private Vector factorATextFieldVector;
    private Vector factorBTextFieldVector;
    private JTextField factorAField;
    private JTextField factorBField;
    private JPanel factorANamePanel;
    private JPanel factorBNamePanel;
    private JPanel groupNamePanel;
    private int minGroupCnt;
    private Listener listener;
    private StatProcessWizard wiz;
    private JSpinner factorALevelCountSpinner;
    private JSpinner factorBLevelCountSpinner;
    private int currFactorACount;
    private int currFactorBCount;
    private boolean mevWhiteBackground;

    public GroupNumberAndNameSelectionPanel(boolean whiteBackground) {
        super(new GridBagLayout());
        this.listener = new Listener();
        this.mevWhiteBackground = whiteBackground;
        this.factorALevelCountSpinner = new JSpinner(new SpinnerNumberModel(2, 2, 20, 1));
        this.factorALevelCountSpinner.addChangeListener(this.listener);
        this.factorBLevelCountSpinner = new JSpinner(new SpinnerNumberModel(2, 2, 20, 1));
        this.factorBLevelCountSpinner.addChangeListener(this.listener);
    }

    public GroupNumberAndNameSelectionPanel(AlgorithmData paramData, StatProcessWizard w, boolean whiteBackground) {
        super(new GridBagLayout());
        this.algData = paramData;
        this.wiz = w;
        this.mevWhiteBackground = whiteBackground;
        this.listener = new Listener();
        this.factorALevelCountSpinner = new JSpinner(new SpinnerNumberModel(2, 2, 20, 1));
        this.factorALevelCountSpinner.addChangeListener(this.listener);
        this.factorBLevelCountSpinner = new JSpinner(new SpinnerNumberModel(2, 2, 20, 1));
        this.factorBLevelCountSpinner.addChangeListener(this.listener);
    }

    public GroupNumberAndNameSelectionPanel(boolean isOneFactor, boolean isVariableGroupCount, int minNumGroups, AlgorithmData paramData, StatProcessWizard w, boolean whiteBackground) {
        super(new GridBagLayout());
        this.mevWhiteBackground = whiteBackground;
        this.initialize(isOneFactor, this.isVarGroupCount, minNumGroups);
        this.algData = paramData;
        this.wiz = w;
        this.currFactorACount = this.currFactorBCount = minNumGroups;
        this.minGroupCnt = minNumGroups;
        this.listener = new Listener();
        this.factorALevelCountSpinner = new JSpinner(new SpinnerNumberModel(2, 2, 20, 1));
        this.factorALevelCountSpinner.addChangeListener(this.listener);
        this.factorBLevelCountSpinner = new JSpinner(new SpinnerNumberModel(2, 2, 20, 1));
        this.factorBLevelCountSpinner.addChangeListener(this.listener);
    }

    private void initialize() {
        this.initialize(this.isOneFactor, this.isVarGroupCount, this.minGroupCnt);
    }

    public void initialize(boolean isOneFactor, boolean isVariableGroupCount, int minNumGroups) {
        this.removeAll();
        this.textFieldVector = new Vector();
        this.isOneFactor = isOneFactor;
        this.isVarGroupCount = isVariableGroupCount;
        this.currFactorACount = this.currFactorBCount = minNumGroups;
        this.minGroupCnt = minNumGroups;
        this.factorALevelCountSpinner.setValue(new Integer(minNumGroups));
        this.factorBLevelCountSpinner.setValue(new Integer(minNumGroups));
        if (!isOneFactor) {
            this.initTwoFactorPanel();
        } else {
            this.initOneFactorPanel();
        }
        this.validate();
    }

    private void initOneFactorPanel() {
        this.removeAll();
        if (this.mevWhiteBackground) {
            this.setBackground(Color.white);
        }
        this.textFieldVector = new Vector();
        this.groupNamePanel = new JPanel(new GridBagLayout());
        this.groupNamePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Select Group Names"));
        if (this.mevWhiteBackground) {
            this.groupNamePanel.setBackground(Color.white);
        }
        if (this.isVarGroupCount) {
            JPanel groupCountPanel = new JPanel(new GridBagLayout());
            groupCountPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Select Number of Groups"));
            if (this.mevWhiteBackground) {
                groupCountPanel.setBackground(Color.white);
            }
            JLabel countLabel = new JLabel("Number of Groups:");
            countLabel.setOpaque(false);
            this.countField = new JTextField(String.valueOf(this.minGroupCnt));
            JButton countUpdateButton = new JButton("Update Count");
            countUpdateButton.addActionListener(this.listener);
            groupCountPanel.add((Component)countLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 5), 0, 0));
            groupCountPanel.add((Component)this.factorALevelCountSpinner, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 5), 0, 0));
            for (int i = 0; i < this.currFactorACount; ++i) {
                JLabel group1Label = new JLabel("Group " + String.valueOf(i + 1) + " Name:");
                group1Label.setOpaque(false);
                group1Label.setPreferredSize(new Dimension(100, 25));
                group1Label.setMinimumSize(new Dimension(100, 25));
                group1Label.setMaximumSize(new Dimension(100, 25));
                JTextField group1Field = new JTextField("Group " + String.valueOf(i + 1));
                group1Field.setPreferredSize(new Dimension(100, 25));
                group1Field.setMinimumSize(new Dimension(100, 25));
                group1Field.setMaximumSize(new Dimension(100, 25));
                this.groupNamePanel.add((Component)group1Label, new GridBagConstraints(0, i, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 15, 5, 10), 0, 0));
                this.groupNamePanel.add((Component)group1Field, new GridBagConstraints(1, i, 1, 1, 1.0, 1.0, 10, 2, new Insets(10, 0, 5, 10), 0, 0));
                this.textFieldVector.add(group1Field);
            }
            this.add((Component)groupCountPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.groupNamePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            JLabel group1Label = new JLabel("Group 1 Name:");
            group1Label.setOpaque(false);
            JLabel group2Label = new JLabel("Group 2 Name:");
            group2Label.setOpaque(false);
            JTextField group1Field = new JTextField("Group 1");
            JTextField group2Field = new JTextField("Group 2");
            this.textFieldVector.add(group1Field);
            this.textFieldVector.add(group2Field);
            this.groupNamePanel.add((Component)group1Label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 15, 25, 10), 0, 0));
            this.groupNamePanel.add((Component)group1Field, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 25, 15), 0, 0));
            this.groupNamePanel.add((Component)group2Label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 20, 10), 0, 0));
            this.groupNamePanel.add((Component)group2Field, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 20, 15), 0, 0));
            this.add((Component)this.groupNamePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private void initTwoFactorPanel() {
        this.removeAll();
        JLabel factorALabel = new JLabel("Factor A Name:");
        this.factorAField = new JTextField("Factor A");
        this.factorAField.setPreferredSize(new Dimension(100, 25));
        this.factorAField.setMinimumSize(new Dimension(100, 25));
        this.factorAField.setMaximumSize(new Dimension(100, 25));
        JLabel factorBLabel = new JLabel("Factor B Name:");
        this.factorBField = new JTextField("Factor B");
        this.factorBField.setPreferredSize(new Dimension(100, 25));
        this.factorBField.setMinimumSize(new Dimension(100, 25));
        this.factorBField.setMaximumSize(new Dimension(100, 25));
        this.factorATextFieldVector = new Vector();
        this.factorBTextFieldVector = new Vector();
        this.factorANamePanel = new JPanel(new GridBagLayout());
        this.factorANamePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Factor A Level Names"));
        JPanel factorACountPanel = new JPanel(new GridBagLayout());
        factorACountPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Factor A"));
        JLabel countLabel = new JLabel("Number of Levels:");
        this.countAField = new JTextField(String.valueOf(this.minGroupCnt));
        JButton countUpdateButton = new JButton("Update Count");
        countUpdateButton.setActionCommand("factor-A-count-update-command");
        countUpdateButton.addActionListener(this.listener);
        factorACountPanel.add((Component)factorALabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 5), 0, 0));
        factorACountPanel.add((Component)this.factorAField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 5), 0, 0));
        factorACountPanel.add((Component)countLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 5), 0, 0));
        factorACountPanel.add((Component)this.factorALevelCountSpinner, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 5), 0, 0));
        for (int i = 0; i < this.currFactorACount; ++i) {
            JLabel group1Label = new JLabel("Level " + String.valueOf(i + 1) + " Name:");
            group1Label.setPreferredSize(new Dimension(150, 25));
            group1Label.setMinimumSize(new Dimension(150, 25));
            group1Label.setMaximumSize(new Dimension(150, 25));
            group1Label.setOpaque(false);
            JTextField group1Field = new JTextField("Level " + String.valueOf(i + 1));
            group1Field.setPreferredSize(new Dimension(100, 25));
            group1Field.setMinimumSize(new Dimension(100, 25));
            group1Field.setMaximumSize(new Dimension(100, 25));
            this.factorANamePanel.add((Component)group1Label, new GridBagConstraints(0, i, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 5), 0, 0));
            this.factorANamePanel.add((Component)group1Field, new GridBagConstraints(1, i, 1, 1, 1.0, 1.0, 10, 2, new Insets(10, 0, 5, 10), 0, 0));
            this.factorATextFieldVector.add(group1Field);
        }
        this.factorBNamePanel = new JPanel(new GridBagLayout());
        this.factorBNamePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Factor B Level Names"));
        JPanel factorBCountPanel = new JPanel(new GridBagLayout());
        factorBCountPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Factor B"));
        countLabel = new JLabel("Number of Levels:");
        this.countBField = new JTextField(String.valueOf(this.minGroupCnt));
        countUpdateButton = new JButton("Update Count");
        countUpdateButton.setActionCommand("factor-B-count-update-command");
        countUpdateButton.addActionListener(this.listener);
        factorBCountPanel.add((Component)factorBLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 5), 0, 0));
        factorBCountPanel.add((Component)this.factorBField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 5), 0, 0));
        factorBCountPanel.add((Component)countLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 5), 0, 0));
        factorBCountPanel.add((Component)this.factorBLevelCountSpinner, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 5), 0, 0));
        for (int i = 0; i < this.currFactorBCount; ++i) {
            JLabel group1Label = new JLabel("Level " + String.valueOf(i + 1) + " Name:");
            group1Label.setPreferredSize(new Dimension(150, 25));
            group1Label.setMinimumSize(new Dimension(150, 25));
            group1Label.setMaximumSize(new Dimension(150, 25));
            group1Label.setOpaque(false);
            JTextField group1Field = new JTextField("Level " + String.valueOf(i + 1));
            group1Field.setPreferredSize(new Dimension(100, 25));
            group1Field.setMinimumSize(new Dimension(100, 25));
            group1Field.setMaximumSize(new Dimension(100, 25));
            this.factorBNamePanel.add((Component)group1Label, new GridBagConstraints(0, i, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 5), 0, 0));
            this.factorBNamePanel.add((Component)group1Field, new GridBagConstraints(1, i, 1, 1, 1.0, 1.0, 10, 2, new Insets(10, 0, 5, 10), 0, 0));
            this.factorBTextFieldVector.add(group1Field);
        }
        if (this.mevWhiteBackground) {
            factorACountPanel.setBackground(Color.white);
            this.factorANamePanel.setBackground(Color.white);
            factorBCountPanel.setBackground(Color.white);
            this.factorBNamePanel.setBackground(Color.white);
        }
        this.add((Component)factorACountPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.factorANamePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)factorBCountPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.factorBNamePanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private void updatePanel() {
        this.currFactorACount = (Integer)this.factorALevelCountSpinner.getValue();
        this.currFactorBCount = (Integer)this.factorBLevelCountSpinner.getValue();
        this.initOneFactorPanel();
        this.validate();
        if (this.wiz != null) {
            this.wiz.updateWizard();
        }
    }

    @Override
    public void populateAlgorithmData() {
        if (this.isOneFactor) {
            String[] groupNames = new String[this.textFieldVector.size() + 1];
            for (int i = 0; i < groupNames.length - 1; ++i) {
                groupNames[i] = ((JTextField)this.textFieldVector.get(i)).getText();
            }
            groupNames[groupNames.length - 1] = "Exclude";
            this.algData.addStringArray("group-names", groupNames);
        } else {
            int i;
            this.algData.addParam("factor-A-name", this.factorAField.getText());
            this.algData.addParam("factor-B-name", this.factorBField.getText());
            String[] factorLabels = new String[this.factorATextFieldVector.size()];
            for (i = 0; i < this.factorATextFieldVector.size(); ++i) {
                factorLabels[i] = ((JTextField)this.factorATextFieldVector.get(i)).getText();
            }
            this.algData.addStringArray("factor-A-level-names", factorLabels);
            factorLabels = new String[this.factorBTextFieldVector.size()];
            for (i = 0; i < this.factorBTextFieldVector.size(); ++i) {
                factorLabels[i] = ((JTextField)this.factorBTextFieldVector.get(i)).getText();
            }
            this.algData.addStringArray("factor-B-level-names", factorLabels);
        }
    }

    @Override
    public void clearValuesFromAlgorithmData() {
        this.algData.getParams().getMap().remove("factor-A-name");
        this.algData.getParams().getMap().remove("factor-B-name");
        this.algData.getParams().getMap().remove("factor-A-level-names");
        this.algData.getParams().getMap().remove("factor-B-level-names");
    }

    @Override
    public void onDisplayed() {
        if (this.wiz != null) {
            this.wiz.updateWizard();
        }
    }

    public void updateTwoFactorPanel(int panelIndex, int numFields) {
        if (panelIndex == 0) {
            this.remove(this.factorANamePanel);
            this.factorATextFieldVector = new Vector();
            this.factorANamePanel = new JPanel(new GridBagLayout());
            this.factorANamePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Factor A Level Names"));
            for (int i = 0; i < numFields; ++i) {
                JLabel group1Label = new JLabel("Level " + String.valueOf(i + 1) + " Name:");
                group1Label.setPreferredSize(new Dimension(150, 25));
                group1Label.setMinimumSize(new Dimension(150, 25));
                group1Label.setMaximumSize(new Dimension(150, 25));
                JTextField group1Field = new JTextField("Level " + String.valueOf(i + 1));
                group1Field.setPreferredSize(new Dimension(100, 25));
                group1Field.setMinimumSize(new Dimension(100, 25));
                group1Field.setMaximumSize(new Dimension(100, 25));
                this.factorANamePanel.add((Component)group1Label, new GridBagConstraints(0, i, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 5), 0, 0));
                this.factorANamePanel.add((Component)group1Field, new GridBagConstraints(1, i, 1, 1, 1.0, 1.0, 10, 2, new Insets(10, 0, 5, 10), 0, 0));
                this.factorATextFieldVector.add(group1Field);
            }
            this.add((Component)this.factorANamePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        } else {
            this.remove(this.factorBNamePanel);
            this.factorBTextFieldVector = new Vector();
            this.factorBNamePanel = new JPanel(new GridBagLayout());
            this.factorBNamePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Factor B Level Names"));
            for (int i = 0; i < numFields; ++i) {
                JLabel group1Label = new JLabel("Level " + String.valueOf(i + 1) + " Name:");
                group1Label.setPreferredSize(new Dimension(150, 25));
                group1Label.setMinimumSize(new Dimension(150, 25));
                group1Label.setMaximumSize(new Dimension(150, 25));
                JTextField group1Field = new JTextField("Level " + String.valueOf(i + 1));
                group1Field.setPreferredSize(new Dimension(100, 25));
                group1Field.setMinimumSize(new Dimension(100, 25));
                group1Field.setMaximumSize(new Dimension(100, 25));
                this.factorBNamePanel.add((Component)group1Label, new GridBagConstraints(0, i, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 5), 0, 0));
                this.factorBNamePanel.add((Component)group1Field, new GridBagConstraints(1, i, 1, 1, 1.0, 1.0, 10, 2, new Insets(10, 0, 5, 10), 0, 0));
                this.factorBTextFieldVector.add(group1Field);
            }
            this.add((Component)this.factorBNamePanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        }
        this.validate();
        if (this.wiz != null) {
            this.wiz.updateWizard();
        }
    }

    public boolean areGroupAndFactorNamesUnique() {
        boolean unique = true;
        if (this.isOneFactor) {
            int i;
            String[] groupNames = new String[this.textFieldVector.size() + 1];
            for (i = 0; i < groupNames.length - 1; ++i) {
                groupNames[i] = ((JTextField)this.textFieldVector.get(i)).getText();
            }
            groupNames[groupNames.length - 1] = "Exclude";
            for (i = 0; i < groupNames.length; ++i) {
                for (int j = i + 1; j < groupNames.length; ++j) {
                    if (!groupNames[i].equals(groupNames[j])) continue;
                    return false;
                }
            }
        } else {
            int j;
            int i;
            if (this.factorAField.getText().equals(this.factorBField.getText())) {
                return false;
            }
            for (i = 0; i < this.factorATextFieldVector.size(); ++i) {
                for (j = i + 1; j < this.factorATextFieldVector.size(); ++j) {
                    if (!((JTextField)this.factorATextFieldVector.get(i)).getText().equals(((JTextField)this.factorATextFieldVector.get(j)).getText())) continue;
                    return false;
                }
            }
            for (i = 0; i < this.factorBTextFieldVector.size(); ++i) {
                for (j = i + 1; j < this.factorBTextFieldVector.size(); ++j) {
                    if (!((JTextField)this.factorBTextFieldVector.get(i)).getText().equals(((JTextField)this.factorBTextFieldVector.get(j)).getText())) continue;
                    return false;
                }
            }
        }
        return unique;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        GroupNumberAndNameSelectionPanel p = new GroupNumberAndNameSelectionPanel(true);
        p.initialize(true, true, 2);
        frame.getContentPane().add(p);
        frame.setSize(600, 500);
        frame.setVisible(true);
    }

    private class Listener
    implements ActionListener,
    ChangeListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GroupNumberAndNameSelectionPanel.this.isOneFactor) {
                GroupNumberAndNameSelectionPanel.this.updatePanel();
            } else if (e.getActionCommand().equals("factor-A-count-update-command")) {
                GroupNumberAndNameSelectionPanel.this.updateTwoFactorPanel(0, (Integer)GroupNumberAndNameSelectionPanel.this.factorALevelCountSpinner.getValue());
            } else {
                GroupNumberAndNameSelectionPanel.this.updateTwoFactorPanel(1, (Integer)GroupNumberAndNameSelectionPanel.this.factorBLevelCountSpinner.getValue());
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (GroupNumberAndNameSelectionPanel.this.isOneFactor) {
                GroupNumberAndNameSelectionPanel.this.currFactorACount = (Integer)GroupNumberAndNameSelectionPanel.this.factorALevelCountSpinner.getValue();
                GroupNumberAndNameSelectionPanel.this.updatePanel();
            } else if (e.getSource() == GroupNumberAndNameSelectionPanel.this.factorALevelCountSpinner) {
                GroupNumberAndNameSelectionPanel.this.updateTwoFactorPanel(0, (Integer)GroupNumberAndNameSelectionPanel.this.factorALevelCountSpinner.getValue());
            } else {
                GroupNumberAndNameSelectionPanel.this.updateTwoFactorPanel(1, (Integer)GroupNumberAndNameSelectionPanel.this.factorBLevelCountSpinner.getValue());
            }
        }
    }
}

