/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.IWizardParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public abstract class GSEAWizard
extends AlgorithmDialog {
    private static final long serialVersionUID = 1L;
    protected int currentStepIndex = 0;
    private int totSteps;
    private String[] stepTitles;
    private ProcessDisplayPanel processPanel;
    private WizardButtonBar wButtonPanel;
    private JPanel mainPanel;
    private AlgorithmData algData;
    protected int result = 2;

    public GSEAWizard(JFrame parent, String title, boolean modal, AlgorithmData params, String[] stepTitles, int stepCount, JPanel initialPanel) {
        super(parent, title, modal);
        this.setBounds(0, 0, 800, 850);
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setPreferredSize(new Dimension(800, 850));
        this.algData = params;
        this.processPanel = new ProcessDisplayPanel(true, stepTitles);
        this.totSteps = stepCount;
        this.wButtonPanel = new WizardButtonBar();
        this.mainPanel.add((Component)this.processPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        super.addContent(this.mainPanel);
        this.supplantButtonPanel(this.wButtonPanel);
        this.validate();
    }

    public void setParamSufficient(boolean suff) {
        this.wButtonPanel.setEnableNextButton(suff);
    }

    public void setInitialPanel(JPanel initialPanel) {
        this.mainPanel.add((Component)initialPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void updateWizard() {
    }

    protected abstract IWizardParameterPanel prepareAndDeliverNextParameterPanel(AlgorithmData var1, int var2);

    protected abstract IWizardParameterPanel prepareAndDeliverPreviousParameterPanel(AlgorithmData var1, int var2);

    public void setStepTitles(String[] titles) {
        this.stepTitles = titles;
    }

    public int getCurrentStepIndex() {
        return this.currentStepIndex;
    }

    public String getCurrentStepTitle() {
        return this.stepTitles[this.currentStepIndex];
    }

    public int showModal() {
        return this.result;
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    protected boolean nextStep() {
        JPanel nextPanel = (JPanel)((Object)this.prepareAndDeliverNextParameterPanel(this.algData, this.currentStepIndex));
        if (nextPanel == null) {
            return false;
        }
        ++this.currentStepIndex;
        this.processPanel.setHighlight(this.currentStepIndex);
        Component comp = this.mainPanel.getComponent(1);
        this.mainPanel.remove(comp);
        this.validate();
        this.mainPanel.add((Component)nextPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.validate();
        if (this.currentStepIndex >= this.totSteps) {
            this.wButtonPanel.setNextText("Execute");
        }
        if (this.currentStepIndex >= 1) {
            this.wButtonPanel.setEnableBackButton(true);
        }
        ((IWizardParameterPanel)((Object)nextPanel)).onDisplayed();
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.setParamSufficient(false);
        return true;
    }

    private void prevStep() {
        IWizardParameterPanel prevPanel = this.prepareAndDeliverPreviousParameterPanel(this.algData, this.currentStepIndex);
        --this.currentStepIndex;
        this.processPanel.setHighlight(this.currentStepIndex);
        Component comp = this.mainPanel.getComponent(1);
        this.mainPanel.remove(comp);
        this.mainPanel.add((Component)((JPanel)((Object)prevPanel)), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.revalidate();
        if (this.currentStepIndex < this.totSteps) {
            this.wButtonPanel.setNextText("Next >");
        }
        if (this.currentStepIndex < 1) {
            this.wButtonPanel.setEnableBackButton(false);
        }
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
    }

    public class Listener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                GSEAWizard.this.result = 2;
                GSEAWizard.this.dispose();
            } else if (command.equals("next-command")) {
                JButton button = (JButton)e.getSource();
                if (button.getText().equals("Execute")) {
                    GSEAWizard.this.nextStep();
                    String eMsg = new String();
                    if (GSEAWizard.this.algData.getParams().getString("gene-identifier").equals("") || GSEAWizard.this.algData.getParams().getString("gene-set-directory").equals("") || GSEAWizard.this.algData.getParams().getString("annotation-file").equals("")) {
                        eMsg = "<html>MeV is missing some required parameters, so you cannot execute...just yet<br><html>Please make sure that you <br>1. Selected gene identifer present in your gene set file from the drop down list<br>2. Loaded the gene set file AND the annotation file.<br></html>";
                        JOptionPane.showMessageDialog(null, eMsg, "Error", 1);
                    } else {
                        GSEAWizard.this.result = 0;
                        GSEAWizard.this.dispose();
                    }
                } else {
                    GSEAWizard.this.nextStep();
                }
            } else if (command.equals("back-command")) {
                GSEAWizard.this.prevStep();
            } else if (command.endsWith("info-command")) {
                HelpWindow.launchBrowser(GSEAWizard.this, "GSEA Help Dialog");
            }
        }
    }

    private class WizardButtonBar
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JButton nextButton;
        private JButton backButton;

        public WizardButtonBar() {
            super(new GridBagLayout());
            Listener listener = new Listener();
            this.setPreferredSize(new Dimension(300, 30));
            this.setSize(new Dimension(300, 30));
            JButton cancelButton = new JButton("Cancel");
            JButton infoButton = new JButton(null, GUIFactory.getIcon("Information24.gif"));
            infoButton.setActionCommand("info-command");
            infoButton.addActionListener(listener);
            infoButton.setFocusPainted(false);
            infoButton.setBorder(BorderFactory.createBevelBorder(0));
            infoButton.setPreferredSize(new Dimension(30, 30));
            JLabel label = new JLabel(GUIFactory.getIcon("dialog_button_bar.gif"));
            cancelButton.setActionCommand("cancel-command");
            cancelButton.addActionListener(listener);
            cancelButton.setFocusPainted(false);
            cancelButton.setBorder(BorderFactory.createBevelBorder(0));
            cancelButton.setPreferredSize(new Dimension(100, 30));
            this.backButton = new JButton("< Back");
            this.backButton.setActionCommand("back-command");
            this.backButton.addActionListener(listener);
            this.backButton.setEnabled(false);
            this.backButton.setFocusPainted(false);
            this.backButton.setBorder(BorderFactory.createBevelBorder(0));
            this.backButton.setPreferredSize(new Dimension(100, 30));
            this.nextButton = new JButton("Next >");
            this.nextButton.setActionCommand("next-command");
            this.nextButton.addActionListener(listener);
            this.nextButton.setEnabled(false);
            this.nextButton.setFocusPainted(false);
            this.nextButton.setBorder(BorderFactory.createBevelBorder(0));
            this.nextButton.setPreferredSize(new Dimension(100, 30));
            this.add((Component)infoButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 10, 0, 30), 0, 0));
            this.add((Component)label, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)cancelButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 10, 0, 30), 0, 0));
            this.add((Component)this.backButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.nextButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        }

        public void setNextText(String text) {
            this.nextButton.setText(text);
        }

        public void setEnableBackButton(boolean enable) {
            this.backButton.setEnabled(enable);
        }

        public void setEnableNextButton(boolean enable) {
            this.nextButton.setEnabled(enable);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
        }
    }

    private class ProcessDisplayPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private String[] stepTitles;
        private JTextPane processPane;

        public ProcessDisplayPanel(boolean isTextDisplay, String[] stepTitles) {
            this.setBackground(Color.white);
            this.stepTitles = stepTitles;
            this.constructPanel();
        }

        private void constructPanel() {
            this.setLayout(new GridBagLayout());
            this.processPane = new JTextPane();
            this.processPane.setEditable(false);
            this.processPane.setContentType("text/html");
            this.processPane.setOpaque(false);
            this.processPane.setMargin(new Insets(10, 10, 10, 10));
            Document doc = this.processPane.getDocument();
            String stepDescription = "<html><font face=\"MS Sans Serif\"><b><u>Process Outline</u></b><br><br>";
            try {
                doc.insertString(doc.getLength(), stepDescription, null);
                for (int i = 0; i < this.stepTitles.length; ++i) {
                    stepDescription = stepDescription + String.valueOf(i + 1);
                    stepDescription = stepDescription + ".) ";
                    stepDescription = stepDescription + this.stepTitles[i] + "    ";
                }
                stepDescription = stepDescription + "</font></html>";
                this.processPane.setText(stepDescription);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            this.setHighlight(0);
            this.add((Component)this.processPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }

        private void setHighlight(int step) {
            try {
                Highlighter highlighter;
                Document doc = this.processPane.getDocument();
                String text = doc.getText(0, doc.getLength());
                int pos = text.indexOf(step + 1 + ".)");
                int endPos = text.indexOf(".", pos + 2) + 1;
                if (endPos < 0) {
                    endPos = text.length();
                }
                if (pos > -1 && (highlighter = this.processPane.getHighlighter()) != null) {
                    highlighter.removeAllHighlights();
                    highlighter.addHighlight(pos, endPos, new MyHighlightPainter(new Color(200, 200, 255)));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            GradientPaint gp = new GradientPaint(0.0f, this.getHeight() / 2, new Color(210, 210, 255), this.getWidth() / 4, this.getHeight() / 2, Color.white, false);
            ((Graphics2D)g).setPaint(gp);
            g.fillRect(0, 0, this.getWidth() / 2, this.getHeight());
            gp = new GradientPaint(this.getWidth(), this.getHeight() / 2, new Color(210, 210, 255), this.getWidth() * 3 / 4, this.getHeight() / 2, Color.white, false);
            ((Graphics2D)g).setPaint(gp);
            g.fillRect(this.getWidth() / 2, 0, this.getWidth(), this.getHeight());
            this.processPane.paint(g);
        }

        class MyHighlightPainter
        extends DefaultHighlighter.DefaultHighlightPainter {
            public MyHighlightPainter(Color color) {
                super(color);
            }
        }
    }
}

