/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DistanceMetricPanel
extends JPanel {
    private JCheckBox absBox;
    private JComboBox metricBox;
    private String globalFunctionName;
    private boolean globalAbsoluteValue;
    private ActionListener listener;

    public DistanceMetricPanel(String globalFunctionName, boolean globalAbsoluteValue, String defaultMetricName, String algName, boolean showTitle, boolean whiteBackground) {
        super(new GridBagLayout());
        this.globalAbsoluteValue = globalAbsoluteValue;
        this.globalFunctionName = globalFunctionName;
        if (whiteBackground) {
            this.setBackground(Color.white);
        }
        if (showTitle) {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), "Distance Metric Selection"));
        }
        JLabel localSettingLabel = new JLabel("Current Metric: ");
        this.absBox = new JCheckBox("Use Absolute Distance", globalAbsoluteValue);
        this.absBox.setOpaque(false);
        this.absBox.setFocusPainted(false);
        Vector<DistanceMetric> metrics = this.buildMetricVector();
        this.metricBox = new JComboBox<DistanceMetric>(metrics);
        this.metricBox.addActionListener(new Listener());
        if (globalFunctionName.equals("not defined")) {
            this.setMetricSelection(defaultMetricName);
        } else {
            this.setMetricSelection(globalFunctionName);
        }
        this.metricBox.addActionListener(new Listener());
        this.enableAbsolute(globalFunctionName);
        JLabel defaultDistanceLabel = new JLabel("(The default distance metric for " + algName + " is " + defaultMetricName + ")");
        this.add((Component)localSettingLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.metricBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)defaultDistanceLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.absBox, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
    }

    public int getMetricIndex() {
        DistanceMetric metric = (DistanceMetric)this.metricBox.getSelectedItem();
        return metric.getIndex();
    }

    public boolean getAbsoluteSelection() {
        return this.absBox.isSelected();
    }

    public void reset() {
        this.setMetricSelection(this.globalFunctionName);
        this.enableAbsolute(this.globalFunctionName);
        this.absBox.setSelected(this.globalAbsoluteValue);
    }

    private Vector<DistanceMetric> buildMetricVector() {
        Vector<DistanceMetric> distanceVector = new Vector<DistanceMetric>();
        distanceVector.addElement(new DistanceMetric("Euclidean Distance", 4));
        distanceVector.addElement(new DistanceMetric("Manhattan Distance", 8));
        distanceVector.addElement(new DistanceMetric("Average Dot Product", 5));
        distanceVector.addElement(new DistanceMetric("Pearson Correlation", 1));
        distanceVector.addElement(new DistanceMetric("Pearson Uncentered", 6));
        distanceVector.addElement(new DistanceMetric("Pearson Squared", 7));
        distanceVector.addElement(new DistanceMetric("Cosine Correlation", 2));
        distanceVector.addElement(new DistanceMetric("Covariance Value", 3));
        distanceVector.addElement(new DistanceMetric("Spearman Rank Correlation", 9));
        distanceVector.addElement(new DistanceMetric("Kendall's Tau", 10));
        distanceVector.addElement(new DistanceMetric("Mutual Information", 11));
        return distanceVector;
    }

    private void enableAbsolute(String metricName) {
        if (metricName.equals("Pearson Correlation") || metricName.equals("Pearson Uncentered") || metricName.equals("Cosine Correlation") || metricName.equals("Average Dot Product")) {
            this.absBox.setEnabled(true);
        } else {
            this.absBox.setEnabled(false);
        }
    }

    private void setMetricSelection(String metricName) {
        for (int i = 0; i < this.metricBox.getItemCount(); ++i) {
            if (!((DistanceMetric)this.metricBox.getItemAt(i)).toString().equals(metricName)) continue;
            this.metricBox.setSelectedIndex(i);
            break;
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    private void fireActionEvent() {
        ActionEvent ae = new ActionEvent(this, 0, "distance_metric_selection_command");
        this.listener.actionPerformed(ae);
    }

    public static void main(String[] args) {
        DistanceMetricPanel panel = new DistanceMetricPanel("Pearson Correlation", true, "Euclidean Distance", "HCL", true, true);
        JFrame frame = new JFrame();
        frame.getContentPane().add(panel);
        frame.setSize(400, 200);
        frame.setVisible(true);
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DistanceMetricPanel.this.enableAbsolute(((DistanceMetric)DistanceMetricPanel.this.metricBox.getSelectedItem()).toString());
            if (DistanceMetricPanel.this.listener != null) {
                DistanceMetricPanel.this.fireActionEvent();
            }
        }
    }

    private class DistanceMetric {
        private String name;
        private int index;

        public DistanceMetric(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

