/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class AlgorithmDialog
extends JDialog {
    protected JButton okButton;
    protected JButton cancelButton;
    protected JButton resetButton;
    protected JButton infoButton;
    protected JPanel mainPanel;
    protected JPanel contentPanel;
    protected JPanel buttonPanel;
    public static final String RESET_COMMAND = "reset-command";
    public static final String OK_COMMAND = "ok-command";
    public static final String CANCEL_COMMAND = "cancel-command";
    public boolean isDataAppropriate = true;
    GradientPaint gp;
    Color backgroundColor = new Color(25, 25, 169);
    Color fadeColor = new Color(140, 220, 240);

    public AlgorithmDialog(Frame parent, String title, boolean modal) {
        this(parent, title, modal, true);
    }

    public AlgorithmDialog(Frame parent, String title, boolean modal, boolean isDataAppropriate) {
        super(parent, title, modal);
        this.isDataAppropriate = isDataAppropriate;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new GridBagLayout());
        this.buttonPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.setActionCommand(OK_COMMAND);
        this.okButton.setSize(60, 30);
        this.okButton.setPreferredSize(new Dimension(60, 30));
        this.okButton.setFocusPainted(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand(CANCEL_COMMAND);
        this.cancelButton.setSize(60, 30);
        this.cancelButton.setPreferredSize(new Dimension(60, 30));
        this.cancelButton.setFocusPainted(false);
        this.resetButton = new JButton("Reset");
        this.resetButton.setActionCommand(RESET_COMMAND);
        this.resetButton.setSize(60, 30);
        this.resetButton.setPreferredSize(new Dimension(60, 30));
        this.resetButton.setFocusPainted(false);
        this.infoButton = new JButton(null, GUIFactory.getIcon("Information24.gif"));
        this.infoButton.setActionCommand("info-command");
        this.infoButton.setSize(30, 30);
        this.infoButton.setPreferredSize(new Dimension(30, 30));
        this.infoButton.setFocusPainted(false);
        Border border = BorderFactory.createBevelBorder(0);
        this.infoButton.setBorder(border);
        this.okButton.setBorder(BorderFactory.createBevelBorder(0, new Color(240, 240, 240), new Color(180, 180, 180), new Color(10, 0, 0), new Color(10, 10, 10)));
        this.resetButton.setBorder(BorderFactory.createBevelBorder(0));
        this.cancelButton.setBorder(BorderFactory.createBevelBorder(0));
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new GridBagLayout());
        if (!isDataAppropriate) {
            JLabel wrongDataLabel = new JLabel("WARNING: This analysis was not intended to be performed on your current data type.");
            wrongDataLabel.setForeground(Color.red);
            wrongDataLabel.setOpaque(false);
            this.buttonPanel.add((Component)wrongDataLabel, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.buttonPanel.add((Component)this.infoButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        JLabel label = new JLabel(GUIFactory.getIcon("dialog_button_bar.gif"));
        this.buttonPanel.add((Component)label, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.buttonPanel.add((Component)this.resetButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.buttonPanel.add((Component)this.okButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 30, 0, 0), 0, 0));
        this.mainPanel.add((Component)new HeaderImagePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.contentPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 15, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.getContentPane().add(this.mainPanel);
        this.pack();
    }

    public AlgorithmDialog(JFrame parent, String title, boolean modal) {
        this(parent, title, modal, true);
    }

    public AlgorithmDialog(JFrame parent, String title, boolean modal, boolean isDataAppropriate) {
        super(parent, title, modal);
        this.isDataAppropriate = isDataAppropriate;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new GridBagLayout());
        this.buttonPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.setActionCommand(OK_COMMAND);
        this.okButton.setSize(60, 30);
        this.okButton.setPreferredSize(new Dimension(60, 30));
        this.okButton.setFocusPainted(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand(CANCEL_COMMAND);
        this.cancelButton.setSize(60, 30);
        this.cancelButton.setPreferredSize(new Dimension(60, 30));
        this.cancelButton.setFocusPainted(false);
        this.resetButton = new JButton("Reset");
        this.resetButton.setActionCommand(RESET_COMMAND);
        this.resetButton.setSize(60, 30);
        this.resetButton.setPreferredSize(new Dimension(60, 30));
        this.resetButton.setFocusPainted(false);
        this.infoButton = new JButton(null, GUIFactory.getIcon("Information24.gif"));
        this.infoButton.setActionCommand("info-command");
        this.infoButton.setSize(30, 30);
        this.infoButton.setPreferredSize(new Dimension(30, 30));
        this.infoButton.setFocusPainted(false);
        Border border = BorderFactory.createBevelBorder(0);
        this.infoButton.setBorder(border);
        this.okButton.setBorder(BorderFactory.createBevelBorder(0, new Color(240, 240, 240), new Color(180, 180, 180), new Color(10, 0, 0), new Color(10, 10, 10)));
        this.resetButton.setBorder(BorderFactory.createBevelBorder(0));
        this.cancelButton.setBorder(BorderFactory.createBevelBorder(0));
        this.buttonPanel.setLayout(new GridBagLayout());
        if (!isDataAppropriate) {
            JLabel wrongDataLabel = new JLabel("WARNING: This analysis was not intended to be performed on your current data type.");
            wrongDataLabel.setForeground(Color.red);
            wrongDataLabel.setOpaque(false);
            this.buttonPanel.add((Component)wrongDataLabel, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.buttonPanel.add((Component)this.infoButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        JLabel label = new JLabel(GUIFactory.getIcon("dialog_button_bar.gif"));
        this.buttonPanel.add((Component)label, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.buttonPanel.add((Component)this.resetButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.buttonPanel.add((Component)this.okButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 30, 0, 0), 0, 0));
        this.mainPanel.add((Component)new HeaderImagePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.contentPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 15, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.getContentPane().add(this.mainPanel);
        this.pack();
    }

    protected void setActionListeners(ActionListener listener) {
        this.okButton.addActionListener(listener);
        this.cancelButton.addActionListener(listener);
        this.resetButton.addActionListener(listener);
        this.infoButton.addActionListener(listener);
    }

    protected void addContent(Component content) {
        this.contentPanel.add(content, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.validate();
    }

    protected void disposeDialog() {
        this.dispose();
    }

    protected void supplantButtonPanel(Component buttonsSet) {
        this.mainPanel.remove(this.buttonPanel);
        this.mainPanel.add(buttonsSet, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 15, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.validate();
    }

    public void setOKButtonText(String label) {
        this.okButton.setText(label);
    }

    public void setResetButtonText(String label) {
        this.resetButton.setText(label);
    }

    public static void main(String[] args) {
        AlgorithmDialog dialog = new AlgorithmDialog(new JFrame(), "Test", true);
        dialog.setVisible(true);
        System.exit(0);
    }

    public class FillPanel
    extends JPanel {
        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            Dimension dim = this.getSize();
            AlgorithmDialog.this.gp = new GradientPaint(0.0f, dim.height / 2, AlgorithmDialog.this.backgroundColor, dim.width, dim.height / 2, AlgorithmDialog.this.fadeColor);
            g2.setPaint(AlgorithmDialog.this.gp);
            g2.fillRect(0, 0, dim.width, dim.height);
            g2.setColor(Color.black);
        }
    }

    public class HeaderImagePanel
    extends JPanel {
        public HeaderImagePanel() {
            this.setLayout(new GridBagLayout());
            JLabel iconLabel = new JLabel(GUIFactory.getIcon("dialog_banner2.gif"));
            iconLabel.setOpaque(false);
            iconLabel.setAlignmentX(0.0f);
            FillPanel fillPanel = new FillPanel();
            fillPanel.setBackground(Color.blue);
            this.add((Component)iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)fillPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }
}

