/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.degseq;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterSelector;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class DEGseqInitBox
extends AlgorithmDialog {
    private static final long serialVersionUID = 1L;
    public static final int JUST_ALPHA = 1;
    public static final int STD_BONFERRONI = 2;
    public static final int ADJ_BONFERRONI = 3;
    public static final int MAX_T = 4;
    public static final int FALSE_NUM = 5;
    public static final int FALSE_PROP = 6;
    public static final int ONE_CLASS = 7;
    public static final int TWO_CLASS = 8;
    public static final int PAIRED = 9;
    public static final int BUTTON_SELECTION = 10;
    public static final int CLUSTER_SELECTION = 11;
    boolean okPressed = false;
    boolean okReady = false;
    Vector<String> exptNames;
    MainPanel mPanel;
    PValuePanel pPanel;
    MethodsPanel methodsPanel;
    ClusterRepository repository;

    public DEGseqInitBox(JFrame parentFrame, boolean modality, Vector<String> exptNames, ClusterRepository experimentClusterRepository) {
        super(parentFrame, "DEGseq Initialization", modality);
        this.exptNames = exptNames;
        this.repository = experimentClusterRepository;
        this.setBounds(0, 0, 600, 700);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        this.okButton.setEnabled(true);
        this.mPanel = new MainPanel();
        JPanel paramsPane = new JPanel();
        paramsPane.setLayout(gridbag);
        this.methodsPanel = new MethodsPanel();
        this.buildConstraints(constraints, 0, 0, 1, 1, 1, 20);
        paramsPane.add((Component)this.methodsPanel, constraints);
        this.pPanel = new PValuePanel();
        this.buildConstraints(constraints, 0, 1, 1, 1, 1, 20);
        paramsPane.add((Component)this.pPanel, constraints);
        JTabbedPane consolidatedPane = new JTabbedPane();
        consolidatedPane.add("Parameters", paramsPane);
        this.buildConstraints(constraints, 0, 1, 1, 1, 1, 20);
        gridbag.setConstraints(consolidatedPane, constraints);
        pane.add((Component)consolidatedPane, constraints);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 80);
        gridbag.setConstraints(this.mPanel, constraints);
        pane.add(this.mPanel);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public void enableOK() {
        this.okButton.setEnabled(true);
    }

    public int getMethod() {
        if (this.methodsPanel.buttonLRT.isSelected()) {
            return 1;
        }
        if (this.methodsPanel.buttonFET.isSelected()) {
            return 2;
        }
        if (this.methodsPanel.buttonMARS.isSelected()) {
            return 3;
        }
        if (this.methodsPanel.buttonMATR.isSelected()) {
            return 4;
        }
        return 0;
    }

    public String getMethodName() {
        if (this.methodsPanel.buttonLRT.isSelected()) {
            return "LRT";
        }
        if (this.methodsPanel.buttonFET.isSelected()) {
            return "FET";
        }
        if (this.methodsPanel.buttonMARS.isSelected()) {
            return "MARS";
        }
        if (this.methodsPanel.buttonMATR.isSelected()) {
            return "MATR";
        }
        return null;
    }

    public int[] getTwoClassAssignments() {
        int[] groupAssignments = new int[this.exptNames.size()];
        block0: for (int i = 0; i < this.exptNames.size(); ++i) {
            for (int j = 0; j < this.mPanel.twoClassPanel.numberGroups; ++j) {
                if (this.mPanel.twoClassPanel.rbArray[i][j].isSelected()) {
                    groupAssignments[i] = j + 1;
                    continue block0;
                }
                groupAssignments[i] = 0;
            }
        }
        return groupAssignments;
    }

    public int[] getClusterTwoClassAssignments() {
        int j;
        int i;
        int[] groupAssignments = new int[this.exptNames.size()];
        ArrayList[] arraylistArray = new ArrayList[2];
        for (i = 0; i < 2; ++i) {
            j = i + 1;
            arraylistArray[i] = this.mPanel.twoClassClusterSelector.getGroupSamples("Samples " + j);
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            boolean doubleAssigned = false;
            groupAssignments[i] = 0;
            for (j = 0; j < 2; ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[i] = j + 1;
                doubleAssigned = true;
            }
        }
        return groupAssignments;
    }

    public int getTestDesign() {
        int design = -1;
        design = 8;
        return design;
    }

    public int getSelectionDesign() {
        int design = -1;
        if (this.getTestDesign() != 7 && this.getTestDesign() == 8) {
            design = this.mPanel.twoClassmulg.getSelectedIndex() == 0 ? 10 : 11;
        }
        return design;
    }

    public float getPValue() {
        return Float.parseFloat(this.pPanel.pValueInputField.getText());
    }

    public String getCutOffField() {
        if (this.pPanel.fdrButton.isSelected()) {
            return "fdr";
        }
        return "pvalue";
    }

    public static void main(String[] args) {
        JFrame dummyFrame = new JFrame();
        Vector<String> dummyVect = new Vector<String>();
        for (int i = 0; i < 23; ++i) {
            dummyVect.add("Expt " + (i + 1));
        }
        dummyVect.add("Expt007");
        DEGseqInitBox oBox = new DEGseqInitBox(dummyFrame, true, dummyVect, null);
        oBox.setVisible(true);
        System.out.println("end");
        System.exit(0);
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                if (!DEGseqInitBox.this.okReady) {
                    return;
                }
                try {
                    if (DEGseqInitBox.this.getTestDesign() != 7 && DEGseqInitBox.this.getTestDesign() == 8) {
                        int[] inGroupAssignments = DEGseqInitBox.this.getSelectionDesign() == 11 ? DEGseqInitBox.this.getClusterTwoClassAssignments() : DEGseqInitBox.this.getTwoClassAssignments();
                        int grpA = 0;
                        int grpB = 0;
                        for (int i = 0; i < inGroupAssignments.length; ++i) {
                            if (inGroupAssignments[i] == 1) {
                                ++grpA;
                            }
                            if (inGroupAssignments[i] != 2) continue;
                            ++grpB;
                        }
                        if (grpA < 2 || grpB < 2) {
                            JOptionPane.showMessageDialog(null, "At least 2 samples must be assigned to each group.", "Error!", 0);
                            DEGseqInitBox.this.okPressed = false;
                            return;
                        }
                        DEGseqInitBox.this.okPressed = true;
                        DEGseqInitBox.this.dispose();
                    }
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(null, "Valid inputs: 0 < alpha < 1, and # of permutations (integer only) > 1", "Error!", 0);
                }
            } else if (command.equals("reset-command")) {
                DEGseqInitBox.this.mPanel.reset();
                DEGseqInitBox.this.pPanel.reset();
            } else if (command.equals("cancel-command")) {
                DEGseqInitBox.this.okPressed = false;
                DEGseqInitBox.this.dispose();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(DEGseqInitBox.this, "DEGseq Initialization Dialog");
            }
        }
    }

    class PValuePanel
    extends JPanel {
        JLabel cutOffLabel;
        JLabel chooseCutoffLabel;
        JTextField pValueInputField;
        JRadioButton pValueButton;
        JRadioButton fdrButton;

        public PValuePanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "P-value / FDR parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 1;
            this.setLayout(gridbag);
            GridBagLayout pValSelectionPanelgrid = new GridBagLayout();
            this.pValueButton = new JRadioButton("P-Value", false);
            this.pValueButton.setFocusPainted(false);
            this.add(this.pValueButton);
            this.fdrButton = new JRadioButton("FDR", true);
            this.fdrButton.setFocusPainted(false);
            this.add(this.fdrButton);
            this.pValueInputField = new JTextField("0.05", 7);
            this.pValueInputField.setMinimumSize(new Dimension(50, 20));
            DEGseqInitBox.this.buildConstraints(constraints, 2, 0, 1, 1, 10, 0);
            constraints.anchor = 13;
            pValSelectionPanelgrid.setConstraints(this.pValueInputField, constraints);
            this.add(this.pValueInputField);
            ButtonGroup chooseCorrection = new ButtonGroup();
            chooseCorrection.add(this.pValueButton);
            chooseCorrection.add(this.fdrButton);
            this.validate();
        }

        protected void reset() {
            this.pValueInputField.setText("0.05");
        }
    }

    class MethodsPanel
    extends JPanel
    implements ActionListener {
        JRadioButton buttonLRT;
        JRadioButton buttonFET;
        JRadioButton buttonMARS;
        JRadioButton buttonMATR;
        JLabel warningMATR;
        String MATR_Cmd = "       Note: Grp1 and Grp2 are treated as 2 (groups of) technical replicates of a sample.";

        public MethodsPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Inference algorithm", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 1;
            this.setLayout(gridbag);
            this.buttonLRT = new JRadioButton("LRT: Likelihood Ratio Test (Marioni et al. 2008)", false);
            this.buttonLRT.setActionCommand("");
            this.buttonFET = new JRadioButton("FET: Fisher's Exact Test (Joshua et al. 2009)", false);
            this.buttonFET.setActionCommand("");
            this.buttonMARS = new JRadioButton("MARS: MA-plot-based method with Random Sampling model (Wang et al. 2009)", false);
            this.buttonMARS.setActionCommand("");
            this.buttonMATR = new JRadioButton("MATR: MA-plot-based method with Technical Replicates (Wang et al. 2009)", false);
            this.buttonMATR.setActionCommand(this.MATR_Cmd);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.buttonLRT);
            buttonGroup.add(this.buttonFET);
            buttonGroup.add(this.buttonMARS);
            buttonGroup.add(this.buttonMATR);
            this.buttonMARS.setSelected(true);
            this.buttonLRT.addActionListener(this);
            this.buttonFET.addActionListener(this);
            this.buttonMARS.addActionListener(this);
            this.buttonMATR.addActionListener(this);
            DEGseqInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 50);
            constraints.anchor = 21;
            gridbag.setConstraints(this.buttonLRT, constraints);
            this.add(this.buttonLRT);
            DEGseqInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 50, 50);
            constraints.anchor = 21;
            gridbag.setConstraints(this.buttonFET, constraints);
            this.add(this.buttonFET);
            DEGseqInitBox.this.buildConstraints(constraints, 0, 2, 1, 1, 50, 50);
            constraints.anchor = 21;
            gridbag.setConstraints(this.buttonMARS, constraints);
            this.add(this.buttonMARS);
            DEGseqInitBox.this.buildConstraints(constraints, 0, 3, 1, 1, 50, 50);
            constraints.anchor = 21;
            gridbag.setConstraints(this.buttonMATR, constraints);
            this.add(this.buttonMATR);
            this.warningMATR = new JLabel("");
            this.warningMATR.setForeground(Color.red);
            DEGseqInitBox.this.buildConstraints(constraints, 0, 4, 1, 1, 10, 10);
            constraints.anchor = 10;
            gridbag.setConstraints(this.warningMATR, constraints);
            this.add(this.warningMATR);
            this.validate();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.warningMATR.setText(e.getActionCommand());
        }
    }

    class MainPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        JPanel dummyPanel;
        ExperimentsPanel twoClassPanel;
        JTabbedPane twoClassmulg;
        ClusterSelector twoClassClusterSelector;
        float alpha;

        public MainPanel() {
            this.setBackground(Color.white);
            this.setLayout(this.gridbag);
            DEGseqInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 10);
            this.constraints.fill = 1;
            DEGseqInitBox.this.okReady = true;
            try {
                this.twoClassPanel = new ExperimentsPanel(DEGseqInitBox.this.exptNames, 2);
                this.twoClassClusterSelector = new ClusterSelector(DEGseqInitBox.this.repository, 2, "Samples");
                if (DEGseqInitBox.this.repository != null) {
                    this.twoClassClusterSelector.setClusterType("Experiment");
                }
                JPanel twoClassClusterSelectorPanel = new JPanel();
                twoClassClusterSelectorPanel.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 1;
                c.weighty = 1.0;
                c.weightx = 1.0;
                c.gridx = 0;
                c.gridy = 1;
                c.gridwidth = 1;
                c.anchor = 20;
                twoClassClusterSelectorPanel.add((Component)this.twoClassClusterSelector, c);
                this.twoClassmulg = new JTabbedPane();
                this.twoClassmulg.add("Button Selection", this.twoClassPanel);
                this.twoClassmulg.add("Cluster Selection", twoClassClusterSelectorPanel);
                this.twoClassmulg.setSelectedIndex(1);
                if (DEGseqInitBox.this.repository == null || DEGseqInitBox.this.repository.isEmpty()) {
                    this.twoClassmulg.setSelectedIndex(0);
                }
                DEGseqInitBox.this.buildConstraints(this.constraints, 1, 0, 1, 3, 100, 100);
                this.constraints.fill = 1;
                this.gridbag.setConstraints(this.twoClassmulg, this.constraints);
                this.add(this.twoClassmulg);
                this.validate();
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(null, "Please enter a value greater than 0 and less than 1!", "Error", 0);
            }
        }

        protected void reset() {
            for (int i = 0; i < this.twoClassPanel.rbArray.length; ++i) {
                this.twoClassPanel.rbArray[i][2].setSelected(true);
            }
        }

        class ExperimentsPanel
        extends JPanel {
            int numPanels = 0;
            int numberGroups;
            JLabel[] expLabels;
            JCheckBox[] exptCheckBoxes;
            JRadioButton[][] rbArray;

            ExperimentsPanel(Vector<String> exptNames, int numGroups) {
                int i;
                int i2;
                this.setBorder(new TitledBorder(new EtchedBorder(), "Experiment Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
                this.setBackground(Color.white);
                this.numberGroups = numGroups;
                ButtonGroup[] chooseGroup = new ButtonGroup[exptNames.size()];
                this.expLabels = new JLabel[exptNames.size()];
                this.exptCheckBoxes = new JCheckBox[exptNames.size()];
                this.rbArray = new JRadioButton[exptNames.size()][this.numberGroups + 1];
                this.numPanels = exptNames.size() / 512 + 1;
                GridBagLayout gridbag = new GridBagLayout();
                GridBagLayout gridbag2 = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                this.setLayout(gridbag2);
                JPanel[] panels = new JPanel[this.numPanels];
                int currPanel = 0;
                for (i2 = 0; i2 < panels.length; ++i2) {
                    panels[i2] = new JPanel(gridbag);
                }
                for (i2 = 0; i2 < exptNames.size(); ++i2) {
                    String s1 = exptNames.get(i2);
                    this.expLabels[i2] = new JLabel(s1);
                    DEGseqInitBox.this.buildConstraints(constraints, 0, i2 % 512, 1, 1, 100, 100);
                    if (numGroups == 1) {
                        constraints.anchor = 17;
                        this.exptCheckBoxes[i2] = new JCheckBox("", true);
                        gridbag.setConstraints(this.exptCheckBoxes[i2], constraints);
                        panels[currPanel].add(this.exptCheckBoxes[i2]);
                        continue;
                    }
                    chooseGroup[i2] = new ButtonGroup();
                    for (int j = 0; j < this.numberGroups + 1; ++j) {
                        this.rbArray[i2][j] = new JRadioButton("Group " + (j + 1));
                        if (j == this.numberGroups) {
                            this.rbArray[i2][j] = new JRadioButton("Excluded");
                        }
                        chooseGroup[i2].add(this.rbArray[i2][j]);
                        DEGseqInitBox.this.buildConstraints(constraints, j, i2 % 512, 1, 1, 100, 100);
                        gridbag.setConstraints(this.rbArray[i2][j], constraints);
                        panels[currPanel].add(this.rbArray[i2][j]);
                    }
                    this.rbArray[i2][this.numberGroups].setSelected(true);
                }
                int maxLabelWidth = 0;
                for (int i3 = 0; i3 < this.expLabels.length; ++i3) {
                    if (!(this.expLabels[i3].getPreferredSize().getWidth() > (double)maxLabelWidth)) continue;
                    maxLabelWidth = (int)Math.ceil(this.expLabels[i3].getPreferredSize().getWidth());
                }
                JPanel bigPanel = new JPanel(new GridBagLayout());
                for (int i4 = 0; i4 < this.numPanels; ++i4) {
                    bigPanel.add((Component)panels[i4], new GridBagConstraints(0, i4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                JScrollPane scroll = new JScrollPane(bigPanel);
                scroll.setHorizontalScrollBarPolicy(32);
                scroll.setVerticalScrollBarPolicy(22);
                JPanel[] exptNameHeaderPanels = new JPanel[this.numPanels];
                GridBagLayout exptHeaderGridbag = new GridBagLayout();
                for (i = 0; i < exptNameHeaderPanels.length; ++i) {
                    exptNameHeaderPanels[i] = new JPanel();
                    exptNameHeaderPanels[i].setSize(50, panels[i].getPreferredSize().height);
                    exptNameHeaderPanels[i].setPreferredSize(new Dimension(maxLabelWidth + 10, panels[i].getPreferredSize().height));
                    exptNameHeaderPanels[i].setLayout(exptHeaderGridbag);
                }
                for (i = 0; i < this.expLabels.length; ++i) {
                    currPanel = i / 512;
                    DEGseqInitBox.this.buildConstraints(constraints, 0, i % 512, 1, 1, 100, 100);
                    constraints.fill = 1;
                    exptHeaderGridbag.setConstraints(this.expLabels[i], constraints);
                    exptNameHeaderPanels[currPanel].add(this.expLabels[i]);
                }
                JPanel headerPanel = new JPanel(new GridBagLayout());
                for (int i5 = 0; i5 < exptNameHeaderPanels.length; ++i5) {
                    headerPanel.add((Component)exptNameHeaderPanels[i5], new GridBagConstraints(0, i5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                scroll.setRowHeaderView(headerPanel);
                DEGseqInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
                constraints.fill = 1;
                gridbag2.setConstraints(scroll, constraints);
                this.add(scroll);
                JPanel panel2 = new JPanel();
                GridBagLayout gridbag3 = new GridBagLayout();
                panel2.setLayout(gridbag3);
                panel2.setBackground(Color.white);
                JButton saveButton = new JButton("  Save settings  ");
                saveButton.setFocusPainted(false);
                saveButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton loadButton = new JButton("  Load settings  ");
                loadButton.setFocusPainted(false);
                loadButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton resetButton = new JButton("  Reset  ");
                resetButton.setFocusPainted(false);
                resetButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                resetButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ExperimentsPanel.this.reset();
                    }
                });
                JFileChooser fc = new JFileChooser(TMEV.getDataPath());
                saveButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (ExperimentsPanel.this.numberGroups == 2) {
                            ExperimentsPanel.this.saveTwoClassAssignments();
                        }
                    }
                });
                loadButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (ExperimentsPanel.this.numberGroups == 2) {
                            ExperimentsPanel.this.loadTwoClassAssignments();
                        }
                    }
                });
                constraints.anchor = 10;
                constraints.fill = 0;
                constraints.insets = new Insets(5, 5, 5, 5);
                DEGseqInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 100);
                gridbag3.setConstraints(saveButton, constraints);
                panel2.add(saveButton);
                DEGseqInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
                gridbag3.setConstraints(loadButton, constraints);
                panel2.add(loadButton);
                DEGseqInitBox.this.buildConstraints(constraints, 2, 0, 1, 1, 34, 0);
                gridbag3.setConstraints(resetButton, constraints);
                panel2.add(resetButton);
                constraints.insets = new Insets(0, 0, 0, 0);
                DEGseqInitBox.this.buildConstraints(constraints, 0, 2, 1, 1, 0, 5);
                constraints.anchor = 10;
                gridbag2.setConstraints(panel2, constraints);
                this.add(panel2);
            }

            protected void reset() {
                for (int i = 0; i < MainPanel.this.twoClassPanel.rbArray.length; ++i) {
                }
            }

            private void saveTwoClassAssignments() {
                JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
                if (fileChooser.showSaveDialog(this) == 0) {
                    File file = fileChooser.getSelectedFile();
                    try {
                        PrintWriter pw = new PrintWriter(new FileWriter(file));
                        Date currDate = new Date(System.currentTimeMillis());
                        String dateString = currDate.toString();
                        String userName = System.getProperty("user.name");
                        pw.println("# Assignment File");
                        pw.println("# User: " + userName + " Save Date: " + dateString);
                        pw.println("#");
                        pw.print("Module:\t");
                        pw.println("edgeR: Two-Class Unpaired");
                        pw.print("Group 1 Label:\t");
                        pw.println("1");
                        pw.print("Group 2 Label:\t");
                        pw.println("2");
                        pw.println("#");
                        pw.println("Sample Index\tSample Name\tGroup Assignment");
                        int[] groupAssgn = DEGseqInitBox.this.getTwoClassAssignments();
                        for (int sample = 0; sample < DEGseqInitBox.this.exptNames.size(); ++sample) {
                            pw.print(String.valueOf(sample + 1) + "\t");
                            pw.print(DEGseqInitBox.this.exptNames.get(sample) + "\t");
                            if (groupAssgn[sample] != 3) {
                                pw.println(groupAssgn[sample]);
                                continue;
                            }
                            pw.println("Exclude");
                        }
                        pw.flush();
                        pw.close();
                    }
                    catch (FileNotFoundException fnfe) {
                        fnfe.printStackTrace();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }

            private void loadTwoClassAssignments() {
                JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
                if (fileChooser.showOpenDialog(this) == 0) {
                    File file = fileChooser.getSelectedFile();
                    try {
                        String line;
                        BufferedReader br = new BufferedReader(new FileReader(file));
                        Vector<String> data = new Vector<String>();
                        while ((line = br.readLine()) != null) {
                            data.add(line.trim());
                        }
                        br.close();
                        Vector<String> groupNames = new Vector<String>();
                        Vector<Integer> sampleIndices = new Vector<Integer>();
                        Vector<String> sampleNames = new Vector<String>();
                        Vector<String> groupAssignments = new Vector<String>();
                        for (int row = 0; row < data.size(); ++row) {
                            line = (String)data.get(row);
                            if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                            String[] lineArray = line.split("\t");
                            if (lineArray[0].startsWith("Module:")) {
                                if (lineArray[1].equals("edgeR: Two-Class Unpaired")) continue;
                                Object[] optionst = new Object[]{"Continue", "Cancel"};
                                if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                                return;
                            }
                            if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                                groupNames.add(lineArray[1]);
                                continue;
                            }
                            try {
                                Integer.parseInt(lineArray[0]);
                            }
                            catch (NumberFormatException nfe) {
                                continue;
                            }
                            sampleIndices.add(new Integer(lineArray[0]));
                            sampleNames.add(lineArray[1]);
                            groupAssignments.add(lineArray[2]);
                        }
                        if (DEGseqInitBox.this.exptNames.size() != sampleNames.size()) {
                            System.out.println(DEGseqInitBox.this.exptNames.size() + "  " + sampleNames.size());
                            System.out.println(DEGseqInitBox.this.exptNames.size() + " s length " + sampleNames.size());
                            JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + DEGseqInitBox.this.exptNames.size() + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                            return;
                        }
                        int fileSampleIndex = 0;
                        int groupIndex = 0;
                        for (int sample = 0; sample < DEGseqInitBox.this.exptNames.size(); ++sample) {
                            boolean doIndex = false;
                            for (int i = 0; i < DEGseqInitBox.this.exptNames.size(); ++i) {
                                if (i == sample || !DEGseqInitBox.this.exptNames.get(i).equals(DEGseqInitBox.this.exptNames.get(sample))) continue;
                                doIndex = true;
                            }
                            fileSampleIndex = sampleNames.indexOf(DEGseqInitBox.this.exptNames.get(sample));
                            if (fileSampleIndex == -1) {
                                doIndex = true;
                            }
                            if (doIndex) {
                                this.setTwoClassStateBasedOnIndex(groupAssignments, groupNames);
                                break;
                            }
                            String groupName = (String)groupAssignments.get(fileSampleIndex);
                            groupIndex = groupNames.indexOf(groupName);
                            try {
                                if (groupIndex == 0) {
                                    this.rbArray[sample][0].setSelected(true);
                                }
                                if (groupIndex == 1) {
                                    this.rbArray[sample][1].setSelected(true);
                                }
                                if (groupIndex != 2 && groupIndex != -1) continue;
                                this.rbArray[sample][2].setSelected(true);
                                continue;
                            }
                            catch (Exception e) {
                                this.rbArray[sample][2].setSelected(true);
                            }
                        }
                        this.repaint();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
                    }
                }
            }

            private void setTwoClassStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames) {
                Object[] optionst = new Object[]{"Continue", "Cancel"};
                if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
                    return;
                }
                for (int sample = 0; sample < DEGseqInitBox.this.exptNames.size(); ++sample) {
                    try {
                        if (groupNames.indexOf(groupAssignments.get(sample)) == 0) {
                            this.rbArray[0][sample].setSelected(true);
                        }
                        if (groupNames.indexOf(groupAssignments.get(sample)) == 1) {
                            this.rbArray[1][sample].setSelected(true);
                        }
                        if (groupNames.indexOf(groupAssignments.get(sample)) != 2 && groupNames.indexOf(groupAssignments.get(sample)) != -1) continue;
                        this.rbArray[2][sample].setSelected(true);
                        continue;
                    }
                    catch (Exception e) {
                        this.rbArray[2][sample].setSelected(true);
                    }
                }
            }
        }
    }
}

