/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class DAMSelectionAreaDialog
extends AlgorithmDialog {
    private int result;
    private JTextField textField1;
    private JTextField textField2;
    private JTextField textField3;
    private JTextField textField4;
    private JTextField textField5;
    private JTextField textField6;
    private float positionX;
    private float positionY;
    private float positionZ;
    private float sizeX;
    private float sizeY;
    private float sizeZ;

    public DAMSelectionAreaDialog(Frame parent, float positionX, float positionY, float positionZ, float sizeX, float sizeY, float sizeZ) {
        super(new JFrame(), "DAM selection area configuration", true);
        this.positionX = positionX;
        this.positionY = positionY;
        this.positionZ = positionZ;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel parameters = new JPanel(new GridLayout(0, 2, 10, 0));
        parameters.setBorder(new EmptyBorder(20, 20, 20, 10));
        parameters.setBackground(Color.white);
        parameters.add(new JLabel("Position X  "));
        this.textField1 = new JTextField(Float.toString(positionX), 5);
        parameters.add((Component)this.textField1, "East");
        parameters.add(new JLabel("Position Y  "));
        this.textField2 = new JTextField(Float.toString(positionY), 5);
        parameters.add((Component)this.textField2, "East");
        parameters.add(new JLabel("Position Z  "));
        this.textField3 = new JTextField(Float.toString(positionZ), 5);
        parameters.add((Component)this.textField3, "East");
        parameters.add(new JLabel("Size X  "));
        this.textField4 = new JTextField(Float.toString(sizeX), 5);
        parameters.add((Component)this.textField4, "East");
        parameters.add(new JLabel("Size Y "));
        this.textField5 = new JTextField(Float.toString(sizeY), 5);
        parameters.add((Component)this.textField5, "East");
        parameters.add(new JLabel("Size Z "));
        this.textField6 = new JTextField(Float.toString(sizeZ), 5);
        parameters.add((Component)this.textField6, "East");
        JPanel panel3 = new JPanel(new BorderLayout());
        panel3.setForeground(Color.white);
        panel3.setBorder(BorderFactory.createLineBorder(Color.gray));
        panel3.setBackground(Color.white);
        panel3.add((Component)parameters, "West");
        panel3.add((Component)new JLabel(GUIFactory.getIcon("dialog_button_bar.gif")), "East");
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.add((Component)panel3, "Center");
        this.addContent(panel1);
        this.setActionListeners(listener);
        this.pack();
        this.setResizable(false);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public float getPositionX() {
        return Float.parseFloat(this.textField1.getText());
    }

    public float getPositionY() {
        return Float.parseFloat(this.textField2.getText());
    }

    public float getPositionZ() {
        return Float.parseFloat(this.textField3.getText());
    }

    public float getSizeX() {
        return Float.parseFloat(this.textField4.getText());
    }

    public float getSizeY() {
        return Float.parseFloat(this.textField5.getText());
    }

    public float getSizeZ() {
        return Float.parseFloat(this.textField6.getText());
    }

    public static void main(String[] args) {
        DAMSelectionAreaDialog dialog = new DAMSelectionAreaDialog(new Frame(), 0.0f, 0.0f, 0.0f, 5.0f, 5.0f, 5.0f);
        dialog.showModal();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    Float.parseFloat(DAMSelectionAreaDialog.this.textField1.getText());
                    Float.parseFloat(DAMSelectionAreaDialog.this.textField2.getText());
                    Float.parseFloat(DAMSelectionAreaDialog.this.textField3.getText());
                    Float.parseFloat(DAMSelectionAreaDialog.this.textField4.getText());
                    Float.parseFloat(DAMSelectionAreaDialog.this.textField5.getText());
                    Float.parseFloat(DAMSelectionAreaDialog.this.textField6.getText());
                    DAMSelectionAreaDialog.this.result = 0;
                }
                catch (Exception exception) {
                    DAMSelectionAreaDialog.this.result = 2;
                }
                DAMSelectionAreaDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                DAMSelectionAreaDialog.this.result = 2;
                DAMSelectionAreaDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                DAMSelectionAreaDialog.this.textField1.setText(String.valueOf(DAMSelectionAreaDialog.this.positionX));
                DAMSelectionAreaDialog.this.textField2.setText(String.valueOf(DAMSelectionAreaDialog.this.positionY));
                DAMSelectionAreaDialog.this.textField3.setText(String.valueOf(DAMSelectionAreaDialog.this.positionZ));
                DAMSelectionAreaDialog.this.textField4.setText(String.valueOf(DAMSelectionAreaDialog.this.sizeX));
                DAMSelectionAreaDialog.this.textField5.setText(String.valueOf(DAMSelectionAreaDialog.this.sizeY));
                DAMSelectionAreaDialog.this.textField6.setText(String.valueOf(DAMSelectionAreaDialog.this.sizeZ));
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(DAMSelectionAreaDialog.this, "DAM Selection Area Configuration");
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            DAMSelectionAreaDialog.this.result = -1;
            DAMSelectionAreaDialog.this.dispose();
        }
    }
}

